ECHO Install Heinzelmann

SET "sourcedir=%~dp0"
SET "targetdir=%~dp0"

if not exist "%sourcedir%legacy\" mkdir "%targetdir%legacy\"
if not exist "%sourcedir%legacy\styles\" mkdir "%targetdir%legacy\styles\"
if not exist "%sourcedir%legacy\styles\default\" mkdir "%targetdir%legacy\styles\default\"
if not exist "%sourcedir%legacy\styles\default\css\" mkdir "%targetdir%legacy\styles\default\css\"
if not exist "%sourcedir%legacy\styles\default\css\ownStyles\" mkdir "%targetdir%legacy\styles\default\css\ownStyles\"
if not exist "%sourcedir%public\" mkdir "%targetdir%public\"
if not exist "%sourcedir%public\styles\" mkdir "%targetdir%public\styles\"
if not exist "%sourcedir%public\styles\default\" mkdir "%targetdir%public\styles\default\"
if not exist "%sourcedir%public\styles\default\css\" mkdir "%targetdir%public\styles\default\css\"
if not exist "%sourcedir%public\styles\default\css\ownStyles\" mkdir "%targetdir%public\styles\default\css\ownStyles\"
if not exist "%sourcedir%public\styles\default\css\ownStyles\rendFiles\" mkdir "%targetdir%public\styles\default\css\ownStyles\rendFiles\"

if exist "%sourcedir%\configuration.php" (goto :copyoldfiles) else (goto :copysource)

:copyoldfiles
ECHO Copy Old Files
move "%sourcedir%configuration.php" "%targetdir%legacy\configuration.php"
robocopy "%sourcedir%styles\default\css\ownStyles" "%targetdir%legacy\styles\default\css\ownStyles" /E
robocopy "%sourcedir%styles\default\css\ownStyles" "%targetdir%public\styles\default\css\ownStyles" /E
if exist "%sourcedir%licence.php" move "%sourcedir%licence.php" "%targetdir%legacy\licence.php"
if exist "%sourcedir%log" move "%sourcedir%log" "%targetdir%legacy\"
if exist "%sourcedir%azure" move "%sourcedir%azure" "%targetdir%public\"
goto :deletefiles

:deletefiles
ECHO Delete Files
SET "keepfile1=InstallHM.bat"
SET "keepfile2=web.config"
SET "keepfile3=sso.php"
SET "keepdir1=legacy"
SET "keepdir2=public"
SET "keepdir3=Quellcode"
SET "keepdir4=upload"
FOR /d %%a IN ("%sourcedir%*") DO IF /i NOT "%%~nxa"=="%keepdir1%" IF /i NOT "%%~nxa"=="%keepdir2%" IF /i NOT "%%~nxa"=="%keepdir3%" IF /i NOT "%%~nxa"=="%keepdir4%" RD /S /Q "%%a"
FOR %%a IN ("%sourcedir%*") DO IF /i NOT "%%~nxa"=="%keepfile1%" IF /i NOT "%%~nxa"=="%keepfile2%" IF /i NOT "%%~nxa"=="%keepfile3%" DEL "%%a"
goto :copysource

:copysource
ECHO Copy Files
if exist "%sourcedir%.env" (del "%SourceDir%Quellcode\.env")
robocopy "%sourcedir%Quellcode" "%targetdir%\" /E
del "%targetdir%\bootstrap\cache\*.php"

ECHO Delete Quellcode
RMDIR "%sourcedir%Quellcode" /S /Q 
if not exist "%sourcedir%legacy\Sessions\" mkdir "%targetdir%legacy\Sessions\"
if not exist "%sourcedir%public\web.config" ren "%sourcedir%public\web.config.example" web.config
if not exist "%sourcedir%legacy\configuration.php" (ren "%sourcedir%legacy\example.configuration.php" configuration.php) else (del "%SourceDir%legacy\example.configuration.php")
icacls "%sourcedir%legacy\log" /grant IIS_IUSRS:(OI)(CI)F
icacls "%sourcedir%legacy\tpl" /grant IIS_IUSRS:(OI)(CI)F
icacls "%sourcedir%legacy\styles" /grant IIS_IUSRS:(OI)(CI)F
icacls "%sourcedir%legacy\configuration.php" /grant IIS_IUSRS:F
icacls "%sourcedir%public\styles" /grant IIS_IUSRS:(OI)(CI)F
icacls "%sourcedir%.env" /grant IIS_IUSRS:F
if not exist "%sourcedir%storage\oauth-private.key" php artisan passport:install

ECHO DELETE Old Files
if exist "%targetdir%legacy\includes\app.php" del "%targetdir%legacy\includes\app.php"
if exist "%targetdir%legacy\includes\auth.php" del "%targetdir%legacy\includes\auth.php"
if exist "%targetdir%legacy\includes\couch.php" del "%targetdir%legacy\includes\couch.php"
if exist "%targetdir%legacy\includes\data\Structure.php" del "%targetdir%legacy\includes\data\Structure.php"
if exist "%targetdir%legacy\includes\database.php" del "%targetdir%legacy\includes\database.php"
if exist "%targetdir%legacy\includes\error.php" del "%targetdir%legacy\includes\error.php"
if exist "%targetdir%legacy\includes\globalvars.php" del "%targetdir%legacy\includes\globalvars.php"
if exist "%targetdir%legacy\includes\heinzelmann.php" del "%targetdir%legacy\includes\heinzelmann.php"
if exist "%targetdir%legacy\includes\locales.php" del "%targetdir%legacy\includes\locales.php"
if exist "%targetdir%legacy\includes\logging.php" del "%targetdir%legacy\includes\logging.php"
if exist "%targetdir%legacy\includes\mailer.php" del "%targetdir%legacy\includes\mailer.php"
if exist "%targetdir%legacy\includes\menu.php" del "%targetdir%legacy\includes\menu.php"
if exist "%targetdir%legacy\includes\modLoader.php" del "%targetdir%legacy\includes\modLoader.php"
if exist "%targetdir%legacy\includes\template.php" del "%targetdir%legacy\includes\template.php"
if exist "%targetdir%legacy\includes\ticketurl.php" del "%targetdir%legacy\includes\ticketurl.php"
if exist "%targetdir%legacy\includes\validate.php" del "%targetdir%legacy\includes\validate.php"

ECHO Destory Batch
( del /q /f "%~f0" >nul 2>&1 & exit /b 0  )
