<?php

    /**
    * FR_Presenter_common
    *
    * @author Dirk Herbes <d.herbes@fair-computer.de>
    * @copyright Dirk Herbes <d.herbes@fair-computer.de>
    * @package Framework
    * @filesource
    */

    /**
    * FR_Presenter_common
    *
    * A common base class for our presenters (views). All of our presenters must
    * extend from this class. If they do not then Presenter::factory() will 
    * return an error.
    *
    * @author Dirk Herbes <d.herbes@fair-computer.de>
    * @package Framework
    */
    abstract class FR_Presenter_common extends FR_Object_Web
    {
        protected $module;

        public function __construct(FR_Module $module)
        {
			//Weitergabe des $modul-Objekts um weitere Instanzierungen des user-Objekts zu vermeiden
            parent::__construct($module);          
            $this->module = $module;
                     
        }

        abstract public function display();

        public function __destruct()
        {
            parent::__destruct();
        }
    }

?>
