<?php

    /**
    * FR_Presenter_localization
    *
    * @author Dirk Herbes <d.herbes@fair-computer.de>
    * @copyright Dirk Herbes <d.herbes@fair-computer.de>
    * @package Framework
    * @filesource
    */

    require_once(SMARTY_DIR.'Smarty.class.php');

    /**
    * FR_Presenter_localization
    *
    * By default we use gettext for localization. (I18N Support)
    *
    * @author Dirk Herbes <d.herbes@fair-computer.de>
    * @package Framework
    * @link http://de.php.net/manual/en/ref.gettext.php
    */
    abstract class FR_Presenter_localization extends FR_Presenter_common
    {
        public $language_code = 'en';
        public $domain = null;

        // {{{ __construct()
        public function __construct(FR_Module $module)
        {
            parent::__construct($module);

            $this->module = $module;
            $this->language_code = $this->user->language_type;

//            putenv('LANG='.$this->language_code.'.UTF-8');
//            setlocale(LC_MESSAGES, $this->language_code.'.UTF-8');

            $this->domain = $module->moduleName;
            if ($module->className != $module->moduleName) {
                $this->domain .= $module->moduleName;
            }
        }
        // }}}

        // {{{ authenticate()
        // abstract function authenticate();
        // }}}

        // {{{ __destruct()
        public function __destruct() {
            parent::__destruct();
        }
        // }}}
    }

?>