<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Assetverwaltung') %]</span>
    </div>
    <div class="card-body">

        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <span class="fcs-card-title h3">[% $user->gettext('Asset') %]</span>[% if $Tools->FCS_Count($nav.entries) %]<span class="fcs-card-title"> - [% $nav.entries %] [% $user->gettext('Eintr&auml;ge gefunden') %]</span>[% /if %]

                <div class="pull-right">
                    
                    
                </div>

            </div>
            <div class="card-body">


                <div class="card panel-info shadow-sm rounded">
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="table table-striped table-bordered  table-condensed">
                                <thead>
                                    <tr>
                                        <th>[% $user->gettext('ID') %]</th>
                                        <th>[% $user->gettext('Name') %]</th>
                                        <th>[% $user->gettext('Zugeordnet') %]</th>
                                        <th>[% $user->gettext('Typ') %]</th>
                                        <th>[% $user->gettext('Domäne') %]</th>
                                        <th>[% $user->gettext('Hostname') %]</th>
             
                                    </tr>
                                </thead>
                                <tbody>
                                    [% foreach from=$Devices item=Device key=DeviceID %]
                                        <tr>
                                            <td onclick="assignDevice([% $DeviceID %]);">[% $DeviceID %]</td>
                                            <td onclick="assignDevice([% $DeviceID %]);">[% $Device.devicename %]</td>
                                            <td onclick="assignDevice([% $DeviceID %]);">[% $Device.contact %]</td>
                                            <td onclick="assignDevice([% $DeviceID %]);">[% $Device.typename %]</td>
                                            <td onclick="assignDevice([% $DeviceID %]);">[% $Device.domainname %]</td>
                                            <td onclick="assignDevice([% $DeviceID %]);">[% $Device.hostname %]</td>
                                           
                                        </tr>
                                    [% /foreach %]
                                </tbody>
                                <tfoot>
                                <th>[% $user->gettext('ID') %]</th>
                                <th>[% $user->gettext('Name') %]</th>
                                <th>[% $user->gettext('Typ') %]</th>
                                <th>[% $user->gettext('Domäne') %]</th>
                                <th>[% $user->gettext('Hostname') %]</th>
         
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script>
    $(document).ready(function () {
        $('.table').DataTable({
            dom: 'Bfrtip',
            buttons: [
//              
            ],
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            },
            initComplete: function () {
                this.api().columns().every(function () {
                    var column = this;
                    var select = $('<select><option value=""></option></select>')
                            .appendTo($(column.footer()).empty())
                            .on('change', function () {
                                var val = $.fn.dataTable.util.escapeRegex(
                                        $(this).val()
                                        );

                                column
                                        .search(val ? '^' + val : '', true, true)
                                        .draw();
                            });
                    column.data().unique().sort().each(function (d, j) {
                        select.append('<option value="' + d + '">' + d + '</option>')
                    });
                });
            }
        });
    })
    [% if $FromClass == 'commercialdevdata' %]
function assignDevice(id) {
        console.log(id);
        $.post("index.php?module=assets&class=commercialdevdata&event=assignDevice",{deviceid:id}, function(data){
            console.log(data);
        });
        parent.closeIframe();
}
[% else %]
function assignDevice(id) {
        console.log(id);
        $.post("index.php?module=assets&class=swproducts&event=assignDevice",{deviceid:id, productid:0}, function(data){
            console.log(data);
        });
        parent.closeIframe();
}
[% /if %]
</script>