<!-- Component CostGroups begin -->
<form action="index.php?module=costcenter" class="form-horizontal form-label-left" method="post" name="hm" id="hm">
    <input type="hidden" name="pos" id="pos" value="[% $pos %]" />
    <input type="hidden" name="save" id="save" value="0" />
    <input type="hidden" name="edit" id="edit" value="0" />

    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <div class="row">
                <div class="col-md-6">
                    <span class="fcs-card-title h4">[% $user->gettext('Kostengruppen') %]</span>
                </div>
                <div class="col-md-6 text-end">
                    <div class="btn-group">
                        <input type="button" class="btn btn-outline-primary" value="[% $user->gettext('Zurück zu den Einstellungen') %]" onclick="self.location.href = 'index.php?module=settings#CostsPanel';"/>                
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body">
            [% foreach from=$Error item=Err %]
                <div class="alert alert-warning">[% $user->gettext($Err) %]</div>
            [% /foreach %]


            <div class="table-responsive">
                <table class="table table-striped table-bordered">
                    <thead>

                        <tr  class="fields">
                            <th class="last">
                                [% $user->gettext('#') %]
                            </th>
                            <th class="last">
                                [% $user->gettext('Kostengruppe') %]&nbsp;
                                <img src="images/sortasc.gif" width="11" height="11" border="0" alt=""  />
                            </th>
                            <th class="last">
                                [% $user->gettext('Kostensatz') %]
                            </th>
                            <th class="last">
                                [% $user->gettext('Währung') %]
                            </th>
                            <th class="last">
                                [% $user->gettext('Einheit') %]
                            </th>
                            <th class="last">[% $user->gettext('Gültig ab/seit') %]
                            </th>
                            <th class="last">&nbsp;
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        [% foreach from=$CostGroups item=costgroup %]
                            [% if $EditCostGroupID != $costgroup.costgroupid %]
                                <tr>
                                    <td class="right">[% $costgroup.costgroupid  %]</td>
                                    <td>[% $costgroup.cgdescr %]</td>
                                    <td>[% $costgroup.costrate %]</td>
                                    <td>[% $costgroup.symbol %] ([% $costgroup.name %], [% $costgroup.shortname %])</td>
                                    <td>[% $costgroup.cedescr %]</td>
                                    <td>[% $costgroup.startdate|date_format:"%d.%m.%Y %H:%M" %]</td>
                                    <td>

                                        <div class="btn-group">
                                            <span class="btn btn-outline-secondary"  title="[% $user->gettext('Bearbeiten') %]" onclick="EditCostGroup([% $costgroup.costgroupid %]);">
                                                <span class="fa fa-pencil"></span>
                                            </span>
                                            <a href="index.php?module=costcenter&amp;event=showCostGroupUsers&amp;cgid=[% $costgroup.costgroupid %] " data-fancybox-type="iframe" class="dialog btn btn-outline-secondary"  title="[% $user->gettext('Anzeigen') %]">
                                                <span class="fa fa-search"></span>
                                            </a>
                                            [% if !$costgroup.inuse %]
                                                <span class="btn btn-outline-danger" title="[% $user->gettext('Entfernen') %]"  onclick="RemoveCostGroup([% $costgroup.costgroupid %]);">
                                                    <span class="fa fa-trash"></span>
                                                </span>
                                            [% /if %]                                        
                                        </div>                                    

                                    </td>
                                </tr>
                            [% else  %]
                                <tr>
                                    <td class="right">[% $costgroup.costgroupid  %]</td>
                                    <td><input type="text" name="Description"  class="form-control" id="Description" value="[% $costgroup.cgdescr %]" /></td>
                                    <td>
                                        <input type="hidden" name="CostRateID"   value="[% $costgroup.costrateid %]" />
                                        <input type="text" name="CostRate" class="form-control" id="CostRate" value="[% $costgroup.costrate %]" />
                                    </td>
                                    <td>
                                        <select size="1" name="CostCurrencyID" id="CostCurrencyID" class="form-control">
                                            [% html_options options=$CostCurrencies selected=$costgroup.costcurrencyid %]
                                        </select>
                                    </td>
                                    <td>
                                        <select size="1" name="CostEntityID" id="CostEntityID" class="form-control">
                                            [% html_options options=$CostEntities selected=$costgroup.costentityid %]
                                        </select>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control datetimepicker" style="text-align:center;" maxlength="10" size="10"name="StartDate" id="StartDate" value="[% $smarty.now|date_format:"%d.%m.%Y %H:%M" %]" />
                                    </td>
                                    <td>

                                        <div class="btn-group">
                                            <a href="JavaScript:saveCG([% $costgroup.costgroupid  %])" title="[% $user->gettext('Speichern') %]" class="btn btn-outline-secondary">
                                                <span class="fa fa-check"></span>
                                            </a>
                                            <a href="JavaScript:Cancel()" title="[% $user->gettext('Abbrechen') %]"  class="btn btn-outline-secondary">
                                                <span class="fa fa-times"></span>
                                            </a>                                        
                                        </div>                                    

                                    </td>
                                </tr>
                            [% /if %]
                        [% foreachelse %]
                            <tr>
                                <td colspan="7" style="text-align:center !important;">[% $user->gettext('Keine Kostengruppen gefunden') %]</td>
                            </tr>
                        [% /foreach %]                        
                    </tbody>
                    [% if !$EditCostGroupID %]
                        <tfoot>
                            <tr class="odd">
                                <td>[% $user->gettext('Neue <br />Gruppe') %]</td>
                                <td><input type="text" name="Description" id="Description" class="form-control" value="[% if $EditCostGroup %][% $CostGroups.cgdescr %][% /if %]" /></td>
                                <td><input type="text" name="CostRate" id="CostRate"  class="form-control" value="" /></td>
                                <td>
                                    <select size="1" name="CostCurrencyID" class="form-control">
                                        [% html_options options=$CostCurrencies %]
                                    </select>
                                </td>
                                <td>
                                    <select size="1" name="CostEntityID" class="form-control">
                                        [% html_options options=$CostEntities %]
                                    </select>
                                </td>
                                <td>
                                    <input type="text" class="form-control datetimepicker" style="text-align:center;" maxlength="16" size="16" id="StartDate" name="StartDate" value="[% $smarty.now|date_format:"%d.%m.%Y %H:%M" %]">
                                </td>
                                <td>
                                    <input type="button" class="btn btn-outline-primary" value="[% $user->gettext('Speichern') %]" onclick="SaveNewCostGroup();"/>
                                </td>
                            </tr>
                        </tfoot>
                    [% /if %]                    
                </table>

                [% if $pages > 0 %]
                    <div class="navigation">
                        <ul>
                            <li>[% $user->gettext('Seite') %]:</li>
                            <li><a href="#" onclick="switchPage([% $pos-1 %])" class="button button-grey"><span>&laquo;</span></a></li>
                            <li><href="JavaScript:switchPage(1)" class="button button-[% if 1 == $nav.page %]green[% else %]grey[% /if %]"><span>1</span></a></li>
                                [% if $nav.pagecount gt 1 %]
                                    <li><a href="JavaScript:switchPage(2)" class="button button-[% if 2 == $nav.page %]green[% else %]grey[% /if %]"><span>2</span></a></li>
                                    [% /if %]
                                    [% if $nav.pagecount gt 2 %]
                                    <li><a href="JavaScript:switchPage(3)" class="button button-[% if 3 == $nav.page %]green[% else %]grey[% /if %]"><span>3</span></a></li>
                                    [% /if %]
                                    [% if $nav.pagecount gt 3 %]
                                    <li><a href="JavaScript:switchPage(4)" class="button button-[% if 4 == $nav.page %]green[% else %]grey[% /if %]"><span>4</span></a></li>
                                    [% /if %]
                                    [% if $nav.pagecount gt 4 %]
                                    <li><a href="JavaScript:switchPage(5)" class="button button-[% if 5 == $nav.page %]green[% else %]grey[% /if %]"><span>5</span></a></li>
                                    [% /if %]
                                    [% if $nav.pagecount gt 5 %]
                                    <li>...</li>
                                    <li><a href="JavaScript:switchPage([% $nav.pagecount %])" class="button button-[% if $nav.pagecount == $nav.page %]green[% else %]grey[% /if %]"><span>[% $nav.pagecount %]</span></a></li>
                                            [% /if %]
                                <li><a href="JavaScript:switchPage([% $pos+1 %])" class="button button-grey"><span>&raquo;</span></a></li>
                        </ul>
                    </div>
                [% /if %]

            </div>
        </div>
    </div>
</form>



<div id="errorbox" onclick="this.style.visibility = 'hidden';
        this.style.display = 'none';" style="display:none;">
    <div id="errorhead">&nbsp;[% $user->gettext('Fehler') %]&nbsp;</div>
    <div id="errorres"></div>
    <div id="errorfoot">&nbsp;&gt; <span>[% $user->gettext('Schlie&szlig;en') %]</span> &lt;&nbsp;</div>
</div>

<script>

    $(".datetimepicker").datetimepicker({
        currentText: 'Jetzt',
        closeText: 'OK',
        timeText: 'Zeit',
        hourText: 'Stunde'
    });

    var DescriptionErr = "[% $user->gettext('Keine Beschreibung angegeben') %]";
    var CostRateErr = "[% $user->gettext('Die Kostenrate darf nicht negativ sein') %]";
    var StartDateErr = "[% $user->gettext('Kein Datum angegeben') %]";

    $(".dialog").fancybox({
        maxWidth: 800,
        maxHeight: 600,
        closeClick: false
    });


</script>

<script src="modules/costcenter/javascript/costcenter.js" ></script>
<!-- Component CostGroups end -->
