<div class="card panel-info shadow-sm rounded">
    <div class="card-header">
        <h3 class="card-title">[% $user->gettext('Ticketliste Ger&auml;te') %]</h3>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-sm table-striped table-hover deviceticketstable">
                <thead>
                    <tr>
                        <th data-hide="phone,tablet" colspan="2">[% $user->gettext('Status') %]</th>
                        <th data-toggle="true" >[% $user->gettext('Kurzbeschreibung') %]</th>
                        <th data-hide="phone,tablet">[% $user->gettext('Eskalation') %]</th>
                        <th >[% $user->gettext('#') %]</th>
                        <th data-hide="phone,tablet">[% $user->gettext('Firma') %]</th>
                        <th data-hide="phone,tablet">[% $user->gettext('Kontakt') %]</th>
                        <th data-hide="phone,tablet">[% $user->gettext('Supporter') %]</th>
                            [% if $hmcompany|strpos:"AVAG HOLDING" !== false %]
                            <th data-hide="phone,tablet">[% $user->gettext('Wiedervorlage am') %]</th>
                            [% else %]
                            <th data-hide="phone,tablet">[% $user->gettext('F&auml;llig am') %]</th>
                            [% /if %]
                        <th data-hide="phone,tablet">[% $user->gettext('Erstellt am') %]</th>
                         [% if $Sennebogen %]
                        <th>[% $user->gettext('Klassifikation')%]</th>
                        <th>[% $user->gettext('Betriebsstunden')%]</th>
                        <th>[% $user->gettext('Fehlerbild')%]</th>
                        [% /if %]
                    </tr>
                </thead>
                <tbody>
                    [% foreach from=$tickets item=ticket %]
                        <tr class="[% if $ticket.isproblem == 1 %]problem[% /if %]">

                            <td nowrap="nowrap" style="text-align:center !important;" class="[% if $ticket.diffonhold > 0 %]onhold[% else %]prio[% $ticket.ticketprioid %][% /if %]">[% $user->gettext($ticket.tstatus) %]</td>
                            <td width="16">
                                [% if $ticket.isproblem == 1 %]
                                    <img src="images/isproblem.gif" width="16" height="16"  alt="[% $user->gettext('Problem') %]" title="[% $user->gettext('Problem') %]" />
                                [% else %]
                                    <img src="images/isincident.gif" width="16" height="16"  alt="[% $user->gettext('Vorfall') %]" title="[% $user->gettext('Vorfall') %]" />
                                [% /if %]
                                [% if $ticket.important == 1 %]<img src="images/important.gif" width="16" height="16"  alt="[% $user->gettext('Kontakt mit Priorität') %]" title="[% $user->gettext('Kontakt mit Priorität') %]" />[% /if %]
                                [% if $ticket.master %]<img src="images/master.gif" width="16" height="16"  alt="[% $user->gettext('Masterticket') %]" title="[% $user->gettext('Masterticket') %] ([% $ticket.master %])" />[% /if %]
                                [% if $ticket.attachments > 0 %]<img src="images/attachment.gif" width="16" height="16"  alt="[% $user->gettext('Dokumente vorhanden') %]" title="[% $user->gettext('Dokumente vorhanden') %]" />[% /if %]
                            </td>
                            <td nowrap="nowrap">&nbsp;[% $ticket.ticketdescr|truncate:50:"...":true %]&nbsp;</td>
                            <td><img src="images/escalation[% if $ticket.escalationlevel > 0 %][% $ticket.escalationlevel %][% else %]0[% /if %].gif" width="57" height="13" alt="" title="[% $user->gettext('Eskalation') %]: -[% if $ticket.escalationlevel > 0 %][% $ticket.escalationlevel %][% else %]0[% /if %]-" /></td>
                            <td nowrap="nowrap"  onclick="window.open('index.php?module=ticket&event=show&id=[% $ticket.id %]', 'Details');" style="cursor:pointer;">[% $ticket.id %]&nbsp;</td>
                            <td nowrap="nowrap">[% $ticket.company|htmlentities %]&nbsp;</td>
                            <td nowrap="nowrap">[% $ticket.contact|htmlentities %]&nbsp;</td>
                            <td nowrap="nowrap">[% $ticket.supporter|htmlentities %]&nbsp;</td>
                            <td nowrap="nowrap">[% $ticket.ticketdesiredate|date_format:"%d.%m.%Y %H:%M" %]&nbsp;</td>
                            <td nowrap="nowrap">[% $ticket.createdate|date_format:"%d.%m.%Y %H:%M" %]&nbsp;</td>
                            [% if $Sennebogen %]
                            <td>[% if $ticket.maingroupdescr %][% $ticket.maingroupdescr %][% /if %][% if $ticket.subgroupdescr %]/[% $ticket.subgroupdescr %][% /if %]</td>
                            <td>[% $ticket.betriebsstunden %]</td>
                            <td>[% if $ticket.errordescr %][% $ticket.errordescr %][% /if %] [% if $ticket.errorpreposition %][% $ticket.errorpreposition %][% /if %] [% if $ticket.errorobject %][% $ticket.errorobject %][% /if %]</td> 
                            [% /if %]
                        </tr>
                    [% foreachelse %]
                        <tr class="even">
                            <td colspan="10">[% $user->gettext('Keine Tickets gefunden') %]</td>
                        </tr>
                    [% /foreach %]
                </tbody>
            </table>            
        </div>
    </div>
</div> 



