
<script src="includes/js/dropzone.js"></script>
<link href="includes/js/dropzone.css" rel="stylesheet" type="text/css" />

<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<style>
    .diffCol {
        color:  green;
    }
    .importError {
        color:red;
    }
    .importSuccess{
        color:green;
    }
</style>
<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Kontakte') %]</span>
    </div>
    <div class="card-body">

        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <span class="fcs-card-title h3">[% $user->gettext('CSV Import') %]

                    <div class="pull-right">
                        <a href="index.php?module=contact" class='btn btn-outline-secondary'>[% $user->gettext('Liste') %]</a>

                        <a href="index.php?module=employee&class=csv&event=clearCSVImport" class="btn btn-outline-primary">[% $user->gettext('Liste leeren') %]</a>

                        <a href="index.php?module=employee&class=csv&&event=getCSVHeaders" class="btn btn-outline-primary">[% $user->gettext('CSV-Vorlage herunterladen') %]</a>
                    </div>
            </div>
            <div class="card-body">

                <div class="card panel-info shadow-sm rounded">
                    <div class="card-body">
                        <form action="index.php?module=employee&class=csv&event=CSVImport" method="post" id="CSVImportForm" class="form form-horizontal center-block">

                            <div>
                                <label><input type="checkbox" name="importContacts" id="importContacts" value="1" checked> [% $user->gettext('Kontakte importieren') %]</label>
                                <label><input type="checkbox" name="importUsers" id="importUsers" value="1" checked> [% $user->gettext('Benutzer importieren') %]</label>
                                <label><input type="checkbox" name="withUpdate" id="withUpdate" value="1" checked> [% $user->gettext('Bestehende Einträge aktualisieren') %]</label>
                            </div>

                            [% if $Data.EntriesToImport %]


                                <p>[% $user->gettext('Es wurden') %] [% $Data.EntriesToImport %] [% $user->gettext('Einträge zum importieren gefunden. Sollen diese angelegt / aktualisiert werden?') %]</p>
                                <input type="hidden" name="importData" value="1">
                                <div>

                                    <span id="startImport" class="btn btn-outline-secondary">[% $user->gettext('Einträge importieren / aktualisieren') %]</span>
                                    <span id="showEntries" class="btn btn-outline-secondary">[% $user->gettext('Einträge zur Auswahl anzeigen') %]</span>
                                </div>



                                <div class="progress" id="ProgressBarContainer" style="display:none;">
                                    <div class="progress-bar progress-bar active" id="ProgressBar" role="progressbar" style="width:0%;min-width:10em;">
                                        [% $user->gettext('Import gestartet...') %]
                                    </div>
                                </div>




                                <table id="ResultTable"  class="table table-bordered table-striped table-sm hidden">
                                    <thead>
                                        <tr>
                                            <th>
                                                [% $user->gettext('Eintrag') %]
                                            </th>
                                            <th>
                                                [% $user->gettext('Messages') %]
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>



                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped table-sm">
                                        <thead>
                                            <tr>
                                                [%*
                                                <th>
                                                <input type="checkbox" id="SelectAll" />
                                                </th>
                                                *%]
                                                [% foreach from=$Data.headers item=Col %]
                                                    <th>
                                                        [% $Col %]
                                                    </th>
                                                [% /foreach %]
                                            </tr>
                                        </thead>
                                        <tbody>

                                            [% foreach from=$Entries item=Object key=csvKey %]
                                                <tr id="CSVColNo_[% $csvKey %]" class="">
                                                    [%*
                                                    <td>
                                                    [% if !$Compare.$csvKey.exist || $Compare.$csvKey.update  %]
                                                    <input type="checkbox" class="EntrieSelection" id="EntrieSelection_[% $csvKey %]" name="selectedEntry[[% $csvKey %]]" value="[% $csvKey %]" class="form-control" />
                                                    [% /if %]
                                                    </td>
                                                    *%]
                                                    [% foreach from=$Object item=val key=ColName %]
                                                        <td>
                                                            [% $val %]
                                                        </td>
                                                    [% /foreach %]
                                                </tr>
                                            [% /foreach %]
                                        </tbody>
                                    </table>
                                </div>

                            [% else %]
                                <p>
                                    <strong>[% $user->gettext('CSV-Datei per Drag and Drop reinziehen') %]</strong>
                                </p>
                            [% /if %]
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script>

    $(document).ready(function () {

        $('#SelectAll').on("click", function () {
            if ($('#SelectAll').prop('checked')) {
                $('.EntrieSelection:visible').prop('checked', true);
            } else {
                $('.EntrieSelection:visible').prop('checked', false);
            }
        })
        $("#hasUpdate").on("click", function () {
            $('.hasUpdate').toggleClass('hidden');
        })

        $("#notExist").on("click", function () {
            $('.notExist').toggleClass('hidden');
        })

        $("#noChanges").on("click", function () {
            $('.noChanges').toggleClass('hidden');
        })


        $('#startImport').on("click", function (e) {
            //importFirstSelectedEntry();
            importAll();
        })


        function importAll() {
            $("#ProgressBarContainer").show();

            $.post("index.php?module=employee&class=csv&event=startCSVImport", function (data) {


            }).done(function (data) {

                $("#ProgressBar").width((data.execute) * 100 / data.total + '%').html(data.execute + " / " + data.total);
                if (data.left > 0) {
                    importAll();
                }

            })
        }
        /**
         * Comment
         */
        function importFirstSelectedEntry() {

            CSVColNo = $(".EntrieSelection:checkbox:checked:first").val();
            if (typeof CSVColNo === "undefined") {
                return;
            }

//            console.log("Nächste: ");
//            console.log("ColNo: " + CSVColNo);

            var selected = [];
            ii = 0;
            $('.EntrieSelection:checkbox:checked').each(function () {
                selected.push($(this).val());
                ii++;
                if (ii == $('#StepWide').val()) {
                    return false;
                }

            });
//             console.log("selected: " + selected);


            $.post("index.php?module=employee&class=csv&event=startCSVImport&CSVColNo=" + CSVColNo, {selected: selected}, function (data) {
//                 console.log(data);

            }).done(function (data) {

// console.log(data);
                $.each(data, function (key, val) {
                    $('#ResultTable').removeClass('hidden');

                    markup = "<tr id='Result_" + key + "' class=' " + (val.error ? 'importError' : 'importSuccess') + "' ><td>" + val.EntryData.hostname + " / " + val.EntryData.devicename + "</td><td>";
                    $.each(val.messages, function (i, item) {
                        markup += item + "<br/>";
                    })
                    markup += "</td></tr>";
                    $('#ResultTable > tbody').append(markup);

                    if (val.error) {
                        $("#CSVColNo_" + key).addClass('importError');
                        //Wenn es einen Fehler gab, die Markierung entfernen.
                        $('#EntrieSelection_' + key).prop('checked', false);
                    } else {
//                    $("#CSVColNo_" + CSVColNo).fadeOut();
                        $("#CSVColNo_" + key).remove();
                    }


//              $("#Result_" + CSVColNo).hide();
//                $("#Result_" + CSVColNo).fadeIn();
                    $("#Result_" + key).show();
                });

                importFirstSelectedEntry();
            });

        }

        Dropzone.options.myDropzone = {

            init: function () {
                this.on("queuecomplete", function (file) {
                    //this.removeAllFiles();
                });
            }
        };

        $(".panel-fcs-content").dropzone({
            url: "index.php?module=employee&class=csv&event=getCSVFile&importContacts=" + $('#importContacts').val() + "&importUsers=" + $('#importUsers').val() + "&withUpdate=" + $('#withUpdate').val() + "&pos=1",
            init: function () {
                this.on("queuecomplete", function (file) {
                    //this.removeAllFiles();
                    location.reload();
                });
            }
        });
    })
</script>
