<!-- Component Employee begin -->
[%*
<script type="text/javascript" src="includes/js/jquery.dataTables.min.js"></script>
<link rel="stylesheet" type="text/css" href="styles/default/css/jquery.dataTables.css" media="screen" />
*%]

<script>

    function checkAll(el) {
        var objArray = document.getElementsByName("employee[]");
        if (objArray && objArray.length > 0) {
            for (i = 0; i < objArray.length; i++) {
                objArray[i].checked = el.checked;
            }
        }
    }

    function checkEmployee(id) {
        var objArray = document.getElementsByName("employee[]");
        if (objArray && objArray.length > 0) {
            for (i = 0; i < objArray.length; i++) {
                if (objArray[i].value == id) {
                    objArray[i].checked = (objArray[i].checked)
                            ? false : true;
                }
            }
        }
    }

    function switchPage(page) {
        document.getElementById('pos').value = page;
        submitForm();
    }

    function changeSort(sort) {
        var el = document.getElementById("sort");
        var els = document.getElementById("order");
        if (el) {
            if (el.value == sort) {
                if (els) {
                    els.value = (els.value == "asc") ? "desc" : "asc";
                }
            } else {
                el.value = sort;
            }
            submitForm();
        }
    }

    function keyEvent(event) {
        if (event.keyCode == 13)
            submitForm();
    }

    var iMode = null;

    function importCheck(mode) {

        if (mode == 1 || isChecked()) {

            iMode = mode;
            $("#dialog-PopUpFrameContent").dialog('open');
        } else {
            alert("[% $user->gettext('Bitte selektieren Sie min. einen Mitarbeiter.') %]");
        }
    }

    function isChecked() {
        var objArray = document.getElementsByName("employee[]");
        if (objArray && objArray.length > 0) {
            for (i = 0; i < objArray.length; i++) {
                if (objArray[i].checked) {
                    return true;
                }
            }
        }
        return false;
    }

    function closePopUpFrame() {
        var el = document.getElementById("PopUpFrame");
        var obj = document.getElementById("PopUpFrameContent");
        el.style.visibility = "hidden";
        obj.style.visibility = "hidden";
    }

    function startImport() {
        var el1 = document.getElementById("uMode");
        var el2 = document.getElementById("cMode");
        var pwd1 = $("#passwd1").val();
        var pwd2 = $("#passwd2").val();
        //var pwd2 = document.getElementById("passwd2").value;

        if (el2.checked) {
            $("#FormcMode").val('Y');
        }
        if (el1.checked) {
            $("#FormuMode").val('Y');
        }
        $("#Formpasswd1").val($("#passwd1").val());
        $("#Formpasswd2").val($("#passwd2").val());

        if (el1 && el2 && (el1.checked || el2.checked)) {
            if (el1.checked)
            {
                if (pwd1 != pwd2) {
                    alert("[% $user->gettext('Passwörter stimmen nicht überein. Bitte kontrollieren Sie Ihre Eingabe.') %]");
                } else {
                    if (pwd1 != '') {
                        document.getElementById("iMode").value = iMode;
                        submitForm();
                    } else {
                        alert("[% $user->gettext('Bitte geben Sie ein Standardpasswort ein') %]");
                    }
                }
            } else
            {
                document.getElementById("iMode").value = iMode;
                submitForm();
                //$("#hm").submit();
            }

        } else {
            alert("[% $user->gettext('Bitte geben Sie an als was Sie den Mitarbeiter anlegen wollen') %]");
        }
    }


    function collapseTr() {
        $(".donotshow").toggleClass("hidden");
    }

</script>
<style>
    .ui-dialog .ui-dialog-titlebar-close span {margin:0px;left: 0;top: 0;}
</style>
    <form action="" method="post" name="hm" onsubmit="return false" id="hm" enctype="multipart/form-data" style="margin:0;padding:0;" class="form-inline fcs-form-padding">
    <input type="hidden" name="pos" id="pos" value="[% $pos %]" />
    <input type="hidden" name="sort" id="sort" value="[% $sort %]" />
    <input type="hidden" name="order" id="order" value="[% $order %]" />
    <input type="hidden" name="iMode" id="iMode" value="" />

    <input type="hidden" name="cMode" id="FormcMode" value="" />
    <input type="hidden" name="uMode" id="FormuMode" value="" />
    <input type="hidden" name="passwd1" id="Formpasswd1" value="" />
    <input type="hidden" name="passwd2" id="Formpasswd2" value="" />


    <!-- ###CONTENT### begin -->
    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <span class="fcs-card-title h2">[%$user->gettext('Mitarbeiter aus Asset.Desk importieren ')%]</span>
        </div>
        <div class="card-body">
            <div class="card panel-info shadow-sm rounded">
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group row mb-3">
                                <label class="control-label" for="filter">[% $user->gettext('Filter') %]:</label>
                                <input type="text" class="form-control" id="filter" name="filter" value="[% $filter %]" onkeyup="keyEvent(event)" autocomplete="off" />
                            </div>
                            <div class="form-group row mb-3">
                                <label><input type="checkbox" name="hideexistingContacts" value="1"[% if $hideexistingContacts == 1 %] checked="checked"[% /if %] onchange="submitForm();"/> [% $user->gettext('Bestehende Kontakte') %]</label>
                            </div>
                            <div class="form-group row mb-3">
                                <label><input type="checkbox" name="hideexistingUsers" value="1" [% if $hideexistingUsers == 1 %] checked="checked"[% /if %] onchange="submitForm();"/> [% $user->gettext('Bestehende Benutzer') %]</label>
                            </div>
                        </div>
                        <div class="col-lg-6 text-end">
                            <div class="btn-group">
                                <input type="button" class="btn btn-outline-primary" value="[% $user->gettext('Auswahl importieren') %]" onclick="importCheck(0);">
                                <input type="button" class="btn btn-outline-primary" value="[% $user->gettext('Alle importieren') %]" onclick="importCheck(1);" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <span class="fcs-card-title h3">[%$user->gettext('Mitarbeiterliste')%]</span><span id="info" class="fcs-card-title h4"> - [% $entries %] [% $user->gettext('Mitarbeiter gefunden') %]</span>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table striped">
                            <thead>
                                <tr class="fields">
                                    <td style="text-align:center !important;">
                                        <input type="checkbox" id="checkall" onclick="checkAll(this);" />
                                    </td>
                                    <td onclick="changeSort('Name');">
                                        [% $user->gettext('Name') %]
                                        [% if $sort == "Name" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </td>
                                    <td onclick="changeSort('Username');">
                                        [% $user->gettext('Benutzername') %]
                                        [% if $sort == "Username" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </td>
                                    <td style="text-align:center !important;">
                                        [% $user->gettext('Benutzer') %]
                                    </td>
                                    <td style="text-align:center !important;">
                                        [% $user->gettext('Kontakt') %]
                                    </td>
                                    <td onclick="changeSort('Email');">
                                        [% $user->gettext('E-Mail') %]
                                        [% if $sort == "Email" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </td>
                                    <td onclick="changeSort('Telefon');">
                                        [% $user->gettext('Telefon') %]
                                        [% if $sort == "Telefon" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </td>
                                    <td onclick="changeSort('Fax');">
                                        [% $user->gettext('Fax') %]
                                        [% if $sort == "Fax" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </td>
                                    <td onclick="changeSort('Handy');">
                                        [% $user->gettext('Handy') %]
                                        [% if $sort == "Handy" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </td>
                                    <td onclick="changeSort('Personalnumber');">
                                        [% $user->gettext('Personalnr.') %] &nbsp;
                                        [% if $sort == "Personalnumber" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </td>
                                    <td onclick="changeSort('Company');">
                                        [% $user->gettext('Firma') %]
                                        [% if $sort == "Company" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </td>
                                    <td onclick="changeSort('DepartmentName');">
                                        [% $user->gettext('Abteilung') %]
                                        [% if $sort == "DepartmentName" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </td>
                                    <td onclick="changeSort('Building');">
                                        [% $user->gettext('Geb&auml;ude') %]
                                        [% if $sort == "Building" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </td>
                                    <td onclick="changeSort('Room');">
                                        [% $user->gettext('Raum') %]
                                        [% if $sort == "Room" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </td>
                                </tr>
                            </thead>
                            <tbody>
                                [% foreach from=$employees item=employee %]
                                    <tr>
                                        <td style="text-align:center !important;">[% if $employee.user_id <= 0 || $employee.contact_id <= 0 %]<input type="checkbox" name="employee[]" value="[% $employee.employeeid %]" />[% else %]&nbsp;[% /if %]</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.name %], [% $employee.prename %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);" [% if $employee.usernameerr %]class="error"[% /if %]>[% $employee.username %]&nbsp;</td>
                                        [% if $employee.username == '' %]
                                            <td style="text-align:center !important;" onclick="checkEmployee([% $employee.employeeid %]);" > <span class="fa fa-minus" title="[% $user->gettext('Import nicht möglich: Der Benutzer hat keinen Benutzernamen') %]"></span> </td>
                                        [% else %]
                                            <td style="text-align:center !important;" onclick="checkEmployee([% $employee.employeeid %]);" ><span style="color: [% if $employee.user_id > 0 %]green[% else %]red[% /if %];" class="fa fa-[% if $employee.user_id > 0 %]check"  title="[% $user->gettext('Der Benutzer existiert bereits') %]" [% else %]xmark" title="[% $user->gettext('Benutzer kann importiert werden') %]"[% /if %]/></td>
                                        [% /if %]
                                        <td style="text-align:center !important;" onclick="checkEmployee([% $employee.employeeid %]);" ><span style="color: [% if $employee.contact_id > 0 %]green[% else %]red[% /if %];" class="fa fa-[% if $employee.contact_id > 0 %]ok"  title="[% $user->gettext('Der Benutzer existiert bereits') %]" [% else %]xmark" title="[% $user->gettext('Benutzer kann importiert werden') %]"[% /if %]/></td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.email %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.telefon %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.fax %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.handy %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.personalno %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.company|truncate:20:"...":true %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.departmentname|truncate:20:"...":true %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.buildingname %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.roomname %]&nbsp;</td>
                                    </tr>
                                [% foreachelse %]
                                    <tr class="even">
                                        <td colspan="13" style="text-align:center !important;">[% $user->gettext('Keine Mitarbeiter zum importieren gefunden...') %]</td>
                                    </tr>
                                [% /foreach %]

                            </tbody>
                        </table>
                        [% $Paging %]
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="dialog-PopUpFrameContent" >
        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <span class="fcs-card-title h5">[% $user->gettext('Standardangaben f&uuml;r die Mitarbeiter') %]</span>
            </div>
            <div class="card-body">
                <div class="form-group row mb-3 row">
                    <label for="cMode" class="control-label col-lg-10">[% $user->gettext('Als Kontakt anlegen:') %]</label>
                    <div class="col-lg-2">
                        <input type="checkbox" name="cMode" value="Y" id="cMode" />
                    </div>
                </div>
                <div class="form-group row mb-3 row">
                    <label for="uMode" class="control-label col-lg-10">[% $user->gettext('Als Benutzer anlegen:') %]</label>
                    <div class="col-lg-2">
                        <input type="checkbox" name="uMode" value="Y" id="uMode" onclick="collapseTr()"/>
                    </div>
                </div>

                <div class="form-group row mb-3 row donotshow hidden" >
                    <label for="passwd1" class="control-label col-lg-5">[% $user->gettext('Passwort') %]:</label>
                    <div class="col-lg-7">
                        <input type="password" class="form-control" name="passwd1" id="passwd1" autocomplete="off"  />
                    </div>
                </div>
                <div class="form-group row mb-3 row donotshow hidden" >
                    <label for="passwd2" class="control-label col-lg-5">[% $user->gettext('Passwort best&auml;tigen') %]:</label>
                    <div class="col-lg-7">
                        <input type="password" class="form-control" name="passwd2" id="passwd2" autocomplete="off"  />
                    </div>
                </div>

                <div class="btn-group row text-center">
                    <div class="col-lg-6">
                        <input type="button" class="btn btn-outline-primary" value="[% $user->gettext('Importieren') %]" onclick="startImport();" />
                    </div>
                    <div class="col-lg-6">
                        <input type="button" class="btn btn-outline-secondary" value="[% $user->gettext('Abbruch') %]" onclick="$('#dialog-PopUpFrameContent').dialog('close');" />
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>


<!-- Component CSV-Import end -->
<script>


    $("#dialog-PopUpFrameContent").dialog({
        autoOpen: false,
        maxWidth: 1500,
        maxHeight: 500,
        closeClick: false,
        closeText: '',
        autoOpen: false,
        onClosed: function () {
            parent.location.reload(true);
        },
        beforeClose: function (event, ui) {

        }
    });

</script>
