<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<form action="index.php?module=errorpatterns&class=errorcodes&event=add" method="post" class='form-horizontal form-label-left'>

    <input type="hidden" name="ErrorCode[AssetTypeID]" id="AssetTypeID" value="[% $AssetTypeID %]"/>
    <input type="hidden" name="ErrorCode[MainGroupID]" id="MainGroupID" value="[% $MainGroupID %]"/>
    <input type="hidden" name="ErrorCode[SubGroupID]" id="SubGroupID" value="[% $SubGroupID %]"/>

    <input type='hidden' name='save' value='1' />
    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <span class="fcs-card-title h2">[% $user->gettext('Fehlercodes') %]</span>
        </div>
        <div class="card-body">
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <div class="row">
                        <div class="col-sm-6">
                            <span class="fcs-card-title h4">
                                [% if $ErrorCode['errorcode'] %]
                                    [% $user->gettext('Fehlercode bearbeiten') %]
                                [% else %]
                                    [% $user->gettext('Fehlercode anlegen') %]
                                [% /if %]
                            </span>
                            [% if $AssetTypeID > 0 %]
                                <small>[% $CodeString %]</small>
                            [% /if %]
                        </div>
                        <div class="col-sm-6 text-end">
                            <div class="btn-group">
                                <input type='submit' class='btn btn-outline-primary' value="[% $user->gettext('Speichern') %]" /> 
                                <a href='index.php?module=errorpatterns&class=errorcodes' class='btn btn-outline-secondary'>[% $user->gettext('Liste') %]</a>                            
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group row mb-3">
                                <label class="col-lg-4 control-label">[% $user->gettext('Aktiv') %]</label>
                                <div class="col-lg-8">
                                    <input type="checkbox" name="ErrorCode[active]" value='1'  [% if !$ErrorCode['errorcode'] || $ErrorCode['active'] %]checked[% /if %] />
                                </div>
                            </div>
                            <div class="form-group row mb-3">
                                <label class="col-lg-4 control-label">[% $user->gettext('Fehlercode') %]</label>
                                <div class="col-lg-8">
                                    <input type='string' class="form-control" name="ErrorCode[errorcode]" value="[% $ErrorCode['errorcode'] %]" pattern="[0-9]{1,}" required/>
                                    <span class="help-block">[% $user->gettext('Bitte geben Sie den Fehlercode als Zahl ein. Mindestens eine Ziffer.') %]</span>
                                </div>
                            </div>
                            [%*
                            <div class="form-group row mb-3">
                            <label class="col-lg-4 control-label">[% $user->gettext('Artikelnummer') %]</label>
                            <div class="col-lg-8">
                            <input type='string' class="form-control" name="ErrorCode[articleno]" value="[% $ErrorCode['articleno'] %]" />
                            </div>
                            </div> 
                            *%]

                        </div>
                        <div class="col-md-8">
                            <div class="form-group row mb-3">
                                <label class="col-lg-3 control-label">[% $user->gettext('Beschreibung') %] DE</label>
                                <div class="col-lg-9">
                                    <textarea name="ErrorCode[descr_de]" class="form-control">[% $ErrorCode['descr_de'] %]</textarea>
                                </div>
                            </div>        
                            <div class="form-group row mb-3">
                                <label class="col-lg-3 control-label">[% $user->gettext('Beschreibung') %] EN</label>
                                <div class="col-lg-9">
                                    <textarea name="ErrorCode[descr_en]" class="form-control">[% $ErrorCode['descr_en'] %]</textarea>
                                </div>
                            </div>                              
                        </div>                        
                    </div>
                </div>
            </div>
            [% if $Tools->FCS_Count($ErrorCodes) %]
                <div class="card panel-info shadow-sm rounded">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-sm-6">
                                <span class="fcs-card-title h4">[% $user->gettext('Zugewiesene Fehlercodes') %]</span>
                            </div>
                            <div class="col-sm-6 text-end">
                                <div class="btn-group">

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="reportTable" class="table">
                            <thead>
                                <tr>
                                    <th>[% $user->gettext('Errorcode') %]</th>
                                    <th>[% $user->gettext('Artikelnummer') %]</th>
                                    <th>[% $user->gettext('Beschreibung') %]</th>
                                    <th>[% $user->gettext('Erstelldatum') %]</th>
                                    <th>[% $user->gettext('Aktiv') %]</th>
                                    <th>[% $user->gettext('Aktionen') %]</th>
                                </tr>
                            </thead>
                            <tbody>
                                [% foreach $ErrorCodes as $row %]
                                    <tr>
                                        <td>[% $row['errorcode'] %]</td>
                                        <td>
                                            [% if $user->language_type == 'de' %]
                                                [% $row['descr_de'] %]
                                            [% else %]
                                                [% $row['descr_en'] %]
                                            [% /if %]
                                        </td>
                                        <td data-sort="[% $row['createdate'] %]">[% $row['createdate']|date_format:"%d.%m.%Y" %]</td>
                                        <td data-sort="[% $row['active'] %]">
                                            [% if $row['active'] %]
                                                <span class="fa  fa-check"></span>
                                            [% else %]
                                                <span class="fa fa-times"></span>
                                            [% /if %]
                                        </td>
                                        <td>
                                            <a href="index.php?module=errorpatterns&class=errorcodes&event=edit&ec=[% $row['errorcode'] %]" class="btn btn-sm btn-outline-secondary" title="[% $user->gettext('Fehlercode bearbeiten') %]"><span class="fa fa-pencil"></span></a>
                                        </td>
                                    </tr>
                                [% /foreach %]
                            </tbody>
                            <tfoot>

                            </tfoot>
                        </table>                                            

                    </div>
                </div>
            [% /if %]
        </div>
    </div>
</form>

<script>
    $(document).ready(function () {

        table = $('#reportTable').DataTable({
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            }
        });
        var data = table.buttons.exportData({
            columns: ':visible'
        });

    });
</script>
