<div class="row" style="margin:20px;">

    [% if $PWDRecovered %]
        [% if $MailSend %]
            <div class="col-sm-12">
                <div class="alert alert-info">[% $user->gettext('Ihnen wurde gerade eine Mail an Ihre E-Mail-Adresse gesendet, um Ihr Passwort zurückzusetzen.') %]</div>
            </div>
        [% else %]

            <div class="col-sm-12">
                <div class="alert alert-info">
                    [% if $MailFailed %]                    
                        [% $user->gettext('Ihrem Account ist keine gültige E-Mail-Adresse zugeordnet.') %]
                    [% else %]
                        [% $user->gettext('Die Mail zum Zurücksetzen des Passworts konnte nicht gesendet werden.') %]<br />
                    [% /if %]                    
                    <br />
                    [% $user->gettext('Bitte wenden Sie sich ggf. an den Administrator') %].</div>
            </div>   

        [% /if %]
    [% /if %]

    [% if $VisibleNewsArticle || $VisibleKBArticle || $Tools->FCS_Count($LinkList)  %]    
        [% if $VisibleKBArticle %]       
            <div class="col-lg-3 col-12">
                <div class="row">
                    <div class="col-12" id="AllKBArticles">
                        <div class="card panel-info shadow-sm rounded">
                            <div class="card-header">
                                <h3 class="card-title">[% $user->gettext('') %]</h3>
                            </div>
                            <div class="card-body">
                                <img src="images/ajax-loader.gif" alt="loading..." />                                                
                            </div>
                        </div>  
                    </div>
                </div>
            </div>
        [% /if %]                   

        [% if $VisibleNewsArticle %]       
            <div class="col-md-5 col-sm-5 col-12">
                <div id="NewsList">
                    <div class="card panel-info shadow-sm rounded" >
                        <div class="card-header">
                            <h3 class="card-title">[% $user->gettext('Aktuelle Meldungen') %]</h3>
                        </div>
                        <div class="card-body">
                            <img src="images/ajax-loader.gif" alt="loading..." />
                        </div>
                    </div> 
                </div>
            </div>
        [% /if %]  

        [% if $Tools->FCS_Count($LinkList) %]   
            <div class="col-md-3 col-sm-3 col-12">

                <div class="card panel-info shadow-sm rounded">
                    <div class="card-header">
                        <h3 class="card-title">[% $user->gettext('Links') %]</h3>
                    </div>
                    <div class="card-body">
                            <ul id="LinkList" class="list-group">
                                
                                    [% foreach from=$LinkList item=Link %]
                                    <a href="[% $Link.url %]" target="_blank" title="[% $Link.descr %]">
                                        <li id="Link_[% $Link.position %]" class="list-group-item">
                                <div class="row" style="min-height:60px">
                                            
                                    <div class="col-xl-5 d-flex align-items-center">
                                        [% if $Link.hasimg %]
                                        <img src="[% $Link.imagepath %]" class="img-fluid" style="width: auto; max-height:60px"/>
                                        [% /if %]
                                    </div>

                                    <div class="col-xl-7">
                                            <h5 class=" fw-bold text-start">[% $Link.descr %]</h5>
                                            <h6 class="text-start" style="white-space: normal; word-wrap: break-word;"> [% $Link.subdescr %] </h6>
                                    </div>
  
                                </div>
                                        </li>
                                        </a>
                                    [% foreachelse %]
                                        <li class="list-group-item">
                                            [% $user->gettext('Keine Links definiert') %]
                                        </li>
                                    [% /foreach %]
                                    
                            </ul>
                    </div>
                </div>                        
            </div>
        [% /if %] 
    [% else %]
        <div class="col-12 offset-md-4 col-md-4">
            <form id="login" autocomplete="off" action="[% $action %]" method="post" name="hm" class="form-horizontal form-label-left">
                <div class="card panel-info shadow-sm rounded">
                    <div class="card-header">
                        <h3 class="card-title">[% $user->gettext('Login') %]</h3>
                    </div>
                    <div class="card-body">
                        [% if $errorno == 2 || $errorno == 1 %]
                            <div class="alert alert-danger">[% $error %]</div>                        
                        [% /if %]   

                        <div class="form-group row mb-3">
                            <label class="col-lg-4 control-label" for="login">[% $user->gettext('Benutzername') %]</label>
                            <div class="col-lg-8">
                                <input type="text"  value="[% $Username %]" name="lx_username" class="form-control logon" placeholder="[% $user->gettext('Benutzername') %]" maxlength="255" autocomplete="off" />
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-lg-4 control-label" for="password">[% $user->gettext('Passwort') %]</label>
                            <div class="col-lg-8">
                                <input type="password" name="lx_password" value="[% $Password %]" class="form-control password" placeholder="[% $user->gettext('Passwort') %]" size="25" maxlength="50" autocomplete="off" />
                            </div>
                        </div>

                        [% if $showDomains && $Tools->FCS_Count($domains) %]
                            <div class="form-group row mb-3">
                                <label class="col-lg-4 control-label" for="Domains">[% $user->gettext('Domain') %]</label>
                                <div class="col-lg-8">
                                    <select size="1" name="lx_domain" id="Domains" class="form-control">
                                        [% html_options options=$domains %]
                                        <option value="">[% $user->gettext('&gt;&gt; ohne Domain &lt;&lt;') %]</option>
                                    </select>
                                </div>
                            </div>
                        [% /if %]
                        [% if $remember_me == 1 %]
                            <div class="form-group row mb-3">
                                <label class="col-lg-4 control-label" for="lx_rememberme">[% $user->gettext('Anmeldung merken') %]</label>
                                <div class="checkbox col-lg-8">
                                    <input type="checkbox" id="lx_rememberme" name="lx_rememberme" value="1" style="margin-left: 0px;"/> 
                                </div>
                            </div>
                        [% /if %]


                        <div class="btn-group">
                            <input type="submit" name="submit" value="[% $user->gettext('Anmelden') %]" class="btn btn-outline-primary">
                            [% if $MailActive && $PwdRecover %]
                                <a href="index.php?module=login&event=pwdrecover" class="btn btn-outline-secondary openInLargeModal">[% $user->gettext('Passwort vergessen') %]</a>
                            [% /if %]
                            [% if $UserCreate && $MailActive %]
                                <a href="index.php?module=login&event=createuser" class="btn btn-outline-secondary register">[% $user->gettext('Registrieren') %]</a>
                            [% /if %]

                        </div>
                    </div>
                </div>              
            </form>
        </div>
    [% /if %]
</div>




<script type="text/javascript">
    jQuery(document).ready(function () {

        $.ajax({
            type: "POST",
            url: "index.php?module=knowledgebase&event=showAll&nolimit=1",
        }).done(function (data) {
            $("#AllKBArticles").html(data);
        });

    });
    [% if $KeyCloakLoginError == 1 %]
        alert("[% $user->gettext('Die Anmeldung über KeyCloak war fehlgeschlagen. Bitte stellen Sie sicher, dass nur ein Benutzer mit der gleichen E-Mail-Adressen in Heinzelmann existiert.') %]");
    [% /if %]
        
    [% if $KeyCloakLoginError == 3 %]
        alert("[% $user->gettext('Sie haben keine Berechtigung für den Zugriff auf das System.') %]");
    [% /if %]

    showNewsList();

    function showSingleNews(NewsID) {
        $.ajax({
            type: "POST",
            url: "index.php?module=news&event=getNewsDetails&news_id=" + NewsID,
        }).done(function (data) {
            $("#NewsList").html(data);
        });
    }

    function showNewsList(Pos) {
        $.ajax({
            type: "POST",
            url: "index.php?module=news&event=getNewsList&pos=" + Pos,
        }).done(function (data) {
            $("#NewsList").html(data);
        });

    }
</script>
