
<link rel="stylesheet" type="text/css" href="includes/js/datatables/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables/datatables.min.js"></script>

<style>
    .TitleCol > .TitleVertical {
        writing-mode: vertical-lr;
        transform: rotate(-180deg);
        text-orientation: mixed;
        min-width: 2em;
        padding:0;
        border-top: 1px solid #111; 
        border-bottom:none;
        
    }
    .isSupportGroup {
        background-color: lightpink !important;
    }
</style>
<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Benutzerrechte') %]</span>
    </div>

    <div class="card-body">


        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <div class="row">
                    <div class="col-sm-6">
                        <span class="fcs-card-title h4">[% $user->gettext('Benutzerrechte') %]</span>
                    </div>
                    <div class="col-sm-6 text-end">
                        <span class="btn btn-outline-secondary active"><a href="index.php?module=reporting&class=userrightreport&event=userGroups" target="_top">[% $user->gettext('Nur Gruppen') %]</a></span>
                        <span class="btn btn-outline-secondary"><a href="index.php?module=reporting&class=userrightreport&event=justUsers" target="_top">[% $user->gettext('Ohne Gruppen') %]</a></span>
                        <span class="btn btn-outline-secondary"><a href="index.php?module=reporting&class=userrightreport" target="_top">[% $user->gettext('Mit Gruppen') %]</a></span>
                        <span class="btn btn-outline-secondary"><a href="index.php?module=reporting&class=userrightreport&event=GroupRightMatrix" target="_top">[% $user->gettext('Gruppenrechte') %]</a></span>

                        [%*<span class="btn btn-outline-secondary"><a href="index.php?module=reporting&class=userrightreport&event=userGroups&excel" target="_blank">Excel</a></span>*%]

                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class='table-responsive' style="max-height: 75vh;">

                    <table id="UserGroupReportTable" class='table table-bordered'>
                        <thead>
                            <tr class="TitleCol">
                                <th>#</th>
                                <th>[% $user->gettext('Name') %]</th>
                                <th>[% $user->gettext('Login') %]</th>
                                <th class="TitleVertical">[% $user->gettext('gesperrt') %]</th>
                                <th>[% $user->gettext('Firma') %]</th>
                                <th>[% $user->gettext('ID') %]</th>
                                    [% foreach from=$Groups item=Group %]

                                    <th  class="TitleVertical [% if $Group.issupportergroup %]isSupportGroup[% /if %]">[% $Group.groupname %]</th>

                                [% /foreach %]
                            </tr>
                        </thead>
                        <tbody>
                            [% foreach from=$Users item=User key=UserID name=UserIteration%]

                                <tr>
                                    <td>[% $smarty.foreach.UserIteration.iteration %]</td>
                                    <td>[% $User.name %]</td>
                                    <td>[% $User.username %]</td>
                                    <td>[% if $User.isblocked %] - [% /if %]</td>
                                    <td>[% $User.company %]</td>
                                    <td>[% $UserID %]</td>
                                    [% foreach from=$Groups item=Group key=GroupID%]
                                        <td class="[% if $Group.issupportergroup %]isSupportGroup[% /if %]">
                                            [% if $User.groups|is_array && $Tools->FCS_InArray($GroupID , $User.groups) %] X [% /if %]
                                        </td>

                                    [% /foreach %]
                                </tr>
                            [% /foreach %]
                        </tbody>

                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<script>
    $(document).ready(function () {
        $('.table').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copy', 'excel',
            ],
            paging: false,
            searching: true,
            ordering: false,
//            stateSave: true,
//            "sPaginationType": "full_numbers",
//            "bLengthChange": true,
//            "iDisplayLength": 200,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "Sorting": [[1, "asc"]]
            }
        });
    })
</script>
