<!-- Component Ticket begin -->

<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>


<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <div class="row">
            <div class="col-sm-6">
                <span class="fcs-card-title h2">[% $user->gettext('Allgemeine Suche') %]</span>
            </div>
            <div class="col-sm-6 text-end">
                <div class="btn-group">

                </div>
            </div>
        </div>
    </div>
    <div class="card-body">

        <div class="row">
            [% if $bigSearch %]               
                <div class="col-lg-12">

                    <div class="card panel-info shadow-sm rounded">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-sm-6">
                                    <span class="fcs-card-title h6">[% $user->gettext('Suche') %]</span>
                                </div>
                                <div class="col-sm-6 text-end">
                                    <div class="btn-group">

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <form action="index.php?module=ticket&amp;event=search"  method="post" class="form-inline">
                                <div class="form-group row mb-3">
                                    <label class=" control-label"> [% $user->gettext('Suchbegriffe') %]</label>


                                    <input type="hidden" name="option" value="ticket" />
                                    <input type="hidden" name="task" value="search" />
                                    <input type="text" name="id" class="form-control ticketid" size="30" maxlength="30" autocomplete="off" value="[% $Words %]" />

                                </div>
                                    <br>
                                <div class="form-group row mb-3 list-form">
                                    <!--<label class="control-label">[% $user->gettext('Bereiche') %]</label>-->
                                    <label for="Tickets"><input type="checkbox" name="SearchFor[]" id="Tickets" value="Tickets" [% if $Tools->FCS_InArray('Tickets' , $SearchFor) %]checked="checked"[% /if %]/>                        
                                        [% $user->gettext('Tickets') %]</label>

                                    [% if $user->hasRight(31) %]
                                        <label for="KBEntries">
                                            <input type="checkbox" name="SearchFor[]" id="KBEntries" value="KBEntries" [% if $Tools->FCS_InArray('KBEntries', $SearchFor) %]checked="checked"[% /if %]/>                        
                                            [% $user->gettext('KB Einträge') %]</label>
                                        [% /if %]

                                    [% if $user->hasRight(42) || $user->hasRight(1005) %]  
                                        <label for="Contacts">
                                            <input type="checkbox" name="SearchFor[]" id="Contacts" value="Contacts" [% if $Tools->FCS_InArray('Contacts', $SearchFor) %]checked="checked"[% /if %]/>                        
                                            [% $user->gettext('Kontakte') %]</label>
                                        [% /if %]

                                    [% if $user->hasRight(40) %]     
                                        <input type="checkbox" name="SearchFor[]" id="Users" value="Users" [% if $Tools->FCS_InArray('Users', $SearchFor) %]checked="checked"[% /if %]/>                        
                                        <label for="Users">[% $user->gettext('Benutzer') %]</label>
                                    [% /if %]

                                    [% if $user->Security->TicketTemplate && $user->hasRight(402) %]
                                        <label for="Templates">
                                            <input type="checkbox" name="SearchFor[]" id="Templates" value="Templates" [% if $Tools->FCS_InArray('Templates', $SearchFor) %]checked="checked"[% /if %]/>                        
                                            [% $user->gettext('Vorlagen') %]</label>    
                                        [% /if %]

                                </div>

                                <div class="form-group row mb-3 list-form">
                                    <input type="submit" class="btn btn-outline-secondary" value="[% $user->gettext('Suchen') %]"/>                                    
                                </div>                        
                            </form>
                        </div>
                    </div>                
                </div>
            [% /if %]
        </div>
        <div class="row">
            <!-- rechte Spalte -->            
            <div   class="[% if $bigSearch %]col-lg-6[% else %]col-lg-12[% /if %]">

                <div class="panel-group" id="leftAccordion" role="tablist" aria-multiselectable="true">                
                    [% if (true && $TicketCount) || ($Tools->FCS_Count($Tickets) OR $Tools->FCS_Count($TicketsAll)) %]
                        <!--Tickets-->
                        <div class="card panel-info shadow-sm rounded">
                            <div class="card-header" role="tab" id="headingTickets">
                                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVEleftAccordion" href="#TicketsPanel" aria-expanded="false" aria-controls="collapseContact">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <h6 class="card-title">
                                        [% $user->gettext('Tickets mit &auml;hnlicher Beschreibung') %] ([% if $bigSearch %][% $TicketCount %][% else %][% if $Tools->FCS_Count($TicketsAll) %][% $Tools->FCS_Count($TicketsAll) %][% /if %][% /if %])
                                    </h6>
                                </div>                                    
                            </div>
                        </a>
                    </div>
                    <div id="TicketsPanel" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingTickets">
                        <div class="card-body" style="overflow:hidden;">
                            [% if $Tools->FCS_Count($Tickets) OR $Tools->FCS_Count($TicketsAll) %]
                                <table id="TicketTable" class="table table-striped"  style="max-width: 40em;">
                                    <thead>                                                    
                                        <tr>
                                            <th>[% $user->gettext('Nr.') %]</th>
                                            <th>[% $user->gettext('Beschreibung') %]</th>
                                            <th>[% $user->gettext('Änderungsdatum') %]</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        [% if $Tools->FCS_Count($TicketsAll) %]              
                                            [% foreach from=$TicketsAll item=Ticket %]
                                                <tr>
                                                    <td>
                                                        <a href="index.php?module=ticket&event=show&id=[% $Ticket.id %]" target="_blank">[% $Ticket.id %]</a>
                                                    </td>
                                                    <td>
                                                        <a href="index.php?module=ticket&event=show&id=[% $Ticket.id %]" target="_blank">[% $Ticket.ticketdescr %]</a>
                                                    </td>
                                                    <td  data-sort="[% $Ticket.updatedate %]">
                                                        <span>[% $Ticket.updatedate|date_format:"%d.%m.%Y %H:%M" %]</span>
                                                    </td>
                                                </tr>
                                            [% /foreach %]
                                        [% /if %]      

                                        [% foreach from=$Tickets item=Ticket %]
                                            <tr>
                                                <td>
                                                    <a href="index.php?module=ticket&event=show&id=[% $Ticket.id %]" target="_blank" >[% $Ticket.id %]</a>
                                                </td>
                                                <td>
                                                    <a href="index.php?module=ticket&event=show&id=[% $Ticket.id %]"  target="_blank">[% $Ticket.ticketdescr %]</a>
                                                </td>
                                                <td data-sort="[% $Ticket.updatedate %]">
                                                    <span>[% $Ticket.updatedate|date_format:"%d.%m.%Y %H:%M" %]</span>
                                                </td>
                                            </tr>
                                        [% /foreach %]
                                    </tbody>
                                </table>
                            [% /if %]
                        </div>
                    </div>
                </div>
            [% else %]
                [% if $Tools->FCS_InArray('Tickets', $SearchFor) %]
                    <div class="card panel-info shadow-sm rounded">
                        <div class="card-body">
                            [% $user->gettext('Keine Tickets gefunden') %]
                        </div>
                    </div>
                [% /if %]
            [% /if %]

            [% if $user->hasRight(31) && $Tools->FCS_Count($KBEntries)%]

                <!--KBEntries-->
                <div class="card panel-info shadow-sm rounded">
                    <div class="card-header" role="tab" id="headingKBEntries">
                        <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVEleftAccordion" href="#KBEntriesPanel" aria-expanded="false" aria-controls="collapseContact">
                            <div class="row">
                                <div class="col-sm-12">
                                    <h6 class="card-title">
                                        [% $user->gettext('Knowledgebase') %] ([% if $Tools->FCS_Count($KBEntries) %][% $Tools->FCS_Count($KBEntries) %][% /if %]) 
                                    </h6>
                                </div>                                       
                            </div>
                        </a>
                    </div>
                    <div id="KBEntriesPanel" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingKBEntries">
                        <div class="card-body">
                            <table id="KBEntrieTable" class="table"  style="max-width: 40em;" >
                                <thead>                                              
                                    <tr>
                                        <th id="Checkobx"><input type="checkbox" class="selectAllKBEntries" value="0" name="AllKBEntries"></th>
                                        <th>[% $user->gettext('Nr.') %]</th>
                                        <th>[% $user->gettext('Artikel') %]</th>
                                        <th>[% $user->gettext('Änderungsdatum') %]</th>
                                            [% if $bigSearch && $user->hasRight(19) %]
                                            <th>
                                            </th>
                                            <th>
                                            </th>
                                        [% /if %]                 
                                    </tr>
                                </thead>
                                <tbody>
                                    [% foreach from=$KBEntries item=Entry %]
                                        <!--href="index.php?module=knowledgebase&justdetails=1&fid=[% $Entry.faqdataid %]"-->
                                        <tr class="odd">
                                            <td><input type="checkbox" class="selectKBEntry" value="[% $Entry.faqdataid %]" name="KBEntries[]"/></td>
                                            <td>
                                                <a href="index.php?module=knowledgebase&fid=[% $Entry.faqdataid %]" target="_blank">
                                                    [% $Entry.faqdataid %]
                                                </a>
                                            </td>
                                            <td>
                                                <a href="index.php?module=knowledgebase&fid=[% $Entry.faqdataid %]" target="_blank">
                                                    [% $Entry.shortdescription %]
                                                </a>
                                            </td>
                                            <td data-sort="[% $Entry.updatedate %]">
                                                <span>[% $Entry.updatedate|date_format:"%d.%m.%Y %H:%M" %]</span>
                                            </td>
                                            [% if $bigSearch && $user->hasRight(19) %]
                                                <td>
                                                    <a href="index.php?module=knowledgebase&event=edit&fid=[% $Entry.faqdataid %]" target="_blank">
                                                        <span class="fa fa-pencil" title="[% $user->gettext('Bearbeiten') %]"></span>
                                                    </a>
                                                </td>
                                            [% /if %]   
                                            [% if $bigSearch && $user->hasRight(19) %]
                                                <td>
                                                    <a href="index.php?module=knowledgebase&event=remove&FAQDataID=[% $Entry.faqdataid %]&ShortDescription=[% $Entry.shortdescription %]&View=Search&SearchValue=[% $Words %]">
                                                        <span class="fa fa-trash" title="[% $user->gettext('Löschen') %]"></span>
                                                    </a>
                                                </td>
                                            [% /if %]   

                                        </tr>
                                    [% /foreach %]
                                </tbody>
                            </table>
                            <div class="row">
                                <div class="col-sm-12" data-bs-toggle="tooltip" title="[% $user->gettext('Markieren Sie Knowledgebase-Artikel um diese gesammelt zu löschen') %]">
                                    <button title="[% $user->gettext('Auswahl löschen') %]" class="btn btn-outline-primary disabled" id="ToggleKBCollection" onclick="DeleteKBEntries()" style="margin:20px 0;" ><span class='fa fa-trash'></span> [% $user->gettext('Auswahl löschen') %]</Button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            [% else %]
                [% if $user->hasRight(31) && $Tools->FCS_InArray('KBEntries', $SearchFor) %]
                    <div class="card panel-info shadow-sm rounded">
                        <div class="card-body">
                            [% $user->gettext('Keine Knowledgebase-Beiträge gefunden') %]
                        </div>
                    </div>
                [% /if %]
            [% /if %]

            [% if $user->Security->TicketTemplate && $user->hasRight(402) && true && $Tools->FCS_Count($Templates)  %]
                <!--Templates-->
                <div class="card panel-info shadow-sm rounded">
                    <div class="card-header" role="tab" id="headingTemplates">
                        <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVEleftAccordion" href="#TemplatesPanel" aria-expanded="false" aria-controls="collapseContact">
                            <div class="row">
                                <div class="col-sm-6">
                                    <h6 class="card-title">
                                        [% $user->gettext('Ticketvorlagen') %] ([% if $Tools->FCS_Count($Templates) %][% $Tools->FCS_Count($Templates) %][% /if %])
                                    </h6>
                                </div>
                                <div class="col-sm-6">

                                </div>
                            </div>
                        </a>
                    </div>
                    <div id="TemplatesPanel" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingTemplates">
                        <div class="card-body">
                            <table class="table"  style="max-width: 40em;" >
                                <thead>
                                    <tr>
                                        <th>[% $user->gettext('Vorlage') %]</th>
                                        <th>&nbsp;</th>
                                            [% if $bigSearch && $user->hasRight(401) %]
                                            <th>
                                                &nbsp;
                                            </th>
                                        [% /if %]    
                                    </tr>
                                </thead>
                                <tbody>
                                    [% foreach from=$Templates item=Template %]
                                        <tr class="odd">
                                            <td>
                                                [% $Template.shortdescr %]
                                            </td>
                                            <td>
                                                <a href="index.php?module=ticket&event=newTicket&amp;TicketTemplateID=[% $Template.tickettemplateid %]" class="btn btn-outline-primary">[% $user->gettext('Verwenden') %]</a>
                                                <br />
                                            </td>
                                            [% if $bigSearch && $user->hasRight(401) %]
                                                <td>
                                                    <a href="#" class="btn btn-outline-secondary" title="[% $user->gettext('Bearbeiten') %]" onclick="document.location.href = 'index.php?module=tickettemplate&event=editTemplate&id=[% $Template.tickettemplateid %]';
                                                                return false;">
                                                        <span class="fa fa-pencil"></span>
                                                    </a>                                                                
                                                </td>
                                            [% /if %]             
                                        </tr>
                                    [% /foreach %]
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            [% else %]
                [% if $user->Security->TicketTemplate && $user->hasRight(402) && $Tools->FCS_InArray('Templates', $SearchFor) %]
                    <div class="card panel-info shadow-sm rounded">
                        <div class="card-body">
                            [% $user->gettext('Keine Vorlagen gefunden') %]
                        </div>
                    </div>
                [% /if %]
            [% /if %]                        
            [% if $bigSearch %]     
            </div>
        </div>
        <div class="col-sm-6">
            <div class="panel-group" id="leftAccordion" role="tablist" aria-multiselectable="true">

                [% if $user->hasRight(40) && $Tools->FCS_InArray('Users', $SearchFor) && $Tools->FCS_Count($Users) %]
                    <!--Users-->
                    <div class="card panel-info shadow-sm rounded">
                        <div class="card-header" role="tab" id="headingUsers">
                            <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVEleftAccordion" href="#UsersPanel" aria-expanded="false" aria-controls="collapseContact">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <h6 class="card-title">
                                            [% $user->gettext('Benutzer') %] ([% if $Tools->FCS_Count($Users) %][% $Tools->FCS_Count($Users) %][% /if %])
                                        </h6>
                                    </div>
                                    <div class="col-sm-8">

                                    </div>
                                </div>
                            </a>
                        </div>
                        <div id="UsersPanel" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingUsers">
                            <div class="card-body">
                                <table id="UserTable" class="table"  style="max-width: 40em;" >
                                    <thead>              
                                        <tr>
                                            <th>[% $user->gettext('ID') %]</th>
                                            <th>[% $user->gettext('Name') %]</th>
                                            <th>[% $user->gettext('Username') %]</th>
                                            <th>[% $user->gettext('eMail') %]</th>
                                            <th>[% $user->gettext('Letzte Anmeldung') %]</th>
                                                [% if $bigSearch && $user->hasRight(40) %]
                                                <th> [% $user->gettext('Bearbeiten') %] </th>
                                                [% /if %]                 
                                        </tr>
                                    </thead>
                                    <tbody>
                                        [% foreach from=$Users item=User %]
                                            <tr class="odd">
                                                <td>
                                                    [% $User.user_id %]
                                                </td>
                                                <td>
                                                    [% $User.name %]
                                                </td>
                                                <td>
                                                    [% $User.username %]
                                                </td>
                                                <td>
                                                    [% $User.email %]
                                                </td>
                                                <td data-sort="[% $User.lastvisitdate %]">
                                                    <span>[% $User.lastvisitdate|date_format:"%d.%m.%Y %H:%M" %]</span>
                                                </td>
                                                [% if $bigSearch && $user->hasRight(40) %]
                                                    <td>
                                                        <a class="btn btn-outline-secondary" href="index.php?module=user&event=edit&id=[% $User.user_id %]">
                                                            <span class="fa fa-pencil" title="[% $user->gettext('Bearbeiten') %]" ></span>
                                                        </a>
                                                    </td>
                                                [% /if %]                 
                                            </tr>
                                        [% /foreach %]
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                [% else %]
                    [% if $user->hasRight(40) && $Tools->FCS_InArray('Users', $SearchFor) %]
                        <div class="card panel-info shadow-sm rounded">
                            <div class="card-body">
                                [% $user->gettext('Keine Benutzer gefunden') %]
                            </div>
                        </div>
                    [% /if %]
                [% /if %]

                [% if ($user->hasRight(42) || $user->hasRight(1005)) && $Tools->FCS_InArray('Contacts', $SearchFor)  && $Tools->FCS_Count($Contacts) %]  
                    <!--Contacts-->
                    <div class="card panel-info shadow-sm rounded">
                        <div class="card-header" role="tab" id="headingContacts">
                            <a class="collapsed" role="button" data-toggle="collapse" data-parent="#DEACTIVEleftAccordion" href="#ContactsPanel" aria-expanded="false" aria-controls="collapseContact">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <h6 class="card-title">
                                            [% $user->gettext('Kontakte') %] ([% if $Tools->FCS_Count($Contacts) %][% $Tools->FCS_Count($Contacts) %][% /if %])
                                        </h6>
                                    </div>
                                    <div class="col-sm-8">

                                    </div>
                                </div>
                            </a>
                        </div>
                        <div id="ContactsPanel" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingContacts">
                            <div class="card-body">
                                <table id="ContactTable" class="table"  style="max-width: 40em;" >
                                    <thead>                                               
                                        <tr>
                                            <th>[% $user->gettext('ID') %]</th>
                                            <th>[% $user->gettext('Kontakt') %]</th>
                                            <th>[% $user->gettext('eMail') %]</th>
                                                [% if $bigSearch && ($user->hasRight(42) || $user->hasRight(3)) %]
                                                <th>
                                                    [% $user->gettext('Bearbeiten') %]
                                                </th>
                                            [% /if %]                 
                                        </tr>
                                    </thead>
                                    <tbody>
                                        [% foreach from=$Contacts item=Contact %]
                                            <tr class="odd">
                                                <td>
                                                    [% $Contact.contact_id %]
                                                </td>
                                                <td>
                                                    [% $Contact.name %]
                                                </td>
                                                <td>
                                                    [% $Contact.email %]
                                                </td>
                                                [% if $bigSearch && ($user->hasRight(42) || $user->hasRight(3)) %]
                                                    <td>
                                                        <div class="btn-group">
                                                            [% if $user->hasRight(42) %]
                                                                <a href="index.php?module=contact&event=edit&id=[% $Contact.contact_id %]" class="btn btn-outline-secondary btn-sm">
                                                                    <span class="fa fa-pencil" title="[% $user->gettext('Bearbeiten') %]"></span>
                                                                </a>
                                                            [% /if %]
                                                            [% if $user->hasRight(3) %]
                                                                <a class="btn btn-outline-primary btn-sm openInBigIFrameModal" href="index.php?module=ticketlist&amp;event=ContactTickets&amp;id=[% $Contact.contact_id %]&amp;indetail=1" title="[% $user->gettext('Tickets des Kontakts anzeigen') %]">
                                                                    <span class="fa fa-search" aria-hidden="true"></span>
                                                                </a>
                                                            [% /if %]
                                                        </div>
                                                    </td>
                                                [% /if %]                 
                                            </tr>
                                        [% /foreach %]
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                [% else %]
                    [% if ($user->hasRight(42) || $user->hasRight(1005)) && $Tools->FCS_InArray('Contacts', $SearchFor) %]
                        <div class="card panel-info shadow-sm rounded">
                            <div class="card-body">
                                [% $user->gettext('Keine Kontakte gefunden') %]
                            </div>
                        </div>
                    [% /if %]
                [% /if %]
            [% /if %]     
        </div>
    </div>            
</div>

</div>
</div>
<div class="modal" id="articleModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body" id='articleContent' style='max-height: 600px; overflow-y:scroll;'>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">[% $user->gettext('Schließen') %]</button>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    /**
     * Comment
     */
    function openDialogBox(faqdataid) {
        $("#articleContent").load("index.php?module=knowledgebase&justdetails=1&fid=" + faqdataid, function (data, status, jqXGR) {  // callback function 
            $("#articleModal").modal('show');
        });



        return;

    }
    $(document).ready(function () {
    [% if $bigSearch %]
        $.fn.dataTable.ext.classes.sPageButton = '';
        $('#UserTable, #ContactTable, #KBEntrieTable, #TicketTable').dataTable({
            order: [[0, 'desc']],
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "oLanguage": {
                "sLengthMenu": "Zeige _MENU_ Eintr&auml;ge",
                "sZeroRecords": "Keine Eintr&auml;ge gefunden",
                "sInfo": "Eintrag _START_ bis _END_ (von _TOTAL_)",
                "sInfoEmpty": " ",
                "sInfoFiltered": " - gefiltert aus _MAX_ Eintr&auml;gen",
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                }
            }
        });

    [% /if %]
        $(".dialog_Beitragssuche")
                .fancybox({
                    'type': 'iframe',
                    'autoSize': false,
                    'width': 1000,
                    'height': 600,
                    'autoResize': true,
                    'autoCenter': true
                });

    });

    var checkboxes = [];
    localStorage.removeItem("checkboxes");

    if (checkboxes.length >= 1) {
        $("#ToggleKBCollection").removeClass('disabled');
    }

    $(".selectKBEntry").on("change", function () {
        if (this.checked) {
            if (checkboxes.indexOf($(this).val()) == -1) {
                checkboxes.push($(this).val());
            }
            if (checkboxes.length >= 1) {
                $("#ToggleKBCollection").removeClass('disabled');
            }
        } else {
            if (checkboxes.indexOf($(this).val()) != -1) {
                checkboxes.splice(checkboxes.indexOf($(this).val()), 1)
            }
            if (checkboxes.length <= 0) {
                $("#ToggleKBCollection").addClass('disabled');
            }
        }
        localStorage.setItem("checkboxes", JSON.stringify(checkboxes));
    });

    $(".selectKBEntry").each(function () {
        if (checkboxes.indexOf($(this).val()) != -1) {
            $(this).prop("checked", true);
        }
    });

    $(".selectAllKBEntries").on("change", function ()
    {
        var CheckBox = $(this);

        $(".selectKBEntry").each(function ()
        {
            if ($(CheckBox).is(":checked"))
            {
                $(this).prop("checked", true);

                if (checkboxes.indexOf($(this).val()) == -1)
                    checkboxes.push($(this).val());

                if (checkboxes.length >= 1)
                    $("#ToggleKBCollection").removeClass('disabled');
            } else
            {
                $(this).prop("checked", false);

                if (checkboxes.indexOf($(this).val()) != -1)
                    checkboxes.splice(checkboxes.indexOf($(this).val()), 1)

                if (checkboxes.length <= 0)
                    $("#ToggleKBCollection").addClass('disabled');
            }
        });

        localStorage.setItem("checkboxes", JSON.stringify(checkboxes));
    });

    function DeleteKBEntries()
    {
         bootbox.confirm('[% $user->gettext("Möchten Sie die ausgewählten Artikel wirklich entfernen?") %]', function (result) {
                        if (result) {
                                var values = JSON.parse(localStorage.getItem("checkboxes"));
                                var KBEntryIDs = values.join();
                                if (values.length == 0)
                                {
                                    alert("Wählen Sie bitte mindestens ein Knowledgebase-Artikel zum Löschen");
                                    return;
                                }

                                $.ajax({
                                    type: "POST",
                                    url: "index.php?module=knowledgebase&event=DeleteCollection",
                                    data: {
                                        KBEntryIDs: KBEntryIDs
                                    }
                                }).done(function (data)
                                {
                                    $("#selectAllKBEntries").prop("checked", false);
                                    location.reload();
                                });

                                return false;

                        }
                       
                    });
   
    }

</script> 
