<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <div class="row">
            <div class="col-sm-6">
                <h3 class="card-title-fcs">[% $user->gettext('Projektinformationen') %]</h3>
            </div>
            <div class="col-sm-6">
                <a href="index.php?module=project&amp;event=edit&amp;id=[% $project.projectid %]" class="btn btn-outline-primary btn-sm text-end" target="_blank">[% $user->gettext('Projektdetails anzeigen') %]</a>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div  class="form-group row mb-3">
            <label class="control-label col-sm-2" >[% $user->gettext('Projekttyp') %]</label>
            <div class="col-sm-10">
                <input type="text" class="form-control"  readonly="readonly" value="[% $project.projectname %]" />
            </div>
        </div>
        [% if $ref_level1_name|trim != '' %]
            <div  class="form-group row mb-3">
                <label class="control-label col-sm-2">[% $user->gettext($ref_level1_name) %]</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control"  readonly="readonly" value="[% $project.ref_level1_label %]" />
                </div>
            </div>
        [% /if %]


        <div  class="form-group row mb-3">
            <label class="control-label col-sm-2">[% $user->gettext('Verantwortlicher') %]</label>
            <div class="col-sm-10">
                <input type="text" class="form-control"  readonly="readonly" value="[% if $project.employee %][% $project.employee %][% else %][% $project.contactname %][% /if %]" />
            </div>
        </div>
        [% if $ref_level2_name|trim != '' %]
            <div  class="form-group row mb-3">
                <label class="control-label col-sm-2">[% $user->gettext($ref_level2_name) %]</label>
                <div class="col-sm-10">
                    [% if $ticketstatusid != 3 && $ticketstatusid != 7 %]
                        <select name="Level2ID" class="form-control" id="Level2ID">
                            <option value="">[% $user->gettext('&gt;&gt; Bitte ausw&auml;hlen &lt;&lt;') %]</option>
                            [% html_options options=$project.ref_level2 selected=$ref_level2_id %]
                        </select>
                    [% else %]
                        <input type="text" class="form-control" value="[% $project.ref_level2[$ref_level2_id] %]" readonly="readonly"/>
                    [% /if %]
                </div>
            </div>
        [% /if %]
        [% if $project.department != "" %]
            <div  class="form-group row mb-3">
                <label class="control-label col-sm-2">[% $user->gettext('Abteilung') %]</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" value="[% $project.department %]" readonly="readonly" />
                </div>
            </div>
        [% /if %]

[% if $user->hasRight(506) %]
        <div  class="form-group row mb-3">
            <label class="control-label col-sm-2">[% $user->gettext('Laufzeit') %]</label>

            <div class="col-sm-4">
                <div class="input-group">
                    <span class="input-group-text">[% $user->gettext('Von') %]</span>
                    <input type="text" class="form-control" value='[% $project.startdate %]' readonly="readonly" />
                </div>
            </div>
            <div class="col-sm-4">
                <div class="input-group">
                    <span class="input-group-text">[% $user->gettext('bis') %]</span>
                    <input type="text" class="form-control" value="[% $project.enddate %]" readonly="readonly" />
                </div>
            </div>

        </div>

        <div  class="form-group row mb-3">
            <label class="control-label col-sm-2">[% $user->gettext('Budget') %]</label>
            <div class="col-sm-4">
                <div class="input-group">
                    <input type="text" class="form-control" value="[% $project.estimatedbudget %]" readonly="readonly" />
                    <span class="input-group-text">[% if $hmcompany == 'OTTO FISCHER AG' %]CHF[% else %][% $user->getCurrencyDescr() %][% /if %]</span>
                </div>
            </div>
        </div>

        <div  class="form-group row mb-3">
            <label class="control-label col-sm-2">[% $user->gettext('Kosten') %]</label>
            <div class="col-sm-4">
                <div class="input-group">
                    <span class="input-group-text">[% $user->gettext('SOLL') %]</span>
                    <input type="text" class="form-control" value="[% $project.runningcosts %]" readonly="readonly" />
                    <span class="input-group-text">[% if $hmcompany == 'OTTO FISCHER AG' %]CHF[% else %][% $user->getCurrencyDescr() %][% /if %]</span>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="input-group">
                    <span class="input-group-text">[% $user->gettext('IST') %]</span>
                    <input type="text" class="form-control" value="[% $project.usedbudget %]" readonly="readonly" />
                    <span class="input-group-text">[% if $hmcompany == 'OTTO FISCHER AG' %]CHF[% else %][% $user->getCurrencyDescr() %][% /if %]</span>
                </div>
            </div>
        </div>
[% /if %]
        <div  class="form-group row mb-3">
            <label class="control-label col-sm-2">[% $user->gettext('Beschreibung') %]</label>
            <div class="col-sm-10">
               <p style="border: 1px solid #e2e3e5; padding: 10px;">[% $project.description %]</p>
            </div>
        </div>
    </div>

</div>
