<!-- Latest compiled and minified CSS -->
<link rel="stylesheet" href="includes/js/bootstrap-select-1.12.4/dist/css/bootstrap-select.min.css">
<!-- Latest compiled and minified JavaScript -->
<script src="includes/js/bootstrap-select-1.12.4/dist/js/bootstrap-select.min.js"></script>
<!-- (Optional) Latest compiled and minified JavaScript translation files -->
<script src="includes/js/bootstrap-select-1.12.4/dist/js/i18n/defaults-[% if $user->language_type == "de" %]de_DE[% else %]en_US[% /if %].min.js"></script>
<form [% if !$snippet %]action="index.php?module=ticket&class=snippets&event=addNew"[% else %]action="index.php?module=ticket&class=snippets&event=editSnippet&id=[% $snippet.ID %]"[% /if %]  id="addSnippetForm"  method="POST" class="form-horizontal form-label-left">
    <input type="hidden" name="SnippetID" value="[% $snippet.ID %]" />
    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <div class="row">
                <div class="col-sm-8">
                    [% if !$snippet %]
                        <span class="fcs-card-title h2">[% $user->gettext('Textbaustein erstellen') %]</span>
                    [% else %]
                        <span class="fcs-card-title h2">[% $user->gettext('Textbaustein bearbeiten') %]</span>
                    [% /if %]
                </div>
                <div class="col-lg-4 text-end">
                    <div class="btn-group">
                        <input type="submit" class="btn btn-outline-primary lightContrast" value="[% $user->gettext('Speichern') %]" />
                        <button role='button' class='btn btn-outline-primary lightContrast' onclick="window.location = 'index.php?module=ticket&class=snippets&event=manageSnippets'">[% $user->gettext('Liste') %]</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="form-group row mb-3">
                <label class="col-lg-2 control-label">[% $user->gettext('Titel') %]</label>
                <div class="col-lg-10">
                    <input type="text" name="title" maxlength="100" class="form-control" value="[% $snippet.Title %]" required="required" placeholder="[% $user->gettext('Titel des Textbausteines') %]"/>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-lg-2 control-label">[% $user->gettext('Rubrik') %]</label>
                <div class="col-lg-10">
                    <select name="RubricID" id="RubricID" class="form-control select">
                        [% foreach $SnippetRubrics as $Rubric %]
                            <option value="[% $Rubric.SnippetRubricID %]" [% if $snippet.SnippetRubricID == $Rubric.SnippetRubricID %]selected="selected"[% /if %]>[% $Rubric.Name %]</option>
                        [% /foreach %]
                    </select>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-lg-2 control-label">[% $user->gettext('Ticketvorlagen') %]</label>
                <div class="col-lg-10 bg-default" id="SelectedTicketTemplates">
                    <select class="form-control selectpicker" name="TicketTemplateID[]" id="TicketTemplateID" data-live-search="true" data-selected-text-format="count>5"
                            data-count-selected-text= "[%$user->gettext('Ticketvorlage')%] ({0} [%$user->gettext('gewählt')%])" title="[% $user->gettext('Ticketvorlagen') %]" multiple>
                        [% foreach $ticketTemplates as $ticketTemplate %]
                            <option value="[% $ticketTemplate->TicketTemplateID %]" [% if $ticketTemplate->selected %]selected="selected"[% /if %]>[% if $ticketTemplate->ShortDescr %][% $ticketTemplate->ShortDescr %][% else %][% $ticketTemplate->title %][% /if %]</option>
                        [% /foreach %]
                    </select>
                    <span class="help-block">[% $user->gettext('Wenn nichts gewählt ist, kann der Textbaustein in allen Ticketvorlagen verwendet werden.') %]</span>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-lg-2 control-label">Text</label>
                <div class="col-lg-10">
                    <div id="quillEditor">
                        [% $user->getQuillToolbar(0,1) %]
                        <div id="editor" style="min-height: 200px;">

                        </div>
                    </div>
                    <textarea name="snippet" required="required" id="LongDescr"  class="form-control" style="height: 0px; visibility:hidden;">[% $snippet.Snippet %]</textarea>
                </div>
            </div>
            [% if $user->hasRight(224) %]
                <div class="form-group row mb-3">
                    <label class="col-lg-2 control-label" for="public">[% $user->gettext('Öffentlich') %]</label>
                    <div class="col-lg-10">
                        <input type="checkbox" name="public" [% if $snippet.ispublic %]checked="checked"[% /if %]>
                    </div>
                </div>
            [% /if %]
        </div>
    </div> 
</form>
<script  src="includes/js/hm-quill.js"></script>
<script>
                            var editor = document.getElementsByClassName('ql-editor');
                            editor[0].innerHTML = `[% if [% $snippet.Snippet %] %][% [% $snippet.Snippet %] %][% /if %]`;

                            setTimeout(() => {
                                quill.focus();
                            })
</script>
