<script type="text/javascript" src="includes/js/bs_DataTables/datatables.min.js"></script>
<link rel="stylesheet" type="text/css" href="includes/js/bs_DataTables/datatables.min.css" media="screen" />


<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Benutzer') %]</span>
    </div>
    <div class="card-body">
        <div class="card panel-info shadow-sm rounded">
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-6">

                    </div>
                    <div class="col-lg-6 text-end">
                        <div class="btn-group">
                            <a  class="btn btn-outline-primary" type="button" href="index.php?module=user&event=create">
                                [%$user->gettext('Neuer Benutzer')%] 
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <span class="fcs-card-title h3">[% $user->gettext('Benutzerliste') %]</span>[% if $Tools->FCS_Count($nav.entries) %]<span class="fcs-card-title"> - [% $nav.entries %] [% $user->gettext('Eintr&auml;ge gefunden') %]</span>[% /if %]
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th >
                                    [% $user->gettext('Name') %]

                                </th>
                                <th >
                                    [% $user->gettext('Username') %]

                                </th>
                                <th >
                                    [% $user->gettext('Sprache') %]

                                </th>
                                <th >
                                    [% $user->gettext('Aktiv') %]

                                </th>
                                <th >
                                    [% $user->gettext('E-Mail') %]
                                </th>
                                <th >
                                    [% $user->gettext('Letzter Login') %]
                                </th>
                                <th>
                                    [% $user->gettext('ID') %]

                                </th>
                                <th>&nbsp;</th>
                            </tr>
                        </thead>
                        <tbody>
                            [% foreach from=$users item=iuser name=userlist %]
                                <tr>
                                    <td>[% $smarty.foreach.userlist.iteration %]</td>
                                    <td>[% $iuser.name %]</td>
                                    <td>[% $iuser.username %]</td>
                                    <td><div><img src="images/[% $iuser.language_type %].gif" alt="[% $iuser.language_type %]"></div></td>
                                    <td><span style="color:[% if $iuser.block == 1 %]red[% else %]green[% /if %];" class="fa fa-[% if $iuser.block == 1 %]xmark[% else %]check[% /if %]"></td>
                                    <td><a href="mailto:[% $iuser.email %]" [% if !$iuser.sendemail %]class="dontSendMails" style="color:lightgrey;" title="[% $user->gettext('Mailversand an Benutzer nicht aktiv') %]"[% /if %]>[% $iuser.email %]</a></td>
                                    <td data-sort="[% $iuser.sort_visited %]">[% $iuser.visited %]</td>
                                    <td>[% $iuser.user_id %]</td>
                                    <td>

                                        [% if $iuser.user_id != 1 && $user->hasRight(41) %]
                                            <a href="index.php?module=user&event=remove&id=[% $iuser.user_id %]" class="btn btn-outline-secondary" onclick="return confirm('[% $iuser.name %] wirklich l&ouml;schen?');" >
                                                <span class="fa fa-trash" title="[% $user->gettext('L&ouml;schen') %]"></span>
                                            </a>
                                        [% /if %]

                                        [% if $user->hasRight(40) %]
                                            <a class="btn btn-outline-secondary" href="index.php?module=user&event=edit&id=[% $iuser.user_id %]"><span class="fa fa-pencil" title="[% $user->gettext('Bearbeiten') %]"></span></a>
                                            [% /if %]
                                    </td>
                                </tr>
                            [% /foreach %]
                        </tbody>

                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Datatables -->


<script>
    $(document).ready(function () {
        $('.table').DataTable({
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "oLanguage": {
                "sLengthMenu": "Zeige _MENU_ Eintr&auml;ge",
                "sZeroRecords": "Keine Eintr&auml;ge gefunden",
                "sInfo": "Eintrag _START_ bis _END_ (von _TOTAL_)",
                "sInfoEmpty": " ",
                "sInfoFiltered": " - gefiltert aus _MAX_ Eintr&auml;gen",
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            }
        });
    })
</script>
