<!-- active_workflow_list.tpl -->
[% if $Tools->FCS_Count($WFIs) %]
    <h4>[% $user->gettext('Aktivierte Workflows') %]</h4>
    <div class="card panel-fcs-border shadow-sm">
        <div class="card-body">

            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>
                                [% $user->gettext('ID') %]
                            </th>
                            <th>
                                [% $user->gettext('Bezeichnung') %]
                            </th>
                            <th>
                                [% $user->gettext('WF-Definition') %]
                            </th>

                            <th>
                                [% $user->gettext('Initiator') %]
                            </th>
                            <th>
                                [% $user->gettext('Startdatum') %]
                            </th>
                            <th>
                                [% $user->gettext('vorrauss. Enddatum') %]
                            </th>
                            <th>
                                [% $user->gettext('Status') %]
                            </th>
                            <th>
                                [% $user->gettext('Aktion') %]
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        [% foreach from=$WFIs item=wfi %]
                            <tr>
                                <td>
                                    [% $wfi.ID %]
                                </td>
                                <td>
                                    [% $wfi.ShortDescr %]
                                </td>
                                <td>
                                    [% $wfi.WFDDescr %]
                                </td>
                                <td>
                                    [% $wfi.Username %] ([% $wfi.Name %])
                                </td>
                                <td>
                                    [% $wfi.StartDate %]
                                </td>
                                <td>
                                    [% $wfi.EndDate %]
                                </td>
                                <td>
                                    [% $user->gettext($wfi.Status) %]
                                </td>
                                <td>
                                    <a href="index.php?module=workflow&amp;event=showactivewf&amp;wfiid=[% $wfi.ID %]" class="btn btn-outline-secondary"><span class="fa fa-search" title="[% $user->gettext('Anzeigen') %]"></span></a>


                                    <a href="index.php?module=workflow&amp;event=showReport&amp;wfiid=[% $wfi.ID %]" title="[% $user->gettext('Bericht') %]" data-fancybox-type="iframe" class="btn btn-outline-secondary dialog" >
                                        <span class="fa fa-envelope" title="[% $user->gettext('Bericht') %]"></span>
                                    </a>
                                </td>
                            </tr>
                        [% foreachelse %]

                        [% /foreach %]
                    </tbody>
                </table>
            </div>
        </div>
    </div>
[% else %]
[% /if %]
