<!-- report.tpl -->
<link rel="stylesheet" type="text/css" href="styles/[% $CSSTEMPLATE %]/css/workflow.css" media="screen" />

[% if false %]
    <script type="text/javascript" src="includes/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" type="text/css" href="styles/default/css/jquery.dataTables.css" media="screen" />
[% else %]
<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.js"></script>
    <script type="text/javascript" src="includes/js/datatables/datatables.date-de.js"></script>
[% /if %]


<!-- workflow_list.tpl -->
<form action="" method="post" name="hm" id="hm_WFReport" enctype="multipart/form-data" class="form-inline fcs-form-padding">
    <input type="hidden" name="WFICount" id="WFICount" value="[% $Tools->FCS_Count($WFIs) %]" />
    <!-- ###CONTENT### begin -->
    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <span class="fcs-card-title h2">[% $user->gettext('Workflow Report') %]</span>
        </div>
        <div class="card-body">
            <div class="card panel-info shadow-sm rounded">
                <div class="card-body list-form">
                    <div class="form-group">
                        <label class="control-label">[%$user->gettext('Definition wählen')%]</label>
                        <select name="wfdid" id="FilterDefinition" class="form-control" onchange="submit();" >
                            [% html_options options=$WFDefs selected=$WFDefinitionID %]
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="control-label">[%$user->gettext('Workflow')%]</label>
                        <div class="input-group">
                            <div class="input-group-text">[%$user->gettext('ab')%]</div>
                            <input type="text" name="startdate" class="form-control datepicker"  value="[% $startdate %]" onchange="submit();"/>
                            <div class="input-group-text">[%$user->gettext('bis')%]</div>
                            <input type="text" name="enddate" class="form-control datepicker" value="[% $enddate %]" onchange="submit();"/>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card panel-info shadow-sm rounded">
                <div class ="card-header">
                    <span class="fcs-card-title h3">[%$user->gettext('Liste')%]</span>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="WFReportTable">
                            <thead>
                                <tr class="fields">
                                    <th colspan="9" style="text-align: center;">Workflow</th>
                                        [% foreach from=$ActivityTitles item=ActivityTitle key=ADefID %]
                                        <th colspan="[% $Tools->FCS_Count($FieldTitles.$ADefID) %]" style="text-align: center;">[% $ActivityTitle %]</th>
                                        [% /foreach %]
                                </tr>
                                <tr class="fields">
                                    <th>[%$user->gettext('ID')%]</th>
                                    <th>[%$user->gettext('Bezeichnung')%]</th>
                                    <th>[%$user->gettext('Initiator')%]</th>
                                    <th>[%$user->gettext('Startdatum')%]</th>
                                    <th>[%$user->gettext('Enddatum')%]</th>
                                    <th>[%$user->gettext('Dauer')%]</th>
                                    <th>[%$user->gettext('Anzahl Aktivitäten')%]</th>
                                    <th>[%$user->gettext('Status')%]</th>
                                    <th>[%$user->gettext('Dokumente')%]</th>

                                    [% foreach from=$FieldTitles item=Titles key=ADefID %]
                                        [% foreach from=$Titles item=Title %]
                                            <th>[% $Title %]</th>
                                        [% /foreach %]
                                    [% /foreach %]
                                </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                    <th>[%$user->gettext('ID')%]</th>
                                    <th>[%$user->gettext('Bezeichnung')%]</th>
                                    <th>[%$user->gettext('Initiator')%]</th>
                                    <th>[%$user->gettext('Startdatum')%]</th>
                                    <th>[%$user->gettext('Enddatum')%]</th>
                                    <th>[%$user->gettext('Dauer')%]</th>
                                    <th>[%$user->gettext('Anzahl Aktivitäten')%]</th>
                                    <th>[%$user->gettext('Status')%]</th>
                                    <th></th>

                                    [% foreach from=$FieldTitles item=Titles key=ADefID %]
                                        [% foreach from=$Titles item=Title %]
                                            <th>[% $Title %]</th>
                                        [% /foreach %]
                                    [% /foreach %]
                                </tr>
                            </tfoot>

                            <tbody>
                                [% foreach from=$WFIs item=wfi %]
                                    <tr style="cursor:pointer;">
                                        <td>
                                            <a href="index.php?module=workflow&event=showactivewf&fromDetailReport&wfiid=[% $wfi.ID %]" title="Bericht anzeigen">[% $wfi.ID %]</a>
                                        </td>
                                        <td>
                                            [% $wfi.ShortDescr %]</a>
                                        </td>
                                        <td>
                                            [% $wfi.Username %] ([% $wfi.Name %])
                                        </td>
                                        <td data-order="[% $wfi.StartDate %]">[% $wfi.StartDate|date_format:"%d.%m.%Y %H:%M" %]</td>
                                        <td data-order="[% $wfi.EndDate %]">[% $wfi.EndDate|date_format:"%d.%m.%Y %H:%M" %]</td>
                                        <td>
                                            [% $wfi.duration_total %]
                                        </td>
                                        <td>
                                            [% $wfi.countActivities %]
                                        </td>
                                        <td>
                                            [% $user->gettext($wfi.Status) %]
                                        </td>
                                        <td>
                                            <ul>
                                                [% foreach from=$wfi.Documents item=document %]
                                                    <li>[% $document %]</li>
                                                [% /foreach %]
                                            </ul>
                                        </td>

                                        [% foreach from=$FieldTitles item=Titles key=ADefID %]
                                            [% foreach from=$Titles item=Title key=key %]
                                                [% if $key == 'Datum' %]
                                                    <td data-order="[% $wfi.Form.$ADefID.$key %]">[% $wfi.Form.$ADefID.$key|date_format:"%d.%m.%Y %H:%M" %]</td>
                                                [% else %]
                                                    <td>[% $wfi.Form.$ADefID.$key %]</td>
                                                [% /if %]
                                            [% /foreach %]
                                        [% /foreach %]

                                    </tr>
                                [% foreachelse %]

                                [% /foreach %]
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<script>

    $("#FilterDefinition").multiselect({
        buttonClass: 'form-select',
    templates: {
        button: '<button type="button" class="multiselect dropdown-toggle" data-bs-toggle="dropdown"><span class="multiselect-selected-text"></span></button>',
    },
        noneSelectedText: 'Definition wählen',
        height: 'auto',
        checkAllText: 'Alle',
        uncheckAllText: 'Keine',
        selectedList: 1,
        selectedText: '# Definitionen gewählt',
        header: false,
        multiple: false
    })

    $(".datepicker").datepicker();

    $(document).ready(function () {
        $('#WFReportTable').DataTable({
            "language": {
                "sEmptyTable": "[% $user->gettext('Keine Daten in der Tabelle vorhanden') %]",
                "sInfo": "[% $user->gettext('_START_ bis _END_ von _TOTAL_ Eintr&auml;gen') %]",
                "sInfoEmpty": "[% $user->gettext('0 bis 0 von 0 Eintr&auml;gen') %]",
                "sInfoFiltered": "[% $user->gettext('(gefiltert von _MAX_ Eintr&auml;gen)') %]",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "[% $user->gettext('_MENU_ Eintr&auml;ge anzeigen') %]",
                "sLoadingRecords": "[% $user->gettext('Wird geladen...') %]",
                "sProcessing": "[% $user->gettext('Bitte warten...') %]",
                "sSearch": "[% $user->gettext('Suchen') %]",
                "sZeroRecords": "[% $user->gettext('Keine Einträge vorhanden.') %]",
                "oPaginate": {
                    "sFirst": "[% $user->gettext('Erste') %]",
                    "sPrevious": "[% $user->gettext('Zur&uuml;ck') %]",
                    "sNext": "[% $user->gettext('N&auml;chste') %]",
                    "sLast": "[% $user->gettext('Letzte') %]"
                },
                "oAria": {
                    "sSortAscending": "[% $user->gettext(': aktivieren, um Spalte aufsteigend zu sortieren') %]",
                    "sSortDescending": "[% $user->gettext(': aktivieren, um Spalte absteigend zu sortieren') %]"
                }
            },
            initComplete: function () {
                this.api().columns().every(function () {
                    var column = this;
                    var select = $('<select><option value=""></option></select>')
                            .appendTo($(column.footer()).empty())
                            .on('change', function () {
                                var val = $.fn.dataTable.util.escapeRegex(
                                        $(this).val()
                                        );

                                column
                                        .search(val ? '^' + val : '', true, true)
                                        .draw();
                            });
                    column.data().unique().sort().each(function (d, j) {
                        select.append('<option value="' + d + '">' + d + '</option>')
                    });
                });
            },
            dom: '<"test"B>tfrip',
            buttons: [
                {
                    extend: 'colvis',
                    text: '[% $user->gettext('Spalten anzeigen') %]'
                },
                , 'copy', 'csv', 'excel',
                {
                    extend: 'print',
                    text: '[% $user->gettext('Drucken') %]'
                },
            ]


        });
    });

</script>
