<?xml version="1.0" encoding="[% $charset %]"?>	

[% if $RSSVersion == "2.0" %]
<rss version="2.0">	
	<channel>		
		<title>[% $RSSTitle %]</title>
    	<link>[% $RSSLocation %]</link>
    	<description>[% $RSSDescription %]</description>
    	<language>[% $RSSLanguage %]</language>	
    	<pubDate>[% $smarty.now|date_format:"%Y-%m-%d %H:%M" %]</pubDate>
		[% foreach from=$Items item=row %]
			<item>
      			<title>[% $row->getTitle() %]</title>
      			<link>[% $row->getLink() %]</link>
      			<description>[% $row->getDescription() %]</description>
      			<author>[% $row->getAuthor() %]</author>
      			<pubDate>[% $row->getPubDate() %]</pubDate>
			</item>
		[% /foreach %]		
	</channel>	
</rss>
[% /if %]


[% if $RSSVersion == "1.0" %]
<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns="http://purl.org/rss/1.0/">
	<channel rdf:about="http://www.xml.com/xml/news.rss">    	
    	<title>[% $RSSTitle %]</title>
    	<link>[% $RSSLocation %]</link>
    	<description>[% $RSSDescription %]</description>
  	</channel>
	[% foreach from=$Items item=row %]  
  		<item rdf:about="http://xml.com/pub/2000/08/09/xslt/xslt.html">
    		<title>[% $row->getTitle() %]</title>
    		<link>[% $row->getLink() %]</link>
    		<description>[% $row->getDescription() %]</description>
  		</item>
	[% /foreach %]
</rdf:RDF>
[% /if %]


[% if $RSSVersion == "0.92" %]
<rss version="0.92">
	<channel>
		<title>[% $RSSTitle %]</title>
		<link>[% $RSSLocation %]</link>
		<description>[% $RSSDescription %]</description>
		<language>[% $RSSLanguage %]</language> 
    	<pubDate>[% $smarty.now|date_format:"%Y-%m-%d %H:%M" %]</pubDate>
		[% foreach from=$Items item=row %]
			<item>
				<title>[% $row->getTitle() %]</title> 
				<link>[% $row->getLink() %]</link> 
				<description>[% $row->getDescription() %]</description> 
			</item>
		[% /foreach %]
	</channel>
</rss>
[% /if %]


[% if $RSSVersion == "0.91" %]
<rss version="0.91">
	<channel>
		<title>[% $RSSTitle|truncate:100:'':true %]</title> 
		<link>[% $RSSLocation|truncate:500:'':true %]</link> 
		<description>[% $RSSDescription|truncate:500:'':true %]</description> 		
		<language>[% $RSSLanguage %]</language> 
    	<pubDate>[% $smarty.now|date_format:"%Y-%m-%d %H:%M" %]</pubDate>		
		[% foreach from=$Items item=row name=itemlist %]		
			[% if $smarty.foreach.itemlist.iteration < 16 %]
				<item>
					<title>[% $row->getTitle()|truncate:100:'':true %]</title> 
					<link>[% $row->getLink()|truncate:500:'':true %]</link> 
					<description>[% $row->getDescription()|truncate:500:'':true %]</description> 
				</item>
			[% /if %]
		[% /foreach %]
	</channel>
</rss>
[% /if %]