<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* CloudPcRegionGroup File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;

use Microsoft\Graph\Core\Enum;

/**
* CloudPcRegionGroup class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class CloudPcRegionGroup extends Enum
{
    /**
    * The Enum CloudPcRegionGroup
    */
    const GRAPHDEFAULT = "default";
    const AUSTRALIA = "australia";
    const CANADA = "canada";
    const US_CENTRAL = "usCentral";
    const US_EAST = "usEast";
    const US_WEST = "usWest";
    const FRANCE = "france";
    const GERMANY = "germany";
    const EUROPE_UNION = "europeUnion";
    const UNITED_KINGDOM = "unitedKingdom";
    const JAPAN = "japan";
    const ASIA = "asia";
    const INDIA = "india";
    const SOUTH_AMERICA = "southAmerica";
    const EUAP = "euap";
    const US_GOVERNMENT = "usGovernment";
    const US_GOVERNMENT_DOD = "usGovernmentDOD";
    const UNKNOWN_FUTURE_VALUE = "unknownFutureValue";
    const NORWAY = "norway";
    const SWITZERLAND = "switzerland";
    const SOUTH_KOREA = "southKorea";
}
