<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* WindowsMalwareCategoryCount File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;
/**
* WindowsMalwareCategoryCount class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class WindowsMalwareCategoryCount extends Entity
{
    /**
    * Gets the activeMalwareDetectionCount
    * Count of active malware detections for this malware category. Valid values -2147483648 to 2147483647
    *
    * @return int|null The activeMalwareDetectionCount
    */
    public function getActiveMalwareDetectionCount()
    {
        if (array_key_exists("activeMalwareDetectionCount", $this->_propDict)) {
            return $this->_propDict["activeMalwareDetectionCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the activeMalwareDetectionCount
    * Count of active malware detections for this malware category. Valid values -2147483648 to 2147483647
    *
    * @param int $val The value of the activeMalwareDetectionCount
    *
    * @return WindowsMalwareCategoryCount
    */
    public function setActiveMalwareDetectionCount($val)
    {
        $this->_propDict["activeMalwareDetectionCount"] = $val;
        return $this;
    }

    /**
    * Gets the category
    * Malware category. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule. Computed. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
    *
    * @return WindowsMalwareCategory|null The category
    */
    public function getCategory()
    {
        if (array_key_exists("category", $this->_propDict)) {
            if (is_a($this->_propDict["category"], "\Beta\Microsoft\Graph\Model\WindowsMalwareCategory") || is_null($this->_propDict["category"])) {
                return $this->_propDict["category"];
            } else {
                $this->_propDict["category"] = new WindowsMalwareCategory($this->_propDict["category"]);
                return $this->_propDict["category"];
            }
        }
        return null;
    }

    /**
    * Sets the category
    * Malware category. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule. Computed. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
    *
    * @param WindowsMalwareCategory $val The value to assign to the category
    *
    * @return WindowsMalwareCategoryCount The WindowsMalwareCategoryCount
    */
    public function setCategory($val)
    {
        $this->_propDict["category"] = $val;
         return $this;
    }
    /**
    * Gets the deviceCount
    * Count of devices with malware detections for this malware category
    *
    * @return int|null The deviceCount
    */
    public function getDeviceCount()
    {
        if (array_key_exists("deviceCount", $this->_propDict)) {
            return $this->_propDict["deviceCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the deviceCount
    * Count of devices with malware detections for this malware category
    *
    * @param int $val The value of the deviceCount
    *
    * @return WindowsMalwareCategoryCount
    */
    public function setDeviceCount($val)
    {
        $this->_propDict["deviceCount"] = $val;
        return $this;
    }
    /**
    * Gets the distinctActiveMalwareCount
    * Count of distinct active malwares for this malware category. Valid values -2147483648 to 2147483647
    *
    * @return int|null The distinctActiveMalwareCount
    */
    public function getDistinctActiveMalwareCount()
    {
        if (array_key_exists("distinctActiveMalwareCount", $this->_propDict)) {
            return $this->_propDict["distinctActiveMalwareCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the distinctActiveMalwareCount
    * Count of distinct active malwares for this malware category. Valid values -2147483648 to 2147483647
    *
    * @param int $val The value of the distinctActiveMalwareCount
    *
    * @return WindowsMalwareCategoryCount
    */
    public function setDistinctActiveMalwareCount($val)
    {
        $this->_propDict["distinctActiveMalwareCount"] = $val;
        return $this;
    }

    /**
    * Gets the lastUpdateDateTime
    * The Timestamp of the last update for the device count in UTC
    *
    * @return \DateTime|null The lastUpdateDateTime
    */
    public function getLastUpdateDateTime()
    {
        if (array_key_exists("lastUpdateDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastUpdateDateTime"], "\DateTime") || is_null($this->_propDict["lastUpdateDateTime"])) {
                return $this->_propDict["lastUpdateDateTime"];
            } else {
                $this->_propDict["lastUpdateDateTime"] = new \DateTime($this->_propDict["lastUpdateDateTime"]);
                return $this->_propDict["lastUpdateDateTime"];
            }
        }
        return null;
    }

    /**
    * Sets the lastUpdateDateTime
    * The Timestamp of the last update for the device count in UTC
    *
    * @param \DateTime $val The value to assign to the lastUpdateDateTime
    *
    * @return WindowsMalwareCategoryCount The WindowsMalwareCategoryCount
    */
    public function setLastUpdateDateTime($val)
    {
        $this->_propDict["lastUpdateDateTime"] = $val;
         return $this;
    }
}
