<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* LearningCourseActivity File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Microsoft\Graph\Model;

/**
* LearningCourseActivity class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class LearningCourseActivity extends Entity
{
    /**
    * Gets the completedDateTime
    * Date and time when the assignment was completed. Optional.
    *
    * @return \DateTime|null The completedDateTime
    */
    public function getCompletedDateTime()
    {
        if (array_key_exists("completedDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["completedDateTime"], "\DateTime") || is_null($this->_propDict["completedDateTime"])) {
                return $this->_propDict["completedDateTime"];
            } else {
                $this->_propDict["completedDateTime"] = new \DateTime($this->_propDict["completedDateTime"]);
                return $this->_propDict["completedDateTime"];
            }
        }
        return null;
    }

    /**
    * Sets the completedDateTime
    * Date and time when the assignment was completed. Optional.
    *
    * @param \DateTime $val The completedDateTime
    *
    * @return LearningCourseActivity
    */
    public function setCompletedDateTime($val)
    {
        $this->_propDict["completedDateTime"] = $val;
        return $this;
    }

    /**
    * Gets the completionPercentage
    * The percentage completion value of the course activity. Optional.
    *
    * @return int|null The completionPercentage
    */
    public function getCompletionPercentage()
    {
        if (array_key_exists("completionPercentage", $this->_propDict)) {
            return $this->_propDict["completionPercentage"];
        } else {
            return null;
        }
    }

    /**
    * Sets the completionPercentage
    * The percentage completion value of the course activity. Optional.
    *
    * @param int $val The completionPercentage
    *
    * @return LearningCourseActivity
    */
    public function setCompletionPercentage($val)
    {
        $this->_propDict["completionPercentage"] = intval($val);
        return $this;
    }

    /**
    * Gets the externalcourseActivityId
    * A course activity ID generated by the provider. Optional.
    *
    * @return string|null The externalcourseActivityId
    */
    public function getExternalcourseActivityId()
    {
        if (array_key_exists("externalcourseActivityId", $this->_propDict)) {
            return $this->_propDict["externalcourseActivityId"];
        } else {
            return null;
        }
    }

    /**
    * Sets the externalcourseActivityId
    * A course activity ID generated by the provider. Optional.
    *
    * @param string $val The externalcourseActivityId
    *
    * @return LearningCourseActivity
    */
    public function setExternalcourseActivityId($val)
    {
        $this->_propDict["externalcourseActivityId"] = $val;
        return $this;
    }

    /**
    * Gets the learnerUserId
    * The user ID of the learner to whom the activity is assigned. Required.
    *
    * @return string|null The learnerUserId
    */
    public function getLearnerUserId()
    {
        if (array_key_exists("learnerUserId", $this->_propDict)) {
            return $this->_propDict["learnerUserId"];
        } else {
            return null;
        }
    }

    /**
    * Sets the learnerUserId
    * The user ID of the learner to whom the activity is assigned. Required.
    *
    * @param string $val The learnerUserId
    *
    * @return LearningCourseActivity
    */
    public function setLearnerUserId($val)
    {
        $this->_propDict["learnerUserId"] = $val;
        return $this;
    }

    /**
    * Gets the learningContentId
    * The ID of the learning content created in Viva Learning. Required.
    *
    * @return string|null The learningContentId
    */
    public function getLearningContentId()
    {
        if (array_key_exists("learningContentId", $this->_propDict)) {
            return $this->_propDict["learningContentId"];
        } else {
            return null;
        }
    }

    /**
    * Sets the learningContentId
    * The ID of the learning content created in Viva Learning. Required.
    *
    * @param string $val The learningContentId
    *
    * @return LearningCourseActivity
    */
    public function setLearningContentId($val)
    {
        $this->_propDict["learningContentId"] = $val;
        return $this;
    }

    /**
    * Gets the learningProviderId
    * The registration ID of the provider. Required.
    *
    * @return string|null The learningProviderId
    */
    public function getLearningProviderId()
    {
        if (array_key_exists("learningProviderId", $this->_propDict)) {
            return $this->_propDict["learningProviderId"];
        } else {
            return null;
        }
    }

    /**
    * Sets the learningProviderId
    * The registration ID of the provider. Required.
    *
    * @param string $val The learningProviderId
    *
    * @return LearningCourseActivity
    */
    public function setLearningProviderId($val)
    {
        $this->_propDict["learningProviderId"] = $val;
        return $this;
    }

    /**
    * Gets the status
    * The status of the course activity. Possible values are: notStarted, inProgress, completed. Required.
    *
    * @return CourseStatus|null The status
    */
    public function getStatus()
    {
        if (array_key_exists("status", $this->_propDict)) {
            if (is_a($this->_propDict["status"], "\Microsoft\Graph\Model\CourseStatus") || is_null($this->_propDict["status"])) {
                return $this->_propDict["status"];
            } else {
                $this->_propDict["status"] = new CourseStatus($this->_propDict["status"]);
                return $this->_propDict["status"];
            }
        }
        return null;
    }

    /**
    * Sets the status
    * The status of the course activity. Possible values are: notStarted, inProgress, completed. Required.
    *
    * @param CourseStatus $val The status
    *
    * @return LearningCourseActivity
    */
    public function setStatus($val)
    {
        $this->_propDict["status"] = $val;
        return $this;
    }

}
