define(function () {
  // Italian
  function ending (count, first, second, third) {
    if ((count % 100 > 9 && count % 100 < 21) || count % 10 === 0) {
      if (count % 10 > 1) {
        return second;
      } else {
        return third;
      }
    } else {
      return first;
    }
  }

  return {
    inputTooLong: function (args) {
      var overChars = args.input.length - args.maximum;

      var message = 'PaÅ¡alinkite ' + overChars + ' simbol';

      message += ending(overChars, 'iÅ³', 'ius', 'Ä¯');

      return message;
    },
    inputTooShort: function (args) {
      var remainingChars = args.minimum - args.input.length;

      var message = 'Ä®raÅ¡ykite dar ' + remainingChars + ' simbol';

      message += ending(remainingChars, 'iÅ³', 'ius', 'Ä¯');

      return message;
    },
    loadingMore: function () {
      return 'Kraunama daugiau rezultatÅ³â€¦';
    },
    maximumSelected: function (args) {
      var message = 'JÅ«s galite pasirinkti tik ' + args.maximum + ' element';

      message += ending(args.maximum, 'Å³', 'us', 'Ä…');

      return message;
    },
    noResults: function () {
      return 'AtitikmenÅ³ nerasta';
    },
    searching: function () {
      return 'IeÅ¡komaâ€¦';
    }
  };
});
