<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>
<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h1">
            [% $user->gettext('Key Account')%]
        </span>
    </div>
    <div class='card-body'>
        <div class='row'>
            <div class='col-sm-12'>

                <div class="card panel-info shadow-sm rounded">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-sm-8">
                            [% if $Tools->FCS_Count($KeyAccounts) %][% if $Tools->FCS_Count($KeyAccounts) > 1 %][% $Tools->FCS_Count($KeyAccounts) %] [% $user->gettext('Einträge gefunden') %][% else %]1[% $user->gettext('Eintrag gefunden') %][% /if %][% /if %]
                        </div>
                        <div class="col-sm-4 text-end">
                            <div class="btn-group">
                                <a href="index.php?module=assets&class=keyaccount&event=create" class="openInBigIFrameModal btn btn-outline-primary">[% $user->gettext('Erstellen') %]</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">

                    <div class="table-responsive">
                        <table class="table table-striped table-bordered  table-condensed">
                            <thead>
                                <tr>
                                    <th>[% $user->gettext('Name')%]</th>
                                    <th>[% $user->gettext('Gruppe')%]</th>
                                    <th>[% $user->gettext('Aktiviert')%]</th>
                                    <th>[% $user->gettext('Erstellt am')%]</th>
                                    <th>[% $user->gettext('Aktualisiert am')%]</th>
                                    <th>&nbsp;</th>
                                </tr>
                            </thead>
                            <tbody>
                                [% foreach $KeyAccounts as $KeyAccount %]
                                    <tr>
                                        <td>[% $KeyAccount->Name %]</td>
                                        <td>[% $KeyAccount->Group->name %]</td>
                                        <td>[% if $KeyAccount->isActive %]<span class="fa fa-check"></span>[% /if %]</td>
                                        <td>[% $KeyAccount->CreateDate|date_format:"d.m.Y H:i:s" %]</td>
                                        <td>[% $KeyAccount->UpdateDate|date_format:"d.m.Y H:i:s" %]</td>
                                        [% if $user->hasRight(26) %]
                                            <td class="ActionFields">
                                                <div class="btn-group">
                                                    <a href="index.php?module=assets&class=keyaccount&event=edit&id=[% $KeyAccount->KeyAccountID %]" class="openInBigIFrameModal btn btn-outline-secondary"><span class="fa fa-pencil"></span></a>
                                                    <a href="index.php?module=assets&class=keyaccount&event=delete&id=[% $KeyAccount->KeyAccountID %]" onclick="return confirm('[% $user->gettext('Möchten Sie diesen Key Accout löschen?') %]');" class="btn btn-outline-secondary"><span class="fa fa-trash"></span></a>
                                                </div>
                                            </td>
                                        [% /if %]
                                    </tr>
                                [% /foreach %]
                            </tbody>

                        </table>
                    </div>
                </div>
            </div>


        </div>
    </div>
</div>
</div>

<script>

    function closeIFrame() {
        $("#myBigIFrameModal").modal('hide');
        window.location = window.location;
    }
    function deleteWF(id) {
        bootbox.confirm("[% $user->gettext('Key Account wirklich löschen?') %]", function (result) {
            if (result) {
                $.post('index.php?module=webformular&event=delete', {id: id}, function (data) {
                    console.log(data);
                    if (data.error) {
                        noty({
                            text: data.messages[0],
                            type: 'error',
                            timeout: notifyTimeout
                        });
                    } else {
                        window.location = 'index.php?module=webformular';
                    }
                });
            }
        });

    }
    $(document).ready(function () {
        $('.table').DataTable({
            dom: 'Bfrtip',
            buttons: [
//                'colvis',
                'excel',
                'print',
                'pdfHtml5'
            ],
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            },
            initComplete: function () {
                this.api().columns().every(function () {
                    var column = this;
                    var select = $('<select><option value=""></option></select>')
                            .appendTo($(column.footer()).empty())
                            .on('change', function () {
                                var val = $.fn.dataTable.util.escapeRegex(
                                        $(this).val()
                                        );

                                column
                                        .search(val ? '^' + val : '', true, true)
                                        .draw();
                            });
                    column.data().unique().sort().each(function (d, j) {
                        select.append('<option value="' + d + '">' + d + '</option>')
                    });
                });
            }
        });
    });


</script>
