<style>

    .BacklogRow{
        cursor: pointer;
    }
</style>

<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Backlog verwaltung') %]</span>
    </div>
    <div class="card-body">

        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <span class="fcs-card-title h3">[% $user->gettext('Backlog') %]</span>
                [% if $Tools->FCS_Count($backlogs) %]
                    <span class="fcs-card-title"> - [% $Tools->FCS_Count($backlogs) %] [% $user->gettext('Eintr&auml;ge gefunden') %]</span>
                [% /if %]

                <span class="float-end">

                    [% if $user->hasRight(900) %]
                        <a  class="btn btn-outline-primary" type="button" href="index.php?module=backlog&event=create">
                            [%$user->gettext('Neues Backlog')%]
                        </a>
                    [% /if %]
                    <a  class="btn btn-outline-primary" type="button" href="index.php?module=backlog&class=sprint">
                        [%$user->gettext('Sprints')%]
                    </a>

                </span>

            </div>
            <div class="card-body">


                <div class="card panel-info shadow-sm rounded">
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>[% $user->gettext('Name')%]</th>
                                        <th>[% $user->gettext('Erstellt am')%]</th>
                                        <th>[% $user->gettext('Erstellt von')%]</th>
                                        <th>[% $user->gettext('Freigeben für')%]</th>
                                        <th>&nbsp;</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    [% foreach from=$backlogs item=backlog key=id %]
                                        <tr class="BacklogRow" data-backlogid="[% $backlog.id %]">
                                            <td>[% $backlog.name %]</td>
                                            <td>[% $backlog.createdate|date_format:'d.m.Y H:i:s' %]</td>
                                            <td>[% $backlog.createuser %]</td>
                                            <td>[% $backlog.groups %]</td>
                                            <td class="ActionFields">

                                                <a href="index.php?module=backlog&event=edit&id=[% $backlog.id %]"><span class="btn btn-sm btn-outline-secondary"><span class="fa fa-pencil"></span></span></a>
                                                [% if $user->hasRight(900) %]
                                                    <span class="btn btn-sm btn-outline-secondary" onclick="deleteBacklog([% $backlog.id %]);" title="[% $user->gettext('Backlog löschen') %]"><span class="fa fa-trash"></span></span>
                                                [% /if %]
                                            </td>
                                        </tr>
                                    [% /foreach %]
                                </tbody>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script>
    function deleteBacklog(id) {
        bootbox.confirm("[% $user->gettext('Backlog wirklich löschen?') %]", function (result) {
            if (result) {
                $.post('index.php?module=backlog&event=delete', {id: id}, function (data) {
                    if(data.error){
                            noty({
                                text: data.messages[0],
                                type: 'error',
                                timeout: notifyTimeout
                            });                    
                    } else {
                        location.reload();
                    }
                });
            }
        });

    }
    $(document).ready(function () {
        $('.table').DataTable({
            dom: 'Bfrtip',
            buttons: [
//                'colvis',
                'excel',
                'print',
                'pdfHtml5'
            ],
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            },
            initComplete: function () {
                this.api().columns().every(function () {
                    var column = this;
                    var select = $('<select><option value=""></option></select>')
                            .appendTo($(column.footer()).empty())
                            .on('change', function () {
                                var val = $.fn.dataTable.util.escapeRegex(
                                        $(this).val()
                                        );

                                column
                                        .search(val ? '^' + val : '', true, true)
                                        .draw();
                            });
                    column.data().unique().sort().each(function (d, j) {
                        select.append('<option value="' + d + '">' + d + '</option>')
                    });
                });
            }
        });
    });


$(".BacklogRow td").not('.ActionFields').on('click', function(e){
    ID = $(this).parent().data('backlogid');
    if(ID > 0){
        window.location = "index.php?module=backlog&event=edit&id="+ID;
    }
})


</script>
