<style>

    .table tr td{
        cursor: pointer;
    }
</style>

<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>
<script type="text/javascript" src="includes/js/jquery-ui-timepicker-addon.js"></script>
<link rel="stylesheet" type="text/css" href="styles/[% $CSSTEMPLATE %]/css/jquery-ui-timepicker-addon.css" media="screen" />

<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Sprintverwaltung') %]</span>
    </div>
    <div class="card-body">

        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <span class="fcs-card-title h3">[% $user->gettext('Sprints') %]</span>[% if $Tools->FCS_Count($sprints) %]<span class="fcs-card-title"> - [% $Tools->FCS_Count($sprints) %] [% $user->gettext('Eintr&auml;ge gefunden') %]</span>[% /if %]

                <div class="float-end">


                    <a  class="btn btn-outline-secondary" type="button" href="index.php?module=backlog">
                        [%$user->gettext('Backlogs')%]
                    </a>
                    [% if $user->hasRight(900) && $Backlog->newSprintsAllowed() %]
                        <a  class="btn btn-outline-primary openInLargeModal" type="button" href="index.php?module=backlog&class=sprint&event=create">
                            [%$user->gettext('Neuer Sprint')%]
                        </a>
                    [% /if %]

                </div>

            </div>
            <div class="card-body">

                <div class="panel-fcs-content">
                    <div class="card-body">
                        <form action="index.php?module=backlog&class=sprint&event=listSprints" id="hm" method="post" class="form-inline">
                            <div class="form-group row mb-3">
                                <label class="control-label">[% $user->gettext('Backlog')%]</label>
                                <select class="form-control" name="BacklogID" onchange="$('#hm').submit();">
                                    <option value="0">[% $user->gettext('Bitte wählen Sie ein Backlog') %]</option>
                                    [% foreach from=$backlogs item = $backlog %]
                                        <option value="[% $backlog.id %]" [% if $BacklogID == $backlog.id %]selected="selected"[% /if %]>[% $backlog.name %]</option>
                                    [% /foreach %]
                                </select>
                            </div><!--
                            [%*
                            <div class="form-group row mb-3">
                            <label class="control-label">[% $user->gettext('Startet zwischen')%]</label>
                            <input type="text" class="form-control datetimepicker" value="[% if $startdatebegin %][% $startdatebegin %][% /if %]" name="startdatebegin" id="startdatebegin" onchange="$('#hm').submit();"/>
                            </div>

                            <div class="form-group row mb-3">
                            <label class="control-label">[% $user->gettext('und')%]</label>
                            <input type="text" class="form-control datetimepicker" value="[% if $startdateend %][% $startdateend %][% /if %]" name="startdateend" id="startdateend" onchange="$('#hm').submit();" />
                            </div>
                            
                            <div class="form-group row mb-3">
                            <label class="control-label">[% $user->gettext('Endet zwischen')%]</label>
                            <input type="text" class="form-control datetimepicker" value="[% if $enddatebegin %][% $enddatebegin %][% /if %]" name="enddatebegin" id="enddatebegin" onchange="$('#hm').submit();"/>
                            </div>

                            <div class="form-group row mb-3">
                            <label class="control-label">[% $user->gettext('und')%]</label>
                            <input type="text" class="form-control datetimepicker" value="[% if $enddateend %][% $enddateend %][% /if %]" name="enddateend" id="enddateend" onchange="$('#hm').submit();" />
                            </div>
                            *%]-->
                            <div class="form-group row mb-3">
                                <label class="control-label">[% $user->gettext('Nur aktive Sprints anzeigen')%]</label>
                                <input name="onlyActive" type="checkbox" [% if $onlyActive%]checked="checked"[% /if %] onchange="$('#hm').submit();">
                            </div>
                        </form>
                    </div>
                </div>
                <div class="card panel-info shadow-sm rounded">
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>[% $user->gettext('Name')%]</th>
                                        <th>[% $user->gettext('Backlog')%]</th>
                                        <th>[% $user->gettext('Von')%]</th>
                                        <th>[% $user->gettext('Bis')%]</th>
                                        <th>[% $user->gettext('Dauer')%] (Std.)</th>
                                        [% if $user->hasRight(900) %]
                                        <th>&nbsp;</th>
                                        [% /if %]
                                    </tr>
                                </thead>
                                <tbody>
                                    [% foreach from=$sprints item=sprint key=id %]
                                        <tr class="SprintRow" data-sprintid="[% $sprint.id %]">
                                            <td>[% $sprint.name %]</td>
                                            <td>[% $sprint.backlogname %]</td>
                                            <td data-sort="[% $sprint.startdate %]">[% if  $sprint.startdate %][% $sprint.startdate|date_format:'d.m.Y' %][% /if %]</td>
                                            <td data-sort="[% $sprint.enddate %]">[% if  $sprint.startdate %][% $sprint.enddate|date_format:'d.m.Y' %][% /if %]</td>
                                            <td>[% $sprint.availablehours %]</td>
                                            [% if $user->hasRight(900) %]
                                            <td class="ActionFields">
                                                <a href="index.php?module=backlog&class=sprint&event=edit&id=[% $sprint.id %]"><span class="btn btn-sm btn-outline-secondary"><span class="fa fa-pencil"></span></span></a>
                                                [% if $user->hasRight(900) %]
                                                    <span class="btn btn-sm btn-outline-secondary" onclick="deleteBacklog([% $sprint.id %]);" title="[% $user->gettext('Backlog löschen') %]"><span class="fa fa-trash"></span></span>
                                                [% /if %]                                                
                                            </td>
                                            [% /if %]
                                        </tr>
                                    [% /foreach %]
                                </tbody>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script>
    function deleteBacklog(id) {
        bootbox.confirm("[% $user->gettext('Sprint wirklich löschen?') %]", function (result) {
            console.log(id);
            if (result) {
                $.post('index.php?module=backlog&class=sprint&event=delete', {id: id}, function (data) {
                    var data = JSON.parse(data);
                    if (data.error) {
                        noty({
                            text: data.messages[0],
                            type: 'error',
                            timeout: notifyTimeout
                        });
                    } else {
                        window.location = 'index.php?module=backlog&class=sprint';
                    }
                });
            }
        });

    }
    $(document).ready(function () {
        $('.table').DataTable({
            dom: 'Bfrtip',
            buttons: [
//                'colvis',
                'excel',
                'print',
                'pdfHtml5'
            ],
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            },
            initComplete: function () {
                this.api().columns().every(function () {
                    var column = this;
                    var select = $('<select><option value=""></option></select>')
                            .appendTo($(column.footer()).empty())
                            .on('change', function () {
                                var val = $.fn.dataTable.util.escapeRegex(
                                        $(this).val()
                                        );

                                column
                                        .search(val ? '^' + val : '', true, true)
                                        .draw();
                            });
                    column.data().unique().sort().each(function (d, j) {
                        select.append('<option value="' + d + '">' + d + '</option>')
                    });
                });
            }
        });
    });


    $('.datetimepicker').datetimepicker();

$(".SprintRow td").not('.ActionFields').on('click', function(e){
    ID = $(this).parent().data('sprintid');
    if(ID > 0){
        window.location = "index.php?module=backlog&class=sprint&event=edit&id="+ID;
    }
})


</script>
