<style>
    .table tr th {
        cursor: pointer;
    }
</style>

<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

[% if $Errors %]
    <div class="alert alert-danger">
        <ul>
            [% foreach from=$Errors item=error %]
                <li>[% $error %]</li>
            [% /foreach %]
        </ul>
    </div>
[% /if %]

<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Ticketstatus & Auswirkungsgrad') %]</span>
    </div>
    <div class="card-body">
        <div class="card panel-info shadow-sm rounded">
            <div class="card-header row">
                <div class="col-md-8">
                    <span class="fcs-card-title h3">
                        [% $user->gettext('Benutzerdefinierte Ticketstatus') %]
                        [% if $Tools->FCS_Count($TicketStatusList) %]
                            <span class="fcs-card-title"> - [% $TicketStatusList|@count %] [% $user->gettext('Einträge gefunden') %]</span>
                        [% /if %]
                    </span>
                </div>
                <div class="col-md-4 text-end">
                    <a href="index.php?module=customstatus&event=edit" class="btn btn-outline-secondary">
                        <span class="fa fa-plus"></span> [% $user->gettext('Status hinzufügen') %]
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="card panel-info shadow-sm rounded">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped" id="statusTable">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>[% $user->gettext('Technischer Name') %]</th>
                                        <th>[% $user->gettext('Deutsch') %]</th>
                                        <th>[% $user->gettext('Englisch') %]</th>
                                        <th>[% $user->gettext('Tickets') %]</th>
                                        <th>&nbsp;</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    [% foreach from=$TicketStatusList item=status %]
                                        <tr>
                                            <td>[% $status.ID %]</td>
                                            <td><code>[% $status.Descr %]</code></td>
                                            <td>[% $status.descr_de %]</td>
                                            <td>[% $status.descr_en %]</td>
                                            <td>
                                                [% assign var="count"  value=$TicketCountMap[$status.ID]|default:0 %]
                                                [% if $count > 0 %]
                                                    <a href="index.php?module=ticketlist&StatusID=[% $status.ID %]" target="_blank">[% $count %]</a>
                                                [% else %]
                                                    0
                                                [% /if %]
                                            </td>     
                                            <td>
                                                <a href="index.php?module=customstatus&event=edit&id=[% $status.ID %]" class="btn btn-sm btn-outline-secondary" title="[% $user->gettext('Bearbeiten') %]">
                                                    <span class="fa fa-pencil"></span>
                                                </a>

                                                [% if $count > 0 %]
                                                    <span class="btn btn-sm btn-outline-secondary disabled" title="[% $user->gettext('Status wird verwendet') %]">
                                                        <span class="fa fa-times"></span>
                                                    </span>
                                                [% else %]
                                                    <a href="javascript:deleteStatus([% $status.ID %])" class="btn btn-sm btn-outline-secondary" title="[% $user->gettext('Status löschen') %]">
                                                        <span class="fa fa-times"></span>
                                                    </a>
                                                [% /if %]

                                            </td>
                                        </tr>
                                    [% /foreach %]
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>





    <div class="card-body">
        <div class="card panel-info shadow-sm rounded">
            <div class="card-header row">
                <div class="col-md-8">
                    <span class="fcs-card-title h3">
                        [% $user->gettext('Benutzerdefinierte Dringlichkeits-Stufen') %]
                        [% if $Tools->FCS_Count($UrgencyList) %]
                            <span class="fcs-card-title"> - [% $UrgencyList|@count %] [% $user->gettext('Einträge gefunden') %]</span>
                        [% /if %]
                    </span>
                </div>
                <div class="col-md-4 text-end">
                    <a href="index.php?module=customstatus&class=customurgency&event=edit" class="btn btn-outline-secondary">
                        <span class="fa fa-plus"></span> [% $user->gettext('Dringlichkeit hinzufügen') %]
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="card panel-info shadow-sm rounded">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped" id="urgencyTable">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Score</th>
                                        <th>[% $user->gettext('Name') %]</th>
                                        <th>[% $user->gettext('Beschreibung') %]</th>
                                        <th>[% $user->gettext('Tickets') %]</th>
                                        <th>&nbsp;</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    [% foreach from=$UrgencyList item=urgency %]
                                        <tr>
                                            <td>[% $urgency.ID %]</td>
                                            <td>[% $urgency.Score %]</td>
                                            <td><code>[% $urgency.Name_de %]</code></td>
                                            <td>[% $urgency.Description_de %]</td>
                                            <td>
                                                [% assign var="count"  value=$TicketCountMapUrgency[$urgency.ID]|default:0 %]
                                                [% if $count > 0 %]
                                                    <a href="index.php?module=ticketlist&IncidentUrgencyID=[% $urgency.ID %]" target="_blank">[% $count %]</a>
                                                [% else %]
                                                    0
                                                [% /if %]
                                            </td>     
                                            <td>
                                                <a href="index.php?module=customstatus&class=customurgency&event=edit&id=[% $urgency.ID %]" class="btn btn-sm btn-outline-secondary" title="[% $user->gettext('Bearbeiten') %]">
                                                    <span class="fa fa-pencil"></span>
                                                </a>

                                                [% if $count > 0 %]
                                                    <span class="btn btn-sm btn-outline-secondary disabled" title="[% $user->gettext('Eintrag wird verwendet') %]">
                                                        <span class="fa fa-times"></span>
                                                    </span>
                                                [% else %]
                                                    <a href="javascript:deleteEntry([% $urgency.ID %], 'urgency')" class="btn btn-sm btn-outline-secondary" title="[% $user->gettext('Eintrag löschen') %]">
                                                        <span class="fa fa-times"></span>
                                                    </a>
                                                [% /if %]

                                            </td>
                                        </tr>
                                    [% /foreach %]
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <div class="card-body">
        <div class="card panel-info shadow-sm rounded">
            <div class="card-header row">
                <div class="col-md-8">
                    <span class="fcs-card-title h3">
                        [% $user->gettext('Benutzerdefinierte Auswirkungs-Stufen') %]
                        [% if $Tools->FCS_Count($ImpactList) %]
                            <span class="fcs-card-title"> - [% $ImpactList|@count %] [% $user->gettext('Einträge gefunden') %]</span>
                        [% /if %]
                    </span>
                </div>
                <div class="col-md-4 text-end">
                    <a href="index.php?module=customstatus&class=customimpact&event=edit" class="btn btn-outline-secondary">
                        <span class="fa fa-plus"></span> [% $user->gettext('Auswirkung hinzufügen') %]
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="card panel-info shadow-sm rounded">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped" id="impactTable">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Score</th>
                                        <th>[% $user->gettext('Name') %]</th>
                                        <th>[% $user->gettext('Beschreibung') %]</th>
                                        <th>[% $user->gettext('Tickets') %]</th>
                                        <th>&nbsp;</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    [% foreach from=$ImpactList item=impact %]
                                        <tr>
                                            <td>[% $impact.ID %]</td>
                                            <td>[% $impact.Score %]</td>
                                            <td><code>[% $impact.Name_de %]</code></td>
                                            <td>[% $impact.Description_de %]</td>
                                            <td>
                                                [% assign var="count"  value=$TicketCountMapUrgencies[$impact.ID]|default:0 %]
                                                [% if $count > 0 %]
                                                    <a href="index.php?module=ticketlist&UrgencyID=[% $impact.ID %]" target="_blank">[% $count %]</a>
                                                [% else %]
                                                    0
                                                [% /if %]
                                            </td>     
                                            <td>
                                                <a href="index.php?module=customstatus&class=customimpact&event=edit&id=[% $impact.ID %]" class="btn btn-sm btn-outline-secondary" title="[% $user->gettext('Bearbeiten') %]">
                                                    <span class="fa fa-pencil"></span>
                                                </a>

                                                [% if $count > 0 %]
                                                    <span class="btn btn-sm btn-outline-secondary disabled" title="[% $user->gettext('Eintrag wird verwendet') %]">
                                                        <span class="fa fa-times"></span>
                                                    </span>
                                                [% else %]
                                                    <a href="javascript:deleteEntry([% $impact.ID %], 'impact')" class="btn btn-sm btn-outline-secondary" title="[% $user->gettext('Eintrag löschen') %]">
                                                        <span class="fa fa-times"></span>
                                                    </a>
                                                [% /if %]

                                            </td>
                                        </tr>
                                    [% /foreach %]
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    </div>
<script>
    $(document).ready(function () {
        $('#statusTable').DataTable({
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "columns": [
                null,
                null,
                null,
                null,
                {"orderable": false}
            ],
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Einträge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Einträge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Einträgen") %]',
                "sSearch": "[% $user->gettext('Filter') %]",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                }
            }
        });
    });

function deleteStatus(id) {
    bootbox.confirm("[% $user->gettext('Diesen Status wirklich löschen?') %]", function(result) {
        if (result) {
            window.location = "index.php?module=customstatus&event=delete&id=" + id;
        }
    });
}

function deleteEntry(id, type) {
    bootbox.confirm("[% $user->gettext('Diesen Eintrag wirklich löschen?') %]", function(result) {
        if (result) {
            window.location = "index.php?module=customstatus&class=custom"+type+"&event=delete&id=" + id;
        }
    });
}

</script>
