<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>



<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <h2 class="card-title-fcs">[% $user->gettext('Fehlercodes') %]</h2>
    </div>

    <div class="card-body">
        <div class="card panel-info shadow-sm rounded">
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-12">
                        <form action="" method="post" name="hm" id="EPReportForm" enctype="multipart/form-data" class="form-inline fcs-form-padding">

                            <input type="hidden" name="export" id="export" value="0" />

                            <div class="input-group">
                                <span class="input-group-text">
                                    [% $user->gettext('Tickets erstellt von')%]
                                </span>
                                <input type="text" class="form-control datepicker" id="startdate" name="startdate" value="[% $selectedFilters['startdate'] %]" onkeyup="keyEvent(event)" />
                                <span class="input-group-text">
                                    [% $user->gettext('bis')%]
                                </span>
                                <input type="text" class="form-control datepicker" id="enddate" name="enddate" value="[% $selectedFilters['enddate'] %]" onkeyup="keyEvent(event)" />
                            </div>                                    

                            <div class="form-group row mb-3">
                                <label  for="search">[% $user->gettext('Fehlercodes') %]</label>
                                <select name="Filter[hm_EPErrorCode.ErrorCode][]" id="ErrorCode" class="form-control" multiple>
                                    <option vlaue="0">-- [% $user->gettext('Alle') %] --</option>
                                    [% html_options options=$ErrorCodes selected=$selectedFilters['hm_EPErrorCode.ErrorCode'] %]
                                </select>
                            </div>

                            <div class="form-group row mb-3">
                                <label  for="search">[% $user->gettext('Artikelnummern') %]</label>
                                <select name="Filter[hm_EPErrorCode.ArticleNo][]" id="ArticleNo" class="form-control" multiple>
                                    <option vlaue="0">-- [% $user->gettext('Alle') %] --</option>
                                    [% html_options options=$ArticleNos selected=$selectedFilters['hm_EPErrorCode.ArticleNo'] %]
                                </select>
                            </div>

                            <div class="form-group row mb-3">
                                <input type='submit' class="btn btn-outline-secondary" value='[% $user->gettext('Filtern') %]'>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <div class="row">
                    <div class="col-lg-6 text-left" >
                        <h3 class="card-title text-left" style="font-size: 24px; display:inline">
                            [% $user->gettext('Report')%]
                        </h3>
                        </span>
                    </div>
                        <div class="col-lg-6 text-end">
                            <div class="form-group row mb-3">
                                <span class="btn btn-outline-secondary" id="CSVExport"><span class="fa fa-download"></span> [% $user->gettext('CSV Export') %]</span>
                            </div>                            
                        </div>

                </div>
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table id="reportTable" class="table">
                        <thead>
                            <tr>

                                <th>[% $user->gettext('Fehlercode') %]</th>
                                <th>[% $user->gettext('Artikelnummer') %]</th>
                                <th>[% $user->gettext('Beschreibung') %]</th>
                                <th>[% $user->gettext('Anzahl Tickets') %]</th>
                            </tr>
                        </thead>
                        <tbody>
                            [% foreach from=$reportData item=row %]
                                <tr>
                                    <td>[% $row['errorcode'] %]</td>
                                    <td>[% $row['articleno'] %]</td>
                                    <td>[% $row['descr'] %]</td>
                                    <td>
                                        <a href="index.php?module=ticketlist&ErrorCodes[]=[% $row['errorcode'] %]" target="_blank">
                                        [% $row['cnttickets'] %]
                                        </a>
                                    </td>
                                </tr>
                            [% /foreach %]
                        </tbody>
                        <tfoot>

                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<script>
    $(document).ready(function () {

        table = $('#reportTable').DataTable({
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            }
        });
        var data = table.buttons.exportData({
            columns: ':visible'
        });

    });

    $('select').select2({theme: 'bootstrap-5'});
    $(".datepicker").datepicker();

    $('#CSVExport').on('click', function (e) {
        $('#export').val(1);
        $('#EPReportForm').submit();
        $('#export').val(0);
    })


</script>