<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>


<style>
    .notEditable {
        text-decoration: none;
        color: inherit;
        cursor: default;
        pointer-events: none;

    }
</style>

<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <h2 class="card-title-fcs">[% $user->gettext('Fehlerbild-Objekte verwalten') %]</h2>
    </div>

    <div class="card-body">
        <div class="card panel-info shadow-sm rounded">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">

                        [% if $user->hasRight(1100) %]
                            <div class="form-group row mb-3">
                                <div class="btn-group" data-toggle="buttons">
                                    <label class="btn btn-outline-secondary" >
                                        <input type="checkbox" id="activateEditing" autocomplete="off" > [% $user->gettext('Bearbeitung aktivieren') %]
                                    </label>
                                </div>
                            </div>
                        [% /if %]
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card panel-info shadow-sm rounded">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-lg-4 text-left" >
                                    <h3 class="card-title text-left" style="font-size: 24px; display:inline">
                                        [% $user->gettext('Beschreibungen')%]
                                    </h3>
                                    </span>
                                </div>
                                <div class="col-lg-8 text-end">
                                    <span data-bs-toggle="modal" data-bs-target="#AddEPPartModal"  data-descr="[% $user->gettext('Beschreibung')%]" data-part="ErrorDescr" class="btn btn-outline-secondary"><span class="fa fa-plus"></span> [% $user->gettext('Zufügen') %]</span>
                                    <a href="index.php?module=errorpatterns&event=export&part=ErrorDescr" class="btn btn-outline-secondary">[% $user->gettext('CSV Export') %]</a>
                                    <a href="index.php?module=errorpatterns&event=CSVImport&part=ErrorDescr" class="btn btn-outline-secondary">[% $user->gettext('CSV Import') %]</a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="reportTable" class="table">
                                    <thead>
                                        <tr>
                                            <th>[% $user->gettext('de') %]</th>
                                            <th>[% $user->gettext('en') %]</th>
                                            <th width="50">[% $user->gettext('Aktion') %]</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        [% foreach from=$ErrorPatternParts['de']['ErrorDescr']  item=Descr key=PartID %]
                                            <tr  class="PatternRow_ErrorDescr_[% $PartID %]">
                                                <td>
                                                    <a href="#" class="notEditable" title="[% $user->gettext('Fehlerbeschreibung bearbeiten') %]" data-type="text" data-pk="[% $PartID %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=descr&lang=de&id=[% $PartID %]" data-title="[% $user->gettext('Fehlerbeschreibung bearbeiten') %]">
                                                        [% $Descr %]
                                                    </a>
                                                </td>
                                                <td>
                                                    <a href="#" class="notEditable" title="[% $user->gettext('Fehlerbeschreibung bearbeiten') %]" data-type="text" data-pk="[% $PartID %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=descr&lang=en&id=[% $PartID %]" data-title="[% $user->gettext('Fehlerbeschreibung bearbeiten') %]">
                                                        [% $ErrorPatternParts['en']['ErrorDescr'][$PartID] %]
                                                    </a>
                                                </td>
                                                <td>
                                                    [% if !$InUse['ErrorDescr'][$PartID] %]
                                                        <span class="btn btn-sm deleteErrorPatternPart" data-type="ErrorDescr" data-id="[% $PartID %]"><span class="fa fa-times"></span></span>
                                                        [% /if %]
                                                </td>
                                            </tr>
                                        [% /foreach %]
                                    </tbody>
                                    <tfoot>

                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">

                    <div class="card panel-info shadow-sm rounded">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-lg-4 text-left" >
                                    <h3 class="card-title text-left" style="font-size: 24px; display:inline">
                                        [% $user->gettext('Präpositionen')%]
                                    </h3>
                                    </span>
                                </div>
                                <div class="col-lg-8 text-end">
                                    <span data-bs-toggle="modal" data-bs-target="#AddEPPartModal"  data-descr="[% $user->gettext('Präposition')%]" data-part="ErrorPreposition" class="btn btn-outline-secondary"><span class="fa fa-plus"></span> [% $user->gettext('Zufügen') %]</span>
                                    <a href="index.php?module=errorpatterns&event=export&part=ErrorPreposition" class="btn btn-outline-secondary">[% $user->gettext('CSV Export') %]</a>
                                    <a href="index.php?module=errorpatterns&event=CSVImport&part=ErrorPreposition" class="btn btn-outline-secondary">[% $user->gettext('CSV Import') %]</a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="reportTable" class="table">
                                    <thead>
                                        <tr>
                                            <th>[% $user->gettext('de') %]</th>
                                            <th>[% $user->gettext('en') %]</th>
                                            <th width="50">[% $user->gettext('Aktion') %]</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        [% foreach from=$ErrorPatternParts['de']['ErrorPreposition']  item=Descr key=PartID %]
                                            <tr  class="PatternRow_ErrorPreposition_[% $PartID %]">
                                                <td>
                                                    <a href="#" class="notEditable" title="[% $user->gettext('Präposition bearbeiten') %]" data-type="text" data-pk="[% $PartID %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=prepo&lang=de&id=[% $PartID %]" data-title="[% $user->gettext('Präposition bearbeiten') %]">
                                                        [% $Descr %]
                                                    </a>
                                                </td>
                                                <td>
                                                    <a href="#" class="notEditable" title="[% $user->gettext('Präposition bearbeiten') %]" data-type="text" data-pk="[% $PartID %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=prepo&lang=en&id=[% $PartID %]" data-title="[% $user->gettext('Präposition bearbeiten') %]">
                                                        [% $ErrorPatternParts['en']['ErrorPreposition'][$PartID] %]
                                                    </a>
                                                </td>
                                                <td>
                                                    [% if !$InUse['ErrorPreposition'][$PartID] %]
                                                        <span class="btn btn-sm deleteErrorPatternPart" data-type="ErrorPreposition" data-id="[% $PartID %]"><span class="fa fa-times"></span></span>
                                                        [% /if %]
                                                </td>
                                            </tr>
                                        [% /foreach %]
                                    </tbody>
                                    <tfoot>

                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">

                    <div class="card panel-info shadow-sm rounded">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-lg-4 text-left" >
                                    <h3 class="card-title text-left" style="font-size: 24px; display:inline">
                                        [% $user->gettext('Objekte')%]
                                    </h3>
                                    </span>
                                </div>
                                <div class="col-lg-8 text-end">
                                    <span data-bs-toggle="modal" data-bs-target="#AddEPPartModal"  data-descr="[% $user->gettext('Objekt')%]" data-part="ErrorObject" class="btn btn-outline-secondary"><span class="fa fa-plus"></span> [% $user->gettext('Zufügen') %]</span>
                                    <a href="index.php?module=errorpatterns&event=export&part=ErrorObject" class="btn btn-outline-secondary">[% $user->gettext('CSV Export') %]</a>
                                    <a href="index.php?module=errorpatterns&event=CSVImport&part=ErrorObject" class="btn btn-outline-secondary">[% $user->gettext('CSV Import') %]</a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="reportTable" class="table">
                                    <thead>
                                        <tr>
                                            <th>[% $user->gettext('de') %]</th>
                                            <th>[% $user->gettext('en') %]</th>
                                            <th width="50">[% $user->gettext('Aktion') %]</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        [% foreach from=$ErrorPatternParts['de']['ErrorObject']  item=Descr key=PartID %]
                                            <tr  class="PatternRow_ErrorObject_[% $PartID %]">
                                                <td>
                                                    <a href="#" class="notEditable" title="[% $user->gettext('Fehlerobjekt bearbeiten') %]" data-type="text" data-pk="[% $PartID %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=object&lang=de&id=[% $PartID %]" data-title="[% $user->gettext('Fehlerobjekt bearbeiten') %]">
                                                        [% $Descr %]
                                                    </a>
                                                </td>
                                                <td>
                                                    <a href="#" class="notEditable" title="[% $user->gettext('Fehlerobjekt bearbeiten') %]" data-type="text" data-pk="[% $PartID %]" data-url="index.php?module=errorpatterns&event=renameDescr&eptype=object&lang=en&id=[% $PartID %]" data-title="[% $user->gettext('Fehlerobjekt bearbeiten') %]">
                                                        [% $ErrorPatternParts['en']['ErrorObject'][$PartID] %]
                                                    </a>
                                                </td>
                                                <td>
                                                    [% if !$InUse['ErrorObject'][$PartID] %]
                                                        <span class="btn btn-sm deleteErrorPatternPart" data-type="ErrorObject" data-id="[% $PartID %]"><span class="fa fa-times"></span></span>
                                                        [% /if %]
                                                </td>
                                            </tr>
                                        [% /foreach %]
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="AddEPPartModal" tabindex="-1" role="dialog" aria-labelledby="AddEPPartModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="AddEPPartModalLabel">...[% $user->gettext('zufügen') %]</h4>
            </div>
            <form action="index.php?module=errorpatterns&event=addEPPart" method="post" class="form-vertical">

                <div class="modal-body">
                    <input type="hidden" name="Part" id="AddEPPart" value=""/>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group row mb-3">
                                <label class="col-lg-2 control-label">DE</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="de"  name="de" />
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group row mb-3">
                                <label class="col-lg-2 control-label">EN</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="en" name="en" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">[% $user->gettext('Abbrechen') %]</button>
                    <button type="submit" class="btn btn-outline-primary" id="addEPPart">[% $user->gettext('Speichern') %]</button>
                </div>
            </form>
        </div>
    </div>
</div>


<script>
    $(document).ready(function () {

        $('.table').DataTable({
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 20,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            }
        });

    });

    [% if $user->hasRight(1100) %]
    $('#activateEditing').on('change', function (e) {
        if ($('#activateEditing').is(':checked')) {
            $(".notEditable").addClass('editable').removeClass('notEditable');
            $.fn.editable.defaults.mode = 'inline';
            $(".editable").editable({
                emptytext: '___',
                success: function (response, newValue) {
                    if (!response.success)
                        return response.message;
                }
            });
        } else {
            $(".editable").addClass('notEditable');
            $(".editable").editable('destroy');
        }
    });

    $('.deleteErrorPatternPart').on('click', function (e) {
        PatternID = $(this).data('id');
        PatternType = $(this).data('type');
        bootbox.confirm("[% $user->gettext('Möchten Sie den Eintrag wirklich löschen?') %]", function (result) {
            if (result) {

                $.ajax({
                    type: "POST",
                    url: "index.php?module=errorpatterns&event=deleteErrorPatternPart",
                    data: {PatternID: PatternID, PatternType: PatternType}
                }).done(function (response) {
                    if (response.error) {
                        noty({
                            text: response.message,
                            type: 'error',
                            timeout: notifyTimeout
                        });
                    } else {
                        noty({
                            text: response.message,
                            type: 'success',
                            timeout: notifyTimeout
                        });
                        $('.PatternRow_' + PatternType + '_' + PatternID).remove();
                    }
                });
            }
        })
    })

    [% /if %]


    $('select').select2({theme: 'bootstrap-5'});



    $('#AddEPPartModal').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget) // Button that triggered the modal
        var descr = button.data('descr') // Extract info from data-* attributes
        var part = button.data('part')
        var modal = $(this)

        modal.find('.modal-title').text(descr + " [% $user->gettext('zufügen') %]");
        modal.find('.modal-body #AddEPPart').val(part);
    })


</script>
