<link rel="stylesheet" type="text/css" href="styles/[% $CSSTEMPLATE %]/css/screen.css" />

<script>
    function keyEvent(event)
    {
        if (event.keyCode == 13) {
            submitForm();
        }
    }

    function showSearchBox() {
        document.getElementById("SearchIcon").style.display = "none";
        document.getElementById("SearchBox").style.display = "block";
    }
</script>

<div class="card panel-info shadow-sm rounded">
    <div class="card-header">
        <h3 class="card-title">[% $user->gettext('Suchformular') %]</h3>
    </div>
    <div class="card-body form-horizontal form-label-left">
        <div class="form-group row mb-3">
            <label class="col-lg-2 control-label">[% $user->gettext('Datum') %]</label>
            <div class="col-lg-10">
                <div class="col-md-3">
                    <select size="1" name="search[DateField]" class="form-control multiple">
                        <option value="hm_Ticket.CreateDate" [% if $search.DateField == "hm_Ticket.CreateDate" %]selected="selected"[% /if %]>[% $user->gettext('Erstellt') %]</option>
                        <option value="hm_Ticket.UpdateDate" [% if $search.DateField == "hm_Ticket.UpdateDate" %]selected="selected"[% /if %]>[% $user->gettext('Aktualisiert') %]</option>
                        <option value="hm_Ticket.DesireDate" [% if $search.DateField == "hm_Ticket.DesireDate" %]selected="selected"[% /if %]>[% $user->gettext('Fällig') %]</option>
                        <option value="hm_Ticket.OnHold" [% if $search.DateField == "hm_Ticket.OnHold" %]selected="selected"[% /if %]>[% $user->gettext('Zurückgestellt') %]</option>
                        <option value="hm_Project.EndDate" [% if $search.DateField == "hm_Project.EndDate" %]selected="selected"[% /if %]>[% $user->gettext('Projektende') %]</option>
                    </select>                    
                </div>
                <div class="col-md-3">
                    <div class="form-group row mb-3">
                        <label class="col-lg-4 control-label">[% $user->gettext('vom') %]</label>
                        <div class="col-lg-8">
                            <input type="text" class="form-control datepicker" id="searchDateStart" name="search[DateStart]" value="[% $search.DateStart %]" size="10" maxlength="10" onkeyup="keyEvent(event)" />
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group row mb-3">
                        <label class="col-lg-4 control-label">[% $user->gettext('bis zum') %]</label>
                        <div class="col-lg-8">
                            <input type="text" class="form-control datepicker" id="searchDateEnd" name="search[DateEnd]" value="[% $search.DateEnd %]" size="10" maxlength="10" onkeyup="keyEvent(event)" />
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <select size="1" onchange="setPeriod(this);" name="search[DatePeriod]" class="form-control  multiple">
                        <option value="0">[% $user->gettext('Keine Auswahl') %]</option>
                        <option value="1" [% if $search.DatePeriod == 1 %]selected="selected"[% /if %]>[% $user->gettext('Heute') %]</option>
                        <option value="2" [% if $search.DatePeriod == 2 %]selected="selected"[% /if %]>[% $user->gettext('Gestern') %]</option>
                        <option value="3" [% if $search.DatePeriod == 3 %]selected="selected"[% /if %]>[% $user->gettext('Letzte Woche') %]</option>
                        <option value="4" [% if $search.DatePeriod == 4 %]selected="selected"[% /if %]>[% $user->gettext('Letzten Monat') %]</option>
                    </select>                            
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group row mb-3">
                <label class="col-lg-4 control-label">[% $user->gettext('Projekt') %]</label>
                <div class="col-lg-8">
                    <select name="search[ProjectID]" class="form-control  multiple">
                        <option value="">[% $user->gettext('Bitte wählen Sie') %]</option>
                        [% html_options options=$projects selected=$search.ProjectID %]
                    </select>   
                </div>
            </div>                

            <div class="form-group row mb-3">
                <label class="col-lg-4 control-label">[% $user->gettext('Kostenstelle') %]</label>
                <div class="col-lg-8">
                    <select name="search[CostCenterID]" class="form-control  multiple">
                        <option value="">[% $user->gettext('Bitte wählen Sie') %]</option>
                        [% html_options options=$costcenter selected=$search.CostCenterID %]
                    </select>    
                </div>
            </div>


            <div class="form-group row mb-3">
                <label class="col-lg-4 control-label">[% $user->gettext('Status') %]</label>
                <div class="col-lg-8">
                    <select name="search[StatusID]" class="form-control  multiple">
                        <option value="0">-- [% $user->gettext('Nur Aktive') %] --</option>
                        [% html_options options=$status selected=$search.StatusID %]
                    </select> 
                </div>
            </div>                
            <div class="form-group row mb-3">
                <label class="col-lg-4 control-label">[% $user->gettext('Ticket-Nr.') %]</label>
                <div class="col-lg-8">
                    <input type="text" class="form-control" id="filter" name="search[TicketID]" value="[% $search.TicketID %]" size="10" onkeyup="keyEvent(event)" />
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-lg-4 control-label">[% $user->gettext('Meine Tickets') %]</label>
                <div class="col-lg-8">
                    <input type="checkbox" name="search[MyTickets]" value="1" [% if $search.MyTickets == 1 %]checked="checked"[% /if %] />
                </div>
            </div>            

            <div class="form-group row mb-3">
                <label class="col-lg-4 control-label">[% $user->gettext('Eintr&auml;ge pro Seite') %]</label>
                <div class="col-lg-8">
                    <select size="1" name="search[EntriesPerPage]" class="form-control multiple">
                        <option value="10" [% if $search.EntriesPerPage == 10 %]selected="selected"[% /if %]>10</option>
                        <option value="20" [% if $search.EntriesPerPage == 20 %]selected="selected"[% /if %]>20</option>
                        <option value="50" [% if $search.EntriesPerPage == 50 %]selected="selected"[% /if %]>50</option>
                        <option value="100" [% if $search.EntriesPerPage == 100 %]selected="selected"[% /if %]>100</option>
                    </select>
                </div>
            </div>            
        </div>


        <div class="col-md-6">
            <div class="form-group row mb-3">
                <label class="col-lg-4 control-label">[% $user->gettext('Projekttyp') %]</label>
                <div class="col-lg-8">
                    <select name="search[ProjectTypeID]" class="form-control  multiple">
                        <option value="">[% $user->gettext('Bitte wählen Sie') %]</option>
                        [% html_options options=$projecttypes selected=$search.ProjectTypeID %]
                    </select>
                </div>
            </div>               

            <div class="form-group row mb-3">
                <label class="col-lg-4 control-label">[% $user->gettext('Firma') %]</label>
                <div class="col-lg-8">
                    <select name="search[Company]" class="form-control  multiple">
                        <option value="">[% $user->gettext('Bitte wählen Sie') %]</option>
                        [% html_options options=$companies selected=$search.Company %]
                    </select>
                </div>
            </div>          

            <div class="form-group row mb-3">
                <label class="col-lg-4 control-label">[% $user->gettext('Priorit&auml;t') %]</label>
                <div class="col-lg-8">
                    <select name="search[PriorityID]" class="form-control multiple">
                        <option value="0">-- [% $user->gettext('Alle Priorit&auml;ten') %] --</option>
                        [% html_options options=$priorities selected=$search.PriorityID %]
                    </select>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-lg-4 control-label">[% $user->gettext('Kurzbeschreibung') %]</label>
                <div class="col-lg-8">
                    <input type="text" class="form-control" id="filter" name="search[TicketDescr]" value="[% $search.TicketDescr %]" size="30" onkeyup="keyEvent(event)" />
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-lg-4 control-label">[% $user->gettext('Kontakt') %]</label>
                <div class="col-lg-8">
                    <input type="text" class="form-control" id="filter" name="search[Contact]" value="[% $search.Contact %]" size="30" onkeyup="keyEvent(event)" />
                </div>
            </div>                

            <div class="form-group row mb-3">
                <label class="col-lg-4 control-label">[% $user->gettext('Sortierung') %]</label>
                <div class="col-lg-8">
                    <div class="col-md-8">
                        <select size="1" class="form-control" name="search[Sorting]" id="sort" id="selectbox multiple" >
                            <option value="Status" [% if $search.Sorting == "Status" %]selected="selected"[% /if %]>[% $user->gettext('Status') %]</option>
                            <option value="Priority" [% if $search.Sorting == "Priority" %]selected="selected"[% /if %]>[% $user->gettext('Priorit&auml;t') %]</option>
                            <option value="TicketDescr" [% if $search.Sorting == "TicketDescr" %]selected="selected"[% /if %]>[% $user->gettext('Kurzbeschreibung') %]</option>
                            <option value="Escalation" [% if $search.Sorting == "Escalation" %]selected="selected"[% /if %]>[% $user->gettext('Eskalation') %]</option>
                            <option value="ID" [% if $search.Sorting == "ID" %]selected="selected"[% /if %]>[% $user->gettext('Ticket-Nr.') %]</option>
                            <option value="Company" [% if $search.Sorting == "Company" %]selected="selected"[% /if %]>[% $user->gettext('Firma') %]</option>
                            <option value="Contact" [% if $search.Sorting == "Contact" %]selected="selected"[% /if %]>[% $user->gettext('Kontakt') %]</option>
                            <option value="CreateDate" [% if $search.Sorting == "CreateDate" %]selected="selected"[% /if %]>[% $user->gettext('Erstellt am') %]</option>
                            <option value="UpdateDate" [% if $search.Sorting == "UpdateDate" %]selected="selected"[% /if %]>[% if $hmcompany|strpos:"AVAG HOLDING" !== false %][% $user->gettext('Zuletzt ge&auml;ndert am') %][% else %][% $user->gettext('Letzte &Auml;nderung am') %][% /if %]</option>
                            <option value="ProjectName" [% if $search.Sorting == "ProjectName" %]selected="selected"[% /if %]>[% $user->gettext('Projekt') %]</option>                            
                            <option value="TypeName" [% if $search.Sorting == "TypeName" %]selected="selected"[% /if %]>[% $user->gettext('Projekttyp') %]</option>                            
                            <option value="Running" [% if $search.Sorting == "Running" %]selected="selected"[% /if %]>[% $user->gettext('Projektstatus') %]</option>                            
                            <option value="CostCenter" [% if $search.Sorting == "CostCenter" %]selected="selected"[% /if %]>[% $user->gettext('Kostenstelle') %]</option>
                            <option value="ProjectCosts" [% if $search.Sorting == "ProjectCosts" %]selected="selected"[% /if %]>[% $user->gettext('Projektkosten') %]</option>                            
                            <option value="EndDate" [% if $search.Sorting == "EndDate" %]selected="selected"[% /if %]>[% $user->gettext('Projektende') %]</option>                            
                        </select>                                        
                    </div>
                    <div class="col-md-4"></div>
                    <select size="1" class="form-control" name="search[SortOrder]" id="sortorder  multiple">
                        <option value="ASC" [% if $search.SortOrder != "DESC" %]selected="selected"[% /if %]>[% $user->gettext('Aufsteigend') %]</option>
                        <option value="DESC" [% if $search.SortOrder == "DESC" %]selected="selected"[% /if %]>[% $user->gettext('Absteigend') %]</option>
                    </select>
                </div>
            </div>            
        </div>


        <input type="button" value="[% $user->gettext('Suchen') %]" class="btn btn-outline-primary" onclick="submitForm();" />
    </div>
</div> 



<script>

    function setPeriod(el) {

        var start = document.getElementById("searchDateStart");
        var end = document.getElementById("searchDateEnd");
        var i = el.options[el.options.selectedIndex].value;

        if (start && end) {

            switch (i) {

                case "1":
                    start.value = "[% $timing.today[0] %]";
                    end.value = "[% $timing.today[1] %]";
                    break;

                case "2":
                    start.value = "[% $timing.yesterday[0] %]";
                    end.value = "[% $timing.yesterday[1] %]";
                    break;

                case "3":
                    start.value = "[% $timing.lastweek[0] %]";
                    end.value = "[% $timing.lastweek[1] %]";
                    break;

                case "4":
                    start.value = "[% $timing.lastmonth[0] %]";
                    end.value = "[% $timing.lastmonth[1] %]";
                    break;

                default:
                case "0":
                    start.value = "";
                    end.value = "";
                    break;
            }
        }
    }

    $(".datepicker").datepicker();
    $(".multiple").multiselect({
    buttonClass: 'form-select',
    templates: {
        button: '<button type="button" class="multiselect dropdown-toggle" data-bs-toggle="dropdown"><span class="multiselect-selected-text"></span></button>',
    },
        multiple: false,
        numberDisplayed: 1 
    });

</script>
