<form action="index.php?module=settings&amp;event=Anonymisieren" method="post" name="hm" id="hm-Settings-Bot" enctype="multipart/form-data" class="form-horizontal form-label-left">
    <input type="hidden"  name="cntTicketsToAno" id="cntTicketsToAno" value="[% $cntTicketsToAno %]" />
    <div class="row">
        <div class = "col-lg-12">
            <div class="card panel-info shadow-sm rounded">
                <div class="card-body">

                    <p>[% $user->gettext('Anonymisierung von geschlossenen Tickets, welche vor dem gewählten Zeitraum angelegt wurden.') %]
                        <br />
                        [% $user->gettext('Es werden die Benutzerinformationen (Ersteller, Bearbeiter, Kontakt) aus den ermittelten Tickets und deren Bearbeitungen (Ticketevents) entfernt.') %]
                        <br />
                        [% $user->gettext('Enthält der Kontakt des Tickets eine Kostenstelle, so wird für diese ein Ersatzkontakt angelegt (CC_...) und im Ticket eingetragen.') %]
                    </p>

                    <div class="form-group row mb-3">
                        <label class="col-lg-1 control-label">[% $user->gettext('Zeitraum') %]</label>
                        <div class="col-lg-2">
                            <div class="input-group">
                                <input type="text" name="olderThen" id="olderThen" value="[% $olderThen %]" size="3" class="form-control" maxlength="3"/>
                                <span class="input-group-text"> [% $user->gettext('Monate') %]</span>
                            </div>
                        </div>
                        <div class="col-lg-9">
                            <span class="btn btn-outline-secondary" id="getTicketsToAno">[% $user->gettext('Tickets ermitteln') %]</span>
                        </div>
                    </div>

                    <div class="row"  id="showWhenTicketsFetched" style="display:none;">
                        <div class="col-lg-6">
                            <div class="progress" id="TicketsAnoProgress" style="">
                                <div class="progress-bar progress-bar active" id="TicketsAnoProgressBar" role="progressbar" style="width:0%;">
                                </div>
                            </div>
                            <span class="help-block"><span id="TicketsFrom">0</span> / <span id="TicketsTo">0</span></span>
                        </div>      
                        <div class="col-lg-12">
                            <input type="button" class="btn btn-outline-secondary" value="[% $user->gettext('Tickets jetzt anonymisieren') %]" onclick="rekAnonym(0);" />

                        </div>                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>



<script type="text/javascript">

    var progress_key = '5006c0eea4618';

    function rekAnonym($i) {
        $AnzTickets = $('#cntTicketsToAno').val();
        console.log("Aufruf: i = " + $i);
        if ($i < $AnzTickets) {
            $.getJSON("index.php?module=settings&class=Anonymisieren&id=" + progress_key + "&zaehler=" + $i, function (data) {
                console.log("data: " + JSON.stringify(data));
                console.log("running_value: " + data.running_value + " von AnzTickets " + $AnzTickets);
                if (data == null) {
                    return true;
                }
                running_value = data.running_value;
//                $("#progressbar").progressBar(running_value, {showText: true, barImage: 'includes/js/img/progressbg_green.gif'});
                $("#TicketsAnoProgressBar").width((running_value) * 100 / $AnzTickets + '%').html(running_value + " / " + $AnzTickets);
                $('#TicketsFrom').html(running_value);
                if (running_value < $AnzTickets) {
                    rekAnonym(running_value, $AnzTickets);
                } else {
                    console.log("Fertig!");
                    $("#TicketsAnoProgressBar").width('100%').html($AnzTickets + " / " + $AnzTickets).addClass('progress-bar-success');
                }

            });
        }
    }

    $('#getTicketsToAno').on('click', function () {
        olderThen = $('#olderThen').val();
        console.log("olderThen: " + olderThen);
        $.post("index.php?module=settings&event=jsongetTicketsToAno",
                {
                    olderThen: olderThen
                },
                function (data) {
                    $('#cntTicketsToAno').val(data);
                    $("#TicketsAnoProgressBar").width('0%').html("0 / " + data).removeClass('progress-bar-success');
                    $('#TicketsTo').html(data);
                    $('#TicketsFrom').html("0");
                    $('#showWhenTicketsFetched').show();
                });
    })
</script>
<!-- Component Settings  - Anonym.tpl end -->