
<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <div class="row">
            <div class="col-sm-8">
                <span class="fcs-card-title h2">[% $user->gettext('Passwort aktualisieren')%] </span>
            </div>
            <div class='col-sm-4 text-end'>
                [% if $NumberOfUsers > 0 %]
                    <a onclick='UpdatePassword()' class='btn btn-outline-secondary'>[% $user->gettext('Aktualisieren')%] </a>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal" style="display:none;" id="CloseButton">[% $user->gettext('Fertig')%]</button>
                [% /if %]
            </div>
        </div>
    </div>
    <div class="card-body">
        [% if $NumberOfUsers > 0 %]
            <div class="alert alert-danger" id="AlertUpdate" style="display:none;">
                [% $user->gettext('Fehler beim Aktualisieren der Passwörter.') %]
            </div>
            <div class="card panel-info shadow-sm rounded">
                <div class="card-body">
                    <p>
                        [% $user->gettext('Durch Aktualisieren werden alle Passwörter der Benutzer durch das neue Verfahren gesichert. Die Passwörter werden nicht geändert.') %]                        
                    </p>
                </div>
            </div>

            <div class="progress" id="progress" style="">
                <div class="progress-bar progress-bar-striped active" id="progressBar" role="progressbar" style="width:0%;">
                </div>
            </div>
        [% else %]
            <div class="card panel-info shadow-sm rounded">
                <div class="card-body">
                    <p>
                        [% $user->gettext('Alle Benutzer wurden auf das neue Passwort-Verfahren umgestellt. Die Passwörter der Benutzer wurden nicht geändert.') %]
                    </p>
                </div>
            </div>
        [% /if %]
    </div>
</div>

<script>
    var totalNum = [% $NumberOfUsers %];
    var count = 0;
    function UpdatePassword() {
        $.post('index.php?module=settings&event=UpdatePassword', {save: 1, count: count}, function (data) {
            if (data === '1') {
                if (count < totalNum - 1) {
                    count++;
                    $("#progressBar").width((count + 1) * 100 / totalNum + '%');
                    UpdatePassword();
                } else {
                    $('#CloseButton').show();
                }
            } else {
                $('#AlertUpdate').show();
            }
        });
    }
</script>

