<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h1">[% $user->gettext('Bitte loggen Sie sich ein') %]</span>
        <p>[% $user->gettext('Bitte stellen Sie sicher, dass der Benutzer das entsprechende Recht hat.') %]</p>
    </div>
    <div class='card-body'>
        [% if $Error %]
            <div class='alert alert-danger'>
                [% $Error %]
            </div>
        [% /if %]
        [% if $Token %]
            <div class='alert alert-success' style='  overflow-wrap: break-word;
                 word-wrap: break-word;'>
                [% $user->gettext('Ihr Access-Token lautet') %]: <br><br> <b><span id='token'>[% $Token %]</span></b>
            </div>
            <a class='btn btn-outline-primary' href='javascript: copyToClipboard("[% $Token %]");'>[% $user->gettext('In die Zwischenablage kopieren') %]</a>&nbsp;<span id="tokenCopied"></span><br><br>
        [% /if %]
        <form action="index.php?module=settings&event=loginToGetToken" method='POST' class='form-horizontal form-label-left'>
            <div class='row'>
                <div class='col-10 col-xs-offset-1'>
                    <input type='hidden' value='1' name='save'>
                    <div class="form-group row mb-3">
                        <label class="col-lg-4 control-label" for="login">[% $user->gettext('Benutzername') %]</label>
                        <div class="col-lg-8">
                            <input type="text"  value="[% $Username %]" name="username" class="form-control" placeholder="[% $user->gettext('Benutzername') %]" maxlength="255" autocomplete="off" />
                        </div>
                    </div>
                    <div class="form-group row mb-3">
                        <label class="col-lg-4 control-label" for="password">[% $user->gettext('Passwort') %]</label>
                        <div class="col-lg-8">
                            <input type="password" name="password" value="" class="form-control" placeholder="[% $user->gettext('Passwort') %]" size="25" maxlength="50" autocomplete="off" />
                        </div>
                    </div>
                    <div class='form-group row mb-3'>
                        <button class='btn btn-outline-primary' style="width:100%">[% $user->gettext('Token aufrufen') %]</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
   
    /**
     * Comment
     */
    function copyToClipboard(string) {
        navigator.clipboard.writeText(string).then(function () {
            $("#tokenCopied").html('[% $user->gettext('Token wurde in die Zwischenablage kopiert.') %]');
        }, function (err) {
            $("#tokenCopied").html('[% $user->gettext('Token konnte nicht in die Zwischenablage kopiert werden.') %]');
        });
        ;
    }
</script>
