<style>
    .modal-lg{
        max-width: 40vw !important;
    }
</style>
<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>
<form action="index.php?module=settings&amp;event=Mail2TicketSettings" method="post" name="hm" id="hm-Settings-M2T" enctype="multipart/form-data" class="form-horizontal form-label-left">

    <input type="hidden" name="storeMail2TicketSettings" value="1" />
    <input type="hidden" name="task" value="mail2ticket" />

    <div class="row">
        <div class="col-12">
            <div class="card panel-info shadow-sm rounded">
                <div class="card-body">
                    <div class="btn-group">
                        <input type="reset" class="btn btn-outline-secondary" value="[% $user->gettext('Reset') %]" />
                        <input type="submit" class="btn btn-outline-secondary" value="[% $user->gettext('&Auml;nderungen speichern') %]" />
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class = "col-lg-6">
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <h3 class="card-title">[% $user->gettext('Verbindungseinstellungen') %]</h3>
                </div>
                <div class="card-body">
                    <div class="form-group row mb-3">
                        <label class="col-lg-5 control-label" >[% $user->gettext('E-Mail2Ticket -Schnittstelle aktiv') %]</label>
                        <div class="col-lg-7">
                            <input type="radio" name="Mail2Ticket[Active]" value="1" [% if $smarty.const.MAIL2TICKET_ACTIVE == 1 %]checked="checked"[% /if %] /> [% $user->gettext('Ja') %]
                            <input type="radio" name="Mail2Ticket[Active]" value="0" [% if $smarty.const.MAIL2TICKET_ACTIVE != 1 %]checked="checked"[% /if %] /> [% $user->gettext('Nein') %]
                        </div>
                    </div>
                    [% if $smarty.const.MAIL2TICKET_ACTIVE == 1 %]

                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  for="Mail2TicketHost">[% $user->gettext('Mailserver') %]</label>
                            <div class="col-lg-7"><input type="text" class="form-control" name="Mail2Ticket[Host]" id="Mail2TicketHost" value="[% $smarty.const.MAIL2TICKET_POP3SRV %]" maxlength="255" size="30" /></div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  for="Mail2TicketSecureConnection">[% $user->gettext('Verbindungssicherheit') %]</label>

                            <div class="col-lg-7">
                                <select size="1" name="Mail2Ticket[SecureConnection]" id="Mail2TicketSecureConnection" class="form-control  select2" style="width: 100%;">
                                    <option value="0" [% if $smarty.const.MAIL2TICKET_POP3_SECURE_CONNECTION === 0 || $smarty.const.MAIL2TICKET_POP3_SECURE_CONNECTION == 'MAIL2TICKET_POP3_SECURE_CONNECTION' %]selected="selected"[% /if %]>[% $user->gettext('Keine') %]</option>
                                    <option value="STARTTLS" [% if $smarty.const.MAIL2TICKET_POP3_SECURE_CONNECTION === 'STARTTLS' %]selected="selected"[% /if %]>[% $user->gettext('STARTTLS') %]</option>
                                    <option value="TLS" [% if $smarty.const.MAIL2TICKET_POP3_SECURE_CONNECTION === 'TLS' %]selected="selected"[% /if %]>[% $user->gettext('SSL/TLS') %]</option>
                                    <option value="MSOfficeOAuth" [% if $smarty.const.MAIL2TICKET_POP3_SECURE_CONNECTION === 'MSOfficeOAuth' %]selected="selected"[% /if %]>[% $user->gettext('MSOffice OAuth') %]</option>
                                    <option value="MSGraphAPI" [% if $smarty.const.MAIL2TICKET_POP3_SECURE_CONNECTION === 'MSGraphAPI' %]selected="selected"[% /if %]>[% $user->gettext('MS Graph') %]</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  for="Mail2TicketUser">[% $user->gettext('Username') %]</label>
                            <div class="col-lg-7">
                                <input type="text" class="form-control" name="Mail2Ticket[User]" id="Mail2TicketUser" value="[% $smarty.const.MAIL2TICKET_POP3USR %]" maxlength="255" size="30" />
                                <span class="help-block">[% $user->gettext('Bitte beachten Sie, dass kein Heinzelmann-Benutzer oder Kontakt dieses Postfach als Mailadresse eingetragen haben sollte. Ansonsten kann es bei Benachrichtigungen zu Mail-Schleifen kommen.') %]</span>
                            </div>
                        </div>

                        <div class="form-group row mb-3 MSOfficeOAuth NotForMSGraphAPI">
                            <div class="col-lg-12">
                                <span class="help-block">[% $user->gettext('Bei der Verwendung von Microsoft Office 365 mit OAuth-Verfahren müssen über das Programm "OfficeTokenGenerator" im Heinzelmann-Service die benötigten Tokens für die verwendeten Mailadressen generiert werden.') %]</span>
                            </div>
                        </div>
                        <div class="form-group row mb-3 MSOfficeOAuth NotForMSOfficeOAuth">
                            <div class="col-lg-12">
                                <span class="help-block">[% $user->gettext('Bei der Verwendung von Microsoft Graph mit OAuth-Verfahren müssen über das Programm "GraphTokenGenerator" im Heinzelmann-Service die benötigten Tokens für die verwendeten Mailadressen generiert werden.') %]</span>
                            </div>
                        </div>


                        <div class="form-group row mb-3 MSOfficeOAuth">
                            <label class="col-lg-5 control-label" for="Mail2TicketClientID">[% $user->gettext('Anwendungs-ID (Client)') %]</label>
                            <div class="col-lg-7">
                                <input type="text" class="form-control" name="Mail2Ticket[ClientID]" id="Mail2TicketClientID" value="[% $smarty.const.MAIL2TICKET_CLIENTID  %]" size="30" />
                                <span class="help-block">[% $user->gettext('ApplikationID aus den Azure-Settings für die entsprechende Applikation') %]</span>
                            </div>
                        </div>

                        <div class="form-group row mb-3 MSOfficeOAuth">
                            <label class="col-lg-5 control-label" for="Mail2TicketTenantID">[% $user->gettext('Verzeichnis-ID (Mandant)') %]</label>
                            <div class="col-lg-7">
                                <input type="text" class="form-control" name="Mail2Ticket[TenantID]" id="Mail2TicketTenantID" value="[% $smarty.const.MAIL2TICKET_TENANTID  %]" size="30" />
                                <span class="help-block">[% $user->gettext('Mandanten-bzw. VerzeichnisID aus den Azure-Settings') %]</span>
                            </div>
                        </div>

                        <div class="form-group row mb-3 NotForMSOfficeOAuth NotForMSGraphAPI">
                            <label class="col-lg-5 control-label"  for="Mail2TicketPassword">[% $user->gettext('Password') %]</label>
                            <div class="col-lg-7"><input type="password" class="form-control" name="Mail2Ticket[Password]" id="Mail2TicketPassword" value="[% if $smarty.const.MAIL2TICKET_POP3PWD_ENCRYPTED %]*********[% /if %]" placeholder="[% $user->gettext('Passwort eingeben')%]" maxlength="255" size="30" /></div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label" >[% $user->gettext('eMails auf Server belassen') %]</label>
                            <div class="col-lg-7">
                                <input type="radio" name="Mail2Ticket[POP3LeaveMsg]" value="1" [% if $smarty.const.MAIL2TICKET_POP3LEAVE_MSG == 1 %]checked="checked"[% /if %] /> [% $user->gettext('Ja') %]
                                <input type="radio" name="Mail2Ticket[POP3LeaveMsg]" value="0" [% if $smarty.const.MAIL2TICKET_POP3LEAVE_MSG != 1 %]checked="checked"[% /if %] /> [% $user->gettext('Nein') %]
                            </div>
                        </div>

                        <div class="form-group row mb-3 NotForMSGraphAPI">
                            <label class="col-lg-5 control-label"  for="Mail2Ticket[ImapFolder]">[% $user->gettext('Verzeichnis für verarb. Mails') %]</label>
                            <div class="col-lg-7">
                                <input type="text" class="form-control" name="Mail2Ticket[ImapFolder]" value="[% if $smarty.const.M2T_IMAPFOLDER != 'M2T_IMAPFOLDER' %][% $smarty.const.M2T_IMAPFOLDER %][% /if %]" maxlength="30" size="30" />
                                <span class="help-block">[% $user->gettext("In dieses Verzeichnis werden verarbeitete Mails verschoben, wenn die Einstellungen 'eMails auf Server belassen' und 'Verbindungstyp' = IMAP gesetzt sind. ") %]</span>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  for="Mail2Ticket[M2TInterval]">[% $user->gettext('Prüfintervall des Dienstes') %]</label>
                            <div class="col-lg-7">
                                <input type="number" name="Mail2Ticket[M2TInterval]" value="[% if $smarty.const.MAIL2TICKET_CHECKINTERVAL != 'MAIL2TICKET_CHECKINTERVAL' %][% $smarty.const.MAIL2TICKET_CHECKINTERVAL %][% else %]1[% /if %]" min="1" max="1440" /> [% $user->gettext('Minuten') %]
                                <span class="help-block">[% $user->gettext('Der Mail2Ticket-Dienst prüft alle x Minuten die angegebenen Postfächer. Standardwert ist 1 Minute') %]</span>
                            </div>
                        </div>


                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  for="Mail2Ticket[Pop3OrImap]">[% $user->gettext('Verbindungstyp') %]</label>
                            <div class="col-lg-7">
                                <input type="radio" name="Mail2Ticket[Pop3OrImap]" value="POP3" [% if $smarty.const.M2T_CONNECTIONTYPE != 'IMAP' %]checked="checked"[% /if %] /> [% $user->gettext('POP3') %]
                                <input type="radio" name="Mail2Ticket[Pop3OrImap]" value="IMAP" [% if $smarty.const.M2T_CONNECTIONTYPE == 'IMAP' %]checked="checked"[% /if %] /> [% $user->gettext('IMAP') %]
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  for="M2TMailFrom">[% $user->gettext('Mailabsender Name') %]</label>

                            <div class="col-lg-7"><input type="text"  name="Mail2Ticket[m2tsmtpfromname]" id="M2TMailFrom" value="[% if 'M2T_SMTP_FROM_NAME' != $smarty.const.M2T_SMTP_FROM_NAME %][% $smarty.const.M2T_SMTP_FROM_NAME %][% else %]Heinzelmann Ticketing Administrator[% /if %]" size="30" maxlength="255" class="form-control" /></div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label" for="Mail2Ticket[M2TInformAdminUnknownSender]">[% $user->gettext('Benachrichtigung über unbekannten Absender senden') %]</label>
                            <div class="col-lg-7">
                                <input type="radio" name="Mail2Ticket[M2TInformAdminUnknownSender]" value="1" [% if $smarty.const.M2T_INFORMADMINUNKNOWNSENDER == 1 %]checked="checked"[% /if %] /> [% $user->gettext('Ja') %]
                                <input type="radio" name="Mail2Ticket[M2TInformAdminUnknownSender]" value="0" [% if $smarty.const.M2T_INFORMADMINUNKNOWNSENDER != 1 %]checked="checked"[% /if %] /> [% $user->gettext('Nein') %]
                                <span class="help-block">[% $user->gettext('Wenn gewünscht, wird der M2T-Administrator über Mails von unbekannten Absendern informiert') %]</span>

                            </div>
                        </div>

                    [% /if %]
                </div>
            </div>

            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <div class="row">
                        <h3 class="card-title">
                            <div class="col-sm-6">[% $user->gettext('Weitere MailAccounts') %]</div>
                            <div class="col-sm-6 text-end">
                                <a href="index.php?module=settings&class=MailAccounts" class="btn btn-outline-primary btn-sm openInBigIFrameModal" >[% $user->gettext('Weiteren MailAccount anlegen') %] </a>
                            </div>
                        </h3>
                    </div>
                </div>
                <div class="card-body">

                    <div class='table-responsive'>
                        <table class="table table-striped"  >
                            <thead>
                                <tr>
                                    <th>[% $user->gettext('ID') %]</th>
                                    <th>[% $user->gettext('Server') %]</th>
                                    <th>[% $user->gettext('User') %]</th>
                                    <th>[% $user->gettext('Kontakt') %]</th>
                                    <th>[% $user->gettext('Supporter') %]</th>
                                    <th>[% $user->gettext('Gruppe') %]</th>
                                    <th>[% $user->gettext('Kategorie') %]</th>
                                    <th>[% $user->gettext('Mails behalten') %]</th>
                                    <th>[% $user->gettext('Aktiviert') %]</th>
                                    <th>[% $user->gettext('Aktion') %]</th>
                                </tr>
                            </thead>
                            <tbody>
                                [% foreach from=$MailAccounts item=MailAccount name=MailAccountList %]
                                    <tr>
                                        <td>[% $MailAccount.mailaccountid %]&nbsp;</td>
                                        <td>[% $MailAccount.mailserver %]&nbsp;</td>
                                        <td>[% $MailAccount.mailuser %]&nbsp;</td>
                                        <td>[% $MailAccount.contactname %]&nbsp;</td>
                                        <td>[% $MailAccount.supportername %]&nbsp;</td>
                                        <td>[% $MailAccount.groupname %]&nbsp;</td>
                                        <td>[% $MailAccount.categoryname %]&nbsp;</td>
                                        <td>[% if $MailAccount.leavemessages == 1%][% $user->gettext('Ja') %][% else %][% $user->gettext('Nein') %][% /if %]&nbsp;</td>
                                        <td>[% if $MailAccount.active == 1%][% $user->gettext('Ja') %][% else %][% $user->gettext('Nein') %][% /if %]&nbsp;</td>
                                        <td style="text-align:center !important;">
                                            <a href="index.php?module=settings&amp;class=MailAccounts&amp;id=[% $MailAccount.mailaccountid %]" class="openInBigIFrameModal" >[% $user->gettext('Bearbeiten') %]</a> /

                                            <a href="index.php?module=settings&amp;class=MailAccounts&amp;event=activate&amp;id=[% $MailAccount.mailaccountid %]">[% if $MailAccount.active == 0 %][% $user->gettext('Aktivieren') %][% else %][% $user->gettext('Deaktivieren') %][% /if %]</a> /

                                            <a href="#" onclick="bootbox.confirm('[% $user->gettext('Diesen Account wirklich löschen?') %]', function (result) {
                                                        if (result) {
                                                            document.location.href = 'index.php?module=settings&amp;class=MailAccounts&amp;event=delete&amp;id=[% $MailAccount.mailaccountid %]';
                                                        }
                                                    })">[% $user->gettext('L&ouml;schen') %]</a>
                                        </td>
                                    </tr>
                                [% foreachelse %]
                                    <tr>
                                        <td colspan="10">[% $user->gettext('Keine weiterer MailAccount vorhanden...') %]</td>
                                    </tr>
                                [% /foreach %]
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="card panel-info shadow-sm rounded" id="M2TBlacklist">
                <div class="card-header">
                    <div class="row">
                        <h3 class="card-title">
                            <div class="col-sm-6">[% $user->gettext('Blacklist') %]</div>
                            <div class="col-sm-6 text-end">                 
                                <a href="index.php?module=settings&event=addToBlackList" class="btn btn-outline-primary btn-sm openInBigIFrameModal" >[% $user->gettext('E-Mail in Blacklist hinzufügen') %] </a>
                            </div>   
                        </h3>                    
                    </div>
                </div>
                <div class="card-body">

                    <div class='table-responsive'>
                        <table class="table table-striped"  id='BlacklistTable'>
                            <thead>
                                <tr>
                                    <th>[% $user->gettext('Adresse') %]</th>
                                    <th>[% $user->gettext('Hinzugefügt von') %]</th>
                                    <th>[% $user->gettext('Hinzugefügt am') %]</th>
                                    <th>[% $user->gettext('Aktion') %]</th>
                                </tr>
                            </thead>
                            <tbody>
                                [% foreach from=$MailBlacklists item=mail  %]
                                    <tr id="blacklist_[% $mail.mailaddressid %]">
                                        <td>[% $mail.mailaddress %]&nbsp;</td>
                                        <td>[% $mail.createusername %]&nbsp;</td>
                                        <td data-sort="[% $mail.createdate %]">[% $mail.createdate|date_format:"%d.%m.%Y %H:%M" %]&nbsp;</td>

                                        <td style="text-align:center !important;">
                                            <a href="#M2TBlacklist" onclick="bootbox.confirm('[% $user->gettext('Diese E-Mail wirklich aus Blacklist löschen?') %]', function (result) {
                                                        if (result) {
                                                            $.post('index.php?module=settings&event=removeFromBlacklist', {'id': [% $mail.mailaddressid %]}, function () {
                                                                noty({
                                                                    text: '[% $user->gettext('Eintrag wurde gelöscht.')%]',
                                                                    type: 'success',
                                                                    timeout: notifyTimeout
                                                                });
                                                                $('#blacklist_[% $mail.mailaddressid %]').detach();

                                                            });
                                                        }
                                                    })">[% $user->gettext('L&ouml;schen') %]</a>
                                        </td>
                                    </tr>
                                [% foreachelse %]

                                [% /foreach %]
                            </tbody>
                        </table>
                    </div>                    
                </div>
            </div>

        </div>

        <div class = "col-lg-6">
            [% if $smarty.const.MAIL2TICKET_ACTIVE == 1 %]
                <div class="card panel-info shadow-sm rounded">
                    <div class="card-body">



                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  for="Mail2TicketDefGroup">[% $user->gettext('Standardgruppe') %]</label>

                            <div class="col-lg-7">
                                <select size="1" name="Mail2Ticket[DefGroup]" id="Mail2TicketDefGroup" class="form-control  select2" style="width: 100%;">
                                    [% foreach from=$SupporterGroups item=group key=GroupID %]
                                        <option value="[% $GroupID %]" [% if $smarty.const.MAIL2TICKET_DEFGROUP == $GroupID %]selected="selected"[% /if %]>[% $user->gettext($group) %]</option>
                                    [% /foreach %]
                                </select>
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  for="Mail2TicketDefSupporter">[% $user->gettext('Standardsupporter') %]</label>

                            <div class="col-lg-7">
                                <select size="1" name="Mail2Ticket[DefSupporter]" id="Mail2TicketDefSupporter" class="form-control  select2" style="width: 100%;">
                                    <option value="0" [% if $smarty.const.MAIL2TICKET_DEFSUPPORTER == 0 || $smarty.const.MAIL2TICKET_DEFSUPPORTER == '' %]selected="selected"[% /if %]>[% $user->gettext('-- Keinen --') %]</option>
                                    [% foreach from=$SupportersFromM2TDefGroup item=supporter key=id %]
                                        <option value="[% $id %]" [% if $smarty.const.MAIL2TICKET_DEFSUPPORTER == $id %]selected="selected"[% /if %]>[% $supporter %]</option>
                                    [% /foreach %]
                                </select>
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  for="Mail2TicketDefContact">[% $user->gettext('Standardkontakt') %]
                                <small>[% $user->gettext('(falls Absender unbekannt ist)') %]</small>
                            </label>

                            <div class="col-lg-7">

                                <select size="1" name="Mail2Ticket[DefContact]" id="Mail2TicketDefContact" class="form-control select2" style="width: 100%;">
                                    <option value="[% $M2TDefContactID %]" selected="selected" >[% $M2TDefContactName %]</option>
                                </select>

                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  for="Mail2TicketDefCat">[% $user->gettext('Standardkategorie') %]
                            </label>

                            <div class="col-lg-7">
                                <select size="1" name="Mail2Ticket[DefCat]" id="Mail2TicketDefCat" class="form-control  select2" style="width: 100%;">
                                    [% foreach from=$Categories item=cat %]
                                        <option value="[% $cat.id %]" [% if $smarty.const.MAIL2TICKET_DEFCAT == $cat.id %]selected="selected"[% /if %]>[% $cat.name %]</option>
                                    [% /foreach %]
                                </select>
                                <span class="help-block">[% $user->gettext('Falls Kategorie 1 Pflichtfeld') %]</span>
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  for="Mail2TicketTicketType">[% $user->gettext('Standardtickettyp') %]
                            </label>

                            <div class="col-lg-7">
                                <select size="1" name="Mail2Ticket[TicketType]" id="Mail2TicketTicketType" class="form-control select2" style="width: 100%;">
                                    <option value="0" [% if $smarty.const.MAIL2TICKET_TICKETTYPE == 0 || $smarty.const.MAIL2TICKET_TICKETTYPE == '' %]selected="selected"[% /if %]>[% $user->gettext('-- Standard Ticket --') %]</option>
                                    [% foreach from=$Tickettypes item=type key=$id%]
                                        <option value="[% $id %]" [% if $smarty.const.MAIL2TICKET_TICKETTYPE == $id %]selected="selected"[% /if %]>[% $user->gettext($type) %]</option>
                                    [% /foreach %]
                                </select>

                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  for="Mail2TicketMandantenID">[% $user->gettext('Mandant für Tickets von diesem Postfach') %]
                            </label>

                            <div class="col-lg-7">
                                <select size="1" name="Mail2Ticket[MandantenID]" id="Mail2TicketMandantenID" class="form-control select2" style="width: 100%;">
                                    [% foreach from=$Mandanten item=mandant key=$id%]
                                        <option value="[% $id %]" [% if $smarty.const.MAIL2TICKET_MANDANTENID == $id %]selected="selected"[% /if %]>[% $user->gettext($mandant) %]</option>
                                    [% /foreach %]
                                </select>
                                <span class="help-block">[% $user->gettext('Wenn ein Mandant durch das Postfach zugewiesen wird, wird nicht der Mandant des Absenders verwendet.') %]</span>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  for="Mail2TicketMailDomain">[% $user->gettext('Emails nur von dieser Dom&auml;ne verarbeiten') %]
                            </label>
                            <div class="col-lg-7">
                                <input type="text" class="form-control" name="Mail2Ticket[MailDomain]" id="Mail2TicketMailDomain" value="[% $smarty.const.MAIL2TICKET_MAILDOMAIN %]"  size="30" />
                                <span class="help-block">[% $user->gettext('Wenn leer - keine Beschr&auml;nkung') %]. 
                                [% $user->gettext('Mehrere Domänen werden mit Semikolon getrennt eingetragen.') %]</span>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label" for="Mail2Ticket[MaildomainKeepInbox]">[% $user->gettext('Mails von nicht passenden Domains behalten') %]</label>
                            <div class="col-lg-7">
                                <input type="radio" name="Mail2Ticket[MaildomainKeepInbox]" value="1" [% if $smarty.const.MAIL2TICKET_MAILDOMAIN_KEEPINBOX == 1 %]checked="checked"[% /if %] /> [% $user->gettext('Ja') %]
                                <input type="radio" name="Mail2Ticket[MaildomainKeepInbox]" value="0" [% if $smarty.const.MAIL2TICKET_MAILDOMAIN_KEEPINBOX != 1 %]checked="checked"[% /if %] /> [% $user->gettext('Nein') %]
                                <span class="help-block">[% $user->gettext('Wenn aktiviert, werden Mails mit abweichender Absenderdomain nicht gelöscht, sondern lediglich als gelesen markiert.') %]</span>
                            </div>
                        </div>


                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label" for="Mail2Ticket[SMTPSSL]">[% $user->gettext('Mailversand des Dienstes über verschlüsselte SMTP Verbindung') %]</label>
                            <div class="col-lg-7">
                                <input type="radio" name="Mail2Ticket[SMTPSSL]" value="1" [% if $smarty.const.SMTPSSL == 1 %]checked="checked"[% /if %] /> [% $user->gettext('Ja') %]
                                <input type="radio" name="Mail2Ticket[SMTPSSL]" value="0" [% if $smarty.const.SMTPSSL != 1 %]checked="checked"[% /if %] /> [% $user->gettext('Nein') %]
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label" for="Mail2Ticket[USETLS12]">[% $user->gettext('TLS v1.2 für SMTP-Verbindung des Dienstes erzwingen') %]</label>
                            <div class="col-lg-7">
                                <input type="radio" name="Mail2Ticket[USETLS12]" value="1" [% if $smarty.const.USETLS12 == 1 %]checked="checked"[% /if %] /> [% $user->gettext('Ja') %]
                                <input type="radio" name="Mail2Ticket[USETLS12]" value="0" [% if $smarty.const.USETLS12 != 1 %]checked="checked"[% /if %] /> [% $user->gettext('Nein') %]
                            </div>
                        </div>                            

                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label" >[% $user->gettext('Antwort an Absender') %]</label>

                            <div class="col-lg-7">
                                <input type="radio" name="Mail2Ticket[ResponseToSender]" value="0" [% if $smarty.const.REPLAYTOSENDER != 1 && $smarty.const.REPLAYTOSENDER != 2 %]checked="checked"[% /if %] /> [% $user->gettext('Nein') %]<br/>
                                <input type="radio" name="Mail2Ticket[ResponseToSender]" value="1" [% if $smarty.const.REPLAYTOSENDER == 1 %]checked="checked"[% /if %] /> [% $user->gettext('An den Absender') %]<br/>
                                <input type="radio" name="Mail2Ticket[ResponseToSender]" value="2" [% if $smarty.const.REPLAYTOSENDER == 2 %]checked="checked"[% /if %] /> [% $user->gettext('An alle Empfänger') %]
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label">[% $user->gettext('Verwendetes Template für ReplyMails') %]</label>
                            <div class="col-lg-7">
                                <span class="input-group">
                                    <select name="Mail2Ticket[ReplyMailTemplateID]" id="ReplyMailTemplateID" class="form-control" style="width: 100%">
                                        [% html_options options=$ActiveReplyMailtemplates selected=$smarty.const.M2T_REPLYMAILTEMPLATEID %]
                                    </select>
                                    <span class="input-group-text">
                                        <a href="index.php?module=settings&amp;event=addMailTemplate" class="openInIFrameModal" data-fancybox-type="iframe" title="[% $user->gettext('Emailtemplate anpassen') %]" ><span class="fa fa-pencil"></span></a>
                                    </span>
                                </span>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  for="Mail2Ticket[M2T_REPLYJUST2CONTACTS]">[% $user->gettext("'Antwort an Absender' nur an Heinzelmann-Kontakte") %]</label>
                            <div class="col-lg-7">
                                <input type="radio" name="Mail2Ticket[M2T_REPLYJUST2CONTACTS]" value="1" [% if $smarty.const.M2T_REPLYJUST2CONTACTS == 1 %]checked="checked"[% /if %] /> [% $user->gettext('Ja') %]
                                <input type="radio" name="Mail2Ticket[M2T_REPLYJUST2CONTACTS]" value="0" [% if $smarty.const.M2T_REPLYJUST2CONTACTS != 1 %]checked="checked"[% /if %] /> [% $user->gettext('Nein') %]
                                <span class="help-block">[% $user->gettext('Mit dieser Option wird die automatische Antwort nur an Absender versandt, die als Heinzelmann-Kontakt angelegt sind.') %]</span>
                            </div>                                
                        </div>                            


                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  title="[% $user->gettext('Hier können sie definieren, welche Kategorie 1 einem Ticket zugeordnet wird, wenn die eMail einen bestimmten Absender oder Betreff enthält. WICHTIG: Es wird erst der Betreff geprüft. Nur wenn dieser nicht in der Liste definiert ist, wird der Absender geprüft.') %]"
                                   >[% $user->gettext('Kategorie / Gruppe durch Absender oder Betreff') %]</label>

                            <div class="col-lg-3">
                                <input type="radio" name="Mail2Ticket[CatForSender]" value="1" [% if $smarty.const.CATFORSENDER == 1 %]checked="checked"[% /if %] /> [% $user->gettext('Ja') %]
                                <input type="radio" name="Mail2Ticket[CatForSender]" value="0" [% if $smarty.const.CATFORSENDER != 1 %]checked="checked"[% /if %] /> [% $user->gettext('Nein') %]
                            </div>

                            <div class="col-lg-4">
                                <a href="index.php?module=settings&amp;event=editCategoryForSenderList" class="btn btn-outline-primary openInIFrameModal" data-fancybox-type="iframe">[% $user->gettext('Liste bearbeiten') %]</a>
                            </div>

                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  title="[% $user->gettext('Mit dieser Option wird versucht, generierte Mails (Abwesenheitsnotizen, volle Postfächer o.ä. ) zu erkennen. Diese werden dann nicht vom Dienst verarbeitet.') %]"
                                   >[% $user->gettext('Generierte Mails nicht verarbeiten') %]</label>
                            <div class="col-lg-7">
                                <input type="radio" name="Mail2Ticket[checkAutoReplys]" value="1" [% if $smarty.const.M2T_CHECKAUTOREPLYS == 1 %]checked="checked"[% /if %] /> [% $user->gettext('Ja') %]
                                <input type="radio" name="Mail2Ticket[checkAutoReplys]" value="0" [% if $smarty.const.M2T_CHECKAUTOREPLYS != 1 %]checked="checked"[% /if %] /> [% $user->gettext('Nein') %]
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  title="[% $user->gettext('Sie können eigene Filter definieren, nach welchen der Betreff durchsucht wird.') %]"
                                   >[% $user->gettext('Betrefffilter') %]</label>
                            <div class="col-lg-3">
                                <input type="radio" name="Mail2Ticket[SubjectFilter]" value="1" [% if $smarty.const.M2T_SUBJECTFILTER == 1 %]checked="checked"[% /if %] /> [% $user->gettext('Ja') %]
                                <input type="radio" name="Mail2Ticket[SubjectFilter]" value="0" [% if $smarty.const.M2T_SUBJECTFILTER != 1 %]checked="checked"[% /if %] /> [% $user->gettext('Nein') %]
                            </div>

                            <div class="col-lg-4">
                                <a href="index.php?module=settings&amp;event=defineSubjectFilter" class="btn btn-outline-primary">[% $user->gettext('Filterdefinitionen') %]</a>
                            </div>
                        </div>


                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  for="Mail2Ticket[UseIFrame]" title="[% $user->gettext('Die eMails werden als HTML-Datei gespeichert und mit den Formatierungen im Ticket angezeigt.') %]">[% $user->gettext('Formatierungen aus HTML E-Mails anzeigen') %]</label>
                            <div class="col-lg-7">
                                <input type="radio" name="Mail2Ticket[UseIFrame]" value="1" [% if $smarty.const.M2T_USEIFRAME == 1 %]checked="checked"[% /if %] /> [% $user->gettext('Ja') %]
                                <input type="radio" name="Mail2Ticket[UseIFrame]" value="0" [% if $smarty.const.M2T_USEIFRAME != 1 %]checked="checked"[% /if %] /> [% $user->gettext('Nein') %]                                
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-lg-5 control-label"  for="Mail2Ticket[UseInlineGraphicsForIFrame]" title="[% $user->gettext('Bilder der HTML-Mails werden als Inline-Daten gespeichert statt als Datei im Dateisystem angelegt.') %]">[% $user->gettext('Bilder der HTML-Mails als Inline-Daten speichern') %]</label>
                            <div class="col-lg-7">
                                <input type="radio" name="Mail2Ticket[UseInlineGraphicsForIFrame]" value="1" [% if $smarty.const.M2T_USEINLINEGRAPHICSFORIFRAME == 1 %]checked="checked"[% /if %] /> [% $user->gettext('Ja') %]
                                <input type="radio" name="Mail2Ticket[UseInlineGraphicsForIFrame]" value="0" [% if $smarty.const.M2T_USEINLINEGRAPHICSFORIFRAME != 1 %]checked="checked"[% /if %] /> [% $user->gettext('Nein') %]
                                <span class="help-block">
                                    [% $user->gettext('Bilder der HTML-Mails werden als Inline-Daten gespeichert. Da die Grafiken dadurch in der DB abgelegt werden, wird die Datenmenge dort u.U. erheblich größer. Die Funktion korrigiert das Verhalten, wenn alle Inline-Grafiken im Mailbody unter gleichen Dateinamen verarbeitet werden.') %]
                                </span>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  for="Mail2Ticket[TicketEditOnly]" title="[% $user->gettext('Es werden nur TicketBEARBEITUNGEN per E-Mail durchgeführt. Es werden keine neuen Tickets angelegt.') %]">[% $user->gettext('Nur Ticket-Bearbeitungen erlauben') %]</label>
                            <div class="col-lg-3">
                                <input type="radio" class="toggleTpl4TicketEditOnly" name="Mail2Ticket[TicketEditOnly]" value="1" [% if $smarty.const.M2T_TICKETEDITONLY == 1 %]checked="checked"[% /if %] /> [% $user->gettext('Ja') %]
                                <input type="radio" class="toggleTpl4TicketEditOnly" name="Mail2Ticket[TicketEditOnly]" value="0" [% if $smarty.const.M2T_TICKETEDITONLY != 1 %]checked="checked"[% /if %] /> [% $user->gettext('Nein') %]
                            </div>

                            <div class="col-lg-4 [% if $smarty.const.M2T_TICKETEDITONLY != 1 %]hidden[% /if %]" id="Tpl4TicketEditOnly" >
                                <span class="input-group " >
                                    <select name="Mail2Ticket[ReplyTpl4TicketEditOnly]" id="ReplyTpl4TicketEditOnly" class="form-control" style="width: 100%">
                                        [% html_options options=$ActiveReplyMailtemplates selected=$smarty.const.M2T_REPLYTPL4TICKETEDITONLY %]
                                    </select>
                                    <span class="input-group-text">
                                        <a href="index.php?module=settings&amp;event=addMailTemplate" class="openInIFrameModal" data-fancybox-type="iframe" title="[% $user->gettext('Emailtemplate anpassen') %]" ><span class="fa fa-pencil"></span></a>
                                    </span>
                                </span>
                                <span class="help-block">[% $user->gettext('Sind Ticketanlagen per Mail nicht erlaubt, können Sie hier das Antworttemplate wählen, welches gesendet wird, wenn ein Ticket per Mail angelegt werden sollte.') %]</span>
                            </div>                            
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-lg-5 control-label"  for="Mail2Ticket[M2T_EDITABLE_CHILDTICKETS]" title="[% $user->gettext('Ermöglicht das Bearbeiten von Childtickets per Mail2Ticket') %]">[% $user->gettext('Childticket-Bearbeitungen per Mail erlauben') %]</label>
                            <div class="col-lg-7">
                                <input type="radio" name="Mail2Ticket[M2T_EDITABLE_CHILDTICKETS]" value="1" [% if $smarty.const.M2T_EDITABLE_CHILDTICKETS == 1 %]checked="checked"[% /if %] /> [% $user->gettext('Ja') %]
                                <input type="radio" name="Mail2Ticket[M2T_EDITABLE_CHILDTICKETS]" value="0" [% if $smarty.const.M2T_EDITABLE_CHILDTICKETS != 1 %]checked="checked"[% /if %] /> [% $user->gettext('Nein') %]
                                <span class="help-block">[% $user->gettext('Ohne diese Option werden E-Mails mit der TicketID eines Childticket im Betreff im entsprechenden Masterticket eingefügt.') %]</span>
                            </div>


                        </div>                            




                    </div>
                </div>
            [% /if %]
        </div>
    </div>
</form>
<script>
    /**
     * 
     */
    function closeIframe() {
        location.href = 'index.php?module=settings#Mail2TicketPanel';
    }


    $(document).ready(function () {

        $('#BlacklistTable').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'excel',
                'print',
                'pdfHtml5'
            ],
            columnDefs: [
                {targets: '_all', render: function (data, type, row, meta) {
                        var api = $('#example').DataTable();
                        return type === 'export' ? $(api.cell(meta.row, meta.col).node()).attr('data-export') : data;
                    }
                }
            ],
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            }
        });
    });

    $('input[type=radio].toggleTpl4TicketEditOnly').on("change", function () {
        if (this.value == '1') {
            $('#Tpl4TicketEditOnly').removeClass('hidden');
        } else {
            $('#Tpl4TicketEditOnly').addClass('hidden');
        }
    });

    [% if $smarty.const.MAIL2TICKET_POP3_SECURE_CONNECTION === 'MSOfficeOAuth' %]
    $('.NotForMSOfficeOAuth').hide();
    [% else if $smarty.const.MAIL2TICKET_POP3_SECURE_CONNECTION === 'MSGraphAPI' %]
    $('.NotForMSGraphAPI').hide();
    [% else %]
    $('.MSOfficeOAuth').hide();
    [% /if %]


    $("#Mail2TicketSecureConnection").on('change', function (e) {
        if ($("#Mail2TicketSecureConnection").val() === 'MSOfficeOAuth') {
            $('.MSOfficeOAuth').show();
            $('.NotForMSOfficeOAuth').hide();            
        } else if ($("#Mail2TicketSecureConnection").val() === 'MSGraphAPI') {
            $('.MSOfficeOAuth').show();
            $('.NotForMSGraphAPI').hide();
        } else {
            $('.NotForMSOfficeOAuth, .NotForMSGraphAPI').show();
            $('.MSOfficeOAuth').hide();
        }
    })

</script>
<!-- Component Settings  - mail2ticket.tpl end -->
