<script>
    function loadEdit(id) {
        $('#structureTypeModal').modal('show');
        $('.modalContent').load('index.php?module=structure&class=type&event=edit&id=' + id);
    }

    function loadCreate() {
        $('#structureTypeModal').modal('show');
        $('.modalContent').load('index.php?module=structure&class=type&event=create');
    }
</script>

<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">
            [% $user->gettext('Strukturtypen')%]
        </span>
    </div>
    <div class="card-body">
        [% if $user->hasRight(1) %]                        

            <div class="card panel-info shadow-sm rounded">

                <div class="card-body text-center">
                    <input type="button" class="btn btn-outline-primary" value="[% $user->gettext('Neuer Typ') %]" onclick="window.location.href = 'javascript:loadCreate()'">

                </div>
            </div>

        [% /if %]
        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <span class="fcs-card-title h3">[% $user->gettext('Liste')%]</span>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped text-center">
                        <thead>
                            <tr class="fields">                                    
                                <td>#</td>
                                <td>[% $user->gettext('Bezeichnung') %]</td>
                                <td>&nbsp;</td>
                            </tr>               
                        </thead>
                        <tbody>
                            [% foreach from=$structuretyps item=typ name=lfdtyp %]
                                <tr>
                                    <td style="">&nbsp;[% $smarty.foreach.lfdtyp.iteration %]&nbsp;</td>
                                    <td style="">
                                        &nbsp;
                                        [% $typ.name %]
                                        &nbsp;
                                    </td>
                                    <td style="">
                                        &nbsp;                            
                                        [% if $user->hasRight(1) %]
                                            <a class="btn btn-outline-secondary" href="index.php?module=structure&amp;class=type&amp;event=remove&id=[% $typ.styp_id %]" onclick="return confirm('[% $typ.name %] \n[% $user->gettext('wirklich löschen?') %]');"><span class="fa fa-trash" title="[% $user->gettext('Löschen') %]"></span></a>
                                            [% /if %]
                                            [% if $user->hasRight(1) %]
                                            <a class="btn btn-outline-secondary" href="javascript:loadEdit('[% $typ.styp_id %]')"><span class="fa fa-pencil" title="[% $user->gettext('Bearbeiten') %]"></span></a>                                
                                            [% /if %]
                                        &nbsp;
                                    </td>
                                </tr>
                            [% foreachelse %]
                                <tr class="row1">
                                    <td colspan="3" style="padding:2px;">
                                        <div align="center">[% $user->gettext("Keine Einträge vorhanden") %]</div>
                                    </td>
                                </tr>                    
                            [% /foreach %]    
                        </tbody>
                    </table>
                </div>	

            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="structureTypeModal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">

                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>


            </div>
            <div class="modal-body modalContent">

            </div>
        </div>
    </div>
</div>
