<style>

    .table tr th{
        cursor: pointer;
    }
</style>

<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Schlagworte') %]</span>
    </div>
    <div class="card-body">

        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <span class="fcs-card-title h3">[% $user->gettext('Schlagworte') %]</span>[% if $Tools->FCS_Count($nav.entries) %]<span class="fcs-card-title"> - [% $nav.entries %] [% $user->gettext('Eintr&auml;ge gefunden') %]</span>[% /if %]

                <div class="pull-right">
                    <a href="index.php?module=tags&event=addTags" class="btn btn-outline-secondary"><span class="fa fa-plus"></span> [% $user->gettext('Schlagwort zufügen') %]</a>

                </div>

            </div>
            <div class="card-body">


                <div class="card panel-info shadow-sm rounded">
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>[% $user->gettext('Schlagwort') %]</th>
                                        <th>[% $user->gettext('Anzahl Tickets') %]</th>
                                        <th>&nbsp;</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    [% foreach from=$Tags item=Tag key=TagID %]
                                        <tr>
                                            <td>[% $Tag.tag %]</td>
                                            <td><a href="index.php?module=ticketlist&TagSelect[]=[% $TagID %]" target="_blank">[% $Tag.cnttickets %]</a></td>
                                            <td>
                                                <a href="index.php?module=tags&event=editTag&id=[% $TagID %]"><span class="btn btn-sm btn-outline-secondary"><span class="fa fa-pencil"></span></span></a>

                                                <span onclick="deleteTag([% $TagID %], [% $Tag.cnttickets %])" class="btn btn-sm btn-outline-secondary" title="[% $user->gettext('Schlagwort löschen') %]"><span class="fa fa-times"></span></span>
                                            </td>
                                        </tr>
                                    [% /foreach %]
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script>
    $(document).ready(function () {
        $('.table').DataTable({
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "columns": [
                null,
                null,
                {"orderable": false}
            ],
            "oLanguage": {
                "sLengthMenu": '[% $user->gettext("Zeige _MENU_ Eintr&auml;ge") %]',
                "sZeroRecords": '[% $user->gettext("Keine Eintr&auml;ge gefunden") %]',
                "sInfo": '[% $user->gettext("Eintrag _START_ bis _END_ (von _TOTAL_)") %]',
                "sInfoEmpty": " ",
                "sInfoFiltered": '[% $user->gettext(" - gefiltert aus _MAX_ Eintr&auml;gen") %]',
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },
                "aaSorting": [[1, "asc"]]
            }
        });
    })



    function deleteTag(TagID, cntTickets) {
        url = "index.php?module=tags&event=deleteTag&id=" + TagID;
        if (cntTickets) {
            bootbox.confirm("[% $user->gettext('Das Schlagwort ist Tickets zugewiesen. Trotzdem löschen?') %]", function (result) {
                if (result) {
                    window.location = url;
                }
            })
        } else {
            window.location = url;
        }
    }

</script>