<script src="includes/js/dropzone.js"></script>
<link href="includes/js/dropzone.css" rel="stylesheet" type="text/css" />

<style>
    .diffCol {
        color:  green;
    }
    .importError {
        color:red;
    }
    .importSuccess{
        color:green;
    }
</style>
<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Ticketimport') %]</span>
    </div>

    <div class="card-body">

        [% if $MasterTicketData && $MasterTicketData['ID'] %]
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <div class="row">
                        <div class="col-sm-6">
                            <span class="fcs-card-title h6">[% $user->gettext('Childtickets importieren für Ticket') %] [% $MasterTicketData['Title'] %] (#[% $MasterTicketData['ID'] %])</span>
                        </div>
                        <div class="col-sm-6 text-end">
                            <div class="btn-group">

                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <span class="help-block">
                        [% $user->gettext('Laden Sie eine CSV-Datei hoch, die den Kontakt und das Gerät für die angelegten Tickets enthält.') %]
                        [% $user->gettext('Die angelegten Tickets werden als Childtickets des Tickets angelegt. Der Tickettitel und die Ticketbeschreibung wird vom Masterticket übernommen:') %]
                    </span>
                    <h3>[% $MasterTicketData['Title'] %]</h3>
                    [% $MasterTicketData['formatedTicketDescr'] %]
                </div>
            </div>
        [% /if %]

        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <span class="fcs-card-title h3">[% $user->gettext('CSV Import') %] [% $Title %]

                    <div class="text-end">
                        <a href="index.php?module=ticket&class=csvimport&event=clearCSVImport[% $AddTicketID %]" class="btn btn-outline-primary">[% $user->gettext('Liste leeren') %]</a>
                        [% if !($MasterTicketData && $MasterTicketData.ID) %]
                                <a href="index.php?module=ticket&class=csvimport&event=getCSVHeaders" class="btn btn-outline-primary">[% $user->gettext('CSV-Vorlage herunterladen') %]</a>
                        [% else %]
                            <a href="index.php?module=ticket&class=csvimport&event=getCSVHeaders&forChilds" class="btn btn-outline-primary">[% $user->gettext('CSV-Vorlage herunterladen') %]</a>
                        [% /if %]
                    </div>
            </div>
            <div class="card-body">

                <div class="card panel-info shadow-sm rounded">
                    <div class="card-body DropzoneTarget">
                        <form action="index.php?module=ticket&class=csvimport" method="post" id="CSVImportForm" class="form form-horizontal center-block">

                            [% if $cntEntries %]


                                [% $user->gettext('Es wurden') %] [% $cntEntries %] [% $user->gettext('Tickets zum importieren gefunden. Sollen diese angelegt werden?') %]
                                <input type="hidden" name="importData" value="1">
                                <span id="startImport" class="btn btn-outline-secondary">[% $user->gettext('Ja') %]</span>

                                <table id="ResultTable"  class="table table-bordered table-striped table-sm hidden">
                                    <thead>
                                        <tr>
                                            <th>
                                                [% $user->gettext('Eintrag') %]
                                            </th>
                                            <th>
                                                [% $user->gettext('Messages') %]
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>

                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped table-sm">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <input type="checkbox" id="SelectAll" />
                                                </th>
                                                <th>
                                                    [% $user->gettext('Aktion') %]
                                                </th>
                                                [% foreach from=$Headers item=Col %]
                                                    <th>
                                                        [% $Col %]
                                                    </th>
                                                [% /foreach %]
                                            </tr>
                                        </thead>
                                        <tbody>
                                            [% foreach from=$CSVData item=Object key=csvKey %]
                                                <tr id="CSVColNo_[% $csvKey %]" class="[% if $ValidationArray.$csvKey.hint %]hint [% /if %][% if $ValidationArray.$csvKey.error %]error [% /if %][% if !$ValidationArray.$csvKey.hint  && !$ValidationArray.$csvKey.error %]fine[% /if %]">
                                                    <td>
                                                        [% if !$ValidationArray.$csvKey.error  %]
                                                            <input type="checkbox" class="Selection" id="Selection_[% $csvKey %]" name="selectedAssets[[% $csvKey %]]" value="[% $csvKey %]" class="form-control" />
                                                        [% /if %]
                                                    </td>
                                                    <td>
                                                        [% if $ValidationArray.$csvKey.error %]
                                                            <span style="color:red;">[% $user->gettext('Fehler') %]</span>
                                                        [% /if %]
                                                        [% if $ValidationArray.$csvKey.hint %]
                                                            <span style="color:orange;">[% $user->gettext('Hinweis') %]</span>
                                                        [% /if  %]
                                                        [% if !$ValidationArray.$csvKey.hint && !$ValidationArray.$csvKey.error %]                                   
                                                            [% $user->gettext('Anlegen') %]
                                                        [% /if %]
                                                    </td>
                                                    [% foreach from=$Object item=val key=ColName %]
                                                        <td [% if $ValidationArray.$csvKey.Messages.$ColName %] class="diffCol"[% /if %]>
                                                            [% $val %]
                                                            [% if $ValidationArray.$csvKey.Messages.$ColName %]
                                                                <hr/><span class="diffValue">
                                                                    [% $ValidationArray.$csvKey.Messages.$ColName %]
                                                                </span>
                                                            [% /if %]
                                                        </td>
                                                    [% /foreach %]
                                                </tr>
                                            [% /foreach %]
                                        </tbody>
                                    </table>
                                </div>

                            [% else %]
                                <p>
                                    <strong>[% $user->gettext('CSV-Datei per Drag and Drop reinziehen') %]</strong>
                                </p>
                            [% /if %]
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script>

    $(document).ready(function () {

        $('#SelectAll').on("click", function () {
            $('.Selection:visible').prop('checked', true);
        })
        /*
         $("#hasUpdate").on("click", function () {
         $('.hasUpdate').toggleClass('hidden');
         })
         
         $("#notExist").on("click", function () {
         $('.notExist').toggleClass('hidden');
         })
         
         $("#noChanges").on("click", function () {
         $('.noChanges').toggleClass('hidden');
         })
         */

        $('#startImport').on("click", function (e) {
            importFirstSelectedDevice();
        })

        /**
         * Comment
         */
        function importFirstSelectedDevice() {

            CSVColNo = $(".Selection:checkbox:checked:first").val();
            if (typeof CSVColNo === "undefined") {

                $.post("index.php?module=ticket&class=csvimport&event=SetInterestCircleForMasterTicket&MasterTicketID=[% $MasterTicketData['ID'] %]", function (data) {
                })
                return;
            }

            console.log("Nächste: ");
            console.log("ColNo: " + CSVColNo);


            $.post("index.php?module=ticket&class=csvimport&event=startCSVImport[% $AddTicketID %]&CSVColNo=" + CSVColNo, function (data) {
                //console.log(data);
            }).done(function (data) {

                $('#ResultTable').removeClass('hidden');

                markup = "<tr id='Result_" + CSVColNo + "' class=' " + (data.error ? 'importError' : 'importSuccess') + "' ><td>" + data.TicketData.ticketdescr + "</td><td>";


                $.each(data.messages, function (i, item) {
                    markup += item + "<br/>";
                })
                markup += "</td></tr>";
                $('#ResultTable > tbody').append(markup);

                if (data.error) {
                    $("#CSVColNo_" + CSVColNo).addClass('importError');
                    //Wenn es einen Fehler gab, die Markierung entfernen.
                    $('#Selection_' + CSVColNo).prop('checked', false);
                } else {
                    $("#CSVColNo_" + CSVColNo).fadeOut();
                    $("#CSVColNo_" + CSVColNo).remove();
                }


                $("#Result_" + CSVColNo).hide();
                $("#Result_" + CSVColNo).fadeIn();


                importFirstSelectedDevice();
            });

        }

        Dropzone.options.myDropzone = {

            init: function () {

                this.on("queuecomplete", function (file) {
                    //this.removeAllFiles();
                });
            }
        };

        $(".DropzoneTarget").dropzone({
            url: "index.php?module=ticket&class=csvimport&event=getCSVFile[% $AddTicketID %]",
            init: function () {
                this.on("queuecomplete", function (file) {
                    //this.removeAllFiles();
                    location.reload();
                });
            }
        });
    })
</script>
