﻿<style>
    .bootstrap-select .dropdown-menu {
        max-width: 450px;
    }
    .bootstrap-select .dropdown-menu span.text {
        display: block;
        overflow: hidden;
        text-overflow: ellipsis;
    }
</style>

<div class="form-horizontal form-label-left">
    <link rel="stylesheet" type="text/css" href="includes/js/select2/css/select2.min.css">
    <script type="text/javascript" src="includes/js/jquery.progressbar.min.js"></script>
    <script type="text/javascript" src="includes/js/jquery-ui-timepicker-addon.js"></script>
    <script type="text/javascript" src="includes/js/select2/js/select2.full.min.js"></script>
    <script type="text/javascript" src="includes/js/select2/js/i18n/de.js"></script>
    <link rel="stylesheet" href="includes/js/bootstrap-select-1.12.4/dist/css/bootstrap-select.min.css">

    <!-- Latest compiled and minified JavaScript -->
    <script src="includes/js/bootstrap-select-1.12.4/dist/js/bootstrap-select.min.js"></script>

    <!-- (Optional) Latest compiled and minified JavaScript translation files -->
    <script src="includes/js/bootstrap-select-1.12.4/dist/js/i18n/defaults-[% if $user->language_type == "de" %]de_DE[% else %]en_US[% /if %].min.js"></script>
    <div class="card panel-info shadow-sm rounded" id="editTicketCollection" >
        <div class="card-header">
            <div class="row">
                <div class="col-lg-6">
                    <span class="fcs-card-title h6">[% $user->gettext('Tickets zusammenführen') %]</span>

                </div>
                <div class="col-lg-6 text-end">
                    <input type="button" class="btn btn-outline-primary" id="btnMergeTickets" name="save" value="[% $user->gettext('Speichern') %]" onclick="submitMerge();">
                    <button type="button" class="btn btn-outline-danger" id="btnCloseMergeTickets" data-bs-dismiss="modal" aria-label="Close"><span aria-hidden="true">[% $user->gettext('Schlie&szlig;en')%]</span></button>
                </div>
            </div>
        </div>

        <div class="card-body">
            <div class="row" >
                <label class="control-label col-sm-12">[% $user->gettext('Bitte Ticket wählen, welches als Zielticket verwendet werden soll.') %]</label>
                <div class="form-group row mb-3"></div>
                <div class="col-md-12">
                    <div  class="form-group row mb-3">
                        <label class="control-label col-sm-2" for="MasterTicket">[% $user->gettext('Zielticket') %]</label>
                        <div class="col-sm-10">
                            <select class="form-control collectionSelect" name="MasterTicket" id="MasterTicket">
                                [% foreach from = $TicketList item = $ticket %]
                                    <option value ="[% $ticket.id %]">#[% $ticket.id %] - [% $user->gettext($ticket.ticketdescr) %]</option>
                                [% /foreach %]
                            </select>
                        </div>
                    </div>
                    <div  class="form-group  mb-3">
                        <label class="control-label" for="MasterTicket">[% $user->gettext('Kontakt(e) des Zieltickets benachrichtigen') %]? </label>
                        <input type="checkbox" id="InformContactNew" [% if $smarty.const.MAINCONTACTMERGETICKET == 1 %]checked="checked"[% /if %]>
                    </div>
                    <div  class="form-group  mb-3">
                        <label class="control-label " for="MasterTicket">[% $user->gettext('Kontakt(e) des Quelltickets benachrichtigen') %]? </label>
                        <input type="checkbox" id="InformContactOld" [% if $smarty.const.SOURCECONTACTMERGETICKET == 1 %]checked="checked"[% /if %]>
                    </div>
                    <div  class="form-group  mb-3">
                        <label class="control-label" for="MasterTicket">[% $user->gettext('Interessierten Kreis des Quelltickets benachrichtigen') %]? </label>
                        <input type="checkbox" id="InformInterestOld" [% if $smarty.const.SOURCEINTERESTMERGETICKET == 1 %]checked="checked"[% /if %]>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>

    function submitMerge()
    {
        values = JSON.parse(localStorage.getItem("checkboxes"));
        var TicketIDs = values.join();

        bootbox.confirm('Ausgew&auml;hlte Tickets wirklich zusammenführen?', function (result)
        {
            if (result)
            {
                $('#btnMergeTickets').prop('disabled', true);
                $('#btnCloseMergeTickets').prop('disabled', true);
                $.ajax({
                    url: "index.php?module=ticket&event=mergeTickets",
                    type: "POST",
                    data: {
                        tickets: TicketIDs,
                        masterticket: $('#MasterTicket').val(),
                        InformContactNew: $("#InformContactNew").is(':checked'),
                        InformContactOld: $("#InformContactOld").is(':checked'),
                        InformInterestOld: $("#InformInterestOld").is(':checked'),
                    }
                }).done(function () {
                    //console.log(result);
                    window.location = 'index.php?module=ticketlist';
                });
            }
        });
    }
</script>