<div class="card panel-info shadow-sm rounded">
    <div class="card-header">
        <div class="row">
            <div class="col-sm-8">
                <span class="fcs-card-title h2">[% $user->gettext('Textbausteine') %]</span>
            </div>
            <div class="col-sm-4 text-end">
                <input type="text" id="SearchValue" class="form-control" placeholder="[% $user->gettext('Suchen') %]"/>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        [% if $insertMode %]
                            <th>
                                [% $user->gettext('Aktion') %]
                            </th>
                        [% /if %]
                        <th>
                            [% $user->gettext('Rubrik') %]
                        </th>
                        <th>
                            [% $user->gettext('Titel') %]
                        </th>
                        <th>
                            [% $user->gettext('Inhalt') %]
                        </th>
                        <th>
                            [% $user->gettext('Erstellt von') %]
                        </th>
                        [% if !$insertMode %]
                            <th>
                                [% $user->gettext('Aktion') %]
                            </th>
                        [% /if %]
                    </tr>
                </thead>
                <tbody id="SnippetTable">
                    [% foreach from=$Snippets item=Snippet %]
                        <tr id="Snippet_[% $Snippet.ID %]">
                            [% if $insertMode %]
                                <td>
                                    <input type="button" class="btn btn-outline-secondary btn-sm" value="[% $user->gettext('Hinzufügen') %]" [% if !$fieldid %]onclick="parent.insertSnippet([% $Snippet.ID %]);"[% else %]onclick="parent.insertSnippet([% $Snippet.id %], '[% $fieldid %]');"[% /if %] />
                                </td>
                            [% /if %]
                            <td style="word-wrap: break-word;">[% $Snippet.Rubric %]</td>
                            <td style="word-wrap: break-word;">[% $Snippet.Title %]</td>
                            <td style="word-wrap: break-word;">[% $Snippet.Snippet %]</td>
                            <td>
                                [% $Snippet.CreateUserName %]
                            </td>
                            [% if $insertMode %]
                            [% else if $Snippet.createuserid == $user->UserID || $user->hasRight(225) %]
                                <td>
                                    <input type="button" class="btn btn-outline-secondary btn-sm" value="[% $user->gettext('Löschen') %]" onclick="deleteSnippet([% $Snippet.ID %])" />
                                </td>
                            [% /if %]
                            </td>
                        </tr>
                    [% /foreach %]
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    function deleteSnippet(id) {
        bootbox.confirm("[% $user->gettext('Textbaustein wirklich löschen?') %]", function (result) {
            if (result) {
                $.post("index.php?module=ticket&class=snippets&event=delete&id=" + id, function (data) {
                    if (data == 1) {
                        $("#Snippet_" + id).hide();
                    }
                });
            }
        })
    }

    $("#SearchValue").on("keyup", function ()
    {
        var value = $(this).val().toLowerCase();
        $("#SnippetTable tr").filter(function ()
        {
            $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
        });
    });
</script>
