<style>
    .type-icon{
        max-height: 16px;
    }

/* Inaktive Ticketvorlagen ausgrauen */
.tt_isNotActive {
    background-color: #f8f9fa !important; /* sehr helles Grau */
    color: #6c757d !important; /* Bootstrap Standard-Grau */
    opacity: 0.5;
}

/* Optional: Icons, Buttons und Links ebenfalls dezenter machen */
.tt_isNotActive i,
.tt_isNotActive a,
.tt_isNotActive button {
    color: #adb5bd !important;
}

/* Optional: Tooltip bei Hover */
.tt_isNotActive:hover::after {
    content: "[% $user->gettext('Diese Vorlage ist inaktiv') %]";
    position: absolute;
    left: 50%;
    transform: translateX(-50%);
    background: rgba(0, 0, 0, 0.75);
    color: #fff;
    font-size: 0.75rem;
    padding: 3px 6px;
    border-radius: 4px;
    white-space: nowrap;
    z-index: 10;
}

</style>
<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<!-- Component TicketTemplate begin -->
<form action="" method="post" name="hm" id="hm" enctype="multipart/form-data" class="form-inline form-label-left">
    <input type="hidden" name="pos" id="pos" value="[% $pos %]" />
    <input type="hidden" name="sort" id="sort" value="[% $sort %]" />
    <input type="hidden" name="sortorder" id="sortorder" value="[% $sortorder %]" />

    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <span class="fcs-card-title h2">[% $user->gettext('Ticketvorlagen') %] [% $oSLA->Description %]</span>       
        </div>
        <div class="card-body">
            <div class="card panel-info shadow-sm rounded">
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="form-group row mb-3">
                                <label class="control-label">[% $user->gettext('Tickettyp') %] &nbsp;  </label>
                                <select class="form-control" name="type" onchange="$('#hm').submit();">
                                    <option value="0"[% if !$selected_type %]selected="selected"[% /if %]>[% $user->gettext('Alle') %]</option>
                                    <option value="9999" [% if $selected_type == 9999 %]selected="selected"[% /if %]>[% $smarty.const.STANDARD_NAME %]</option>
                                    [% foreach from=$type_list item=$type %]
                                        <option value="[% $type.type_id %]" [% if $selected_type == $type.type_id %]selected="selected"[% /if %]>[% $type.type_name %]</option>
                                    [% /foreach %]
                                </select>
                            </div>

                        </div>
                        <div class="col-lg-4 text-end">
                            <div class="btn-group">                                                   
                                <a  class="btn btn-outline-primary" type="button" href="index.php?module=tickettemplate&event=newTemplate">
                                    [%$user->gettext('Neue Vorlage erstellen')%] 
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <span class="fcs-card-title h3">[% $user->gettext('Ticketvorlagen') %]</span>[% if $entries %]<span class="fcs-card-title"> - [% $entries %] [% $user->gettext('Vorlage(n)') %]</span>[% /if %]
                </div>
                <div class="card-body">

                    <div class="table-responsive">
                        <table class="table table-striped">                    
                            <thead>
                                <tr>
                                    <th class="no-sort">
                                        [% $user->gettext('') %]
                                    </th>
                                    <th title="[% $user->gettext('Reihenfolge in der Ticketauswahl') %]">
                                        [% $user->gettext('Reihenfolge') %]
                                    </th>                                       
                                    <th>
                                        [% $user->gettext('Kurzbeschreibung (Titel)') %]
                                    </th>                                 
                                    <th>
                                        [% $user->gettext('Gruppe') %]
                                    </th>
                                    <th >
                                        [% $user->gettext('Supporter') %]
                                    </th>
                                    <th >
                                        [% $user->gettext('Letzte Änderung am') %]
                                    </th>
                                    <th >
                                        [% $user->gettext('Letzte Änderung von') %]
                                    </th>
                                    <th >
                                        [% $user->gettext('1. Kategorie') %]
                                    </th>
                                    <th >
                                        [% $user->gettext('2. Kategorie') %]
                                    </th>
                                    <th >
                                        [% $user->gettext('Priorit&auml;t') %]
                                    </th>
                                    <th >
                                        [% $user->gettext('Tickettyp') %]
                                    </th>                                    
                                    <th>
                                        [% $user->gettext('Wiederholungen') %]
                                    </th>
                                    [% if $auth->Security->FormWizard == 1 && $showForms %]
                                        <th >
                                            [% $user->gettext('Formular') %]
                                        </th>
                                    [% /if %]
                                    <th>
                                        [% $user->gettext('Aktiv') %]
                                    </th>
                                    <th class="no-sort"></th>
                                </tr>
                            </thead>                            
                            <tbody>
                                [% foreach from=$templates item=template %]
                                    <tr id="activeRow_[% $template.tickettemplateid %]" class="[% if $template.isactive == 0%]tt_isNotActive[% /if %]">
                                        <td>
                                            [% if !$template.icon_path %]
                                                <img title="[% $smarty.const.STANDARD_NAME %]" src="index.php?module=upload&class=download&event=ShowImage&name=[% $smarty.const.STANDARD_ICON %]"  class="type-icon">
                                            [% else %]
                                                <img title="[% $template.type_name %]" src="index.php?module=upload&class=download&event=ShowImage&name=[% $template.icon_path %]"  class="type-icon">
                                            [% /if %]
                                        </td>
                                        <td>[% $template.ordernoinselectlist %]</td>
                                        <td nowrap="nowrap" onclick="document.location.href = 'index.php?module=tickettemplate&event=editTemplate&id=[% $template.tickettemplateid %]';" >[% $template.title %]</td>
                                        <td  onclick="document.location.href = 'index.php?module=tickettemplate&event=editTemplate&id=[% $template.tickettemplateid %]';" >[% $template.groups.groupnames %]</td>
                                        <td  onclick="document.location.href = 'index.php?module=tickettemplate&event=editTemplate&id=[% $template.tickettemplateid %]';" >[% $template.supporters.supporternames %]</td>
                                        <td  onclick="document.location.href = 'index.php?module=tickettemplate&event=editTemplate&id=[% $template.tickettemplateid %]';" data-sort="[% $template.updatedate %]">[% $template.updatedate|date_format:'d.m.Y H:i' %]</td>
                                        <td  onclick="document.location.href = 'index.php?module=tickettemplate&event=editTemplate&id=[% $template.tickettemplateid %]';">[% $template.updatename %]</td>
                                        
                                        <td  onclick="document.location.href = 'index.php?module=tickettemplate&event=editTemplate&id=[% $template.tickettemplateid %]';" >[% $template.category1name %]</td>
                                        <td  onclick="document.location.href = 'index.php?module=tickettemplate&event=editTemplate&id=[% $template.tickettemplateid %]';" >[% $template.category2name %]</td>
                                        <td nowrap="nowrap" onclick="document.location.href = 'index.php?module=tickettemplate&event=editTemplate&id=[% $template.tickettemplateid %]';" >[% $template.priodescr %]</td>
                                        <td>[% $template.type_name|default:"Ticket" %]</td>
                                        <td  onclick="document.location.href = 'index.php?module=tickettemplate&event=editTemplate&id=[% $template.tickettemplateid %]';" >[% $template.repeatdescr %] [% $template.timepoint %]</td>

                                        [% if $auth->Security->FormWizard == 1 && $showForms %]
                                            [% if $user->hasRight(810) || $user->hasRight(36) %]
                                                <td nowrap="nowrap"><a href="index.php?module=formwizard&event=editFormular&id=[% $template.formid %]" target="_blank">[% $template.formname %]</a></td>
                                                [% else %]
                                                <td nowrap="nowrap" onclick="document.location.href = 'index.php?module=tickettemplate&event=editTemplate&id=[% $template.tickettemplateid %]';" >[% $template.formname %]</td>
                                            [% /if %]
                                        [% /if %]

    <td class="text-center" 
        id="activeCol_[% $template.tickettemplateid %]" 
        data-active="[% $template.isactive %]" 
        data-order="[% $template.isactive %]">
        <i class="fa [% if $template.isactive %]fa-toggle-on[% else %]fa-toggle-off[% /if %]" 
           title="[% if $template.isactive %][% $user->gettext('Aktiv') %][% else %][% $user->gettext('Inaktiv') %][% /if %]"
           onclick="toggleActive([% $template.tickettemplateid %])">
        </i>
    </td>
                                        <td>
                                            <a href="index.php?module=tickettemplate&event=editTemplate&id=[% $template.tickettemplateid %]" class="btn btn-outline-secondary btn-sm" ><span class="fa fa-pencil" title="[% $user->gettext('Bearbeiten') %]"></span></a>

                                            <a href="index.php?module=tickettemplate&event=copyTemplate&tid=[% $template.tickettemplateid %]&list=true" class="btn btn-outline-secondary btn-sm" ><span class="fa fa-copy" title="[% $user->gettext('Kopieren') %]"></span></a>

                                            <a href="javascript:if (confirm('[% $user->gettext('Vorlage wirklich entfernen?') %]')){document.location.href = 'index.php?module=tickettemplate&event=remove&id=[% $template.tickettemplateid %]';}" class="btn btn-outline-secondary btn-sm" ><span class="fa fa-trash" title="[% $user->gettext('Löschen') %]"></span></a>                                        
                                        </td>
                                    </tr>
                                [% foreachelse %]
                                    <tr class="even">
                                        <td colspan="9">[% $user->gettext('Keine Vorlagen gefunden') %]</td>
                                    </tr>
                                [% /foreach %]
                            </tbody>

                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<script>

    $(document).ready(function () {


        $('.table').dataTable({
            stateSave: true,
            "sPaginationType": "full_numbers",
            "bLengthChange": true,
            "iDisplayLength": 10,
            "aaSorting": [[1, "desc"],[2, "asc"]],
            "oLanguage": {
                "sLengthMenu": "[% $user->gettext('Zeige _MENU_ Einträge') %]",
                "sZeroRecords": "[% $user->gettext('Keine Einträge gefunden') %]",
                "sInfo": "[% $user->gettext('Einträge _START_ bis _END_ (von _TOTAL_)') %]",
                "sInfoEmpty": " ",
                "sInfoFiltered": " [% $user->gettext('- gefiltert aus _MAX_ Einträgen') %]",
                "sSearch": "Filter",
                "oPaginate": {
                    "sFirst": "&lt;&lt;",
                    "sLast": "&gt;&gt;",
                    "sNext": "&gt;",
                    "sPrevious": "&lt;"
                },                
            },
            "columnDefs": [{
                    "targets": 'no-sort',
                    "orderable": false,
            }]
        });

    });

function toggleActive(templateID) {
    let col = $('#activeCol_' + templateID);
    let row = $('#activeRow_' + templateID);
    let icon = col.find('i');
    let isActive = parseInt(col.data('active')); // aktuellen Status holen

    $.post('index.php?module=tickettemplate&event=toggleActive', 
        { templateid: templateID, isActive: isActive }, 
        function (newStatus) {
            newStatus = parseInt(newStatus);

            // Icon und Tooltip anpassen
            if (newStatus === 1) {
                icon.removeClass('fa-toggle-off').addClass('fa-toggle-on');
                icon.attr('title', 'Aktiv');
                row.removeClass('tt_isNotActive');
            } else {
                icon.removeClass('fa-toggle-on').addClass('fa-toggle-off');
                icon.attr('title', 'Inaktiv');
                row.addClass('tt_isNotActive');
            }

            // data-Attribute updaten
            col.data('active', newStatus);
            col.attr('data-order', newStatus);
        }
    );
}


</script>
<!-- Component TicketTemplate end -->
