function shoutboxEvent(event) {
    event.preventDefault();
    if (event.keyCode == 13) {
        sendShoutboxMessage();
    }
}

function getShoutboxEntries(xmldoc) {
    makeHttpRequest("index.php?module=start&class=shoutbox", "showShoutboxEntries", true);
}

function sendShoutboxMessage() {
    var obj = document.getElementById("shoutmessage");
    if (obj && obj.value != "") {
        var message = obj.value;//escape(obj.value);
        obj.value = "";
        obj.focus();
        makeHttpRequest("index.php?module=start&class=shoutbox&add=" + message, "getShoutboxEntries", false);
    }
}

function askTheBot() {
    var obj = document.getElementById("shoutmessage");
    if (obj && obj.value != "") {
        var message = obj.value;//escape(obj.value);
        obj.value = "";
        obj.focus();
        makeHttpRequest("index.php?module=start&class=shoutbox&ask=" + message, "getShoutboxEntries", false);
    }
}

function showShoutboxEntries(xmldoc) {

    var entries = xmldoc.getElementsByTagName("entry");
//    console.log('showShoutboxEntries: ' + entries.length);
    var output = "";

    for (i = 0; i < entries.length; i++) {

        var evenodd = (i % 2) + 1;
        var entry = entries[i];
        var username = entry.childNodes[1].firstChild.data;
        var message = entry.childNodes[2].firstChild.data;
        var createdate = entry.childNodes[3].firstChild.data;
        var msgtype = entry.childNodes[4].firstChild.data;
        var askthebot = entry.childNodes[5].firstChild.data;
        var fromToday = entry.childNodes[6].firstChild.data;
//console.log(entry);
//console.log(askthebot);
//console.log(entry.childNodes[5].firstChild.data);

        var fromTodayClass = fromToday == 1 ? 'fromToday' : '';
        if (msgtype == "sent") {

            output += '<div class="col-sm-10">';
            if (askthebot > 0) {
                output += '<div class="panel panel-success">';
            } else {
                output += '<div class="panel panel-info">';
            }
            output += '<div class="card-header ' + fromTodayClass + '">' +
                    '<h3 class="card-title">' + username + ' <small>' + createdate + '</small></h3>' +
                    '</div>' +
                    '<div class="card-body">' +
                    message +
                    '</div>' +
                    '</div> </div>';

        } else {
            output += '<div class="col-sm-10 col-sm-offset-2">';
            if (askthebot > 0) {
                output += '<div class="card panel-success">';
            } else {
                output += '<div class="card panel-default">';
            }
            output += '<div class="card-header text-right  ' + fromTodayClass + '">' +
                    '<h3 class="card-title">' + username + ' <small>' + createdate + '</small></h3>' +
                    '</div>' +
                    '<div class="card-body">' +
                    message +
                    '</div>' +
                    '</div></div> ';
        }


    }
    output += '';
    var obj = document.getElementById("shoutbox");
    if (obj)
        obj.innerHTML = output;
}
