<div class="panel panel-fcs-border">
    <div class="panel-heading">
        <h2 class="panel-title-fcs">Liste der Zeitgesteuerten Workflows</h2>
    </div>

    <div class="panel-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr class="fields">
                        <th>
                            Workflow-Definition
                        </th>
                        <th>
                            Bezeichnung
                        </th>
                        <th>
                            Wiederholung
                        </th>
                        <th>
                            Nächste Ausführung
                        </th>
                        <th>
                            Aktion
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @if($ScheduledWorkflows->count() > 0 )
                        @foreach ($ScheduledWorkflows as $scheduledWorkflow)                    
                            <tr>
                                <td>
                                    {{ $scheduledWorkflow->WorkflowDefinition }}
                                </td>
                                <td>
                                    {{ $scheduledWorkflow->Name }}
                                </td>
                                <td>
                                    {{ TranslateRepeatMode($scheduledWorkflow->RepeatType) }}
                                </td>
                                <td>
                                    @if($scheduledWorkflow->Active)
                                        {{ \Carbon\Carbon::parse($scheduledWorkflow->NexExecution)->format('d.m.Y H:i') }}
                                    @else
                                        <i>deaktiviert</i>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('ToggleScheduledWorkflowDefinitionActive', $scheduledWorkflow->ScheduledWorkflowDefinitionID ) }}" class="btn btn-default">
                                        @if($scheduledWorkflow->Active)
                                        <span class="fa fa-remove" title="Deaktivieren"></span>
                                        @else
                                        <span class="fa fa-check" title="Aktivieren"></span>
                                        @endif
                                    </a>
                                    <a href="{{ route('DeleteScheduledWorkflow', $scheduledWorkflow->ScheduledWorkflowDefinitionID ) }}" onclick="return confirm('{{ $scheduledWorkflow->Name }} wirklich löschen?');" class="btn btn-default">
                                        <span class="fa fa-trash" title="Löschen"></span>
                                    </a>
                                    <a href="index.php?module=scheduledworkflow&event=EditScheduledWorkflow&ScheduledWorkflowDefinitionID={{ $scheduledWorkflow->ScheduledWorkflowDefinitionID }}" class="btn btn-default">
                                        <span class="fa fa-pencil" title="Bearbeiten"></span>
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr class="even">
                            <td>
                                Keine Einträge gefunden
                            </td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
</div>
