# Sofa/Eloquence

[![GitHub Tests Action Status](https://github.com/jarektkaczyk/eloquence-base/workflows/Tests/badge.svg)](https://github.com/jarektkaczyk/eloquence-base/actions?query=workflow%3Atests+branch%3Amaster) [![Coverage Status](https://coveralls.io/repos/jarektkaczyk/eloquence-base/badge.svg)](https://coveralls.io/r/jarektkaczyk/eloquence-base) [![Code Quality](https://scrutinizer-ci.com/g/jarektkaczyk/eloquence-base/badges/quality-score.png)](https://scrutinizer-ci.com/g/jarektkaczyk/eloquence-base) [![Downloads](https://poser.pugx.org/sofa/eloquence-base/downloads)](https://packagist.org/packages/sofa/eloquence-base) [![stable](https://poser.pugx.org/sofa/eloquence-base/v/stable.svg)](https://packagist.org/packages/sofa/eloquence-base)

Easy and flexible extensions for the [Eloquent ORM](https://laravel.com/docs/eloquent).

Currently available extensions:

1. [Base - Searchable](https://github.com/jarektkaczyk/eloquence-base) query - crazy-simple fulltext search through any related model 
1. [Validable](https://github.com/jarektkaczyk/eloquence-validable) - self-validating models
2. [Mappable](https://github.com/jarektkaczyk/eloquence-mappable) -map attributes to table fields and/or related models
3. [Metable](https://github.com/jarektkaczyk/eloquence-metable) - meta attributes made easy
4. [Mutable](https://github.com/jarektkaczyk/eloquence-mutable) - flexible attribute get/set mutators with quick setup 
5. [Mutator](https://github.com/jarektkaczyk/eloquence-mutable) - pipe-based mutating

## Installation

```bash
composer require sofa/eloquence-base
```

**Check the [documentation](https://github.com/jarektkaczyk/eloquence/wiki) for installation and usage info, [website](http://softonsofa.com/tag/eloquence/) for examples and [API reference](http://jarektkaczyk.github.io/eloquence-api)**

## Contribution

Shout out to all the Contributors!

All contributions are welcome, PRs must be **tested** and **PSR-2 compliant**.

To validate your builds before committing use the following composer command:
```bash
composer test
```
