<?php

/**
* FR_Mail
*
* @author Dirk Herbes <d.herbes@fair-computer.de>
* @copyright Dirk Herbes <d.herbes@fair-computer.de>
* @package Framework
* @filesource
*/

/**
* FR_Mail
*
* A common base class for our Modules.
*
* @author Dirk Herbes <d.herbes@fair-computer.de>
* @package Framework
*/
class FR_Presenter_mail extends FR_Presenter_localization
{
    protected $module = null;

    private $template = null;

    private $path = null;

    public $recipient = null;

    public $data = array();

    public function __construct(FR_Module $module)
    {
        parent::__construct($module);
        $this->path = FR_BASE_PATH.'/tpl/'.FR_TEMPLATE;
        $this->template = new Smarty();
        $this->template->left_delimiter = '[%';
        $this->template->right_delimiter = '%]';
        $this->template->template_dir = $this->path.'/'.'templates';
        $this->template->compile_dir = $this->path.'/'.'templates_c';
        $this->template->cache_dir = $this->path.'/'.'cache';
        $this->template->config_dir = $this->path.'/'.'config';
        $this->template->assign('countries', $module->user->countries);
    }


    public function display()
    {
    }


    public function send()
    {
        //$path = FR_BASE_PATH.'/modules/'.$this->module->moduleName.'/tpl';;
        //$tplFile = $this->module->tplMail;

        //$this->template->assign('user',$this->user);

        foreach ($this->data as $var => $val) {
          //  $this->template->assign($var, $val);
        }

        //$mail = $this->template->fetch($path.'/'.$tplFile);
        $subject = '';

        if (preg_match('#<subject>(.*)</subject>(.*)$#Uis', $mail, $match)) {
            $mail = $match[2];
            $subject = $match[1];
        }

//        echo $this->recipient.'<br>';
//        echo $subject.'<br>';
//        echo $mail.'<br>';
    }

    public function set($var, $val)
    {
        $this->data[$var] = $val;
    }

    public function __destruct()
    {
        parent::__destruct();
    }
}

?>