<?php

/**
 * Description of Event
 *
 * @author jkoepke
 */
class FR_Ticket_Ticket extends FR_Object_Web {

    private $TicketID = 0;
    private $TicketData = array();

    public function __construct($TicketID) {
        parent::__construct();

        $this->TicketID = $TicketID;
    }


    /**
     * Liefert die aktuellen Ticketdaten als Array.
     *
     * @param int $id TicketID
     * @return array Ticketdaten
     */
    public function getTicket($id) {

        if (is_array($id) && isset($id['id'])) {
            $id = (int) $id['id'];
        }

        if (isset($this->TicketData[$id])) {
            return $this->TicketData[$id];
        }

        if (defined('HMCOMPANY') && HMCOMPANY == 'HOLIDAY AUTOS') {
            $sql = sprintf('SELECT hm_Ticket.EscalationLevel, hm_Ticket.EscalationType, hm_Ticket.ID, hm_Ticket.Published, hm_Ticket.ContactID,
                            hm_Ticket.SupporterID, %s DesireDate, %s OnHold, hm_Ticket.TicketDescr, hm_Ticket.TicketPrioID, hm_Ticket.IsProblem,
                            hm_Ticket.TicketStatusID, hm_Ticket.TicketReferenzID, hm_Ticket.CategoryID1, hm_Ticket.CategoryID2,
                            %s CreateDate, %s EditDate, hm_Ticket.CreateUserID, %s UpdateDate, hm_Ticket.UpdateUserID, hm_Ticket.Expense,
                            hm_Contacts.name, hm_Users.name Supporter, hm_Users.sendEmail SupporterMailSend, hm_Users.email SupporterMail, hm_TicketPrio.Descr Priority,
                            hm_TicketStatus.Descr TStatus, Cat1.name Category1, Cat2.name Category2, %s DiffOnHold,
                            hm_Ticket.GroupID, hm_Groups.name Gruppe,  hm_Contacts.street, hm_Contacts.important, hm_Contacts.plz, hm_Contacts.city, hm_Contacts.state,
                            hm_Contacts.country, hm_Contacts.fax, hm_Contacts.phone, hm_Company.company, hm_Contacts.personalno, hm_Contacts.com_position,
                            hm_Contacts.misc, hm_Contacts.email, hm_Contacts.mobil, hm_Contacts.user_id ContactUseriD, hm_Contacts.building, hm_Contacts.room, hm_Contacts.floor,
                            UpdateUser.name UpdateUser, CreateUser.name CreateUser, hm_contacts.sendemails,
                            hm_Ticket.EscalationDate, hm_Ticket.TicketUserPrioID, hm_TicketUserPrio.Descr UserPriority, WFA.ActivityID, WFA.WFIID,
                            hm_Ticket.Archived
                        FROM
                            hm_Ticket
                            LEFT JOIN hm_Contacts ON hm_Ticket.ContactID = hm_Contacts.contact_id
                            LEFT JOIN hm_Company ON hm_Contacts.CompanyID = hm_Company.CompanyID
                            LEFT JOIN hm_Users ON hm_Ticket.SupporterID = hm_Users.user_id
                            LEFT JOIN hm_TicketPrio ON hm_Ticket.TicketPrioID = hm_TicketPrio.TicketPrioID
                            LEFT JOIN hm_TicketPrio hm_TicketUserPrio ON hm_Ticket.TicketUserPrioID = hm_TicketUserPrio.TicketPrioID
                            LEFT JOIN hm_TicketStatus ON hm_Ticket.TicketStatusID = hm_TicketStatus.ID
                            LEFT JOIN hm_Categories Cat1 ON hm_Ticket.CategoryID1 = Cat1.id
                            LEFT JOIN hm_Categories Cat2 ON hm_Ticket.CategoryID2 = Cat2.id
                            LEFT JOIN hm_Groups ON hm_Ticket.GroupID = hm_Groups.group_id
                            LEFT JOIN hm_Users CreateUser ON CreateUser.user_id = hm_Ticket.CreateUserID
                            LEFT JOIN hm_Users UpdateUser ON UpdateUser.user_id = hm_Ticket.UpdateUserID
                        WHERE
                            hm_Ticket.id = %u', $this->DB_CONVERT('hm_Ticket.TicketDesireDate'), $this->DB_CONVERT('hm_Ticket.onHold'), $this->DB_CONVERT('hm_Ticket.CreateDate'), $this->DB_CONVERT('hm_Ticket.EditDate'), $this->DB_CONVERT('hm_Ticket.UpdateDate'), $this->DB_DATEDIFF('minute', $this->DB_DATE('now()'), 'hm_Ticket.OnHold'), $id);
        } else {
            $sql = sprintf('SELECT %s SolutionDate, hm_Ticket.EscalationLevel, hm_Ticket.EscalationType, hm_Ticket.ID, hm_Ticket.Published, hm_Ticket.ContactID,
                            hm_Ticket.SupporterID, %s DesireDate, %s OnHold, hm_Ticket.TicketDescr, hm_Ticket.TicketPrioID, hm_Ticket.IsProblem,
                            hm_Ticket.TicketStatusID, hm_Ticket.TicketReferenzID, hm_Ticket.CategoryID1, hm_Ticket.CategoryID2,
                            %s CreateDate, %s EditDate, hm_Ticket.CreateUserID, %s UpdateDate, hm_Ticket.UpdateUserID, hm_Ticket.Expense,
                            hm_Contacts.name, hm_Users.name Supporter, hm_Users.sendEmail SupporterMailSend, hm_Users.email SupporterMail, hm_TicketPrio.Descr Priority,
                            hm_TicketStatus.Descr TStatus, Cat1.name Category1, Cat2.name Category2, %s DiffOnHold,
                            hm_Ticket.GroupID, hm_Groups.name Gruppe,  hm_Contacts.street, hm_Contacts.important, hm_Contacts.plz, hm_Contacts.city, hm_Contacts.state,
                            hm_Contacts.country, hm_Contacts.fax, hm_Contacts.phone, hm_Company.company, hm_Contacts.personalno, hm_Contacts.com_position,
                            hm_Contacts.misc, hm_Contacts.email, hm_Contacts.mobil, hm_Contacts.user_id ContactUseriD,
                            hm_Contacts.sendemails, hm_Contacts.building, hm_Contacts.room, hm_Contacts.floor,
                            UpdateUser.name UpdateUser, CreateUser.name CreateUser,
                            hm_Ticket.EscalationDate, hm_Ticket.InventoryNumber, WFA.ActivityID ActivityID, WFA.WFIID,
    						hm_Ticket.PrioAccepted, hm_Ticket.Archived, hm_Ticket.expExpense, hm_TicketBasket.TicketID TicketBasket
                        FROM
                            hm_Ticket
                            LEFT JOIN hm_WF_Activity WFA ON hm_Ticket.ID = WFA.TicketID
                            LEFT JOIN hm_Contacts ON hm_Ticket.ContactID = hm_Contacts.contact_id
                    LEFT JOIN hm_TicketSupporter ON hm_Ticket.ID = hm_TicketSupporter.TicketID AND hm_TicketSupporter.removeDate = 0
                    LEFT JOIN hm_TicketGroup ON hm_Ticket.ID = hm_TicketGroup.TicketID AND hm_TicketGroup.removeDate = 0
                    LEFT JOIN hm_Company ON hm_Company.CompanyID = hm_Contacts.CompanyID
                            LEFT JOIN hm_Users ON hm_Ticket.SupporterID = hm_Users.user_id
                            LEFT JOIN hm_TicketPrio ON hm_Ticket.TicketPrioID = hm_TicketPrio.TicketPrioID
                            LEFT JOIN hm_TicketStatus ON hm_Ticket.TicketStatusID = hm_TicketStatus.ID
                            LEFT JOIN hm_Categories Cat1 ON hm_Ticket.CategoryID1 = Cat1.id
                            LEFT JOIN hm_Categories Cat2 ON hm_Ticket.CategoryID2 = Cat2.id
                            LEFT JOIN hm_Groups ON hm_Ticket.GroupID = hm_Groups.group_id
                            LEFT JOIN hm_Users CreateUser ON CreateUser.user_id = hm_Ticket.CreateUserID
                            LEFT JOIN hm_Users UpdateUser ON UpdateUser.user_id = hm_Ticket.UpdateUserID
                            LEFT JOIN hm_TicketBasket ON hm_Ticket.ID = hm_TicketBasket.TicketID and hm_TicketBasket.UserID = %u
                        WHERE
                            hm_Ticket.id = %u', $this->DB_CONVERT('hm_Ticket.SolutionDate'), $this->DB_CONVERT('hm_Ticket.TicketDesireDate'), $this->DB_CONVERT('hm_Ticket.onHold'), $this->DB_CONVERT('hm_Ticket.CreateDate'), $this->DB_CONVERT('hm_Ticket.EditDate'), $this->DB_CONVERT('hm_Ticket.UpdateDate'), $this->DB_DATEDIFF('minute', $this->DB_DATE('now()'), 'hm_Ticket.OnHold'), $this->user->UserID, $id);
        }

        $row = $this->db->getRow($sql);

        if (DB::isError($row)) {
            return array();
        }

        $row['isproblem'] = (int) $row['isproblem'];
        $row['ticketbasket'] = ($row['ticketbasket'] > 0) ? true : false;
        $row['escalationdatestr'] = (($timestamp = strtotime($row['escalationdate'])) != -1) ? date('d.m.Y H:i', $timestamp) : '';

        $sql = sprintf('SELECT EventDescr FROM hm_TicketEvent WHERE TicketID = %u AND TicketStatusID IN (1,2,13) AND (Deleted = 0 OR Deleted IS NULL) ORDER BY id ASC', $id);
        $row2 = $this->db->getOne($sql);
        $row['longdescr'] = (DB::isError($row2)) ? '' : $row2;

        //MultiSupporter:
        $row['groups'] = $this->getTicketGroups($id);
        $row['supporters'] = $this->getTicketSupporters($id);
//Flag, ob der Benutzer
        $row['isusergroup'] = 1;

        if (ASSETDESK != 1) {
            $sql = 'SELECT id, name FROM hm_ContactStructure, hm_Structure WHERE structure_id = id ' .
                    'and contact_id = ' . (int) $row['contactid'];
            $resStruct = $this->db->query($sql);

            if (!DB::isError($resStruct)) {
                while ($temp = $resStruct->fetchrow(DB_FETCHMODE_ASSOC)) {
                    $row['contactstructure'][$temp['id']] = $temp['name'];
                }
            }
        }
        //$this->debugLog("TicketDaten: ", $row);
        $this->TicketData[$id] = $row;
        return $row;
    }


    private function getTicketGroups($TicketID) {
        $Groups = array();
        $GroupNames = array();
        if ($TicketID) {
            $sql = sprintf('SELECT G.name, G.group_id '
                    . 'FROM hm_TicketGroup TG '
                    . 'INNER JOIN hm_Groups G ON TG.GroupID = G.group_id '
                    . 'WHERE TG.TicketID = %u  AND TG.removeDate = 0 ORDER BY G.name', $TicketID);
            $res = $this->db->query($sql);
            if (!DB::isError($res)) {
                while ($row = $res->fetchrow(DB_FETCHMODE_ASSOC)) {
                    $Groups[] = $row;
                    $GroupNames[$row['group_id']] = $row['name'];
                    $GroupIDs[$row['group_id']] = $row['group_id'];
                    $isInGroup = ($isInGroup || $this->user->inGroup($row['group_id'])) ? TRUE : FALSE;
                }
            }
        }
        return array('groupnames' => $this->tools->FCS_Implode($GroupNames, ', '), 'groups' => $Groups, 'ids' => $GroupIDs, 'CurrentUserIsInGroup' => $isInGroup);
    }

    private function getTicketSupporters($TicketID) {
        $Supporters = array();
        $SupporterNames = array();
        if ($TicketID) {
            $sql = sprintf('SELECT U.user_id, U.name Supporter, U.sendEmail SupporterMailSend, U.email SupporterMail, C.phone '
                    . 'FROM hm_TicketSupporter TS '
                    . 'INNER JOIN hm_Users U ON TS.UserID = U.user_id '
                    . 'LEFT JOIN hm_Contacts C ON C.User_ID = U.user_id '
                    . 'WHERE TS.TicketID = %u  AND TS.removeDate = 0 ORDER BY U.name', $TicketID);

            $res = $this->db->query($sql);
            if (!DB::isError($res)) {
                while ($row = $res->fetchrow(DB_FETCHMODE_ASSOC)) {
                    $Supporters[] = $row;
                    $SupporterNames[$row['user_id']] = $row['supporter'];

                    $SupporterEmails[$row['user_id']] = ($row['supportermailsend'] == 1) ? sprintf('<a href="mailto:%s">%s</a>', $row['supportermail'], $row['supporter']) : $row['supporter'];

                    $SupporterPhone[$row['user_id']] = ('' != trim($row['phone'])) ? $row['phone'] : '-';

                    $SupporterIDs[$row['user_id']] = $row['user_id'];
                }
            }
        }
        return array(
            'supporternames' => $this->tools->FCS_Implode($SupporterNames, ', '),
            'supporteremails' => $this->tools->FCS_Implode($SupporterEmails, ', '),
            'supporterphone' => $this->tools->FCS_Implode($SupporterPhone, ', '),
            'supporters' => $Supporters, 'ids' => $SupporterIDs,
            'CurrentUserIsSupporter' => isset($SupporterIDs[$this->user->UserID]));
    }

}
