<?php

// no direct access
defined('_VALID_HM') or die('Restricted access');

class heinzelmannVersion {

    var $PRODUCT = 'Heinzelmann';
    var $RELEASE = '7.22.002';
    var $MAINVERSION = '7.22';
    var $FORMATEDVERSION = '';
    var $DEV_STATUS = 'release';
    var $DEV_LEVEL = '1';
    var $BUILD = '$Revision: 2664';
    var $CODENAME = 'Bootstrap';
    var $RELDATE = '2025-12-11'; //yyy-mm-dd
    var $RELTIME = '13:00';
    var $COPYRIGHT = '';
    var $URL = 'https://heinzelmann.fair-computer.de/';

    function __construct() {
        $tmp = explode('.', $this->RELEASE);
        $this->MAINVERSION = $tmp[0] . "." . $tmp[1];
        $this->FORMATEDVERSION = "<strong>" . $tmp[0] . "." . $tmp[1] . "</strong>";
        unset($tmp[0]);
        unset($tmp[1]);
        if (count($tmp)) {
            $this->FORMATEDVERSION .= "." . implode('.', $tmp);
        }
    }

    function getLongVersion() {
        return $this->PRODUCT . ' ' . $this->RELEASE . '.' . $this->DEV_LEVEL . ' '
                . $this->DEV_STATUS
                . ' [ ' . $this->CODENAME . ' ] ' . $this->RELDATE . ' '
                . $this->RELTIME . ' ' . $this->RELTZ;
    }

    function getShortVersion() {
        return $this->RELEASE . '.' . $this->DEV_LEVEL;
    }

    function getHelpVersion() {
        if ($this->RELEASE > '1.0') {
            return '.' . str_replace('.', '', $this->RELEASE);
        } else {
            return '';
        }
    }

}

$Version = new heinzelmannVersion();

if (defined('HMCOMPANY') && HMCOMPANY == 'HOLIDAY AUTOS') {
    $Version->PRODUCT = 'SAM';
}
?>
