<link rel="stylesheet" type="text/css" href="includes/js/select2/css/select2.min.css"/>
<script type="text/javascript" src="includes/js/select2/js/select2.full.min.js"></script>
<script type="text/javascript" src="includes/js/select2/js/i18n/de.js"></script>

<script type="text/javascript" src="includes/js/jquery-ui-timepicker-addon.js"></script>
<link rel="stylesheet" type="text/css" href="styles/[% $CSSTEMPLATE %]/css/jquery-ui-timepicker-addon.css" media="screen" />

<script src="https://cdn.jsdelivr.net/npm/chart.js@2.8.0"></script>


<style>
    .connectedCol{min-height: 200px;}
    .moveableItem{

        position: relative;
        min-height: 1px;
        padding-left: 15px;
        padding-right: 15px;

    }   

</style>

<div class='card panel-fcs-border shadow-sm'>
    <div class='card-header'>
        <div class="row">
            <div class="col-sm-8">
                <span class='fcs-card-title h3'>
                    [% if $Sprint.id %]
                        [% $user->gettext('Sprint') %]: [% $Sprint.name %] [% if $Sprint.active == 2 %]([% $user->gettext('GESCHLOSSEN')%])[% /if %]
                    [% else if !$NewSprint %]
                        [% $user->gettext('Neuen Sprint anlegen') %]
                    [% else %]
                        [% $user->gettext('Nächsten Sprint anlegen') %]
                    [% /if %] 
                </span> 
                [% if $Sprint.id %]
                    &nbsp; <b>[% $user->gettext('Gesamter Aufwand')%]: [% $Sprint.Tickets.sumExpenseOverAllHRA|default:"0" %]</b>
                [% /if %]
            </div>
            <div class="col-sm-4 text-end">
                [% if $Sprint.id && $user->hasRight(900) %]
                    [% if $Sprint.active == 0 || $Sprint.active == 3 %]
                        <span class="btn btn-outline-secondary" onclick="activate();">[% $user->gettext('Aktivieren') %]</span>
                    [% else if $Sprint.active == 1 %]
                        <span class="btn btn-outline-secondary" onclick="closeSprint([% $Sprint.id %]);">[% $user->gettext('Abschließen') %]</span>
                    [% /if %]
                [% /if %]                
                [% if $Sprint.active < 2 && $user->hasRight(900) %]<button class="btn btn-outline-secondary" onclick="submitSprintForm();">[% $user->gettext('Speichern') %]</button>[% /if %]
                [% if $Sprint.id %]
                    <a class='btn btn-outline-primary' href='index.php?module=backlog&event=edit&id=[% $Sprint.backlogid %]'>[% $user->gettext('Backlog')%] </a>
                    [%*
                    <a class='btn btn-outline-primary' href='index.php?module=backlog&class=sprint'>[% $user->gettext('Liste')%] </a>
                    *%]
                [% /if %]
                <a  class="btn btn-outline-primary" type="button" href="index.php?module=backlog&class=sprint">
                    [%$user->gettext('Liste')%]
                </a>
            </div>
        </div>
    </div>
    <div class="card-body">


        <div class="card panel-info shadow-sm rounded">

            <div class="card-body">
                <div class="row">
                    <div class="col-lg-12">
                        <form action = 'index.php?module=backlog&class=sprint&event=edit' method='post' class="[% if $Sprint.id %]form-inline[% else %]form-horizontal[% /if %] fcs-form-padding" id="formSprint">
                            <input type="hidden" id="SprintID" name="sprint[id]" value="[% $Sprint.id %]" />
                            <input type="hidden" name="sprint[backlogid]"  id="BacklogID" value="[% $Sprint.backlogid %]" />
                            <input type="hidden" name="save" value="1" />
                            [% if $NewSprint %]
                                <input type="hidden" name="sprint[active]" value="3" />
                            [% /if %]

                            <input type="hidden" class="form-control" id="sumExpenseOpen" class="sumExpense" value="[% $Sprint.Tickets.sumExpenseOpen %]">
                            <input type="hidden" class="form-control" id="sumExpenseInProgress" class="sumExpense"  value="[% $Sprint.Tickets.sumExpenseInProgress %]">
                            <input type="hidden" class="form-control" id="sumExpenseToDo"  class="sumExpense" value="[% $Sprint.Tickets.sumExpenseToDo %]">
                            <input type="hidden" class="form-control" id="sumExpenseClosed"  class="sumExpense" value="[% $Sprint.Tickets.sumExpenseClosed %]">
                            <input type="hidden" class="form-control" id="sumExpenseOverAll"  class="sumExpense" value="[% $Sprint.Tickets.sumExpenseOverAll %]">


                            [% if !$Sprint.backlogid && $Tools->FCS_Count($Backlogs) %]
                                <div class="form-group row mb-3">
                                    <label class="col-lg-4 control-label">[% $user->gettext('Backlog') %]</label>
                                    <div class="col-lg-8">
                                        <select name="sprint[backlogid]" class="form-control select2" id="BacklogSelect">
                                            [% foreach from=$Backlogs item=Backlog %]
                                                <option value="[% $Backlog.id %]">[% $Backlog.name %]</option>
                                            [% /foreach %]

                                        </select>
                                    </div>
                                </div>
                            [% /if %]

                            <div class="form-group row mb-3">
                                <label class="col-lg-4 control-label">Name</label>
                                <div class="col-lg-8">
                                    <input [% if $Sprint.active == 2 %] readonly="readonly"[% /if %] type="text" name="sprint[name]" class="form-control" value="[% $Sprint.name %]" placeholder="[% $user->gettext('Name des Sprints') %]"/>
                                </div>
                            </div>
                            <div class="form-group row mb-3">
                                <label class="col-lg-4 control-label">[% $user->gettext('Arbeitszeit pro Tag (Stunden)') %]</label>
                                <div class="col-lg-8">
                                    <input type="number" name="sprint[hoursperday]" min="0" max="24" [% if $Sprint.active == 2 %]readonly="readonly"[% /if %] id="HoursPerDay" class="form-control" value="[% $Sprint.hoursperday %]" oninput="CheckHoursPerDay(this)"/>
                                </div>
                            </div>   
                            [% if $Sprint.id %]
                                <div class="form-group row mb-3">
                                    <label class="col-lg-4 control-label">[% $user->gettext('Start') %]</label>
                                    <div class="col-lg-8">
                                        <input type="datetime" name="sprint[startdate]" id="StartDate" class="form-control datepicker" value="[% if $Sprint.startdate %][% $Sprint.startdate|date_format:"%d.%m.%Y" %][% /if %]" />
                                    </div>
                                </div>
                                <div class="form-group row mb-3">
                                    <label class="col-lg-4 control-label">[% $user->gettext('Ende') %]</label>
                                    <div class="col-lg-8">
                                        <input type="datetime" name="sprint[enddate]" id="EndDate" class="form-control datepicker" value="[% if $Sprint.enddate %][% $Sprint.enddate|date_format:"%d.%m.%Y" %][% /if %]" />
                                    </div>
                                </div>
                            [% /if %]
                            [% if $Sprint.id %]
                                <div class="form-group row mb-3">
                                    <label class="col-lg-4 control-label">[% $user->gettext('Verfügbare Stunden') %]</label>
                                    <div class="col-lg-8">
                                        <input type="int" name="sprint[availablehours]"  [% if $Sprint.active == 2 %]readonly="readonly"[% /if %] id="AvailableHours" class="form-control" value="[% $Sprint.availablehours %]" style="width: 50%"/>
                                    </div>
                                </div>    
                            [% /if %]
                            [%*
                            <div class="form-group row mb-3">
                            <label class="col-lg-4 control-label">Aktiv</label>
                            <div class="col-lg-8">
                            <input type="checkbox" name="active">
                            </div>
                            </div>
                            <div class="form-group row mb-3">
                            <label class="col-lg-4 control-label">[% $user->gettext('Ende') %]</label>
                            <div class="col-lg-8">
                            <input type="datetime" name="sprint[enddate]" id="EndDate" class="form-control datetimepicker" value="[% $Sprint.enddate|date_format:"%d.%m.%Y %H:%M" %]" />
                            </div>
                            </div>
                       

                            <div class="form-group row mb-3">
                            <label class="col-lg-4 control-label">Neues Sprint nach Ablauf</label>
                            <div class="col-lg-8">
                            <select class='form-control'>
                            [% foreach from=$sprints item=$sprint%]
                            <option value='[% $sprint.id %]'>[% $sprint.name %]</option>
                            [% /foreach %]
                            </select>
                            </div>
                            </div> 
                           
                            <div class="form-group row mb-3">
                            <label class="col-lg-4 control-label">Benutzer zufügen</label>
                            <div class="col-lg-8">
                            <select name="sprint[userids][]" id="addUserIDs" class="form-control select2" multiple/>
                            [% html_options options=$Users selected=$Sprint.selected_userids %]
                            </select>
                            </div>
                            </div>

                            <ul class="list-unstyled" id="Resources">
                            [% foreach from=$Sprint.userids item=User %]
                            <li id="UserID_[% $User.userid  %]">
                            <div class="form-group row mb-3">
                            <label class="col-lg-4 control-label">[% $User.name %]</label>
                            <div class="col-lg-6">
                            <div class="input-group">
                            <input type="number" min="1" max="100" name="AvailableQuote[[% $User.userid  %]]" class="form-control" id="AvailableQuote_[% $User.userid  %]" />
                            <div class="input-group-text">%</div>
                            </div>                                                                                                
                            </div>
                            <div class="col-lg-2">
                            <span class="btn btn-outline-secondary saveUser" data-userid="[% $User.userid  %]"  ><span class="fa fa-floppy-disk"></span></span>
                            <span class="btn btn-outline-secondary removeUser" data-userid="[% $User.userid  %]"  ><span class="fa fa-times"></span></span>
                            </div>                                        
                            </div>
                            </li>
                            [% /foreach %]
                            </ul>
                            *%]
                        </form>                            
                    </div>
                </div>
            </div>
        </div>




        [% if $Sprint.id && $LogData %]
            <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
                <div class="card panel-info shadow-sm rounded">

                    <div class="card-header" >
                        <a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            <div class="row">
                                <div class="col-lg-12">
                                    <h3 class="card-title">[% $user->gettext('Burn Down') %]</h3>
                                </div>
                            </div>                    
                        </a>                       
                    </div>  

                    <div id="collapseOne" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingOne">
                        <div class="card-body">
                            <canvas id="BurnDownChart" width="100%" height="500" ></canvas>
                        </div>
                    </div>
                </div>
            </div>
        [% /if %]
        [% if $Sprint.id %]

            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <h3 class="card-title">[% $user->gettext('Tickets') %]</h3>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="col-sm-4">
                            <div class="card panel-info shadow-sm rounded">
                                <div class="card-header">
                                    <h3 class="card-title">[% $user->gettext('Offen') %] <span id="HRsumExpenseOpen"></span></h3>
                                </div>
                                <div class="card-body connectedCol" style="overflow-x:scroll;" id="OpenTicketPanel" data-tableid="1">
                                    <table class="table table-condensed" id="OpenTicketTable">
                                        <thead>
                                            <tr>
                                                <th>[% $user->gettext('Typ') %]</th>
                                                <th>[% $user->gettext('ID') %]</th>
                                                <th>[% $user->gettext('Titel') %]</th>
                                                <th>[% $user->gettext('Projekt') %]</th>
                                                <th>[% $user->gettext('Supporter') %]</th>                                                
                                                <th>[% $user->gettext('Aufwand') %]</th> 
                                                    [% if $user->hasRight(900)%]
                                                    <th></th> 
                                                    [% /if %]
                                            </tr>
                                        </thead>
                                        <tbody class="">
                                            [% foreach $Sprint.SprintTicketsByTag.1 as $Tag  => $data %]
                                                <tr id ="T_[% $Tag|md5 %]" class="draggable_tr well">                                                
                                                    <td colspan="2" onclick="toggleRow('[% $Tag|md5 %]_Sprint1');">
                                                        <span class="Tag_[% $Tag|md5 %]_Sprint1" style="display:none;"><span class="fa fa-maximize"></span></span>
                                                        <span class="Tag_[% $Tag|md5 %]_Sprint1"><span class="fa fa-chevron-down"></span></span> 

                                                        <span class="fa fa-tag"></span>
                                                    </td>

                                                    <td colspan="3"  style="text-align: center;">[% $Tag|default:$user->gettext('Ohne Tag') %] ([% $Tools->FCS_Count($data.tickets) %]) </td>
                                                    <td>[% $data.sumExpenseOpenHRA|default:0 %] </td>
                                                    [% if $user->hasRight(900)%]
                                                        <td>

                                                        </td>
                                                    [% /if %]                                                
                                                </tr>                                           

                                                [% foreach from=$data.tickets item=Ticket %]
                                                    <tr class="OpenTicketRow moveableItem Tag_[% $Tag|md5 %]_Sprint1" data-ticketid="[% $Ticket.id %]" id="Ticket_[% $Ticket.id %]" data-expexpense="[% $Ticket.expexpense %]" data-ticketid="[% $Ticket.id %]">
                                                        <td class="handle"><img style="max-height: 16px;" title="[% $Ticket.type_name %]" src="index.php?module=upload&class=download&event=ShowImage&name=[% $Ticket.icon_path %]"  class="type-icon"></td>
                                                        <td><a href="index.php?module=ticket&event=show&id=[% $Ticket.id %]" target="_blank">[% $Ticket.id %]</a></td>
                                                        <td>[% $Ticket.ticketdescr %]</td>
                                                        <td>[% $Ticket.projectname %]</td>
                                                        <td>
                                                            [% foreach from=$Ticket.ticketsupporter.supporters item=Supporter %]
                                                                <span class="badged">[% $Supporter.supporter %]</span>
                                                            [% /foreach %]
                                                        </td>
                                                        <td>[% $Ticket.ExpenseData.expexpense_human %]</td>
                                                        [% if $user->hasRight(900)%]
                                                            <td><a href="javascript:removeTicketFromSprint([% $Ticket.id %])" class="btn btn-outline-secondary btn-sm"><span class="fa fa-trash"></span></a></td>
                                                                [% /if %]
                                                    </tr>
                                                [% foreachelse %]
                                                    <tr>
                                                        <td colspan="6">[% $user->gettext('Tickets per Drag`nDrop zuordnen') %]</td>
                                                    </tr>
                                                [% /foreach %]
                                            [% /foreach %]
                                        </tbody>
                                    </table>
                                </div>
                            </div>                                             
                        </div>
                        <div class="col-sm-4">
                            <div class="card panel-info shadow-sm rounded">
                                <div class="card-header">
                                    <h3 class="card-title">[% $user->gettext('In Arbeit') %] <span id="HRsumExpenseInProgress"></span></h3>
                                </div>
                                <div class="card-body connectedCol" id="InProgressTicketPanel" style="overflow-x:scroll;" data-tableid="2">
                                    <table class="table table-condensed" id="InProgressTicketTable">
                                        <thead>
                                            <tr>
                                                <th>[% $user->gettext('Typ') %]</th>
                                                <th>[% $user->gettext('ID') %]</th>
                                                <th>[% $user->gettext('Titel') %]</th>
                                                <th>[% $user->gettext('Projekt') %]</th>
                                                <th>[% $user->gettext('Supporter') %]</th>                                                
                                                <th>[% $user->gettext('Aufwand') %]</th>
                                                    [% if $user->hasRight(900)%]
                                                    <th></th>
                                                    [% /if %]
                                            </tr>
                                        </thead>
                                        <tbody id="ClosedTicketTableBody">
                                            [% foreach $Sprint.SprintTicketsByTag.2 as $Tag  => $data %]
                                                <tr id ="T_[% $Tag|md5 %]" class="draggable_tr well">                                                
                                                    <td colspan="2" onclick="toggleRow('[% $Tag|md5 %]_Sprint2');">
                                                        <span class="Tag_[% $Tag|md5 %]_Sprint2" style="display:none;"><span class="fa fa-maximize"></span></span>
                                                        <span class="Tag_[% $Tag|md5 %]_Sprint2"><span class="fa fa-chevron-down"></span></span> 

                                                        <span class="fa fa-tag"></span>
                                                    </td>

                                                    <td colspan="3"  style="text-align: center;">[% $Tag|default:$user->gettext('Ohne Tag') %] ([% $Tools->FCS_Count($data.tickets) %]) </td>
                                                    <td>[% $data.sumExpenseInProgressHRA|default:0 %] </td>
                                                    [% if $user->hasRight(900)%]
                                                        <td>

                                                        </td>
                                                    [% /if %]                                                
                                                </tr>                                           

                                                [% foreach from=$data.tickets item=Ticket %]
                                                    <tr class="InProgressTicketRow  moveableItem Tag_[% $Tag|md5 %]_Sprint2" data-ticketid="[% $Ticket.id %]" id="Ticket_[% $Ticket.id %]" data-expexpense="[% $Ticket.expexpense %]" data-ticketid="[% $Ticket.id %]">
                                                        <td class="handle"><img style="max-height: 16px;" title="[% $Ticket.type_name %]" src="index.php?module=upload&class=download&event=ShowImage&name=[% $Ticket.icon_path %]"  class="type-icon"></td>
                                                        <td><a href="index.php?module=ticket&event=show&id=[% $Ticket.id %]" target="_blank">[% $Ticket.id %]</a></td>
                                                        <td>[% $Ticket.ticketdescr %]</td>
                                                        <td>[% $Ticket.projectname %]</td>
                                                        <td>
                                                            [% foreach from=$Ticket.ticketsupporter.supporters item=Supporter %]
                                                                <span class="badged">[% $Supporter.supporter %]</span>
                                                            [% /foreach %]
                                                        </td>
                                                        <td>[% $Ticket.ExpenseData.expexpense_human %]</td>
                                                        [% if $user->hasRight(900)%]
                                                            <td><a href="javascript:removeTicketFromSprint([% $Ticket.id %])" class="btn btn-outline-secondary btn-sm"><span class="fa fa-trash"></span></a></td>
                                                                [% /if %]
                                                    </tr>                                          
                                                [% /foreach %]
                                            [% /foreach %]
                                        </tbody>
                                    </table>
                                </div>
                            </div>                                             
                        </div>
                        <div class="col-sm-4">
                            <div class="card panel-info shadow-sm rounded">
                                <div class="card-header">
                                    <h3 class="card-title">[% $user->gettext('Erledigt') %]  <span id="HRsumExpenseClosed"></span></h3>
                                </div>
                                <div class="card-body connectedCol" style="overflow-x:scroll;" id="ClosedTicketPanel"  data-tableid="3">
                                    <table class="table table-condensed" id="ClosedTicketTable">
                                        <thead>
                                            <tr>
                                                <th>[% $user->gettext('Typ') %]</th>
                                                <th>[% $user->gettext('ID') %]</th>
                                                <th>[% $user->gettext('Titel') %]</th>
                                                <th>[% $user->gettext('Projekt') %]</th>
                                                <th>[% $user->gettext('Supporter') %]</th>                                                
                                                <th>[% $user->gettext('Aufwand') %]</th>
                                                    [% if $user->hasRight(900)%]
                                                    <th></th>
                                                    [% /if %]
                                            </tr>
                                        </thead>
                                        <tbody id="ClosedTicketTableBody" >
                                            [% foreach $Sprint.SprintTicketsByTag.3 as $Tag  => $data %]
                                                <tr id ="T_[% $Tag|md5 %]" class="draggable_tr well">                                                
                                                    <td colspan="2" onclick="toggleRow('[% $Tag|md5 %]_Sprint3');">
                                                        <span class="Tag_[% $Tag|md5 %]_Sprint3" style="display:none;"><span class="fa fa-floppy-maximize"></span></span>
                                                        <span class="Tag_[% $Tag|md5 %]_Sprint3"><span class="fa fa-chevron-down"></span></span> 

                                                        <span class="fa fa-tag"></span>
                                                    </td>

                                                    <td colspan="3"  style="text-align: center;">[% $Tag|default:$user->gettext('Ohne Tag') %] ([% $Tools->FCS_Count($data.tickets) %]) </td>
                                                    <td>[% $data.sumExpenseClosedHRA|default:0 %] </td>
                                                    [% if $user->hasRight(900)%]
                                                        <td>

                                                        </td>
                                                    [% /if %]                                                
                                                </tr>                                           

                                                [% foreach from=$data.tickets item=Ticket %]
                                                    <tr class="ClosedTicketRow moveableItem handle Tag_[% $Tag|md5 %]_Sprint3" data-ticketid="[% $Ticket.id %]" id="Ticket_[% $Ticket.id %]">
                                                        <td><img style="max-height: 16px;" title="[% $Ticket.type_name %]" src="index.php?module=upload&class=download&event=ShowImage&name=[% $Ticket.icon_path %]"  class="type-icon"></td>
                                                        <td><a href="index.php?module=ticket&event=show&id=[% $Ticket.id %]" target="_blank">[% $Ticket.id %]</a></td>
                                                        <td>[% $Ticket.ticketdescr %]</td>
                                                        <td>[% $Ticket.projectname %]</td>
                                                        <td>
                                                            [% foreach from=$Ticket.ticketsupporter.supporters item=Supporter %]
                                                                <span class="badged">[% $Supporter.supporter %]</span>
                                                            [% /foreach %]
                                                        </td>
                                                        <td>
                                                            [% if $Ticket.ExpenseData.expense %]                                     

                                                                [% $Ticket.ExpenseData.expense_human %]

                                                                (<span [% if $Ticket.ExpenseData.expense_percent <= 100 %] style="color:green;"[% else %] style="color:red;"[% /if %]>
                                                                    [% $Ticket.ExpenseData.expense_percent %]% </span>[% $user->gettext('von') %] [% $Ticket.ExpenseData.expexpense_human %])
                                                                [% else %]
                                                                    [% $Ticket.expexpense %]
                                                                [% /if %]
                                                        </td>
                                                        [% if $user->hasRight(900)%]
                                                            <td><a href="javascript:removeTicketFromSprint([% $Ticket.id %])" class="btn btn-outline-secondary btn-sm"><span class="fa fa-trash"></span></a></td>
                                                                [% /if %]
                                                    </tr>
                                                [% /foreach %]
                                            [% /foreach %]
                                        </tbody>
                                    </table>
                                </div>
                            </div>                                             
                        </div>
                    </div>                                    

                </div>
            </div> 

        </div>
    [% /if %]
</div>




<script>
    function CheckHoursPerDay(input)
    {
        if(input.value < 0)
            input.value = 0;
        if(input.value > 24)
            input.value = 24;
    }

    $('#addUserIDs').select2({theme: 'bootstrap-5'});

    $('#addUserIDs').on('select2:selecting', function (e) {
        console.log('Selecting: ', e.params.args.data);
        addToSprint(e.params.args.data.id, e.params.args.data.text);
    });


    $(".datepicker").datepicker();
    [% if $Sprint.active == 1 && $user->hasRight(26) %]

    $(".datepicker").datepicker();

    $(function () {
        $(" .connectedCol").sortable({
            connectWith: ".connectedCol",
            items: ".moveableItem",
            handle: ".handle",
            placeholder: "ui-state-highlight",
            update: function (e) {

            },
            start: function (e) {

            },
            stop: function (event, ui) {
                //                addToTable(event);
            },
            receive: function (event, ui) {
                console.log("[" + this.id + "] received [" + ui.item.html() + "] from [" + ui.sender.attr("id") + "]");
                console.log("Target Data ID " + $(this).data('tableid'));
                console.log("ui.item.expexpense " + $(ui.item).data('expexpense'));
                console.log("ui.item.TicketID " + $(ui.item).data('ticketid'));
                $('#' + this.id).find('tbody').append(ui.item);

                TargetDataID = $(this).data('tableid');
                DraggedExpense = $(ui.item).data('expexpense');
                MovedTicketID = $(ui.item).data('ticketid');

                if (TargetDataID == 3) {
                    bootbox.confirm("[% $user->gettext('Das Ticket erhält dadurch den Status ERLEDIGT. Soll die Einstufung vorgenommen werden?') %]", function (result) {
                        if (result) {

                            $.post("index.php?module=backlog&class=sprint&event=moveTicketSprintStatus", {'sprintid': $("#SprintID").val(), "tid": MovedTicketID, 'inStatus': TargetDataID}, function (data) {

                                if (TargetDataID == 3) {


                                    sumExpenseClosed = parseInt($('#sumExpenseClosed').val(), 10);
                                    sumExpenseClosed += DraggedExpense;
                                    if (sumExpenseClosed < 0) {
                                        sumExpenseClosed = 0;
                                    }
                                    $('#sumExpenseClosed').val(sumExpenseClosed);

                                    sumExpenseInProgress = parseInt($('#sumExpenseInProgress').val(), 10);
                                    sumExpenseInProgress -= DraggedExpense;
                                    $('#sumExpenseInProgress').val(sumExpenseInProgress);
                                }
                                refreshTimes();
                            })
                        } else {
                            //Bringt das Element zurück zur Ursprungsposition
                            $(" .connectedCol").sortable("cancel");
                        }

                    })
                } else {
                    $.post("index.php?module=backlog&class=sprint&event=moveTicketSprintStatus", {'sprintid': $("#SprintID").val(), "tid": MovedTicketID, 'inStatus': TargetDataID}, function (data) {

                        if (TargetDataID == 2) {
                            sumExpenseOpen = parseInt($('#sumExpenseOpen').val(), 10);
                            sumExpenseOpen -= DraggedExpense;
                            if (sumExpenseOpen < 0) {
                                sumExpenseOpen = 0;
                            }
                            $('#sumExpenseOpen').val(sumExpenseOpen);

                            sumExpenseInProgress = parseInt($('#sumExpenseInProgress').val(), 10);
                            sumExpenseInProgress += DraggedExpense;
                            $('#sumExpenseInProgress').val(sumExpenseInProgress);
                        }
                        if (TargetDataID == 1) {
                            sumExpenseInProgress = parseInt($('#sumExpenseInProgress').val(), 10);
                            sumExpenseInProgress -= DraggedExpense;
                            if (sumExpenseInProgress < 0) {
                                sumExpenseInProgress = 0;
                            }
                            $('#sumExpenseInProgress').val(sumExpenseInProgress);

                            sumExpenseOpen = parseInt($('#sumExpenseOpen').val(), 10);
                            sumExpenseOpen += DraggedExpense;
                            $('#sumExpenseOpen').val(sumExpenseOpen);
                        }
                        refreshTimes();
                    })

                }

            }
        })
    });
    [% /if %]

    refreshTimes();

    function refreshTimes() {

        url = "index.php?module=backlog&class=sprint&event=getHRTime&id=[% $Sprint.id|default:"0"%]";
        $.get(url, {'time': parseInt($('#sumExpenseOpen').val(), 10)}, function (data) {
            if (data != '') {
                $('#HRsumExpenseOpen').html("(" + data + ")");
                $('#HeaderOpenHRA').html(data);
            } else {
                $('#HRsumExpenseOpen').html("");
                $('#HeaderOpenHRA').html(0);
            }
        });
        $.get(url, {'time': parseInt($('#sumExpenseInProgress').val(), 10)}, function (data) {
            if (data != '') {
                $('#HRsumExpenseInProgress').html("(" + data + ")");
                $('#HeaderInProcessHRA').html(data);
            } else {
                $('#HRsumExpenseInProgress').html("");
                $('#HeaderInProcessHRA').html(0);
            }
        });
        $.get(url, {'time': parseInt($('#sumExpenseClosed').val(), 10)}, function (data) {
            if (data != '') {
                $('#HRsumExpenseClosed').html("(" + data + ")");
                $('#HeaderClosedHRA').html(data);
            } else {
                $('#HRsumExpenseClosed, #HeaderClosedHRA').html("");
                $('#HeaderClosedHRA').html(0);
            }
        });
    }



    function addToTable(e) {
        console.log("addToTable e " + e);
        console.log("addToTable ID " + $(this).attr("id"));
    }

    function savePosition(id) {
        console.log("SavePosition ID " + id);
    }

    function addToSprint(UserID, Username) {


        markup = '<li id="UserID_' + UserID + '">';
        markup += '<div class="form-group row mb-3">';
        markup += '<label class="col-lg-4 control-label">' + Username + '</label>';
        markup += '<div class="col-lg-6">';
        markup += '<div class="input-group">';
        markup += '<input type="number" name="AvailableQuote[' + UserID + ']" class="form-control" id="AvailableQuote_' + UserID + '" />';
        markup += '<div class="input-group-text">%</div></div>';
        markup += '</div>';
        markup += '<div class="col-lg-2">';
        markup += '<span class="btn btn-outline-secondary saveUser" data-userid="' + UserID + '"  ><span class="fa fa-floppy-disk"></span></span>';
        markup += '<span class="btn btn-outline-secondary removeUser" data-userid="' + UserID + '"  ><span class="fa fa-times"></span></span>';
        markup += '</div>';
        markup += '</div>';
        markup += ' </li>';
        $('#Resources').append(markup);


        $.post("index.php?module=backlog&class=sprint&event=addUser&sprintid=" + $("#SprintID").val() + "&userid=" + UserID, function (data) {

            console.log("Zugefügt: " + data);
        }).done(function (data) {

            if (data.error) {

            } else {

            }

        })
    }

    $('#addUserIDs').on('select2:unselecting', function (e) {
        removeUserID(e.params.args.data.id);
    });

    $(".removeUser").on('click', function (e) {
        UserID = $(this).data('userid');
        removeUserID(UserID);
    })


    function removeUserID(UserID) {
        $('#UserID_' + UserID).remove();
        $("#addUserIDs option[value=" + UserID + "]").prop("selected", false).parent().trigger("change");
        $.post("index.php?module=backlog&class=sprint&event=removeUser&sprintid=" + $("#SprintID").val() + "&userid=" + UserID, function (data) {

            console.log("Entfernt: " + data);
        })
    }


    $('.datetimepicker').on('change', function () {
        StartDate = $('#StartDate').val();
        EndDate = $('#EndDate').val();
        Zeit = "dddd";

        console.log("Von " + StartDate + " bis " + EndDate + " => " + Zeit);
    })

    [% if $Sprint.id %]

    function removeTicketFromSprint(TicketID) {

        bootbox.confirm("[% $user->gettext('Ticket wirklich aus Sprint entfernen?') %]", function (result) {
            if (result) {
                $.post('index.php?module=backlog&class=sprint&event=removeTicket', {sprintid:[% $Sprint.id %], ticketid: TicketID}, function (data) {
                    var data = JSON.parse(data);
                    if (data.error) {
                        noty({
                            text: data.messages[0],
                            type: 'error',
                            timeout: notifyTimeout
                        });
                    } else {
                        window.location = 'index.php?module=backlog&class=sprint&event=edit&id=[% $Sprint.id %]';
                    }
                    //w
                });
            }
        })
    }

        [% if $LogData %]

    var ctx = document.getElementById('BurnDownChart');
    ctx.height = 300;

    var config = {
        type: 'line', //-> mit type scatter stehen die Punkte an der korrekten Stelle. 
        data: {
            labels: [% $LogData.Labels %], //-> ohne Label werden die Linien zumindes bis zum ende durchgezogen...
            datasets: [
                {
                    label: 'SOLL (Geplant)',
                    fill: false,
                    stepped: false,
                    backgroundColor: 'rgba(128,0,128, 1)',
                    borderColor: 'rgba(128,0,128, 1)',
                    data: [% $LogData.DatasetPlaned %],
                    yAxisID: 'yAufwand'
                },
                {
                    label: 'IST',
                    fill: false,
                    stepped: false,
                    backgroundColor: 'rgba(255,0,0, 1)',
                    borderColor: 'rgba(255,0,0, 1)',
                    data: [% $LogData.DatasetIST %],
                    yAxisID: 'yAufwand'

                },
                {
                    label: 'SOLL (Tickets)',
                    hidden: true,
                    fill: false,
                    stepped: true,
                    backgroundColor: 'rgba(0,0,255, 1)',
                    borderColor: 'rgba(0,0,255, 1)',
                    steppedLine: false,
                    data: [% $LogData.DatasetSOLL %],
                    yAxisID: 'yAufwand'
                },
                {
                    label: 'Tickets',
                    type: 'scatter',
                    hidden: true,
                    fill: false,
                    stepped: true,
                    backgroundColor: 'rgba(105,105,105, 1)',
                    borderColor: 'rgba(105,105,105, 1)',
                    data: [% $LogData.DatasetTicketsOpen %],
                    yAxisID: 'yTickets'
                },
                {
                    label: 'Tickets (Gesamt)',
                    type: 'scatter',
                    hidden: true,
                    fill: false,
                    stepped: true,
                    backgroundColor: 'rgba(155,155,155, 1)',
                    borderColor: 'rgba(155,155,155, 1)',
                    data: [% $LogData.DatasetTicketsTotal %],
                    yAxisID: 'yTickets'
                }

            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                xAxes: [{
                        display: true,
                        scaleLabel: {
                            display: true,
                            labelString: 'Zeit'
                        },
                        ticks: {
                            //                            beginAtZero: true,
                            //                            sampleSize: 8
                            // Include a dollar sign in the ticks

                            callback: function (value, index, values) {
                                return 'Tag ' + index;


                            }

                        }
                    }],
                yAxes: [{
                        id: 'yAufwand',
                        display: true,
                        scaleLabel: {
                            display: true,
                            labelString: 'Aufwand'
                        },
                        ticks: {
                            beginAtZero: true,
                            //                            sampleSize: 8
                        }
                    },
                    {
                        id: 'yTickets',
                        display: true,
                        position: 'right',
                        gridLines: {
                            drawOnChartArea: false, // only want the grid lines for one axis to show up
                        },
                        scaleLabel: {
                            display: true,
                            labelString: 'Tickets'
                        },
                        ticks: {
                            beginAtZero: true,
                            //                            sampleSize: 8
                            callback: function (value) {
                                if (value % 1 === 0) {
                                    return value;
                                }
                            }
                        }
                    }
                ]
            },
            animation: {
                duration: 0 // general animation time
            }
        }
    };

    //var chart = new Chart(ctx, config);

    $('#collapseOne').on('shown.bs.collapse', function () {
        chart = new Chart(ctx, config);
    })

    $('#collapseOne').on('hide.bs.collapse', function () {
        chart.destroy();
    })

        [% /if %]

    function activate() {
        $.post('index.php?module=backlog&class=sprint&event=activeSprint', {id: $("#SprintID").val(), startdate: $("#StartDate").val(), enddate: $('#EndDate').val(), hoursperday: $("#HoursPerDay").val()}, function (data) {
            console.log(data);
            var data = JSON.parse(data);
            if (!data.error) {
                location.reload();
            } else {
                noty({
                    text: data.messages[0],
                    type: 'error',
                    timeout: notifyTimeout
                });
            }
        });
    }
    [% /if %]


    function closeSprint(id) {
        bootbox.confirm("[% $user->gettext('Wollen Sie den aktuellen Sprint wirklich abschließen?') %]", function (result) {
            if (result) {
                window.location = "index.php?module=backlog&class=sprint&event=closeSprint&id=" + id;
            }
        })
    }

    function submitSprintForm() {

        $.post('index.php?module=backlog&event=hasPlannedSprint', {id: $('#BacklogSelect').val()}, function (data) {
            console.log(data);
            if (parseInt(data) === 1) {
                noty({
                    text: '[% $user->gettext('Sprint ist nicht erstellbar, da das gewählte Backlog schon einen geplanten Sprint hat')%]',
                    type: 'error',
                    timeout: notifyTimeout
                });
            } else {
                $('#formSprint').submit();
            }
        })
    }
    function toggleRow(TagHash) {
        $('.Tag_' + TagHash).toggle();
    }

    $(document).ready(function () {
        var highest = null;
        var hi = 0;
        $(".connectedCol").each(function () {
            var h = $(this).height();
            if (h > hi) {
                hi = h;
                highest = $(this);
            }
        });
        $(".connectedCol").each(function () {
            $(this).height(hi);
        });
        console.log(hi);
    });


</script>
