<!-- Nav tabs -->
<ul id="AssetInfoTab[% $DeviceID %]" class="nav nav-tabs" role="tablist">
    <li role="presentation"><a class="nav-link active" href="#commonAssetData_[% $DeviceID %]" aria-controls="commonAssetData_[% $DeviceID %]" role="tab" data-bs-toggle="tab">[% $user->gettext('Basisdaten') %]</a></li>
        [% if $Device['Bios'] %]
        <li role="presentation"><a class="nav-link" href="#biosAssetData_[% $DeviceID %]" aria-controls="biosAssetData_[% $DeviceID %]" role="tab" data-bs-toggle="tab">[% $user->gettext('BIOS & OS') %]</a></li>
        [% /if %]
        [% if $Device['Commercial'] %]
        <li role="presentation"><a class="nav-link" href="#commercialAssetData_[% $DeviceID %]" aria-controls="commercialAssetData_[% $DeviceID %]" role="tab" data-bs-toggle="tab">[% $user->gettext('Kommerzielle Daten') %]</a></li>
        [% /if %]

    [% if $Device['Software']['Software'] %]
        <li role="presentation"><a class="nav-link" href="#softwareAssetData_[% $DeviceID %]" aria-controls="softwareAssetData_[% $DeviceID %]" role="tab" data-bs-toggle="tab">[% $user->gettext('Software') %]</a></li>
        [% /if %]
    <li role="presentation"><a  class="nav-link" href="#ticketsAssetData_[% $DeviceID %]" aria-controls="ticketsAssetData_[% $DeviceID %]" role="tab" data-bs-toggle="tab" onclick="ShowTickets([% $DeviceID %]);">[% $user->gettext('Tickets') %]</a></li>
</ul>

<!-- Tab panes -->
<div class="tab-content">
    <div role="tabpanel" class="tab-pane active" id="commonAssetData_[% $DeviceID %]">
        [% foreach from=$Device.Basisdaten item=$Values key=$Section %]

            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">                    
                    <div class="row">
                        <div class="col-sm-6">
                            <span class="fcs-card-title h4">[% $user->gettext($Section) %]</span>
                        </div>
                        <div class="col-sm-6 text-end">
                            <div class="btn-group">
                                <a class="btn btn-outline-primary btn-sm lightContrast" href="javascript: copyElementToClipboard('Data2Copy_[% $DeviceID %]') " title="[% $user->gettext('Basisdaten in Zwischenablage kopieren') %]"><span class="fa fa-copy"></span></a>                        
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    [% include file=$modulePath|cat:"/assetInfoList.tpl" listItems=$Values %]

                    <div style="display:none;" id="Data2Copy_[% $DeviceID %]">
[% include file=$modulePath|cat:"/assetInfo2Copy.tpl" listItems=$Values %]  
                    </div>
                </div>
            </div>
        [% /foreach %]
    </div>

    [% if $Device['Bios'] %]
        <div role="tabpanel" class="tab-pane" id="biosAssetData_[% $DeviceID %]">

            <div class="row">
                <div class="col-sm-12 col-md-6">
                    <div class="card panel-info shadow-sm rounded">
                        <div class="card-header">
                            <h3 class="card-title">[% $user->gettext('BIOS') %]</h3>
                        </div>
                        <div class="card-body">
                            [% include file=$modulePath|cat:"/assetInfoList.tpl" listItems=$Device.Bios oneColumn=true %]
                        </div>
                    </div>
                </div>
                <div class="col-sm-12 col-md-6">
                    <div class="card panel-info shadow-sm rounded">
                        <div class="card-header">
                            <h3 class="card-title">[% $user->gettext('OS') %]</h3>
                        </div>
                        <div class="card-body">
                            [% include file=$modulePath|cat:"/assetInfoList.tpl" listItems=$Device.OS oneColumn=true %]
                        </div>
                    </div>
                </div>
            </div>
        </div>
    [% /if %]

    <div role="tabpanel" class="tab-pane" id="commercialAssetData_[% $DeviceID %]">
        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <h3 class="card-title">[% $user->gettext('Kommerzielle Daten') %]</h3>
            </div>
            <div class="card-body">
                [% include file=$modulePath|cat:"/assetInfoList.tpl" listItems=$Device.Commercial.Default %]


                [% if $Tools->FCS_Count($Device.Commercial.Anschaffung) %]
                    <h4>[% $user->gettext('Anschaffung') %]</h4>
                    [% include file=$modulePath|cat:"/assetInfoList.tpl" listItems=$Device.Commercial.Anschaffung %]
                [% /if %]

                [% if $Tools->FCS_Count($Device.Commercial.Buchhaltung) %]
                    <h4>[% $user->gettext('Buchhaltung') %]</h4>
                    [% include file=$modulePath|cat:"/assetInfoList.tpl" listItems=$Device.Commercial.Buchhaltung %]
                [% /if %]



                [% if $Tools->FCS_Count($Device.Commercial.AfA) %]
                    <h4>[% $user->gettext('AfA-Daten') %]</h4>
                    [% include file=$modulePath|cat:"/assetInfoList.tpl" listItems=$Device.Commercial.AfA %]
                [% /if %]

                [% if $Tools->FCS_Count($Device.Commercial.Leasing) %]
                    <h4>[% $user->gettext('Leasing-Daten') %]</h4>
                    [% include file=$modulePath|cat:"/assetInfoList.tpl" listItems=$Device.Commercial.Leasing %]
                [% /if %]


            </div>
        </div>
    </div>

    <div role="tabpanel" class="tab-pane" id="softwareAssetData_[% $DeviceID %]">
        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <h3 class="card-title">[% $user->gettext('Software') %]</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table  class="table table-striped table-sm table-hover softwaredevicetable">
                        <thead>
                            <tr>
                                <th>[% $user->gettext('Katalogsoftware') %]</th>
                                <th>[% $user->gettext('Name') %]</th>
                                <th>[% $user->gettext('Version') %]</th>
                                <th>[% $user->gettext('Kategorie') %]</th>
                                <th>[% $user->gettext('Sprache') %]</th>
                                <th>[% $user->gettext('Hersteller') %]</th>
                                <th>[% $user->gettext('Verzeichnis') %]</th>
                                <th>[% $user->gettext('Beschreibung') %]</th>
                                <th>[% $user->gettext('Installiert am') %]</th>
                            </tr>
                        </thead>
                        <tbody>
                            [% foreach from=$Device['Software']['Software'] item=$Software key=$Label %]

                                <tr>

                                    <td>[% if $Software.swcatalogid %][% $user->gettext('Ja') %][% else %][% /if %]</td>
                                    <td>[% $Software.productname %]</td>
                                    <td>[% $Software.version %]</td>
                                    <td>[% $Software.category %]</td>
                                    <td>[% $Software.swlanguage %]</td>
                                    <td>[% $Software.vendor %]</td>
                                    <td>[% $Software.instdir %]</td>
                                    <td>[% $Software.descr %]</td>
                                    <td>[% $Software.instdate %]</td>

                                </tr>

                            [% /foreach %]
                        </tbody>
                    </table>

                    [% if $Device['Software']['ProdCatalog'] %]
                        <div class="card panel-info shadow-sm rounded">
                            <div class="card-header">
                                <h3 class="card-title">[% $user->gettext('Softwarekatalog') %]</h3>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table  class="table table-striped table-sm table-hover softwaredevicetable">
                                        <thead>
                                            <tr>
                                                <th>[% $user->gettext('Name') %]</th>
                                                <th>[% $user->gettext('Version') %]</th>
                                                <th>[% $user->gettext('Sprache') %]</th>
                                                <th>[% $user->gettext('Hersteller') %]</th>
                                                <th>[% $user->gettext('Kategorie') %]</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            [% foreach from=$Device['Software']['ProdCatalog'] item=$CatalogSoftware %]
                                                <tr>
                                                    <td>[% $CatalogSoftware.prodname %]</td>
                                                    <td>[% $CatalogSoftware.prodversion %]</td>
                                                    <td>[% $CatalogSoftware.prodlanguage %]</td>
                                                    <td>[% $CatalogSoftware.prodvendor %]</td>
                                                    <td>[% $CatalogSoftware.categoryname %]</td>
                                                </tr>
                                            [% /foreach %]
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    [% /if %]
                </div>
            </div>
        </div>
    </div>
    <div role="tabpanel" class="tab-pane" id="ticketsAssetData_[% $DeviceID %]">
        <div id="DeviceTicket[% $DeviceID %]"></div>
    </div>
</div>

[% if $assetlist %]
    <script>
        function ShowTickets(DevID) {
            {
                $("#DeviceTicket" + DevID).load("index.php?module=device&event=getDeviceTickets&id=" + DevID);
            }
        }
function copyElementToClipboard(element) {
    $("#" + element).show();
    window.getSelection().removeAllRanges();
    let range = document.createRange();
    range.selectNode(typeof element === 'string' ? document.getElementById(element) : element);
    window.getSelection().addRange(range);
    document.execCommand('copy');
    window.getSelection().removeAllRanges();
    $("#" + element).hide();
    noty({
        text: "Assetdaten wurden in Clipboard kopiert",
        type: 'success',
        timeout: notifyTimeout
    });
}

</script>
[% /if %]
