<!-- Component CSV-Import begin -->
<script>
    function checkAll(el) {
        var objArray = document.getElementsByName("employee[]");
        if (objArray && objArray.length > 0) {
            for (i = 0; i < objArray.length; i++) {
                objArray[i].checked = el.checked;
            }
        }
    }

    function checkEmployee(id) {
        var objArray = document.getElementsByName("employee[]");
        if (objArray && objArray.length > 0) {
            for (i = 0; i < objArray.length; i++) {
                if (objArray[i].value == id) {
                    objArray[i].checked = (objArray[i].checked)
                            ? false : true;
                }
            }
        }
    }

    function switchPage(page) {
        document.getElementById('pos').value = page;
        submitForm();
    }

    function changeSort(sort) {
        var el = document.getElementById("sort");
        var els = document.getElementById("order");
        if (el) {
            if (el.value == sort) {
                if (els) {
                    els.value = (els.value == "asc") ? "desc" : "asc";
                }
            } else {
                el.value = sort;
            }
            submitForm();
        }
    }

    function keyEvent(event) {
        if (event.keyCode == 13)
            submitForm();
    }

    var iMode = null;

    function importCheck(mode) {

        if (mode == 1 || isChecked()) {

            if (document.getElementById('csvFormat2') == undefined || !document.getElementById('csvFormat2').checked) {

                iMode = mode;
                $("#dialog-PopUpFrameContent").dialog('open');
            } else {
                document.getElementById("iMode").value = mode;

                submitForm();
            }
        } else {
            alert("[% $user->gettext('Bitte selektieren Sie min. einen Mitarbeiter.') %]");
        }
    }

    function isChecked() {
        var objArray = document.getElementsByName("employee[]");
        if (objArray && objArray.length > 0) {
            for (i = 0; i < objArray.length; i++) {
                if (objArray[i].checked) {
                    return true;
                }
            }
        }
        return false;
    }

    function closePopUpFrame() {
        var el = document.getElementById("PopUpFrame");
        var obj = document.getElementById("PopUpFrameContent");
        el.style.visibility = "hidden";
        obj.style.visibility = "hidden";
    }

    function startImport() {
        var el1 = document.getElementById("uMode");
        var el2 = document.getElementById("cMode");

        var pwd1 = $("#passwd1").val();
        var pwd2 = $("#passwd2").val();

        if (el2.checked) {
            $("#FormcMode").val('Y');
        }
        if (el1.checked) {
            $("#FormuMode").val('Y');
        }
        $("#Formpasswd1").val($("#passwd1").val());
        $("#Formpasswd2").val($("#passwd2").val());

        if (el1 && el2 && (el1.checked || el2.checked)) {
            if (el1.checked)
            {
                if (pwd1 != pwd2) {
                    alert("[% $user->gettext('Passwörter stimmen nicht überein. Bitte kontrollieren Sie Ihre Eingabe.') %]");
                } else {
                    if (pwd1 != '') {
                        document.getElementById("iMode").value = iMode;
                        submitForm();
                    } else {
                        alert("[% $user->gettext('Bitte geben Sie ein Standardpasswort ein') %]");
                    }
                }
            } else
            {
                document.getElementById("iMode").value = iMode;
                submitForm();
                //$("#hm").submit();
            }

        } else {
            alert("[% $user->gettext('Bitte geben Sie an als was Sie den Mitarbeiter anlegen wollen') %]");
        }
    }

    function collapseTr() {

        $(".invisible").show();

    }

</script>
<style>
    .ui-dialog .ui-dialog-titlebar-close span {margin:0px;left: 0;top: 0;}
</style>

<form action="" method="post" name="hm" id="hm" enctype="multipart/form-data" style="margin:0;padding:0;" class="form-inline fcs-form-padding">
    <input type="hidden" name="pos" id="pos" value="[% $pos %]" />
    <input type="hidden" name="sort" id="sort" value="[% $sort %]" />
    <input type="hidden" name="order" id="order" value="[% $order %]" />
    <input type="hidden" name="iMode" id="iMode" value="" />

    <input type="hidden" name="cMode" id="FormcMode" value="" />
    <input type="hidden" name="uMode" id="FormuMode" value="" />
    <input type="hidden" name="passwd1" id="Formpasswd1" value="" />
    <input type="hidden" name="passwd2" id="Formpasswd2" value="" />

    <!-- ###CONTENT### begin -->
    <div class="card panel-fcs-border shadow-sm">
        <div class="card-header">
            <span class="fcs-card-title h2">
                [%$user->gettext('Mitarbeiter aus ActiveDirectory importieren')%]
            </span>
        </div>
        <div class="card-body">
            <div class="card panel-info shadow-sm rounded">
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="row">
                                <div class="form-group row mb-3 " style="margin-left: 10px;">
                                    <label class="control-label">[%$user->gettext('Filter')%]: </label>
                                    <input type="text" class="form-control" id="filter" name="filter" value="[% $filter %]" onkeyup="keyEvent(event);" autocomplete="off" />
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group row mb-3" style="margin-left: 10px; margin-top: 10px;">
                                    <label class="control-label">[%$user->gettext('Liste filtern')%]: </label>
                                    &nbsp;<label><input type="checkbox" name="hideexistingContacts" value="1"[% if $hideexistingContacts == 1 %] checked="checked"[% /if %] onchange="submitForm();"/> [% $user->gettext('Bestehende Kontakte nicht anzeigen') %]</label>
                                    &nbsp;<label><input type="checkbox" name="hideexistingUsers" value="1" [% if $hideexistingUsers == 1 %] checked="checked"[% /if %] onchange="submitForm();"/> [% $user->gettext('Bestehende Benutzer nicht anzeigen') %]</label>                                               
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 text-end">
                            <div class="btn-group">
                                <a href="javascript:importCheck(0);" class="btn btn-outline-primary" >[% $user->gettext('Auswahl importieren') %]</a>
                                <a href="javascript:importCheck(1);" class="btn btn-outline-primary" >[% $user->gettext('Alle importieren') %]</a>
                            </div>
                            [% if $updated %]<div style="text-align:center;"><strong>Daten wurden importiert...</strong></div>[% /if %]
                        </div>
                    </div>

                </div>

            </div>
            <div class="card panel-info shadow-sm rounded">
                <div class="card-header">
                    <span class="fcs-card-title h3">[% $user->gettext('Mitarbeiterliste')%]</span><span class="fcs-card-title h4">-[% $entries %] [% $user->gettext('Mitarbeiter gefunden') %]</span> 
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr class="fields">
                                    <th style="text-align:center !important;">
                                        <input type="checkbox" id="checkall" onclick="checkAll(this);" />
                                    </th>
                                    <th onclick="changeSort('name');">
                                        [% $user->gettext('Name') %]
                                        [% if $sort == "name" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </th>
                                    <th onclick="changeSort('username');">
                                        [% $user->gettext('Benutzername') %]
                                        [% if $sort == "username" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </th>
                                    [% if $ADImport %]
                                        <th onclick="changeSort('existingUserID');">
                                            [% $user->gettext('Benutzer') %]
                                            [% if $sort == "existingUserID" %]
                                                &nbsp;
                                                <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                            [% /if %]
                                        </th>
                                        <th onclick="changeSort('existingContactID');">
                                            [% $user->gettext('Kontakt') %]
                                            [% if $sort == "existingContactID" %]
                                                &nbsp;
                                                <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                            [% /if %]
                                        </th>
                                        <th onclick="changeSort('published');">
                                            [% $user->gettext('Aktiv') %]
                                            [% if $sort == "published" %]
                                                &nbsp;
                                                <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                            [% /if %]
                                        </th>                            
                                    [% /if %]
                                    <th onclick="changeSort('email');">
                                        [% $user->gettext('E-Mail') %]
                                        [% if $sort == "email" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </th>
                                    <th onclick="changeSort('telefon');">
                                        [% $user->gettext('Telefon') %]
                                        [% if $sort == "telefon" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </th>
                                    <th onclick="changeSort('fax');">
                                        [% $user->gettext('Fax') %]
                                        [% if $sort == "fax" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </th>
                                    <th onclick="changeSort('handy');">
                                        [% $user->gettext('Handy') %]
                                        [% if $sort == "handy" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </th>
                                    <th onclick="changeSort('personalno');">
                                        [% $user->gettext('Personalnummer') %]
                                        [% if $sort == "personalno" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </th>

                                    <th onclick="changeSort('company');">
                                        [% $user->gettext('Firma') %]
                                        [% if $sort == "company" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </th>

                                    <th onclick="changeSort('department');">
                                        [% $user->gettext('Abteilung') %]
                                        [% if $sort == "department" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </th>

                                    <th onclick="changeSort('building');">
                                        [% $user->gettext('Geb&auml;ude') %]
                                        [% if $sort == "building" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </th>
                                    <th onclick="changeSort('room');">
                                        [% $user->gettext('Raum') %]
                                        [% if $sort == "room" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </th>
                                    <th onclick="changeSort('floor');">
                                        [% $user->gettext('Stockwerk') %]
                                        [% if $sort == "floor" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </th>
                                    <th onclick="changeSort('lang');">
                                        [% $user->gettext('Sprache') %]
                                        [% if $sort == "lang" %]
                                            &nbsp;
                                            <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                        [% /if %]
                                    </th>                        
                                    [% if $CostCenter %]
                                        <th onclick="changeSort('costcenter');">
                                            [% $user->gettext('Kostenstelle') %]
                                            [% if $sort == "costcenter" %]
                                                &nbsp;
                                                <span class="fa fa-chevron-[% if $order == "desc" %]down[% else %]up[% /if %]"></span>
                                            [% /if %]
                                        </th>
                                    [% /if %]
                                </tr>
                            </thead>
                            <tbody>
                                [% foreach from=$employees item=employee %]
                                    <tr>
                                        <td style="text-align:center !important;"><input type="checkbox" name="employee[]" value="[% $employee.employeeid %]" /></td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);" [% if $employee.importedFlag %]class="import" title="Erfolgreich importiert" [% /if %]> [% $employee.name %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);" [% if $employee.existingUserID %]class="error" title="In DB schon vorhanden" [% /if %]>[% $employee.username %]&nbsp;</td>
                                        [% if $ADImport %]
                                            <td style="text-align:center !important;" onclick="checkEmployee([% $employee.employeeid %]);" ><span style="color:[% if $employee.existingUserID %]green[%else%]red[%/if%];" class="fa fa-[% if $employee.existingUserID %]check[% else %]xmark[%/if%]" title="[% if $employee.existingUserID %]Der Benutzer existiert bereits[%else%]Benutzer kann importiert werden[%/if%]"></span></td>
                                            <td style="text-align:center !important;" onclick="checkEmployee([% $employee.employeeid %]);" ><span style="color:[% if $employee.existingContactID %]green[%else%]red[%/if%];" class="fa fa-[% if $employee.existingContactID %]check[% else %]xmark[%/if%]" title="[% if $employee.existingContactID %]Der Benutzer existiert bereits[%else%]Benutzer kann importiert werden[%/if%]"></span></td>
                                            <td style="text-align:center !important;" onclick="checkEmployee([% $employee.employeeid %]);" >[% if $employee.published %] Ja [% else %]Nein [% /if %]</td>
                                        [% /if %]
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.email %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.telefon %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.fax %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.handy %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.personalno %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.company %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.department %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.building %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.room %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.floor %]&nbsp;</td>
                                        <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.lang %]&nbsp;</td>
                                        [% if $CostCenter %]
                                            <td onclick="checkEmployee([% $employee.employeeid %]);">[% $employee.costcenter %]&nbsp;</td>
                                        [% /if %]
                                    </tr>
                                [% foreachelse %]
                                    <tr class="even">
                                        <td colspan="[% if $ADImport %]18[% else %]17[% /if %]" style="text-align:center !important;">[% if $ADUpdate %][% $user->gettext('Keine Mitarbeiter zum aktualisieren gefunden...') %][% else %][% $user->gettext('Keine Mitarbeiter zum importieren gefunden...') %][% /if %]</td>
                                    </tr>
                                [% /foreach %]


                            </tbody>
                        </table>
                        [% if $pages > 1 %]
                            [% $Paging %]
                        [% /if %]
                    </div>
                </div>
            </div>
        </div>
    </div>



    <div id="dialog-PopUpFrameContent" >
        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <span class="fcs-card-title h5">[% $user->gettext('Standardangaben f&uuml;r die Mitarbeiter') %]</span>
            </div>
            <div class="card-body">
                <div class="form-group row mb-3 row">
                    <label for="cMode" class="control-label col-lg-10">[% $user->gettext('Als Kontakt anlegen:') %]</label>
                    <div class="col-lg-2">
                        <input type="checkbox" name="cMode" value="Y" id="cMode" />
                    </div>
                </div>
                <div class="form-group row mb-3 row">
                    <label for="uMode" class="control-label col-lg-10">[% $user->gettext('Als Benutzer anlegen:') %]</label>
                    <div class="col-lg-2">
                        <input type="checkbox" name="uMode" value="Y" id="uMode" [% if !$ADImport %]onclick="collapseTr()"[% /if %] />
                    </div>
                </div>
                [% if !$ADImport %]

                    <div class="form-group row mb-3 row invisible" id="invisible1" style="display:none;">
                        <label for="passwd1" class="control-label col-lg-4">[% $user->gettext('Passwort') %]:</label>  
                        <div class="col-lg-8">
                            <input type="password" class="form-control" name="passwd1" id="passwd1" autocomplete="off"  />
                        </div>
                    </div>
                    <div class="form-group row mb-3 row invisible" id="invisible2" style="display:none;">
                        <label for="passwd2" class="control-label col-lg-4">[% $user->gettext('Passwort best&auml;tigen') %]:</label>  
                        <div class="col-lg-8">
                            <input type="password" class="form-control" name="passwd2" id="passwd1" autocomplete="off"  />
                        </div>
                    </div>
                [% /if %]
                <div class="btn-group row text-center">
                    <div class="col-lg-6">
                        <input type="button" class="btn btn-outline-primary" value="[% $user->gettext('Importieren') %]" onclick="startImport();" />
                    </div>
                    <div class="col-lg-6">
                        <input type="button" class="btn btn-outline-secondary" value="[% $user->gettext('Abbruch') %]" onclick="$('#dialog-PopUpFrameContent').dialog('close');" />
                    </div>
                </div>
            </div>
        </div>

    </div>
</form>
<!-- Component CSV-Import end -->
<script>

    $(".dialog").fancybox({
        maxWidth: 500,
        maxHeight: 300,
        closeClick: false,
        autoOpen: false,
        onClosed: function () {
            parent.location.reload(true);
        }
    });

    $("#dialog-PopUpFrameContent").dialog({
        autoOpen: false,
        maxWidth: 500,
        maxHeight: 300,
        closeClick: false,
        closeText: '',
        onClosed: function () {
            parent.location.reload(true);
        },
        beforeClose: function (event, ui) {

        }
    });

</script>
