
<link rel="stylesheet" type="text/css" href="includes/js/datatables_1.11.5/datatables.min.css"/>
<script type="text/javascript" src="includes/js/datatables_1.11.5/datatables.min.js"></script>

<div class="card panel-fcs-border shadow-sm">
    <div class="card-header">
        <span class="fcs-card-title h2">[% $user->gettext('Benutzerrechte') %]</span>
    </div>

    <div class="card-body">


        <div class="card panel-info shadow-sm rounded">
            <div class="card-header">
                <div class="row">
                    <div class="col-sm-6">
                        <span class="fcs-card-title h4">[% $user->gettext('Benutzerrechte') %]</span>
                    </div>

                </div>
            </div>
            <div class="card-body">
                <div class='table-responsive' style="max-height: 75vh;">              

                    <table class='table table-bordered'>
                        <thead class="sticky-top" style="z-index: 90;">
                            <tr>
                                <th>Sektion</th>
                                <th>Segment</th>
                                <th>Recht</th>
                                    [% foreach from=$RightByGroups item=Group key=GroupName %]
                                    <th>[% $GroupName %]</th>
                                    [% /foreach %]
                            
                            </tr>
                            
                        </thead>
                        [% assign var=actualSection value= $Rights.section   %]
                        [% assign var=actualSegment value= $Rights.segment  %]
       

                        [% foreach from=$Rights item=Right key=RightID %]   
             
                            <tr>
                            
                                [% if  $actualSection != $Right.section  %]
                                    [% assign var=actualSection value= $Right.section  %]        

                                    <td rowspan="[% $Count.Sections[$Right.section] %]">
                                        [% $Right.section %]  
                                    </td>
                                [% /if %]
                                



                                [% if $actualSegment != $Right.segment  %]
                                    [% assign var=actualSegment value= $Right.segment  %]                             
                                    <td rowspan="[% $Count.SectionSegments[$Right.section].Segment[$Right.segment] %] ">[% $Right.segment %]</td>
                                [% /if %]      




                                
                                <td>[% $Right.rightname %]</td>

                                [% foreach from=$RightByGroups item=Group key=GroupName %]
                                    
                                        <td>    
                                            <input type="checkbox" 
                                            value="[% $RightID %]" 
                                            data-groupid="[% $Group.GroupID %]" 
                                            data-rightname="[% $Right.rightname %]"
                                            data-groupname="[% $GroupName %]"
                                            class="RightToSelect"
                                            [% if $Group.hasRight[$RightID] %] checked [% /if %]
                                            [% if $RightID == 1006 && !$user->inGroup(1) %] disabled [% /if %] > 
                                            <script> console.log("Geladene GruppenID: [% $Group.GroupID %] / geladenes groupRight: groupright_[% $RightID %]_[% $Group.GroupID %]"  ); </script>
                                        </td>
                                    
                                [% /foreach %]

                                
                            </tr>
                        [% /foreach %]
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<script>
$(document).ready(function () {
    $(document).on('click', '.RightToSelect', function () {
        console.log("onClick function ");

        let selectedGroup = $(this).data("groupid");
        let selectedRight = $(this).attr('value');
        let GroupName = $(this).data('groupname')
        let RightName = $(this).data('rightname');
        let addRight = $(this).is(':checked') ? 1 : 0;

        console.log("Selected Group:", selectedGroup);
        console.log("Selected Right:", selectedRight);
        console.log("Right Name:", RightName);
        console.log("Add Right:", addRight);

        $.post("index.php?module=groups&event=changeGroupRight", {GroupID: selectedGroup, RightID: selectedRight, addRight: addRight, GroupName: GroupName, RightName: RightName}).done(function (json) {
                if (json.error === false) {
                    noty({text: json.message, timeout: notifyTimeout});
                } else {
                    noty({text: json.message, type: 'error', timeout: notifyTimeout});
                }
            });
    });


    
});


</script>
