if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Ticket]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[Ticket]
GO
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TicketCategory]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[TicketCategory]
GO
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TicketDevice]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[TicketDevice]
GO
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TicketEscalation]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[TicketEscalation]
GO
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TicketEscalationLevel]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[TicketEscalationLevel]
GO
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TicketEscalationRequirement]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[TicketEscalationRequirement]
GO
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TicketEvent]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[TicketEvent]
GO
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TicketKnowledgeBase]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[TicketKnowledgeBase]
GO
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TicketPrio]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[TicketPrio]
GO
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TicketStatus]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[TicketStatus]
GO
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UserCategory]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[UserCategory]
GO
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UserDevices]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[UserDevices]
GO
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UsedKnowledgeBaseCategories]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[UsedKnowledgeBaseCategories]
GO
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UsedTicketCategories]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[UsedTicketCategories]
GO
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[EscalationAction]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [dbo].[EscalationAction]
GO
CREATE TABLE [dbo].[hm_Attachment] (
	[AttachmentID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[FileName] [varchar] (255)  NULL ,
	[ChangedFileName] [varchar] (255)  NULL ,
	[FileExtension] [varchar] (10)  NULL ,
	[FileSize] [bigint] NULL ,
	[ImageWidth] [int] NULL ,
	[ImageHeight] [int] NULL ,
	[CreateDate] [datetime] NULL ,
	[CreateUser] [varchar] (100)  NULL ,
	[CreateUserID] [bigint] NULL ,
	[UpdateDate] [datetime] NULL ,
	[UpdateUser] [varchar] (100)  NULL ,
	[ShortDescr] [varchar] (100)  NULL ,
	[AttachmentTypID] [bigint] NULL ,
	[LongDescr] [text]  NULL ,
	[URL] [varchar] (255)  NULL ,
	[SessionID] [varchar] (255)  NULL,
        [NotPublic] [tinyint] NULL
 CONSTRAINT [PK_Attachment] PRIMARY KEY CLUSTERED
(
	[AttachmentID] ASC
)) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_AttachmentTyp] (
	[AttachmentTypID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[AttachmentTypName] [varchar] (20)  NULL,
 CONSTRAINT [PK_AttachmentTyp] PRIMARY KEY CLUSTERED
(
	[AttachmentTypID] ASC
)) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_Categories] (
	[id] [bigint] IDENTITY (1, 1) NOT NULL ,
	[lft] [bigint] NOT NULL ,
	[rgt] [bigint] NOT NULL ,
	[root_id] [bigint] NOT NULL ,
	[levelno] [bigint] NOT NULL ,
	[ordering] [bigint] NOT NULL ,
	[name] [varchar] (50)  NULL ,
	[published] [tinyint] NULL ,
	[cost_rate] [float] NULL ,
    [sla_time] [int] NULL ,
	[notice_time1] [int] NULL ,
    [notice_time2] [int] NULL ,
    [DefaultGroupID] [bigint] NULL ,
	[EscalationFirstHintPercent] [int] NULL ,
	[EscalationSecondHintPercent] [int] NULL ,
	[EscalationThirdHintPercent] [int] NULL ,
	[EscalationFirstStepMinutes] [int] NULL ,
	[EscalationSecondStepMinutes] [int] NULL ,
	[EscalationFirstStepAddEmail] [varchar] (255)  NULL ,
	[EscalationSecondStepAddEmail1] [varchar] (255)  NULL ,
	[EscalationSecondStepAddEmail2] [varchar] (255)  NULL ,
	[InformContact] [tinyint] NULL,
    [inCalendar] [tinyint] NOT NULL DEFAULT (1),
    [NeedDevice] [tinyint] NULL,
	[DeciderMandatory] [tinyint] NULL,
    [Prio] [tinyint] NOT NULL DEFAULT ((0)),
    [desiretime_minutes] [int] NULL,
    [desiretime_hours] [int] NULL,
    [desiretime_days] [int] NULL,
    [EscalationFirstHintSendMail] [tinyint] NULL,
    [EscalationSecondHintSendMail] [tinyint] NULL,
    [EscalationThirdHintSendMail] [tinyint] NULL,
    [UseRootEscalation] [tinyint] NOT NULL DEFAULT (1),
 CONSTRAINT [PK_Categories] PRIMARY KEY CLUSTERED
(
	[id] ASC
)) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_ContactStructure] (
	[structure_id] [bigint] NOT NULL ,
	[contact_id] [bigint] NOT NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_ContactToEmployee] (
	[ContactID] [bigint] NOT NULL ,
	[EmployeeID] [bigint] NOT NULL ,
	[published] [tinyint] NOT NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_Contacts] (
	[contact_id] [bigint] IDENTITY (1, 1) NOT NULL ,
	[name] [varchar] (100)  NOT NULL ,
	[street] [varchar] (150)  NULL ,
	[plz] [varchar] (20)  NULL ,
	[city] [varchar] (255)  NULL ,
	[state] [varchar] (255)  NULL ,
	[country] [varchar] (255)  NULL ,
	[fax] [varchar] (50)  NULL ,
	[phone] [varchar] (50)  NULL ,
	[user_id] [bigint] NULL ,
	[company] [varchar] (100)  NULL ,
	[com_position] [varchar] (100)  NULL ,
	[published] [tinyint] NOT NULL ,
	[misc] [text]  NULL ,
	[email] [varchar] (255)  NULL ,
	[mobil] [varchar] (50)  NULL ,
	[personalno] [varchar] (255)  NULL ,
	[created] [datetime] NULL ,
	[updated] [datetime] NULL ,
	[important] [tinyint] NOT NULL,
	[image] [varchar] (255)  NULL ,
    [ADguid] [varchar] (255) NULL,
    [building] [varchar] (255)  NULL ,
    [room] [varchar] (255)  NULL,
    [floor] [varchar] (255)  NULL,
    [sendEmails] [tinyint] NOT NULL DEFAULT (1),
    [CostCenter] [varchar] (255) NULL,
    [department] [varchar] (255) NULL,
    [eMailTicketAddress] [int] NULL,
    [CompanyID] [int] NULL,
    [MandantenID] [int] DEFAULT 0 NULL,
    [NativeGUID] AS LOWER(SUBSTRING(ADGuid, 7, 2) + SUBSTRING(ADGuid, 5, 2) + SUBSTRING(ADGuid, 3, 2) + SUBSTRING(ADGuid, 1, 2) + SUBSTRING(ADGuid, 12, 2) + SUBSTRING(ADGuid, 10, 2) + SUBSTRING(ADGuid, 17, 2) + SUBSTRING(ADGuid, 15, 2) + Replace(SUBSTRING(ADGuid, 20, 17), '-', ''))
 CONSTRAINT [PK_UserContact] PRIMARY KEY CLUSTERED
(
	[contact_id] ASC
)) ON [PRIMARY]

GO
CREATE TABLE [dbo].[hm_EscalationAction] (
	[EscalationActionID] [int] IDENTITY (1, 1) NOT NULL ,
	[TicketEscalationID] [int] NULL ,
	[ActionNr] [int] NULL ,
	[ActionItem] [varchar] (300)  NULL,
 CONSTRAINT [PK_EscalationAction] PRIMARY KEY CLUSTERED
(
	[EscalationActionID] ASC
)) ON [PRIMARY]

GO

CREATE TABLE [dbo].[hm_EscalationHistory] (
	[EscalationID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[EscalationLevel] [tinyint] NOT NULL ,
	[EscalationDate] [datetime] NOT NULL ,
	[EscalationType] [tinyint] NOT NULL ,
	[TicketID] [bigint] NOT NULL,
 CONSTRAINT [PK_EscalationHistory] PRIMARY KEY CLUSTERED
(
	[EscalationID] ASC
)) ON [PRIMARY]
GO

CREATE TABLE [dbo].[hm_FAQAttachment] (
	[FAQDataID] [bigint] NOT NULL ,
	[AttachmentID] [bigint] NOT NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_FAQCategories] (
	[FAQCategoryID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[Name] [varchar] (255)  NOT NULL ,
	[Description] [varchar] (255)  NULL,
    ParentFAQCategoryID  [int] NULL,
    SortOrder  [int] NULL,
 CONSTRAINT [PK_FAQCategories] PRIMARY KEY CLUSTERED
(
	[FAQCategoryID] ASC
)) ON [PRIMARY]
GO

CREATE TABLE [dbo].[hm_FAQCategoryRelation] (
	[FAQDataID] [bigint] NOT NULL ,
	[FAQCategoryID] [bigint] NOT NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_FAQData] (
	[FAQDataID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[Active] [bit] NOT NULL ,
	[Keywords] [text]  NOT NULL ,
	[ShortDescription] [varchar] (255)  NOT NULL ,
	[Description] [varchar] (MAX) NOT NULL ,
	[CreateDate] [datetime] NOT NULL ,
	[CreateUser] [varchar] (50)  NULL ,
	[UpdateDate] [datetime] NOT NULL ,
	[UpdateUser] [varchar] (50)  NULL,
	[ValidTill] [datetime]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_FAQVisits] (
	[FAQDataID] [bigint] NOT NULL ,
	[Visits] [bigint] NOT NULL ,
	[LastVisit] [datetime] NOT NULL ,
	[IP] [varchar] (39)  NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_FAQVoting] (
	[FAQVotingID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[FAQDataID] [bigint] NOT NULL ,
	[Vote] [smallint] NOT NULL ,
	[CreateUserID] [bigint] NOT NULL ,
	[CreateUser] [varchar] (50)  NOT NULL ,
	[CreateDate] [datetime] NOT NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_GroupCategory] (
	[category_id] [bigint] NULL ,
	[group_id] [bigint] NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_TickettypeCategory] (
        [type_id] [bigint] NULL ,
        [category_id] [bigint] NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_GroupRights] (
	[group_id] [bigint] NOT NULL ,
	[right_id] [bigint] NOT NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_Groups] (
	[group_id] [bigint] IDENTITY (1, 1) NOT NULL ,
	[name] [varchar] (100)  NOT NULL,
	[SupportGroup] [int] NULL,
        [Avatar] [varchar](255) NULL,
        [CroppedAvatar] [varchar](255) NULL,
        [paKDNR] VARCHAR(200) NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_News] (
	[NewsID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[Title] [varchar] (100)  NOT NULL ,
	[Intro] [varchar] (max)  NOT NULL ,
	[Main] [varchar] (max)  NULL ,
	[Autor] [varchar] (255)  NULL ,
	[CreateUser] [varchar] (255)  NULL ,
	[CreateUserID] [bigint] NULL ,
	[CreateDate] [datetime] NOT NULL ,
	[UpdateUser] [varchar] (255)  NULL ,
	[UpdateUserID] [bigint] NULL ,
	[UpdateDate] [datetime] NULL ,
	[Published] [tinyint] NOT NULL,
    [Deleted] [tinyint] NOT NULL DEFAULT (0),
	[ValidTill] [datetime],
	[ContainerColor] VARCHAR(7)
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_NewsGroups]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_NewsGroups] (
    [NewsGroupsID] [bigint] IDENTITY (1, 1) NOT NULL ,
    [NewsID] [bigint] NOT NULL ,
    [GroupID] [bigint] NOT NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_Rights] (
	[RightID] [bigint] NOT NULL ,
	[RightName] [varchar] (5000)  NOT NULL ,
	[RightsSectionID] [int] NOT NULL ,
	[RightsOrder] [int] NOT NULL,
        [RightDescr] [varchar](5000) NULL,
        [SegmentID] [int] NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_RightsSection] (
	[RightsSectionID] [int] IDENTITY (1, 1) NOT NULL ,
	[SectionName] [varchar] (50)  NOT NULL ,
	[SectionOrder] [int] NOT NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_RightsSegment](
	[SegmentID] [int] NOT NULL,
	[Descr] [varchar](100) NOT NULL,
	[SectionID] [int] NULL,
	[SegmentOrder] [int] NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_Structure] (
	[id] [bigint] IDENTITY (1, 1) NOT NULL ,
	[root_id] [bigint] NOT NULL ,
	[lft] [bigint] NOT NULL ,
	[rgt] [bigint] NOT NULL ,
	[levelno] [bigint] NOT NULL ,
	[ordering] [bigint] NOT NULL ,
	[name] [varchar] (60)  NULL ,
	[descr] [text]  NULL ,
	[styp_id] [bigint] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_StructureTyp] (
	[styp_id] [bigint] IDENTITY (1, 1) NOT NULL ,
	[name] [varchar] (50)  NOT NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_Ticket] (
    [ID] [bigint] IDENTITY (1, 1) NOT NULL,
    [ContactID] [bigint] NULL ,
    [GroupID] [bigint] NULL ,
    [SupporterID] [bigint] NULL ,
    [TicketDesireDate] [datetime] NULL ,
    [TicketDesireUpdateDate] [datetime] NULL ,
    [OnHold] [datetime] NULL ,
    [TicketDescr] [varchar] (500)  NOT NULL ,
    [TicketPrioID] [bigint] NULL ,
    [TicketStatusID] [int] NULL ,
    [TicketReferenzID] [bigint] NULL ,
    [CategoryID1] [bigint] NULL ,
    [CategoryID2] [bigint] NULL ,
    [Published] [tinyint] NULL ,
    [Expense] [int] NULL ,
    [CreateDate] [datetime] NOT NULL ,
    [CreateUserID] [bigint] NULL ,
    [UpdateDate] [datetime] NULL ,
    [UpdateUserID] [bigint] NULL ,
    [EscalationLevel] [tinyint] NULL ,
    [EscalationDate] [datetime] NULL ,
    [EscalationType] [tinyint] NULL ,
    [UniqID] [varchar] (20)  NULL ,
    [EOSToDo] [tinyint] NULL ,
    [Handover] [varchar] (255)  NULL,
    [IsProblem] [tinyint] NULL,
    [UserGroupID] [bigint] NULL,
    [EditDate] [datetime] NULL,
    [InventoryNumber] [varchar](50) NULL,
    [SolutionDate] [datetime] NULL,
    [KaufbInventoryNumber] [bigint] NULL,
    [PrioAccepted] [tinyint] NULL,
    [anonymous] [tinyint] NULL,
    [archived] [tinyint] NULL,
    [archivdate] [datetime] NULL,
    [archivuserid] [int] NULL,
    [expExpense] [int] NULL,
    [ServiceID] [int] NULL,
    [SLAID] [int] NULL,
    [MajorIncident] [tinyint] NULL,
    [LocationStructureID] [bigint] NULL,
    [TypeID] [bigint] NULL,
    [RatingDate] [datetime] NULL,
    [RatingComment] [text] NULL,
    [Draft] [bigint] NULL,
    [BOTSuggestedKBIDs] [varchar](255) NULL,
    [BOTMatchedKBID] [tinyint] NULL,
    [PreOnHoldStatusID] [int] NULL,
    [EPClassMainGroupID] [int] NULL,
    [EPClassSubGroupID] [int] NULL,
    [HasFinancialCommitment] [tinyint] NOT NULL DEFAULT (0),
    [FinancialCommitmentValue] [varchar](500) NULL,
    [FinancialCommitmentCreateUserID] [bigint] NULL,
    [FinancialCommitmentCreateDate] [datetime] NULL,
    [AutoClose] [int] NULL,
    [ConnectedTicket_SortOrder] VARCHAR(MAX),
    [ConnectedTicket_SortBy] VARCHAR(MAX),
    [isWPRequest] [tinyint] DEFAULT(0),
    [paDealerID] INT NULL,
    [paCallTypeID] INT NULL,
    [paCallID] [varchar](255) NULL,
    [CreatedFromTemplateID] [bigint] DEFAULT 0 NULL,
    [DeletedOn] datetime NULL,
     [OperatingHours] [int] NULL,
     [isIntern] [bit] NULL DEFAULT 0,
     IncidentImpactID INT NULL,
     IncidentUrgencyID INT NULL,
     IncidentPrio INT NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_TicketAttachment] (
	[TicketID] [bigint] NOT NULL ,
	[AttachmentID] [bigint] NOT NULL ,
	[TicketEventID] [bigint] NULL,
        [EmbeddedImages] [tinyint] DEFAULT 0 NOT NULL,
        [SessionID] [varchar](64) NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_TicketDevice] (
	[TicketID] [bigint] NULL ,
	[DeviceID] [bigint] NULL ,
	[SessionID] [varchar] (200)  NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_TicketEvent] (
	[ID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[TicketID] [bigint] NOT NULL ,
	[UserID] [bigint] NULL ,
	[TicketStatusID] [int] NULL ,
	[EventDescr] [text]  NOT NULL ,
	[Expense] [bigint] NULL ,
	[NotPublic] [tinyint] NULL ,
	[CreateDate] [datetime] NOT NULL ,
	[CreateUserID] [bigint] NULL ,
	[UpdateDate] [datetime] NULL ,
	[UpdateUserID] [bigint] NULL ,
	[Invoiced] [tinyint] NULL ,
	[Processingtype] [bigint] NULL,
	[EventDate] [datetime] NULL,
	[Deleted] [tinyint] NULL,
	[CostGroupID] [int] NULL DEFAULT (0),
	[CostRatePerMinute] [float] NULL,
	[Cat1IDForCostGroup] [int] NULL,
	[ProjectCostRateSource] varchar(15) NULL,
	[ProjectCostGroupID] int NULL DEFAULT (0),
	[ProjectCostRatePerMinute] [float] NULL,
	[ProjectFactor] [float] NULL,
	[IFrameID] varchar(13) NULL,
	[ProjectFixCosts] [float] DEFAULT 0,
	[important] BIT NULL,
	[SubStatusID] int NULL,
    [MailSubject] varchar (MAX) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_TicketPrio] (
	[TicketPrioID] [bigint] IDENTITY (1, 1) NOT NULL,
	[Descr] [varchar] (20)  NOT NULL ,
	[Ordering] [int] NOT NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_TicketStatus] (
	[ID] [int] NOT NULL ,
	[Descr] [varchar] (50)  NOT NULL,
    descr_en VARCHAR(50) DEFAULT NULL,
    descr_de VARCHAR(50) DEFAULT NULL,
    is_custom TINYINT DEFAULT 0
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_TicketFilter] (
	[FilterID] [bigint] IDENTITY (1, 1) NOT NULL,
	[FilterName] [varchar] (50)  NOT NULL ,
	[IsDefault] [tinyint] NOT NULL,
	[UserID] [bigint] NOT NULL ,
	[CreateDateStart] [datetime] NULL ,
	[CreateDateEnd] [datetime] NULL ,
	[UpdateDateStart] [datetime] NULL ,
	[UpdateDateEnd] [datetime] NULL ,
	[OnHold] [datetime] NULL ,
	[Display] [varchar] (15)  NULL ,
	[StatusID] [bigint] NULL ,
	[Filter] [varchar] (50)  NULL ,
	[Sorting] [varchar] (20)  NULL ,
	[Sortorder] [varchar] (5)  NULL ,
	[MyTickets] [tinyint] NULL ,
	[TicketBasket] [tinyint] NULL,
	[DesireDateStart] [datetime] NULL ,
	[DesireDateEnd] [datetime] NULL ,
	[EntriesPerPage] [bigint] NULL ,
    [FilterList] [tinyint] NULL ,
    [PrioID] [bigint] NULL ,
    [Master] [tinyint] NULL ,
    [Problem] [tinyint] NULL ,
	[CategoryID] [bigint] NULL,
	[TicketID] [bigint] NULL,
    [DesireDatePeriod] [tinyint] NULL,
    [CreateDatePeriod] [tinyint] NULL,
    [UpdateDatePeriod] [tinyint] NULL,
    [GroupID] [bigint] NULL,
    [Category2ID] [bigint] NULL,
    [NoOnHold] [tinyint] NULL,
    [SupporterID] [bigint] NULL,
    [CreateUserID] [bigint] NULL,
    [UpdateUserID] [bigint] NULL,
	[WorkOnDateStart] [datetime] NULL ,
	[WorkOnDateEnd] [datetime] NULL ,
    [WorkOnDatePeriod] [tinyint] NULL,
    [Config] [text] NULL
 CONSTRAINT [PK_TicketFilter] PRIMARY KEY CLUSTERED
(
	[FilterID] ASC
)) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_UserGroups] (
	[user_id] [bigint] NOT NULL ,
	[group_id] [bigint] NOT NULL
) ON [PRIMARY]

GO
--Verhindert, dass Doppelte Einträge erneut angelegt werden:
ALTER TABLE [dbo].[hm_UserGroups] ADD  CONSTRAINT [PK_hm_UserGroups] PRIMARY KEY CLUSTERED 
(
	[user_id] ASC,
	[group_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
GO

CREATE TABLE [dbo].[hm_Users] (
    [user_id] [bigint] IDENTITY (1, 1) NOT NULL ,
    [name] [varchar] (50)  NOT NULL ,
    [username] [varchar] (255)  NOT NULL ,
    [password] [varchar] (255)  NOT NULL ,
    [email] [varchar] (255)  NULL ,
    [block] [tinyint] NOT NULL ,
    [sendEmail] [tinyint] NOT NULL ,
    [registerDate] [datetime] NOT NULL ,
    [lastvisitDate] [datetime] NULL ,
    [language_type] [varchar] (10)  NOT NULL ,
    [RandomUserID] [varchar] (50)  NULL ,
    [RandomUserID2] [varchar] (50)  NULL ,
    [WYSIWYG] [tinyint] NULL ,
    [EmployeeID] [bigint] NULL,
    [AuthLDAP] [varchar] (255)  NULL ,
    [ADguid] [varchar] (255)  NULL ,
    [Config] [text]  NULL ,
    [Deleted] [tinyint] NULL ,
    [ProjectCostRate] [DECIMAL] (10,2) NULL ,
    [changePW] [tinyint] NULL,
    [remfilters] [tinyint] NULL DEFAULT ((1)),
	[ShowScrollingAreas] [tinyint] DEFAULT 0 NOT NULL,
	[LandingPage] [int] DEFAULT 0 NOT NULL,
	[ShowTicketsInNewTab] [tinyint] DEFAULT 0 NOT NULL,
    [Signatur] [varchar](5000) NULL,
    [PwdChangeDate] [datetime] DEFAULT GETDATE() NULL,
    [PushMessageCreate] [tinyint] DEFAULT 0 NOT NULL,
    [PushMessageEdit] [tinyint] DEFAULT 0 NOT NULL,
    [PushMessageAssign] [tinyint] DEFAULT 0 NOT NULL,
    [PushMessageClose] [tinyint] DEFAULT 0 NOT NULL,
    [PushMessageEscalation] [tinyint] DEFAULT 0 NOT NULL,
    [TLconfig] [text] NULL,
    [view_num] [int] NULL,
    [Avatar] [varchar] (255) NULL,
    [CroppedAvatar] [varchar] (255) NULL,
    [PWType][int] NULL,
    [sso][int] NULL,
    [ResetToken][varchar](255) NULL,
    [TTPreChange] [int] DEFAULT (1) NOT NULL,
    [TTPostChange] [int] DEFAULT (1) NOT NULL,
    [UseMSTeamsNotifications] [tinyint] DEFAULT 0 NOT NULL,
    [MSTeamsEMailAddress] varchar (MAX) NULL,
    [MSTeamsToken] [varchar] (max) NULL,
    [MSTeamsRefreshToken] [varchar] (max) NULL,
    [MSTeamsTokenExpiryDate] [datetime] NULL,
    [NumberOfAttempts] [int]  DEFAULT 0 NOT NULL,
    [NextPossibleLogin] [datetime]  NULL,
    [pASupporterID] varchar (50) NULL,
    [paAccount] varchar (50) NULL,
    [email_verified_at] DATETIME NULL,
    [OAuth2AccessTokenHash] VARCHAR(64) NULL,
    [AccessToken] [varchar](255)  NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_FAQGroups] (
        [FAQDataID] [bigint] NOT NULL ,
        [GroupID] [bigint] NOT NULL
) ON [PRIMARY]
GO


ALTER TABLE [dbo].[hm_FAQData] WITH NOCHECK ADD
	CONSTRAINT [PK_FAQData] PRIMARY KEY  CLUSTERED
	(
		[FAQDataID]
	)  ON [PRIMARY]
GO
ALTER TABLE [dbo].[hm_FAQVisits] WITH NOCHECK ADD
	CONSTRAINT [PK_FAQVisits] PRIMARY KEY  CLUSTERED
	(
		[FAQDataID]
	)  ON [PRIMARY]
GO
ALTER TABLE [dbo].[hm_FAQVoting] WITH NOCHECK ADD
	CONSTRAINT [PK_FAQVoting] PRIMARY KEY  CLUSTERED
	(
		[FAQVotingID]
	)  ON [PRIMARY]
GO
ALTER TABLE [dbo].[hm_Groups] WITH NOCHECK ADD
	CONSTRAINT [PK_groups] PRIMARY KEY  CLUSTERED
	(
		[group_id]
	)  ON [PRIMARY]
GO
ALTER TABLE [dbo].[hm_News] WITH NOCHECK ADD
	CONSTRAINT [PK_News] PRIMARY KEY  CLUSTERED
	(
		[NewsID]
	)  ON [PRIMARY]
GO
ALTER TABLE [dbo].[hm_Rights] WITH NOCHECK ADD
	CONSTRAINT [PK_Rights] PRIMARY KEY  CLUSTERED
	(
		[RightID]
	)  ON [PRIMARY]
GO
ALTER TABLE [dbo].[hm_RightsSection] WITH NOCHECK ADD
	CONSTRAINT [PK_RightsSection] PRIMARY KEY  CLUSTERED
	(
		[RightsSectionID]
	)  ON [PRIMARY]
GO
ALTER TABLE [dbo].[hm_Structure] WITH NOCHECK ADD
	CONSTRAINT [PK_Structure_1] PRIMARY KEY  CLUSTERED
	(
		[id]
	)  ON [PRIMARY]
GO
ALTER TABLE [dbo].[hm_StructureTyp] WITH NOCHECK ADD
	CONSTRAINT [PK_structure] PRIMARY KEY  CLUSTERED
	(
		[styp_id]
	)  ON [PRIMARY]
GO
ALTER TABLE [dbo].[hm_Ticket] WITH NOCHECK ADD
	CONSTRAINT [PK_Ticket] PRIMARY KEY  CLUSTERED
	(
		[ID]
	)  ON [PRIMARY]
GO
ALTER TABLE [dbo].[hm_TicketEvent] WITH NOCHECK ADD
	CONSTRAINT [PK_TicketEvent] PRIMARY KEY  CLUSTERED
	(
		[ID]
	)  ON [PRIMARY]
GO
ALTER TABLE [dbo].[hm_TicketPrio] WITH NOCHECK ADD
	CONSTRAINT [PK_TicketPrio] PRIMARY KEY  CLUSTERED
	(
		[TicketPrioID]
	)  ON [PRIMARY]
GO
ALTER TABLE [dbo].[hm_TicketStatus] WITH NOCHECK ADD
	CONSTRAINT [PK_TicketStatus] PRIMARY KEY  CLUSTERED
	(
		[ID]
	)  ON [PRIMARY]
GO
ALTER TABLE [dbo].[hm_Users] WITH NOCHECK ADD
	CONSTRAINT [PK_users] PRIMARY KEY  CLUSTERED
	(
		[user_id]
	)  ON [PRIMARY]
GO
ALTER TABLE [dbo].[hm_TicketFilter] ADD
	CONSTRAINT [DF_TicketFilter_IsDefault] DEFAULT (0) FOR [IsDefault]
GO
ALTER TABLE [dbo].[hm_TicketFilter] ADD
	CONSTRAINT [DF_TicketFilter_EntriesPerPage] DEFAULT (20) FOR [EntriesPerPage]
GO
ALTER TABLE [dbo].[hm_Attachment] ADD
	CONSTRAINT [DF_Attachment_FileSize] DEFAULT (0) FOR [FileSize],
	CONSTRAINT [DF_Attachment_AttachmentTyp] DEFAULT (0) FOR [AttachmentTypID]
GO
ALTER TABLE [dbo].[hm_Categories] ADD
	CONSTRAINT [DF_Categories_published] DEFAULT (1) FOR [published]
GO
ALTER TABLE [dbo].[hm_ContactToEmployee] ADD
	CONSTRAINT [DF_ContactToEmployee_published] DEFAULT (0) FOR [published]
GO
ALTER TABLE [dbo].[hm_Contacts] ADD
	CONSTRAINT [DF_UserContact_published] DEFAULT (1) FOR [published],
	CONSTRAINT [DF_Contacts_important] DEFAULT (0) FOR [important]
GO
ALTER TABLE [dbo].[hm_FAQData] ADD
	CONSTRAINT [DF_FAQData_Active] DEFAULT (0) FOR [Active]
GO
ALTER TABLE [dbo].[hm_News] ADD
	CONSTRAINT [DF_News_Published] DEFAULT (0) FOR [Published]
GO
ALTER TABLE [dbo].[hm_Rights] ADD
	CONSTRAINT [DF_Rights_RightsOrder] DEFAULT (0) FOR [RightsOrder]
GO
ALTER TABLE [dbo].[hm_Ticket] ADD
	CONSTRAINT [DF_Ticket_Published] DEFAULT (1) FOR [Published]
GO
ALTER TABLE [dbo].[hm_Users] ADD
	CONSTRAINT [DF_user_enabled] DEFAULT (0) FOR [email],
	CONSTRAINT [DF_User_block] DEFAULT (0) FOR [block],
	CONSTRAINT [DF_User_sendEmail] DEFAULT (0) FOR [sendEmail],
	CONSTRAINT [DF_User_language_id] DEFAULT ('de') FOR [language_type],
	CONSTRAINT [DF_Users_WYSIWYG] DEFAULT (0) FOR [WYSIWYG]
GO
INSERT INTO [dbo].[hm_TicketPrio] (Descr, Ordering) VALUES ('Low', 1)
GO
INSERT INTO [dbo].[hm_TicketPrio] (Descr, Ordering) VALUES ('Medium', 2)
GO
INSERT INTO [dbo].[hm_TicketPrio] (Descr, Ordering) VALUES ('High', 3)
GO
INSERT INTO [dbo].[hm_TicketPrio] (Descr, Ordering) VALUES ('Urgent', 4)
GO
INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr) VALUES (1, 'OPEN')
GO
INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr) VALUES (2, 'ACTIVE')
GO
INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr) VALUES (3, 'CLOSED')
GO
INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr) VALUES (4, 'ASSIGNED')
GO
INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr) VALUES (5, 'CHANGED')
GO
INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr) VALUES (6, 'REOPENED')
GO
INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr) VALUES (7, 'VERIFIED')
GO
INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr) VALUES (8, 'ONHOLD')
GO
INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr) VALUES (9, 'DONE')
GO
INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr) VALUES (10, 'WAITING')
GO
INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr) VALUES (11, 'IMPOSSIBLE')
GO
INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr) VALUES (12, 'SEND')
GO
INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr) VALUES (13, 'RESPONSE')
GO
INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr) VALUES (14, 'CANCELED')
GO
INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr) VALUES (15, 'SKIPPED')
GO
INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr) VALUES (16, 'WAITING FOR ANSWER')
GO
INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr) VALUES (17, 'NEW')
GO
INSERT INTO [dbo].[hm_AttachmentTyp] (AttachmentTypName) VALUES ('Datei')
GO
INSERT INTO [dbo].[hm_AttachmentTyp] (AttachmentTypName) VALUES ('Hyperlink')
GO
INSERT INTO [dbo].[hm_AttachmentTyp] (AttachmentTypName) VALUES ('Notiz')
GO
INSERT INTO [dbo].[hm_RightsSection] (SectionName, SectionOrder) VALUES ('Tickets erstellen', 2)
GO
INSERT INTO [dbo].[hm_RightsSection] (SectionName, SectionOrder) VALUES ('Tickets bearbeiten', 3)
GO
INSERT INTO [dbo].[hm_RightsSection] (SectionName, SectionOrder) VALUES ('Reporting', 4)
GO
INSERT INTO [dbo].[hm_RightsSection] (SectionName, SectionOrder) VALUES ('Knowledgebase', 5)
GO
INSERT INTO [dbo].[hm_RightsSection] (SectionName, SectionOrder) VALUES ('Tickets', 1)
GO
INSERT INTO [dbo].[hm_RightsSection] (SectionName, SectionOrder) VALUES ('Firmenstruktur', 9)
GO
INSERT INTO [dbo].[hm_RightsSection] (SectionName, SectionOrder) VALUES ('Kategorien', 8)
GO
INSERT INTO [dbo].[hm_RightsSection] (SectionName, SectionOrder) VALUES ('Administration', 10)
GO
INSERT INTO [dbo].[hm_RightsSection] (SectionName, SectionOrder) VALUES ('Benutzer', 7)
GO
INSERT INTO [dbo].[hm_RightsSection] (SectionName, SectionOrder) VALUES ('Kontakte', 6)
GO
INSERT INTO [dbo].[hm_RightsSection] (SectionName, SectionOrder) VALUES ('Asset.Desk', 11)
GO
INSERT INTO [dbo].[hm_RightsSection] (SectionName, SectionOrder) VALUES ('ITIL', 12)
GO
INSERT INTO [dbo].[hm_RightsSection] (SectionName, SectionOrder) VALUES ('Sonstiges', 13)
GO
INSERT INTO [dbo].[hm_StructureTyp] (name) VALUES ('Standort')
GO
INSERT INTO [dbo].[hm_StructureTyp] (name) VALUES ('Abteilung')
GO
INSERT INTO [dbo].[hm_StructureTyp] (name) VALUES ('Raum')
GO
INSERT INTO [dbo].[hm_StructureTyp] (name) VALUES ('Kostenstelle')
GO
INSERT INTO [dbo].[hm_Users] (name, username, password, email, block, sendEmail, registerDate,
lastvisitDate, language_type, Deleted, PWType) VALUES ('Administrator', 'admin', '21232f297a57a5a743894a0e4a801fc3', 'heinzelmann@fair-computer.de',
0, 0, getdate(), getdate(), 'de', 0, 0)
GO
INSERT INTO [dbo].[hm_UserGroups] (user_id, group_id) VALUES (1, 1)
GO
INSERT INTO [dbo].[hm_Groups] (name) VALUES ('Administrator')
GO
INSERT INTO [dbo].[hm_Groups] (name) VALUES ('Chiefsupporter')
GO
INSERT INTO [dbo].[hm_Groups] (name) VALUES ('Supporter')
GO
INSERT INTO [dbo].[hm_Groups] (name) VALUES ('Anwender')
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (1, 'Neues Ticket anlegen', 1, 0)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (2, 'Kontakt ändern', 2, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (3, 'Ticketübersicht des Kontaktes', 2, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (4, 'Gruppe, Supporter ändern', 2, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (5, 'Kategorien ändern', 2, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (6, 'Fälligkeitstermin ändern', 2, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (7, 'Priorität ändern', 2, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (8, 'Ticketreferenz ändern', 2, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (9, 'Ticketbeschreibung ändern', 2, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (10, 'Neues Dokument erstellen', 2, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (11, 'Dokument entfernen', 2, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (12, 'Tickets zurückstellen', 2, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (13, 'Asset-Suche (Asset.Desk)', 2, 2)
GO

INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (15, 'Knowledgebaseeinträge erstellen', 4, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (16, 'Manueller E-Mail Versand an Kunden', 2, 1)
GO
INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (17, 'E-Mail an Kontakt anpassen', 2, 1);
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (19, 'Knowledgebase Administration', 4, 1)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (20, 'Ticket kategorisieren', 1, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (21, 'Fälligkeitstermin setzen', 1, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (22, 'Ticketpriorität setzen', 1, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (23, 'Ticket referenzieren', 1, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (24, 'Aufwand erfassen', 1, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (25, 'Schnellschuss zulassen', 1, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (26, 'Alle Tickets bearbeiten (Supporter)', 2, 0)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID) 
VALUES (126, 'Fachsupporter', 2, 0, 'Benutzer mit diesem Recht haben die Möglichkeit, in Tickets in denen Sie dem Interessierten Kreis zugeordnet sind Ticketbearbeitungen zuzufügen.<br/>Die Bearbeitungen sind nur intern sichtbar (Interne Notiz).', 23)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (27, 'Ticket wieder öffnen', 2, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (28, 'Nur Tickets der eigenen Gruppe anzeigen', 5, 6)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (29, 'Nur eigene Tickets anzeigen', 5, 5)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (30, 'Reporting anzeigen', 3, 1)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (31, 'Knowledgebasezugriff', 4, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (32, 'Firmenstruktur verwalten', 6, 1)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (33, 'Kategorien zuordnen', 7, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (34, 'Kategorien bearbeiten', 7, 1)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (35, 'Kategorien entfernen', 7, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (63, 'Nur Hauptkategorien anzeigen', 7, 4)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (36, 'Heinzelmann-Einstellungen', 8, 1)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (37, 'Eigenes Passwort ändern', 8, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (38, 'Gruppe bearbeiten', 9, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (39, 'Gruppe löschen', 9, 4)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (40, 'Benutzer bearbeiten', 9, 1)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (41, 'Benutzer löschen', 9, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (42, 'Kontakte verwalten', 10, 1)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (1005, 'Kontaktliste anzeigen', 10, 6)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (43, 'Kontakte löschen', 10, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (44, 'Kontakt einem Benutzer zuordnen', 10, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (45, 'Nur eigene Assets', 2, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (46, 'News bearbeiten', 2, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (47, 'Mitarbeiterimport', 10, 4)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (48, 'Kostenbetrachtung', 3, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (49, 'Supporter vorblenden', 2, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (50, 'Alle Tickets anzeigen', 5, 1)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (51, 'Kategorie 2 ausblenden', 2, 8)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (52, 'Benutzergruppe anzeigen', 2, 24)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (53, 'Benutzergruppe anlegen', 1, 10)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (54, 'Benutzergruppe bearbeiten', 2, 25)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (55, '+ Tickets der Gruppe(n)', 5, 10)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (56, '+ Tickets der eigenen Firma', 5, 10)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (57, 'Interne Notiz verfassen', 2, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (58, 'Nur Tickets der eigenen Firma anzeigen', 5, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (59, 'Geschlossene Tickets nicht anzeigen', 5, 11)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (60, 'Erweitertes Reporting anzeigen', 3, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (61, 'Asset-Reservierung bearbeiten', 11, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (100, 'Tickets löschen', 2, 8)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (101, '+ unkategorisierte Tickets', 5, 10)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (200, 'Kommerzielle Daten anzeigen (Asset)', 11, 1)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (201, 'Software anzeigen (Asset)', 11, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (202, 'Benutzerdefinierte Felder anzeigen (Asset)', 11, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (300, 'Tickets einstufen', 12, 1)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (301, 'ChangeRequest Manager (CRM)', 12, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (304, 'ChangeRequests anzeigen', 12, 5)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (400, 'Shoutboxzugriff', 13, 1)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (401, 'Ticketvorlagen erstellen', 13, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (402, 'Tickets aus Vorlagen erstellen', 13, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (62, 'Asset-Suche (Active Directory)', 2, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (522, 'Priorität anzeigen', 2, 11);
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (521, 'Fälligkeitstermin anzeigen', 2, 11);
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (524, 'Aufwand anzeigen', 2, 11);
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (412, 'Kalender anzeigen', 13, 6)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (65, 'Nur Tickets der eigenen Abteilung anzeigen', 5, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (66, '+ Tickets der eigenen Abteilung', 5, 10)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (67, 'Nur Tickets von Kontakten aus eigenen Gruppen', 5, 4)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (114, 'Ticketexport per Mail', 2, 30)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (115, 'Inventarnummer ändern', 2, 31);
GO
INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (116, 'Tickets nicht schließen', 2, 29);
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (210, 'Tickets kopieren', 1, 30);
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (211, 'Tickets verknüpfen', 2, 32)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (810, 'Formulare bearbeiten', 8, 3);
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (215, 'Gruppe ändern', 2, 4)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (216, 'Supporter ändern', 2, 4)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (217, 'Gruppe ist Pflichtfeld', 1, 4)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (218, 'Supporter ist Pflichtfeld', 1, 4)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (600, 'Beschreibung eigener Events ändern', 15, 1)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (601, 'EventDate eigener Events ändern', 15, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (602, 'Aufwand eigener Events ändern', 15, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (603, 'Eigene Event löschen', 15, 4)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (610, 'Beschreibung aller Events ändern', 16, 1)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (611, 'EventDate ändern', 16, 2)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (612, 'Aufwand ändern', 16, 3)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (613, 'Event löschen', 16, 4)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (410, 'Standardeinstellung Liste ändern', 13, 4)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (411, 'Benutzereinstellung Liste ändern', 13, 5)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (110, 'Status Erledigt setzen', 2, 27)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (111, 'Nur Erledigte Tickets schließen', 2, 28)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (112, 'Erledigte Tickets bearbeiten', 2, 29)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (113, 'Bearbeitungsart anzeigen', 2, 12)
GO
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID)
    VALUES (1006, 'Benutzerrollen verwalten', 4, 6, 'Benutzer mit diesem Recht dürfen die Rolle anderer Benutzer ändern', 2)
GO
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
    VALUES (235, 'Interessierten Kreis nicht anzeigen', 1, 24, 45, 'Benutzern mit diesem Recht wird die Auswahlliste zum Interessierten Kreis nicht angezeigt');
GO
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
    VALUES (240, 'Interne Notizen anzeigen', 1, 24, 50, 'Benutzer mit diesem Recht sehen die Internen Notizen auch wenn Sie nicht Supporter des Tickets sind.');
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 1)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 2)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 3)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 5)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 6)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 7)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 8)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 9)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 10)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 11)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 12)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 13)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 15)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 19)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 20)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 21)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 22)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 23)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 24)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 25)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 26)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 27)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 30)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 31)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 32)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 33)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 34)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 35)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 36)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 37)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 38)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 39)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 40)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 41)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 42)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 43)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 44)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 46)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 47)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 48)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 57)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 60)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 61)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 62)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 100)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 113)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 114)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 200)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 201)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 202)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 210)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 211)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 215)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 216)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 300)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 301)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 302)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 310)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 303)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 304)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 400)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 401)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 402)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 410)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 411)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 412)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 500)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 501)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 502)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 503)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 504)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 505)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 521)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 522)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 524)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 600)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 601)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 602)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 603)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 610)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 611)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 612)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 613)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 703)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 704)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 705)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 810)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 1006)
GO

INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 1)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 2)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 3)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 5)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 6)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 7)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 8)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 9)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 10)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 11)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 12)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 13)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 15)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 16)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 17)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 19)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 20)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 21)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 22)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 23)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 24)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 25)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 26)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 27)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 30)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 31)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 37)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 38)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 40)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 42)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 44)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 46)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 47)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 48)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 49)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 57)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 60)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 61)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 62)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 114)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 200)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 201)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 202)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 210)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 211)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 215)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 216)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 300)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 301)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 302)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 303)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 400)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 401)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 402)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 411)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 412)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 500)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 501)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 502)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 503)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 504)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 505)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 521)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 522)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 524)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 412)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 524)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 600)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 601)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 602)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 603)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 703)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 704)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 705)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (2, 810)
GO

INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 1)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 2)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 3)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 5)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 6)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 7)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 8)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 9)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 10)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 11)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 12)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 13)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 15)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 16)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 20)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 21)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 22)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 23)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 24)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 25)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 26)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 27)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 30)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 31)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 37)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 40)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 42)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 44)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 49)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 57)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 61)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 62)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 200)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 201)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 202)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 210)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 211)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 215)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 216)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 221)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 300)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 400)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 401)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 402)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 411)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 412)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 500)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 504)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 505)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 521)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 522)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 524)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (3, 600)

GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (4, 1)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (4, 3)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (4, 10)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (4, 11)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (4, 13)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (4, 20)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (4, 27)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (4, 29)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (4, 30)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (4, 31)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (4, 37)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (4, 45)
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (4, 402)
GO

INSERT INTO [dbo].[hm_News] (Title, Intro, Autor, CreateUser, CreateUserID, CreateDate, Published) VALUES
('FCSBEGR_1', 'FCSBEGR_2', 'FCS Fair Computer Systems GmbH', 'Administrator', 1, getdate(), 1)
GO
CREATE TABLE [dbo].[hm_Interest] (
	[user_id] [bigint] NULL ,
	[ticket_id] [bigint] NULL
) ON [PRIMARY]
GO
 CREATE  INDEX [IX_HMINTEREST] ON [dbo].[hm_Interest]([ticket_id], [user_id]) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_CalEvent] (
	[CalEventID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[CalEventStartDate] [datetime] NOT NULL ,
	[CalEventEndDate] [datetime] NULL ,
	[CalEventName] [varchar] (100)  NOT NULL ,
	[CalEventDescription] [text]  NULL ,
	[CalEventLocation] [varchar] (100)  NULL ,
	[CalEventStartDay] [tinyint] NOT NULL ,
	[CalEventStartMonth] [tinyint] NOT NULL ,
	[CalEventStartYear] [int] NOT NULL ,
	[CalEventEndDay] [tinyint] NULL ,
	[CalEventEndMonth] [tinyint] NULL ,
	[CalEventEndYear] [int] NULL ,
	[CalEventOwnerID] [bigint] NOT NULL ,
	[CalEventCreateDate] [datetime] NOT NULL ,
	[CalEventUpdateUserID] [bigint] NULL ,
	[CalEventUpdateDate] [datetime] NULL ,
	[CalEventUniqID] [varchar] (50)  NULL ,
	[CalEventDateDay] [tinyint] NOT NULL ,
	[CalEventRepeatMode] [tinyint] NOT NULL ,
	[CalEventRepeatEnd] [int] NULL ,
	[CalEventRepeatEvery] [tinyint] NOT NULL ,
	[CalEventRepeatConfig] [varchar] (20)  NULL ,
    [CalDeviceID] [bigint] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_CalEventGroups] (
	[CalEventID] [bigint] NOT NULL ,
	[CalEventGroupID] [bigint] NOT NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_CalEventUsers] (
	[CalEventID] [bigint] NOT NULL ,
	[CalEventUserID] [bigint] NOT NULL
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[hm_CalEvent] WITH NOCHECK ADD
	CONSTRAINT [PK_hm_CalEvent] PRIMARY KEY  CLUSTERED
	(
		[CalEventID]
	)  ON [PRIMARY]
GO
ALTER TABLE [dbo].[hm_CalEvent] ADD
	CONSTRAINT [DF_hm_CalEvent_CalEventDateDay] DEFAULT (0) FOR [CalEventDateDay],
	CONSTRAINT [DF_hm_CalEvent_CalEventRepeatMode] DEFAULT (0) FOR [CalEventRepeatMode],
	CONSTRAINT [DF_hm_CalEvent_CalEventRepeatEvery] DEFAULT (1) FOR [CalEventRepeatEvery]
GO
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Empployee]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
ALTER TABLE [dbo].[Employee] ADD
    [Company] [varchar] (100)  NULL
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_TicketHistory]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_TicketHistory] (
    [TicketHistoryID] [bigint] IDENTITY (1, 1) NOT NULL ,
    [ID] [bigint] NULL,
    [ContactID] [bigint] NULL ,
    [GroupID] [bigint] NULL ,
    [SupporterID] [bigint] NULL ,
    [TicketDesireDate] [datetime] NULL ,
    [OnHold] [datetime] NULL ,
    [TicketDescr] [varchar] (500)  NULL ,
    [TicketPrioID] [bigint] NULL ,
    [TicketStatusID] [int] NULL ,
    [TicketReferenzID] [bigint] NULL ,
    [CategoryID1] [bigint] NULL ,
    [CategoryID2] [bigint] NULL ,
    [Published] [tinyint] NULL ,
    [Expense] [int] NULL ,
    [CreateDate] [datetime] NULL ,
    [CreateUserID] [bigint] NULL ,
    [UpdateDate] [datetime] NULL ,
    [UpdateUserID] [bigint] NULL ,
    [EscalationLevel] [tinyint] NULL ,
    [EscalationDate] [datetime] NULL ,
    [EscalationType] [tinyint] NULL ,
    [UniqID] [varchar] (20)  NULL ,
    [EOSToDo] [tinyint] NULL,
    [Handover] [varchar] (255)  NULL
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysindexes] WHERE name = 'PK_TicketHistory')
ALTER TABLE [dbo].[hm_TicketHistory] WITH NOCHECK ADD
    CONSTRAINT [PK_TicketHistory] PRIMARY KEY  CLUSTERED
    (
        [TicketHistoryID]
    )  ON [PRIMARY]
GO
CREATE TRIGGER tr_TicketHistory ON hm_Ticket FOR INSERT, UPDATE
AS INSERT INTO hm_TicketHistory (ID, ContactID, GroupID, SupporterID,
    TicketDesireDate, OnHold, TicketDescr, TicketPrioID, TicketStatusID,
    TicketReferenzID, CategoryID1, CategoryID2, Published, Expense, CreateDate,
    CreateUserID, UpdateDate, UpdateUserID, EscalationLevel, EscalationDate,
    EscalationType, UniqID, EOSToDo, Handover)
  SELECT ID, ContactID, GroupID, SupporterID, TicketDesireDate, OnHold,
    TicketDescr, TicketPrioID, TicketStatusID, TicketReferenzID, CategoryID1,
    CategoryID2, Published, Expense, CreateDate, CreateUserID, UpdateDate,
    UpdateUserID, EscalationLevel, EscalationDate, EscalationType, UniqID,
    EOSToDo, Handover FROM inserted
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_TicketDesireDateChange]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_TicketDesireDateChange] (
    [TicketID] [bigint] NOT NULL ,
    [DesireDate] [datetime] NOT NULL ,
    [OnHold] [datetime] NULL ,
    [UserID] [bigint] NOT NULL,
    [CreateDate] [datetime] NULL
) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM [dbo].[sysindexes] WHERE name = 'PK_hm_TicketDesireDateChange')
ALTER TABLE [dbo].[hm_TicketDesireDateChange] WITH NOCHECK ADD
    CONSTRAINT [PK_hm_TicketDesireDateChange] PRIMARY KEY  CLUSTERED
    (
        [TicketID]
    )  ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_AuthLDAP]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE hm_AuthLDAP(
	[AuthLDAPTUID] [bigint] IDENTITY(1,1) NOT NULL,
	[LDAPType] [tinyint] NOT NULL CONSTRAINT [DF_hm_AuthLDAP_LDAPType]  DEFAULT ((1)),
	[Server] [varchar](50)  NOT NULL,
	[Port] [bigint] NULL,
	[Domain] [varchar](50)  NOT NULL,
	[BaseDN] [varchar](100)  NOT NULL,
	[LDAPUser] [varchar](200)  NULL,
	[LDAPPassword] [varchar](200)  NULL,
	[Ordering] [int] NULL,
	[Filter] [varchar](300) NULL
 ) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysindexes] WHERE name = 'PK_hm_AuthLDAP')
ALTER TABLE [dbo].[hm_AuthLDAP] WITH NOCHECK ADD
 CONSTRAINT [PK_hm_AuthLDAP] PRIMARY KEY CLUSTERED
(
	[AuthLDAPTUID] ASC
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_TicketTemplate]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_TicketTemplate] (
    [TicketTemplateID] [bigint] IDENTITY (1, 1) NOT NULL ,
    [ShortDescr] [varchar] (255)  NOT NULL ,
    [LongDescr] [text]  NULL ,
    [GroupID] [bigint] NULL,
    [SupporterID] [bigint] NULL,
    [Category1ID] [bigint] NULL,
    [Category2ID] [bigint] NULL,
    [PrioID] [bigint] NULL,
    [CreateDate] [datetime] NOT NULL,
    [CreateUserID] [bigint] NOT NULL,
    [UpdateDate] [datetime] NULL,
    [UpdateUserID] [bigint] NULL,
    [RepeatMode] [tinyint] NULL,
    [DaysOfWeek] [varchar] (20)  NULL ,
    [DayOfMonth] [tinyint] NULL ,
    [MonthOfYear] [tinyint] NULL ,
    [StartTimePoint] [varchar] (20)  NULL ,
    [OnetimePoint] [datetime] NULL ,
    [SerialTicket] [tinyint] NULL,
    [ContactID] [bigint] NULL,
    [LastCreation] [datetime] NULL,
    [RepeatDays] [int] NULL,
    [TypeID] [bigint] NULL,
    [title] varchar(100) NULL,
    [templatedescr] [text] NULL,
    [TemplateTags] [varchar] (max) NULL,
    [OrderNoInSelectlist] [int] DEFAULT 0 NOT NULL,
    [NextRepeat][datetime] NULL,
    IncidentImpactID [int] NULL,
    IncidentUrgencyID [int] NULL,
    isActive [bit] Default 1 NOT NULL
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_Shoutbox]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_Shoutbox] (
    [UserID] [bigint] NOT NULL,
    [Message] [text]  NOT NULL ,
    [CreateDate] [datetime] NOT NULL,
    [AskTheBot] [tinyint] DEFAULT(0) NOT NULL
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_ChangeRequest]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ChangeRequest](
    [ChangeRequestID] [bigint] IDENTITY(1,1) NOT NULL,
    [RequesterID] [bigint] NOT NULL,
    [DateOfApplication] [datetime] NOT NULL,
    [Initiator] [varchar](200)  NOT NULL,
    [Subject] [varchar](200)  NOT NULL,
    [ReminderNo] [int] NOT NULL,
    [Priority] [tinyint] NOT NULL,
    [Consequences] [tinyint] NOT NULL,
    [SystemsConcerned] [text]  NULL,
    [Summary] [text]  NULL,
    [Category1ID] [bigint] NOT NULL,
    [Category2ID] [bigint] NOT NULL,
    [Phase] [tinyint] NOT NULL,
    [CreateDate] [datetime] NOT NULL,
    [CreateUserID] [bigint] NOT NULL,
    [UpdateDate] [datetime] NULL,
    [UpdateUserID] [bigint] NULL,
    [DenyReason] [text]  NULL,
    [ProjectID] [int] NULL
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_ChangeRequestProgress]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ChangeRequestProgress](
    [ChangeRequestProgressID] [bigint] IDENTITY(1,1) NOT NULL,
    [ChangeRequestID] [bigint] NOT NULL,
    [ReminderNo] [int] NULL,
    [Priority] [tinyint] NULL,
    [Category1ID] [bigint] NULL,
    [Category2ID] [bigint] NULL,
    [RealizationPeriod] [int] NULL,
    [SystemPeriod] [int] NULL,
    [Consequences] [tinyint] NULL,
    [CABRequired] [tinyint] NULL,
    [Clearing] [tinyint] NULL,
    [Accepted] [tinyint] NULL,
    [Recovery] [tinyint] NULL,
    [BriefDowntime] [tinyint] NULL,
    [Successful] [tinyint] NULL,
    [SystemsConcerned] [text]  NULL,
    [Summary] [text]  NULL,
    [ProcessesConcerned] [text]  NULL,
    [CustomerConcerned] [text]  NULL,
    [CABUsers] [text]  NULL,
    [DenyReason] [text]  NULL,
    [DenyConsequences] [text]  NULL,
    [Release] [text]  NULL,
    [Comment] [text]  NULL,
    [RecoveryReason] [text]  NULL,
    [Testers] [text]  NULL,
    [FailedReason] [text]  NULL,
    [BuilderID] [bigint] NULL,
    [Phase] [tinyint] NULL,
    [RealizationDate] [datetime] NULL,
    [CABDeadline] [datetime] NULL,
    [ExpectInvestment] [float] NULL,
    [ClearingBy] [varchar](200)  NULL,
    [CreateDate] [datetime] NOT NULL,
    [CreateUserID] [bigint] NOT NULL,
    [UpdateDate] [datetime] NULL,
    [UpdateUserID] [bigint] NULL,
    [CabNotify] [tinyint] NULL
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_ChangeRequestAttachment]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ChangeRequestAttachment](
    [AttachmentID] [bigint] IDENTITY(1,1) NOT NULL,
    [ChangeRequestID] [bigint] NULL,
    [ReminderNo] [int] NULL,
    [Phase] [tinyint] NULL,
    [FileName] [varchar](255) NULL,
    [ChangedFileName] [varchar](255)  NULL,
    [FileExtension] [varchar](50)  NULL,
    [FileSize] [bigint] NULL,
    [Width] [int] NULL,
    [Height] [int] NULL,
    [CreateDate] [datetime] NOT NULL,
    [CreateUserID] [bigint] NOT NULL,
    [UpdateDate] [datetime] NULL,
    [UpdateUserID] [bigint] NULL,
    [Removed] [tinyint] NULL,
    [ShortDescr] [varchar](200)  NULL,
    [LongDescr] [text]  NULL,
    [URL] [varchar](255)  NULL
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[HelpdeskCost]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[HelpdeskCost](
    [HelpdeskCostID] [bigint] IDENTITY(1,1) NOT NULL,
    [DateService] [datetime] NOT NULL,
    [TicketNumber] [bigint] NOT NULL,
    [Description] [varchar] (255) NOT NULL ,
    [CostCenter] [varchar] (10) NULL ,
    [CompanyCodeID] int NULL,
    [Note] [varchar] (300) NULL ,
    [UnitCost] [decimal] (10,2) NOT NULL,
    [Amount] [decimal] (10,2) NOT NULL,
    [TotalCost] [decimal] (10,2) NOT NULL,
    [DeviceID] int NULL,
    [DomainName] [varchar] (50) NULL ,
    [HostName] [varchar] (50) NULL ,
    [Status] [int] NOT NULL,
    [CreateDate] [datetime] NOT NULL ,
    [IsDeleted] [int] NOT NULL,
    [DateProcessed] [datetime] NULL ,
    [EmployeeID] [int] NULL ,
    [ProcessRemark] [varchar] (100) NULL ,
    [DateDeleted] [datetime] NULL,
    [TicketEventID] [int] NULL,
    [CostGroupID] [int] NULL DEFAULT (0),
    [Cat1IDForCostGroup] [int] NULL,
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[HelpdeskCost] WITH NOCHECK ADD
	CONSTRAINT [PK_HelpdeskCost] PRIMARY KEY  CLUSTERED
	(
		[HelpdeskCostID]
	)  ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_ProjectTypeCostCenter]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ProjectTypeCostCenter](
    [ProjectTypeID] [bigint] NOT NULL,
    [CostCenterID] [bigint] NOT NULL
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_Project]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_Project](
    [ProjectID] [bigint] IDENTITY(1,1) NOT NULL,
    [ProjectTypeID] [bigint] NOT NULL,
    [ProjectName] [varchar](255) NOT NULL,
    [ProjectFactor] [decimal](10, 2) NULL,
    [Description] [text] NULL,
    [EmployeeID] [bigint] NULL,
    [CostCenterID] [bigint] NULL,
    [Active] [tinyint] NOT NULL CONSTRAINT [DF_hm_Project_Active]  DEFAULT ((1)),
    [StartDate] [datetime] NULL,
    [EndDate] [datetime] NULL,
    [EstimatedBudget] [decimal](10, 2) NULL,
    [UsedBudget] [decimal](10, 2) NULL,
    [CreateUserID] [bigint] NULL,
    [CreateUser] [varchar](100) NULL,
    [CreateDate] [datetime] NULL,
    [UpdateUserID] [bigint] NULL,
    [UpdateUser] [varchar](100) NULL,
    [UpdateDate] [datetime] NULL,
    [invoiced_1] [money] NULL,
    [invoiced_2] [money] NULL,
    [invoiced_3] [money] NULL,
    [invoiced_4] [money] NULL,
    [invoiced_5] [money] NULL,
    [invoiced_6] [money] NULL,
    [invoiced_7] [money] NULL,
    [invoiced_8] [money] NULL,
    [invoiced_9] [money] NULL,
    [invoiced_10] [money] NULL,
    [invoiced_11] [money] NULL,
    [invoiced_12] [money] NULL,
    [deduction_1] [money] NULL,
    [deduction_2] [money] NULL,
    [deduction_3] [money] NULL,
    [deduction_4] [money] NULL,
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_ProjectTicket]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ProjectTicket](
    [ProjectTicketID] [bigint] IDENTITY(1,1) NOT NULL,
    [ProjectID] [bigint] NOT NULL,
    [TicketID] [bigint] NOT NULL,
    [ProjectCosts] [decimal](10, 2) NULL,
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_RightsSection] WHERE RightsSectionID = 14)
    INSERT INTO [dbo].[hm_RightsSection] (SectionName, SectionOrder) VALUES ('Projektverwaltung', 14)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 500)
   INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder) VALUES (500, 'Zugriff auf Projektverwaltung', 14, 1)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 501)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder) VALUES (501, 'Projekte erstellen', 14, 2)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 502)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder) VALUES (502, 'Projekte bearbeiten', 14, 3)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 503)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder) VALUES (503, 'Projekttypen verwalten', 14, 4)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 504)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder) VALUES (504, 'Ticket einem Projekt zuordnen', 14, 5)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 505)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder) VALUES (505, 'Projektzuordnung bearbeiten', 14, 6)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_Project_Ref_Definition]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_Project_Ref_Definition](
    [ProjectRefDefinitionID] [bigint] IDENTITY(1,1) NOT NULL,
    [TableRef] [varchar](100) NOT NULL,
    [Active] [tinyint] NOT NULL,
    [SourceTable] [varchar](100) NOT NULL,
    [SourceIDField] [varchar](100) NOT NULL,
    [SourceNumberField] [varchar](100) NOT NULL,
    [SourceLabelField] [varchar](100) NOT NULL,
    [SourceNumberFieldRef] [varchar](100) NULL,
    [Name] [varchar](100) NOT NULL,
) ON [PRIMARY]

GO


IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_ProjectTypeLevel1]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ProjectTypeLevel1] (
    [ProjectTypeID] [bigint] NOT NULL,
    [Level1ID] [varchar](100) NOT NULL
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_ProjectLevel2]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ProjectLevel2] (
    [ProjectID] [bigint] NOT NULL,
    [Level2ID] [varchar](100) NOT NULL
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_ProjectType]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ProjectType](
    [ProjectTypeID] [bigint] IDENTITY(1,1) NOT NULL,
    [TypeName] [varchar](255) NOT NULL,
    [Description] [text] NULL,
    [Active] [tinyint] NOT NULL CONSTRAINT [DF_hm_ProjectType_Active]  DEFAULT ((1)),
    [Level2ID] [varchar](100) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_Project]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_Project](
    [ProjectID] [bigint] IDENTITY(1,1) NOT NULL,
    [ProjectTypeID] [bigint] NOT NULL,
    [ProjectName] [varchar](255) NOT NULL,
    [ProjectFactor] [decimal](10, 2) NULL,
    [Description] [text] NULL,
    [EmployeeID] [bigint] NULL,
    [CostCenterID] [bigint] NULL,
    [Active] [tinyint] NOT NULL CONSTRAINT [DF_hm_Project_Active]  DEFAULT ((1)),
    [StartDate] [datetime] NULL,
    [EndDate] [datetime] NULL,
    [EstimatedBudget] [decimal](10, 2) NULL,
    [UsedBudget] [decimal](10, 2) NULL,
    [CreateUserID] [bigint] NULL,
    [CreateUser] [varchar](100) NULL,
    [CreateDate] [datetime] NULL,
    [UpdateUserID] [bigint] NULL,
    [UpdateUser] [varchar](100) NULL,
    [UpdateDate] [datetime] NULL,
    [Level1ID] [varchar](100) NULL
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_ProjectTicket]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ProjectTicket](
    [ProjectID] [bigint] NOT NULL,
    [TicketID] [bigint] NOT NULL,
    [ProjectCosts] [decimal](10, 2) NULL,
    [Level2ID] [varchar](100) NOT NULL,
 CONSTRAINT [PK_hm_ProjectTicket] PRIMARY KEY CLUSTERED
(
	[TicketID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_ProjectTicket' AND COLUMN_NAME = 'Level2ID')
    ALTER TABLE [dbo].[hm_ProjectTicket] ADD [Level2ID] [varchar](100) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Project' AND COLUMN_NAME = 'Level1ID')
    ALTER TABLE [dbo].[hm_Project] ADD [Level1ID] [varchar](100) NULL
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_ProjectTicket' AND COLUMN_NAME = 'ProjectTicketID')
    ALTER TABLE [dbo].[hm_ProjectTicket] DROP COLUMN [ProjectTicketID]
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Users' AND COLUMN_NAME = 'ProjectCostRate')
    ALTER TABLE [dbo].[hm_Users] ADD [ProjectCostRate] [DECIMAL] (10,2) NULL
GO

if NOT exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_TicketFromEmail]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_TicketFromEmail] (
	[ID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[TicketID] [bigint] NOT NULL ,
	[MessageID] [varchar] (255)  NOT NULL ,
	[ImportStatus] [varchar] (10)  NULL ,
	[CreateDate] [datetime] NULL ,
	[CreateUserID] [bigint] NULL,
        [Active] [int] NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_Report](
      [ReportID] [bigint] IDENTITY(1,1) NOT NULL,
      [ReportName] [varchar](150) NOT NULL,
      [ReportView] [varchar](200) NOT NULL,
      [IsVisible] [tinyint] NOT NULL
 CONSTRAINT [PK_hm_Report] PRIMARY KEY CLUSTERED
(
      [ReportID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_ProcessingType]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ProcessingType] (
	[processingtype_id] [bigint] IDENTITY (1, 1) NOT NULL ,
	[description] [varchar] (50) NOT NULL ,
	[sort] [int]  NULL ,
	[created] [datetime] NOT NULL ,
	[updated] [datetime] NULL,
	[published] [tinyint] NOT NULL DEFAULT ((1))
) ON [PRIMARY]
GO


INSERT INTO [dbo].[hm_RightsSection] (SectionName, SectionOrder) VALUES ('Eigene Bearbeitungen', 15)
GO
INSERT INTO [dbo].[hm_RightsSection] (SectionName, SectionOrder) VALUES ('Alle Bearbeitungen', 16)
GO
INSERT INTO [dbo].[hm_RightsSection] (SectionName, SectionOrder) VALUES ('Workflow', 17)
GO
CREATE TABLE [dbo].[hm_Configuration] (
	[ConfigurationID] [int] IDENTITY (1, 1) NOT NULL ,
	[ConfigurationName] [varchar] (255)  NULL ,
	[Configuration] [text]  NULL
) ON [PRIMARY]
GO
INSERT INTO [dbo].[hm_Configuration] (ConfigurationName, Configuration) VALUES ('selectableLists', 'a:1:{s:10:"Ticketlist";a:3:{s:7:"Columns";s:23:"0,1,2,3,4,5,6,7,9,12,13";s:5:"Sort1";a:2:{s:6:"Column";i:9;s:9:"Direction";i:0;}s:5:"Sort2";a:2:{s:6:"Column";N;s:9:"Direction";i:0;}}}')
GO

CREATE TABLE [dbo].[hm_TimePeriod](
	[ID] [int] IDENTITY(5,1) NOT NULL ,
	[Name] [varchar](30) NOT NULL,
	[start_date] [int] NULL,
	[start_months] [int] NULL,
	[start_weeks] [int] NULL,
	[start_days] [int] NULL,
	[end_months] [int] NULL,
	[end_weeks] [int] NULL,
	[end_days] [int] NULL,
	[published] [tinyint] NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_TicketBasket](
	[UserID] [int] NOT NULL,
	[TicketID] [int] NOT NULL,
PRIMARY KEY CLUSTERED
(
	[UserID] ASC,
	[TicketID] ASC
)) ON [PRIMARY]

GO

CREATE TABLE [dbo].[hm_GroupLDAPGroup](
	[GroupID] [int] NOT NULL,
	[LDAPGroupDN] [varchar](500) NOT NULL,
	[Server] [varchar](500) NOT NULL,
 CONSTRAINT [PK_hm_GroupLDAPGroup] PRIMARY KEY CLUSTERED
(
	[GroupID] ASC,
	[Server] ASC
)) ON [PRIMARY]

GO

CREATE TABLE [dbo].[hm_LDAPDevices](
	[DeviceID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[location] [varchar](100) NULL,
	[descr] [varchar](1000) NULL,
	[OS] [varchar](100) NULL,
	[Type] [varchar](100) NULL,
	[objectguid] [varchar](32) NOT NULL,
	[dn] [varchar](200) NULL,
 CONSTRAINT [PK_hm_LDAPDevice] PRIMARY KEY CLUSTERED
(
	[DeviceID] ASC
)) ON [PRIMARY]

GO

CREATE TABLE [dbo].[hm_TicketLDAPDevice](
	[TicketID] [int] NULL,
	[DeviceID] [int] NOT NULL,
	[SessionID] [varchar](64) NULL
) ON [PRIMARY]

GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 703)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (703, 'Workflows verwalten', 17, 2)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 705)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (705, 'Workflows starten', 17, 6)
GO
CREATE TABLE [dbo].[hm_WFDef_Activity](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[WFDID] [int] NULL,
	[SessionID] [varchar](60) NULL,
	[Description] [varchar](100) NOT NULL,
	[TargetType] [tinyint] NULL,
	[TargetUserID] [int] NULL,
	[TargetGroupID] [int] NULL,
	[Duration] [float] NOT NULL,
	[ShowPrevInformations] [tinyint] NULL,
    [ShowDirectPrevActivity] [tinyint] NULL,    
	[NotificationType] [tinyint] NULL,
	[NotificationUserID] [int] NULL,
	[NotificationGroupID] [int] NULL,
	[TaskType] [tinyint] NOT NULL,
	[TaskText] [varchar](max) NULL,
	[TaskFormName] [varchar](50) NULL,
	[DesireTime] [float] NULL,
	[StartConID] [tinyint] NULL,
	[Starttime] [float] NULL,
	[UniqID] [varchar](32) NULL,
	[Form] [text] NULL,
        [ProjectID] [int] NULL,
        [sendReport] [int] NULL,
        [LoopsAllowed] [int] DEFAULT 0 NOT NULL,
        [AdressSourceActivity] [varchar](max) NULL,
        [ReminderTime] [varchar](5) NULL,
        [NoMessage] INT NOT NULL DEFAULT(0)
 CONSTRAINT [PK_hm_WFDef_Activity] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)) ON [PRIMARY]

GO

CREATE TABLE [dbo].[hm_WFDef_DependedActivitys](
	[ActivityID] [int] NOT NULL,
	[DependActivityID] [int] NOT NULL,
	[Field] varchar(500) NULL,
	[Value] varchar(500) NULL,
        [SessionID] [varchar](64) NULL,
        [OrCondition] [tinyint] DEFAULT 0 NOT NULL,
) ON [PRIMARY]

GO

CREATE TABLE [dbo].[hm_WFDefinitions](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Description] [varchar](300) NOT NULL,
	[groups] [int] NULL,
	[deleted] [tinyint] NULL,
	[published] [tinyint] NULL,
	[uniqID] [varchar](32) NULL,
        [ProjectID] [int] NULL,
 CONSTRAINT [PK_hm_WFDefinitions] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)) ON [PRIMARY]

GO

CREATE TABLE [dbo].[hm_WFInstanz](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[WFDID] [int] NULL,
	[Descr] [varchar](150) NOT NULL,
	[InitiatorID] [int] NOT NULL,
	[SubstitudeID] [int] NULL,
	[StartDate] [datetime] NULL,
	[EndDate] [datetime] NULL,
	[DateType] [tinyint] NOT NULL,
	[Active] [tinyint] NOT NULL,
	[CreateDate] [datetime] NOT NULL,
	[uniqid] [varchar](32) NULL,
        [ProjectID] [int] NULL,
        [RefLvl2ID] [int] NULL,
        [Canceled] [int] DEFAULT 0 NOT NULL,
        [UpdateDate] [datetime] NULL,
        [UpdateUserID] [bigint] NULL,
        [ContactID] [int] NULL
 CONSTRAINT [PK_hm_WFInstanz] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)) ON [PRIMARY]


GO

CREATE TABLE [dbo].[hm_WFActive_DepActivities](
	[AI_ID] [int] NOT NULL,
	[DepAI_ID] [int] NOT NULL,
	[Field] varchar(500) NULL,
	[Value] varchar(500) NULL,
        [OrCondition] [tinyint] DEFAULT 0 NOT NULL,
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[hm_WF_Activity](
	[ActivityID] [int] IDENTITY(1,1) NOT NULL,
	[WFIID] [int] NOT NULL,
	[DefActivityID] [int] NOT NULL,
	[TicketID] [int] NULL,
	[DescriptionName] [varchar](300) NULL,
	[InitiatorID] [int] NOT NULL,
	[GroupID] [int] NULL,
	[Duration] [float] NULL,
	[ShowOtherInformations] [tinyint] NULL,
    [ShowDirectPrevActivity] [tinyint] NULL,
	[TicketStatusID] [int] NOT NULL,
	[NotificationType] [tinyint] NULL,
	[TaskType] [int] NULL,
	[TaskText] [varchar](max) NULL,
	[Description] [varchar](300) NULL,
	[Expense] [int] NULL,
	[TargetType] [tinyint] NULL,
	[TargetUserID] [int] NULL,
	[TargetGroupID] [int] NULL,
	[NotificationUserID] [int] NULL,
	[NotificationGroupID] [int] NULL,
	[TaskFormName] [varchar](50) NULL,
	[StartConID] [tinyint] NULL,
	[Starttime] [float] NULL,
	[uniqID] [varchar](32) NULL,
	[FormData] [text] NULL,
	[Form] [text] NULL,
	[DesireTime] [float] NULL,
	[showTicket] [tinyint] NULL,
        [ProjectID] [int] NULL,
        [sendReport] [int] NULL,
        [EndDate] [datetime] NULL,
        [NoMessage] INT NOT NULL DEFAULT(0)
 CONSTRAINT [PK_hm_WF_Activity] PRIMARY KEY CLUSTERED
(
	[ActivityID] ASC
)) ON [PRIMARY]

GO

CREATE TABLE [dbo].[hm_TicketTemplateGroups](
	[TicketTemplateID] [int] NOT NULL,
	[GroupID] [int] NOT NULL,
 CONSTRAINT [PK_hm_TemplateGroups] PRIMARY KEY CLUSTERED
(
	[TicketTemplateID] ASC,
	[GroupID] ASC
)) ON [PRIMARY]

GO

CREATE TABLE [dbo].[hm_CostRate](
	[CostRateID] [int] IDENTITY(1,1) NOT NULL,
	[CreateDate] [datetime] NOT NULL,
	[CreateUserID] [int] NULL,
	[CostRate] [float] NOT NULL,
	[CostCurrencyID] [int] NOT NULL,
	[CostEntityID] [int] NOT NULL,
 CONSTRAINT [PK_CostRate] PRIMARY KEY CLUSTERED
(
	[CostRateID] ASC
)) ON [PRIMARY]

GO

CREATE TABLE [dbo].[hm_CostUsers](
	[UserID] [bigint] NOT NULL,
	[CostGroupID] [int] NOT NULL,
	[StartDate] [datetime] NOT NULL
) ON [PRIMARY]

GO

CREATE TABLE [dbo].[hm_CostCategories](
	[CategoryID] [bigint] NOT NULL,
	[CostGroupID] [int] NOT NULL,
	[StartDate] [datetime] NOT NULL
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[hm_CostCurrency](
	[CostCurrencyID] [int] IDENTITY(1,1) NOT NULL,
	[Symbol] [varchar](10) NULL,
	[Name] [varchar](255) NOT NULL,
	[Shortname] [varchar](10) NULL,
 CONSTRAINT [PK_hm_CostCurreny] PRIMARY KEY CLUSTERED
(
	[CostCurrencyID] ASC
))ON [PRIMARY]

GO
CREATE TABLE [dbo].[hm_CostDefault](
	[CostGroupID] [int] NOT NULL,
	[StartDate] [datetime] NOT NULL
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[hm_CostEntity](
	[CostEntityID] [int] IDENTITY(1,1) NOT NULL,
	[Description] [varchar](100) NOT NULL,
	[PerMinute] [float] NOT NULL,
 CONSTRAINT [PK_hm_CostEntity] PRIMARY KEY CLUSTERED
(
	[CostEntityID] ASC
)) ON [PRIMARY]


GO
INSERT INTO [dbo].[hm_CostCurrency] ([Symbol],[Name],[Shortname]) VALUES ('&#8364;', 'Euro', 'EUR')
GO
INSERT INTO [dbo].[hm_CostCurrency] ([Symbol],[Name],[Shortname]) VALUES ('&#36;', 'Dollar', 'USD')
GO
INSERT INTO [dbo].[hm_CostCurrency] ([Symbol],[Name],[Shortname]) VALUES ('CHF', 'Schweizer Franken', 'CHF')
GO

INSERT INTO [dbo].[hm_CostEntity] ([Description],[PerMinute]) VALUES ('Stunde' ,0.0166666666666667)

GO

CREATE TABLE [dbo].[hm_CostGroupRate](
	[CostGroupID] [int] NOT NULL,
	[CostRateID] [int] NOT NULL,
	[StartDate] [datetime] NOT NULL
) ON [PRIMARY]

GO
INSERT INTO HM_CostGroupRate (CostGroupID, CostRateID, StartDate) VALUES (0,0,'20000101')
GO
CREATE TABLE [dbo].[hm_CostGroup](
	[CostGroupID] [int] IDENTITY(1,1) NOT NULL,
	[Description] [varchar](100) NOT NULL,
	[Deleted] [tinyint] NULL,
 CONSTRAINT [PK_hm_CostGroup] PRIMARY KEY CLUSTERED
(
	[CostGroupID] ASC
)) ON [PRIMARY]


GO

CREATE TABLE [dbo].[hm_MailRecipientsForEvent](
	[RecipientID] [bigint] IDENTITY(1,1) NOT NULL,
	[TicketEventID] [bigint] NOT NULL,
	[eMail] [varchar](250) NOT NULL,
	[RealName] [varchar](250) NULL,
	[RecipientType] [varchar](10) NOT NULL
) ON [PRIMARY]

GO

CREATE TABLE [dbo].[hm_MailsSendTo](
	[MessageID] [bigint] IDENTITY(1,1) NOT NULL,
	[Recipient] [varchar](4000) NULL,
	[Title] [varchar](500) NOT NULL,
	[TicketEventID] [bigint] NOT NULL,
	[SentTo] [varchar](50) NOT NULL,
	[CreateDate] [datetime] NOT NULL,
 CONSTRAINT [PK_hm_MailsSendTo] PRIMARY KEY CLUSTERED
(
	[MessageID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

CREATE TABLE [dbo].[hm_MailToFromTicketEvent](
	[SendMailsForEventID] [bigint] IDENTITY(1,1) NOT NULL,
	[TicketEventID] [bigint] NOT NULL,
	[eMail] [varchar](250) NOT NULL,
	[RealName] [varchar](250) NULL,
	[AddressSource] [varchar](10) NOT NULL,
	[Service] [varchar](10) NULL
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[hm_ProjectCostTicketEvent](
	[ProjectID] [bigint] NOT NULL,
	[CostRatePerMinute] [float] NOT NULL,
	[TicketEventID] [bigint] NOT NULL,
	[Expense] [int] NOT NULL,
	[CreateDate] [datetime] NOT NULL,
	[UpdateDate] [datetime] NOT NULL,
	[CreateUserID] [int] NOT NULL,
	[UpdateUserID] [int] NOT NULL,
    [ProjectFactor] [float] NOT NULL DEFAULT (1),
 CONSTRAINT [PK_hm_ProjectCostTicketEvent] PRIMARY KEY CLUSTERED
(
	[ProjectID] ASC,
	[TicketEventID] ASC
)) ON [PRIMARY]

GO

CREATE TABLE [dbo].[hm_TicketReferences] (
	[TicketID] [bigint] NOT NULL ,
	[ConnectedTicketID] [bigint] NOT NULL ,
	[OnHoldFlag] [tinyint] NULL ,
        [sendMailToTicketID] [int] NULL,
        [sendMailToConnectedTicketID] [int] NULL,
 CONSTRAINT [PK_TicketReferences] PRIMARY KEY CLUSTERED
(
	[TicketID] ASC,
	[ConnectedTicketID] ASC
)) ON [PRIMARY]
GO

CREATE TABLE [dbo].[hm_MailAccounts](
	[MailAccountID] [int] NOT NULL IDENTITY(1,1),
	[MailServer] [varchar](300) NOT NULL,
	[MailUser] [varchar](300) NOT NULL,
	[MailPassword] [varchar](300) NOT NULL,
	[CategoryID] [int] NULL,
	[ContactID] [int] NULL,
	[SupporterID] [int] NULL,
	[GroupID] [int] NULL,
	[Active] [tinyint] NULL,
	[LeaveMessages] [tinyint] NULL,
    [maildomain] [varchar] (100) NULL,
    [SecureConnection] [varchar] (20) NULL,
    [ResponseToSender] [tinyint] NULL,
    [CatForSender] [tinyint] NULL,
    [checkAutoReplys] [tinyint] NULL,
    [UseIFrame] [tinyint] NULL,
    [TicketEditOnly] [tinyint] NULL,
    [subjectfilter] [tinyint] NULL,
    [replyaddress] [varchar] (100) NULL,
    [replyname] [varchar] (100) NULL,
    [replymailtemplateid] [int] NULL,
    [TicketTypeID] [bigint] NULL,
    [MandantenID] [bigint] NULL,
    [ReplyTpl4TicketEditOnly] [int] NULL,
    [clientid] [varchar](300) NULL,
    [tenantid] [varchar](300) NULL,
    [accesstoken] [varchar] (max) NULL,
    [MaildomainKeepInbox] [bit] NULL DEFAULT 0,
    [PWisEncrypted] [tinyint] DEFAULT 0 NOT NULL
 CONSTRAINT [PK_hm_MailAccounts] PRIMARY KEY CLUSTERED
(
	[MailAccountID] ASC
)
) ON [PRIMARY]

GO
CREATE TABLE [dbo].[hm_MailTicketxContacts](
	[contact_id] [int] NOT NULL,
	[user_id] [int] NOT NULL,
	[LastUseDate] [datetime] NOT NULL,
	[CountUses] [int] NOT NULL,
 CONSTRAINT [PK_MailTicketxContacts] PRIMARY KEY CLUSTERED
(
	[contact_id] ASC,
	[user_id] ASC
)) ON [PRIMARY]

GO

CREATE TABLE [dbo].[hm_TicketRequiredAction](
	[TicketID] [int] NOT NULL,
	[TicketEventID] [int] NOT NULL,
 CONSTRAINT [PK_TicketRequiredAction] PRIMARY KEY CLUSTERED
(
	[TicketID] ASC,
	[TicketEventID] ASC
)) ON [PRIMARY]

GO

CREATE TABLE [dbo].[hm_CategoryMailSender](
	[MailaddressID] [int] IDENTITY(1,1) NOT NULL,
	[MailAddress] [varchar](500) NOT NULL,
	[CategoryID] [int] NOT NULL,
        [GroupID] [int] NULL,
	[UpdateDate] [smalldatetime] NULL,
	[AddressOrSubject] [tinyint] NULL,
        [SupporterID] [int] NULL,
        [TicketTypeID] [int] NULL,
        [DesiredDate] [int] NULL,
        [TicketPrioID] [int] NULL,
 CONSTRAINT [PK_CategoryMailAddress] PRIMARY KEY CLUSTERED
(
	[MailaddressID] ASC
)) ON [PRIMARY]

GO
CREATE TABLE [dbo].[hm_SubjectFilters](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[SubjectFilter] [varchar](500)  NOT NULL,
	[Active] [tinyint] NULL,
 CONSTRAINT [PK_hm_SubjectFilters] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)) ON [PRIMARY]
GO

CREATE TABLE [dbo].[hm_TicketForm] (
        [TicketID] [bigint] NOT NULL ,
        [FormID] [bigint] NOT NULL,
 CONSTRAINT [PK_hm_TicketForm] PRIMARY KEY CLUSTERED
(
	[TicketID] ASC,
	[FormID] ASC
)) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_ServicesData] (
    [ServiceType] [varchar](20) NULL,
	[StartDate] [datetime] NULL,
	[Version] [varchar](10) NULL,
	[PathToService] [varchar](200) NULL,
	[ServiceActive] [tinyint] NULL
)
GO
/*SLA*/
CREATE TABLE [dbo].[hm_SLADataCache](
	[SLAID] [int] NOT NULL,
	[Tickets] [int] NOT NULL,
	[inTime] [int] NULL,
	[outTime] [int] NULL,
	[inTimePercent] [float] NULL,
	[outTimePercent] [float] NULL,
	[CacheTimestamp] [bigint] NULL,
	[StartDate] [datetime] NULL,
	[EndDate] [datetime] NULL,
 CONSTRAINT [PK_hm_SLADataCache_1] PRIMARY KEY CLUSTERED
(
	[SLAID] ASC
)) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_SLADefinition](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Description] [varchar](100) NOT NULL,
	[SLAObjectTable] [varchar](50) NOT NULL,
	[SLAObjectField] [varchar](50) NOT NULL,
	[SLAObjectID] [int] NOT NULL,
	[TimeType] [int] NOT NULL,
	[ValidRangeBegin] [datetime] NULL,
	[TargetStatus] [int] NULL,
	[SLATime] [int] NULL,
	[Active] [int] NULL,
	[UpdateDate] [datetime] NULL,
	[UpdateUserID] [int] NULL,
	[CreateDate] [datetime] NULL,
	[CreateUserID] [int] NULL,
 CONSTRAINT [PK_hm_SLADefinition] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)) ON [PRIMARY]

GO
CREATE TABLE [dbo].[hm_SLATimeTicket](
	[TicketID] [int] NOT NULL,
	[SLAID] [int] NOT NULL,
	[EndDate] [datetime] NULL,
	[StartDate] [datetime] NULL,
	[CacheMinutes] [bigint] NULL,
    [isOutTime] [tinyint] NULL,
 CONSTRAINT [PK_hm_SLATimeTicket] PRIMARY KEY CLUSTERED
(
	[TicketID] ASC,
	[SLAID] ASC
) ) ON [PRIMARY]

GO
CREATE TABLE [dbo].[hm_TicketOnHoldStartStop](
	[OnHoldID] [bigint] IDENTITY(1,1) NOT NULL,
	[TicketID] [bigint] NOT NULL,
	[OnHoldStart] [datetime] NOT NULL,
	[OnHoldStop] [datetime] NULL,
 CONSTRAINT [PK_hm_TicketOnHoldStartStop_1] PRIMARY KEY CLUSTERED
(
	[OnHoldID] ASC,
	[TicketID] ASC
)) ON [PRIMARY]
GO
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (302, 'SLA-Reports anzeigen', 3, 5)
GO
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (303, 'SLAs bearbeiten', 3, 5)

GO

CREATE TABLE [dbo].[hm_Company](
	[CompanyID] [bigint] IDENTITY(1,1) NOT NULL,
	[company] [varchar](100) NULL,
    [Deleted] [tinyint] NULL,
    [pAAccount] [varchar](32) NULL,
 CONSTRAINT [PK_hm_Company] PRIMARY KEY CLUSTERED
(
	[CompanyID] ASC
) ) ON [PRIMARY]
GO

CREATE TABLE [dbo].[hm_SLATimeCache](
	[StartDate] [datetime] NOT NULL,
	[EndDate] [datetime]NOT NULL,
	[Minutes] [bigint] NOT NULL,
 CONSTRAINT [PK_hm_SLATimeCache] PRIMARY KEY CLUSTERED
(
	[StartDate] ASC,
	[EndDate] ASC
) ) ON [PRIMARY]

GO

CREATE TABLE [dbo].[hm_TicketListCache](
	[UserID] [int] NOT NULL,
	[Timestamp] [int] NOT NULL,
	[HashValue] [varchar](32) NOT NULL,
	[TicketIDs] [text] NULL,
	[Part]	[int]	NOT NULL
 CONSTRAINT [PK_hm_TicketListCache] PRIMARY KEY CLUSTERED
(
	[UserID] ASC,
	[Timestamp] ASC,
	[HashValue] ASC,
	[Part] ASC
) ) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

CREATE TABLE [dbo].[hm_CRAttachment](
	[AttachmentID] [int] NOT NULL,
	[CRID] [int] NOT NULL,
 CONSTRAINT [PK_hm_CRAttachment] PRIMARY KEY CLUSTERED
(
	[AttachmentID] ASC,
	[CRID] ASC
)) ON [PRIMARY]

GO

IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_Tags]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_Tags](
	[ID] [bigint] IDENTITY(1,1) NOT NULL,
	[Tag] [varchar](100) NOT NULL
 CONSTRAINT [PK_hm_Tags] PRIMARY KEY CLUSTERED
(
	[ID] ASC,
    [Tag] ASC
) ) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_TicketTags]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_TicketTags](
	[TicketID] [bigint] NOT NULL,
	[TagID] [bigint] NOT NULL
 CONSTRAINT [PK_hm_TicketTags] PRIMARY KEY CLUSTERED
(
	[TicketID] ASC,
    [TagID] ASC
) ) ON [PRIMARY]

GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 219)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (219, 'Schlagworte', 2, 39);
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 220)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (220, 'Schlagworte bearbeiten', 2, 40);
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 221)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, RightsOrder)
    VALUES (221, 'Tickets archivieren', 2, 0);
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_TapiCalls]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_TapiCalls](
    [PhoneNo] [varchar](100) NOT NULL,
    [ContactID] [bigint] NULL,
    [UserID] [bigint] NOT NULL,
    [CallDate] [datetime] NOT NULL
 CONSTRAINT [PK_hm_TapiCalls] PRIMARY KEY CLUSTERED
(
	[PhoneNo] ASC,
    [UserID] ASC,
    [CallDate] ASC
) ) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_Styles](
	[CSSDefinition] [varchar](300) NOT NULL,
	[CSSValue] [varchar](4500) NOT NULL,
	[CreateDate] [datetime] DEFAULT Getdate() NOT NULL,
        [Active] [tinyint] DEFAULT 1 ,

 CONSTRAINT [PK_hm_Styles] PRIMARY KEY CLUSTERED
(
	[CSSDefinition] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_MailTemplates]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_MailTemplates](
        [TemplateID] [int] Identity(1, 1),
	[MailType] [varchar](300) NOT NULL,
        [Subject] [varchar](300) NULL,
	[Content] [text] NULL,
	[CreateDate] [datetime] DEFAULT Getdate() NOT NULL,
        [Active] [tinyint] DEFAULT 1,
        [TemplateTitle] [varchar] (50) NULL,
        [MandantID] [bigint] DEFAULT 0
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 68)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (68, '+ Tickets von anderen Supportern ausblenden', 5, 10)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 71)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder)
VALUES (71, 'Volle Kategorieauswahl', 2, 3)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_TapiCalls]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_TapiCalls](
    [PhoneNo] [varchar](100) NOT NULL,
    [ContactID] [bigint] NULL,
    [UserID] [bigint] NOT NULL,
    [CallDate] [datetime] NOT NULL
 CONSTRAINT [PK_hm_TapiCalls] PRIMARY KEY CLUSTERED
(
	[PhoneNo] ASC,
    [UserID] ASC,
    [CallDate] ASC
) ) ON [PRIMARY]

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_TicketFilter' AND COLUMN_NAME = 'FilterDescr')
    ALTER TABLE [dbo].[hm_TicketFilter] ADD [FilterDescr] [varchar](4500) NULL

GO

IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_TicketFilterGroups]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_TicketFilterGroups](
	[FilterID] [int] NOT NULL,
        [GroupID] [int] NOT NULL,
 CONSTRAINT [PK_hm_TFGroups] PRIMARY KEY CLUSTERED
(
	[FilterID] ASC,
        [GroupID] ASC
)) ON [PRIMARY]

GO

IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_TicketFilterUsers]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_TicketFilterUsers](
	[FilterID] [int] NOT NULL,
        [UserID] [int] NOT NULL,
        [isDefault] [tinyint] NULL,
        [isFavorit] [tinyint] NULL,
 CONSTRAINT [PK_hm_TFUsers] PRIMARY KEY CLUSTERED
(
	[FilterID] ASC,
        [UserID] ASC
)) ON [PRIMARY]

GO

IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_ContactMailAddress]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ContactMailAddress](
	[ContactID] [int] NOT NULL,
    [MailAddress] [varchar](300) NOT NULL,
    [Descr] [varchar](300) NULL,
 CONSTRAINT [PK_hm_ContactMailAddress] PRIMARY KEY CLUSTERED
(
	[ContactID] ASC,
    [MailAddress] ASC

)) ON [PRIMARY]

GO

IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_ContactPhoneNo]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ContactPhoneNo](
	[ContactID] [int] NOT NULL,
    [PhoneNo] [varchar](300) NOT NULL,
    [Descr] [varchar](300) NULL,
    [TapiPhoneNo] AS CAST(REPLACE(LTRIM(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(PhoneNo, '/', ''),'-', ''),')', ''),'(', ''),'+', ''),' ', ''),'0', ' ')),' ', '0') AS Varchar(300) )
 CONSTRAINT [PK_hm_ContactPhoneNo] PRIMARY KEY CLUSTERED
(
	[ContactID] ASC,
    [PhoneNo] ASC
)) ON [PRIMARY]

GO
UPDATE hm_RightsSection SET SectionName = 'Zugriffsmanagement', SectionOrder = 10 WHERE RightsSectionID = 1
GO
UPDATE hm_RightsSection SET SectionName = 'Tickets', SectionOrder = 20 WHERE RightsSectionID = 2
GO
UPDATE hm_RightsSection SET SectionName = 'Module', SectionOrder = 30 WHERE RightsSectionID = 3
GO
UPDATE hm_RightsSection SET SectionName = 'Administration', SectionOrder = 50 WHERE RightsSectionID = 4
GO
DELETE FROM hm_RightsSection WHERE RightsSectionID > 4
GO
DELETE FROM hm_RightsSegment
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (1, 'Asset.Desk', 10)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (2, 'Benutzer', 20)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (3, 'Dokumente', 30)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (4, 'Einstellungen', 40)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (5, 'Firmenstruktur', 50)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (6, 'Formulare', 60)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (7, 'Assets', 70)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (8, 'Gruppe / Supporter', 80)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (9, 'ITIL', 90)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (10, 'Kalender', 100)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (11, 'Kategorien', 110)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (12, 'Knowledgebase', 120)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (13, 'Kontakte', 130)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (14, 'Mailversand', 140)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (15, 'Nachträgliche Änderungen', 150)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (16, 'News', 160)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (17, 'Pflichtfelder', 170)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (18, 'Projekt', 180)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (19, 'Referenzieren', 190)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (20, 'Reporting', 200)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (21, 'Schließen', 210)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (22, 'Shoutbox', 220)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (23, 'Supporter', 630)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (24, 'Ticketdaten', 540)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (25, 'Ticketevents', 250)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (26, 'Ticketliste', 270)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (27, 'Tickets', 580)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (28, 'Tickets erstellen', 290)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (29, 'Ticketvorlagen', 300)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (30, 'Verwaltung', 310)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (31, 'Workflow', 320)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (33, 'Mandanten', 320)
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 0, SegmentID = 28, RightDescr = 'Benutzer mit diesem Recht dürfen selbst Tickets in HEINZELMANN erstellen.' WHERE RightID = 1
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 11, SegmentID = 24, RightDescr = 'Benutzer mit diesem Recht dürfen den Kontakt eines Tickets nachträglich ändern.' WHERE RightID = 2
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 9, SegmentID = 24, RightDescr = 'Dieses Recht blendet den Benutzern der entsprechenden Gruppen im Dialog für Ticketdetails ein Fernglas-Symbol neben dem eingetragenen Kontakt ein. Ein Klick auf dieses Symbol listet alle bisherigen Tickets des Kontakts auf.' WHERE RightID = 3
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 12, SegmentID = 11, RightDescr = 'Benutzer mit diesem Recht dürfen die Kategorisierung eines Tickets verändern.' WHERE RightID = 5
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 6, SegmentID = 24, RightDescr = 'Benutzer mit diesem Recht dürfen die Ticketfälligkeit verändern.' WHERE RightID = 6
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 9, SegmentID = 24, RightDescr = 'Benutzer mit diesem Recht dürfen Priorität des Tickets verändern.' WHERE RightID = 7
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 9, SegmentID = 19, RightDescr = 'Benutzer mit diesem Recht können Tickets einem Masterticket zuordnen oder die Zuordnung entfernen.' WHERE RightID = 8
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 9, SegmentID = 24, RightDescr = 'Benutzer mit diesem Recht dürfen den Betreff (Kurzbeschreibung) eines Tickets verändern, unter welcher das Ticket in allen Listen geführt wird.' WHERE RightID = 9
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 9, SegmentID = 3, RightDescr = 'Benutzer mit diesem Recht dürfen einem Ticket Anlagen beifügen.' WHERE RightID = 10
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 9, SegmentID = 3, RightDescr = 'Benutzer mit diesem Recht dürfen Anlagen eines Tickets wieder entfernen.' WHERE RightID = 11
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 9, SegmentID = 24, RightDescr = 'Benutzer mit diesem Recht können Tickets zurückstellen (Status ON HOLD)' WHERE RightID = 12
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 2, SegmentID = 7, RightDescr = 'Dieses Recht hat nur Wirkung in Verbindung mit einer Asset.Desk-Datenbank. Es erlaubt die Suche nach Assets innerhalb der Datenbank, welche einem Ticket hinzugefügt werden können.', RightName = 'Asset-Suche (Asset.Desk)' WHERE RightID = 13
GO
UPDATE hm_Rights SET RightsSectionID = 3, RightsOrder = 3, SegmentID = 12, RightDescr = 'Berechtigt zur Anlage noch nicht freigegebener KB-Einträge aus geschlossenen Tickets und ohne Ticketvorlage.' WHERE RightID = 15
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 1, SegmentID = 14, RightDescr = 'Ist dieses Recht gesetzt, so werden die Kontakte der betroffenen Gruppe nicht mehr automatisch per Email benachrichtigt, sobald eine Änderung am Ticket erfolgt. Eine Information kann dann bei Bedarf versandt werden, wenn das Ticket bearbeitet wird. Hierzu muss das Häkchen bei <strong>E-Mail an den Kontakt</strong> gesetzt werden ' WHERE RightID = 16
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 1, SegmentID = 14, RightDescr = 'Dieses Recht erweitert das vorhergehende Recht <strong>Manueller E-Mail Versand an Kunden</strong>.   Hat ein Benutzer beide Rechte, so erhält er beim Bearbeiten eines Tickets nach dem Aktivieren der Checkbox <strong>E-Mail an Kontakt</strong> ein erweitertes Fenster mit der Option, den Betreff der Nachricht sowie die Empfänger zu ändern.    Bei Ticketbearbeitungen werden die Auswahlfelder <strong>E-Mail an Kontakt</strong>, <strong>E-Mail an Support</strong>, <strong>CC</strong> und <strong>Betreff</strong>, die für die abzuschickende Mail angezeigt, in der die Empfänger und der Betreff bearbeitet werden können.  Die Eingabe mehrere Empfänger-Adressen ist ebenfalls möglich, diese müssen lediglich mit Komma oder Semikolon getrennt eingegeben werden. Des Weiteren kann der Benutzer durch das Aktivieren der Checkbox <strong>Nur diese Beschreibung mit Benutzerkontakt senden</strong> die Informationen in der Benachrichtigungsmail auf den Text dieser Änderung, die Daten des Benutzers und den Link zum Ticket reduzieren.' WHERE RightID = 17
GO
UPDATE hm_Rights SET RightsSectionID = 3, RightsOrder = 1, SegmentID = 12, RightDescr = 'Erlaubt alle Tätigkeiten in der Knowledgebase, insbesondere die Freigabe und Deaktivierung von Artikeln, Zuweisung und Erstellung von Rubriken.' WHERE RightID = 19
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 6, SegmentID = 11, RightDescr = 'Benutzer mit diesem Recht dürfen einem Ticket bei der Erstellung bis zu zwei Kategorien zuordnen.<strong>Allen Benutzern müssen diejenigen Kategorien zugeordnet sein, welche sie auswählen dürfen.</strong>' WHERE RightID = 20
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 6, SegmentID = 24, RightDescr = 'Benutzer mit diesem Recht dürfen einem Ticket einen gewünschten Fälligkeitstermin geben, der von der Standard-Fälligkeit abweicht.' WHERE RightID = 21
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 9, SegmentID = 24, RightName = 'Priorität setzen', RightDescr = 'Benutzer mit diesem Recht dürfen die Priorität eines Tickets selbst bestimmen.' WHERE RightID = 22
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 6, SegmentID = 19, RightDescr = 'Benutzer mit diesem Recht dürfen in einem Ticket ein anderes mit ähnlichem/gleichem Inhalt referenzieren. In der Datenbank wird dann eine Verbindung zwischen den beiden Tickets hergestellt.' WHERE RightID = 23
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 6, SegmentID = 24, RightDescr = 'Benutzer mit diesem Recht dürfen bei der Erstellung/Bearbeitung eines Tickets  ihren hierfür benötigten zeitlichen Aufwand erfassen.' WHERE RightID = 24
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 6, SegmentID = 21, RightDescr = 'Benutzer mit diesem Recht dürfen ein Ticket mit der Option <strong>Schnellschuss</strong> schon bei der Anlage schließen. Dies macht Sinn, wenn sich z.B. bereits während der Fehlerdiagnose / -suche, beim Gespräch mit dem Melder oder bei nachträglicher Ticketanlage eine Weiterverfolgung des Tickets unnötig wird, da der Vorfall bzw. das Problem bereits behoben ist.' WHERE RightID = 25
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 0, SegmentID = 23, RightDescr = 'Dieses Recht ist das zentrale Recht von HEINZELMANN. Es ermöglicht den Gruppen, die dieses Recht erhalten, Tickets für Dritte zu bearbeiten. Benutzer mit diesem Recht werden <strong>Supporter</strong> genannt.<strong>Durch die Lizenzierung von HEINZELMANN anhand der Supporter-Accounts entscheidet dieses Recht über den Verbrauch der HEINZELMANN Lizenzen</strong>' WHERE RightID = 26
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 9, SegmentID = 21, RightDescr = 'Ist dieses Recht gesetzt, dürfen die Mitglieder der betreffenden Gruppe geschlossene Tickets wieder öffnen, sofern sie die Rechte haben, diese anzuzeigen.' WHERE RightID = 27
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 5, SegmentID = 27, RightDescr = 'Benutzer mit diesem Recht sehen nur die Tickets, bei welchen er als Mitglied der zugewiesenen Gruppe, als Support-Mitarbeiter oder als Kontakt eingetragen ist.' WHERE RightID = 28
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 5, SegmentID = 27, RightDescr = 'Benutzer mit diesem Recht sehen nur die Tickets, bei welchen er als Support-Mitarbeiter und/oder Kontakt eingetragen ist.' WHERE RightID = 29
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 1, SegmentID = 20, RightDescr = 'Ermöglicht die Nutzung des Reiters <strong>Reporting</strong>. Der Umfang der angezeigten Reports wird über die übrigen Gruppenrechte gesteuert.' WHERE RightID = 30
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 2, SegmentID = 12, RightDescr = 'Benutzer mit diesem Recht können freigegebene KB-Einträge aufrufen und danach suchen.' WHERE RightID = 31
GO
UPDATE hm_Rights SET RightsSectionID = 4, RightsOrder = 1, SegmentID = 5, RightDescr = '<strong>Nur ohne Asset.Desk</strong>Benutzer mit diesem Recht dürfen unter <strong>Verwaltung > Struktur</strong> eine Abteilungs-struktur definieren.' WHERE RightID = 32
GO
UPDATE hm_Rights SET RightsSectionID = 3, RightsOrder = 2, SegmentID = 11, RightDescr = 'Berechtigt zur Zuordnung von Kategorien zu Benutzergruppen.' WHERE RightID = 33
GO
UPDATE hm_Rights SET RightsSectionID = 3, RightsOrder = 1, SegmentID = 11, RightDescr = 'Berechtigt zur Anlage und Bearbeitung von Kategorien in HEINZELMANN.' WHERE RightID = 34
GO
UPDATE hm_Rights SET RightsSectionID = 3, RightsOrder = 3, SegmentID = 11, RightDescr = 'Berechtigt zur Löschung von Kategorien.' WHERE RightID = 35
GO
UPDATE hm_Rights SET RightsSectionID = 4, RightsOrder = 1, SegmentID = 4, RightDescr = 'Berechtigt zur Anzeige und Bearbeitung der in HEINZELMANN zur Verfügung stehenden Einstellungsmöglichkeiten ' WHERE RightID = 36
GO
UPDATE hm_Rights SET RightsSectionID = 4, RightsOrder = 2, SegmentID = 2, RightDescr = 'Benutzer mit diesem Recht dürfen ihr Passwort zur Anmeldung an HEINZELMANN eigenständig festlegen oder ändern (<strong>Verwaltung > Eigenes Passwort ändern</strong>).' WHERE RightID = 37
GO
UPDATE hm_Rights SET RightsSectionID = 4, RightsOrder = 3, SegmentID = 2, RightDescr = 'Ermöglicht die Anlage und Bearbeitung von Gruppen sowie deren Berechtigungen.' WHERE RightID = 38
GO
UPDATE hm_Rights SET RightsSectionID = 4, RightsOrder = 4, SegmentID = 2, RightDescr = 'Berechtigt zur Löschung von Gruppen.' WHERE RightID = 39
GO
UPDATE hm_Rights SET RightsSectionID = 4, RightsOrder = 1, SegmentID = 2, RightDescr = 'Berechtigt zur Anlage und Bearbeitung von Benutzerkonten in HEINZELMANN.' WHERE RightID = 40
GO
UPDATE hm_Rights SET RightsSectionID = 4, RightsOrder = 2, SegmentID = 2, RightDescr = 'Berechtigt zur Löschung von Benutzerkonten.' WHERE RightID = 41
GO
UPDATE hm_Rights SET RightsSectionID = 4, RightsOrder = 1, SegmentID = 13, RightDescr = 'Berechtigt zur Anlage und Bearbeitung von Kontakten.' WHERE RightID = 42
GO
UPDATE hm_Rights SET RightsSectionID = 4, RightsOrder = 3, SegmentID = 13, RightDescr = 'Berechtigt zur Löschung von Kontakten.' WHERE RightID = 43
GO
UPDATE hm_Rights SET RightsSectionID = 4, RightsOrder = 2, SegmentID = 13, RightDescr = 'Benutzer mit diesem Recht dürfen Kontakte einem Benutzerkonto zuordnen.' WHERE RightID = 44
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 2, SegmentID = 7, RightDescr = 'Benutzer mit dieses Recht dürfen nur Assets auswählen / anzeigen lassen, die ihnen in Asset.Desk zugeordnet sind.<strong>Setzt das Recht Asset-Suche voraus</strong>', RightName = 'Nur eigene Assets' WHERE RightID = 45
GO
UPDATE hm_Rights SET RightsSectionID = 3, RightsOrder = 9, SegmentID = 16, RightDescr = 'Dieses Recht erlaubt die Bearbeitung und Einstellung von News auf der HEINZELMANN-Startseite.' WHERE RightID = 46
GO
UPDATE hm_Rights SET RightsSectionID = 4, RightsOrder = 4, SegmentID = 13, RightDescr = 'Berechtigt zum Kontaktimport und -update.' WHERE RightID = 47
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 2, SegmentID = 20, RightDescr = 'Zeigt in den Reports kostenbezogene Felder mit an.' WHERE RightID = 48
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 9, SegmentID = 24, RightDescr = 'Ist dieses Recht gesetzt, wird ein Ticketersteller, falls es sich um einen Supporter handelt, im Feld <strong>Supporter</strong> automatisch vorausgewählt.' WHERE RightID = 49
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 1, SegmentID = 27, RightDescr = 'Benutzer mit diesem Recht sehen alle Tickets die angelegt wurden, selbst wenn zudem eines der anderen Ticketrechte wie z.B. <strong>Nur Tickets der eigenen Gruppe anzeigen</strong> aktiv ist.  <strong>Das Recht zu erteilen ist dann sinnvoll, wenn ein Gesamtüberblick über alle Tickets erhalten werden soll, z.B. zu Reporting-Zwecken. Meistens geschieht dies für Benutzer, die selber keinen oder nur geringfügig Support leisten. Andernfalls kann der Effekt zu Problemen prozessualer und organisatorischer Natur führen.</strong>  Ein Anwendungsbeispiel für das Recht ist der Incident Manager. Mit dieser Option erhält er einen Einblick auf alle Tickets und kann so ggf. einer Eskalation zuvor kommen und seinen weiteren Aufgaben (Berichtserstellung) nachkommen. Er kann weiterhin Mitglied einer allgemeinen (Support-)Benutzergruppe sein und zusätzlich einer Management/Reporting-Gruppe mit dem Recht <strong>alle Tickets anzeigen</strong> zugeordnet werden.' WHERE RightID = 50
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 14, SegmentID = 24, RightDescr = 'Die Kategorie 2 wird für die Benutzer mit diesem Recht nicht angezeigt.' WHERE RightID = 51
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 30, SegmentID = 24, RightDescr = 'Blendet das Feld <strong>Gruppe</strong> in den Details eines Tickets für die betroffenen Benutzer ein. Benutzer sehen die zugewiesene Gruppe der Tickets.' WHERE RightID = 52
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 14, SegmentID = 24, RightDescr = 'Benutzer mit diesem Recht können einem Ticket bei Erstellung eine Benutzergruppe zuweisen, welche dafür zuständig sein soll.' WHERE RightID = 53
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 31, SegmentID = 24, RightDescr = 'Benutzer mit diesem Recht können in Tickets zusätzlich eine Benutzergruppe eintragen.' WHERE RightID = 54
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 10, SegmentID = 27, RightDescr = 'Benutzer mit diesem Recht sehen zusätzlich die Tickets, welche einer ihrer Benutzergruppen zugewiesen wurden.' WHERE RightID = 55
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 10, SegmentID = 27, RightDescr = 'Benutzer mit diesem Recht sehen zusätzlich die Tickets von Kontakten, die derselben Firma angehören.' WHERE RightID = 56
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 9, SegmentID = 25, RightDescr = 'Mit diesem Recht kann eine Ticketbearbeitung als intern gekennzeichnet werden. Der Eintrag ist daraufhin nur noch sichtbar für:  <ul>    <li>Den Ersteller des Eintrags</li>    <li>Den Benutzern aus der zugeordneten Supportgruppe</li>     <li>Den zugeordneten Support-Mitarbeiter</li>    <li>Den Benutzern aus der Administrator-Gruppe</li>  </ul> ' WHERE RightID = 57
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 2, SegmentID = 27, RightDescr = 'Benutzer mit diesem Recht sehen nur die Tickets, deren zugeordnete Kontakte derselben Firma wie der des Benutzerkontakts zugehören.' WHERE RightID = 58
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 11, SegmentID = 27, RightDescr = 'Den Benutzern mit diesem Recht werden geschlossene Tickets nicht angezeigt.' WHERE RightID = 59
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 3, SegmentID = 20, RightDescr = '<strong>Setzt das Zusatzmodul Erweitertes Reporting voraus</strong>Benutzer mit diesem Recht erhalten Zugriff auf das erweiterte Reporting mit frei definierbaren Views.' WHERE RightID = 60
GO
UPDATE hm_Rights SET RightsSectionID = 3, RightsOrder = 3, SegmentID = 10, RightDescr = '<strong>Setzt das Zusatzmodul Kalender voraus</strong>Benutzer mit diesem Recht können einem Kalender-Termin Assets per Reservierung zuordnen bzw. diese Reservierungen aufheben.', RightName = 'Asset-Reservierung bearbeiten' WHERE RightID = 61
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 2, SegmentID = 7, RightDescr = 'Erlaubt die Suche nach Assets innerhalb eines Active Directory, welche einem Ticket hinzugefügt werden können.' WHERE RightID = 62
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 4, SegmentID = 11, RightDescr = 'Benutzer mit diesem Recht können bei der Kategorie-Zuordnung eines Tickets nur aus den Haupt-, nicht aus deren Unterkategorien zu wählen.' WHERE RightID = 63
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 3, SegmentID = 27, RightDescr = 'Benutzer mit diesem Recht sehen nur die Tickets, deren zugeordnete Kontakte derselben Abteilung wie der des Benutzerkontakts zugehören.' WHERE RightID = 65
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 10, SegmentID = 27, RightDescr = 'Benutzer mit diesem Recht sehen zusätzlich die Tickets von Kontakten, die derselben Abteilung angehören.' WHERE RightID = 66
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 4, SegmentID = 27, RightDescr = 'Benutzer mit diesem Recht sehen alle Tickets, deren zugeordnete Kontakte mit Benutzern verknüpft sind, welche denselben Benutzergruppen zugehörig sind.' WHERE RightID = 67
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 10, SegmentID = 27, RightDescr = 'Tickets welche einem (anderen) Supporter zugeordnet sind werden nicht angezeigt.' WHERE RightID = 68
GO

UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 12, SegmentID = 11, RightDescr = 'Benutzer mit diesem Recht können im Ticket auch Kategorien wählen, die nicht der Benutzergruppe zugeordnet sind.   Das kann verwendet werden, wenn Benutzer generell nur über die Tickets Ihrer Kategorien benachrichtig werden sollen bzw. nur diese angezeigt bekommen, aber dennoch Tickets anderen Kategorien zuordnen können sollen.' WHERE RightID = 71
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 14, SegmentID = 30, RightDescr = 'Benutzer mit diesem Recht dürfen Tickets löschen. Die Option ist nach dem Aufruf der Details eines geschlossenen Tickets verfügbar.' WHERE RightID = 100
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 10, SegmentID = 27, RightDescr = 'Benutzer mit diesem Recht sehen zusätzlich Tickets, denen keine Kategorie zugeordnet ist.' WHERE RightID = 101
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 33, SegmentID = 21, RightDescr = 'Benutzer mit diesem Recht können Tickets auf den Status Erledigt (DONE) setzen.' WHERE RightID = 110
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 34, SegmentID = 21, RightDescr = 'Benutzer mit diesem Recht können Tickets mit dem Status Erledigt (DONE) schließen.' WHERE RightID = 111
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 35, SegmentID = 21, RightDescr = 'Benutzer mit diesem Recht können Tickets mit dem Status Erledigt (DONE) weiter bearbeiten.' WHERE RightID = 112
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 18, SegmentID = 24, RightDescr = 'Dieses Recht ermöglicht die Zuordnung einer Bearbeitungsart bei der Ticketerstellung oder -bearbeitung.' WHERE RightID = 113
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 36, SegmentID = 14, RightDescr = 'Kontakte lassen sich im Kontaktformular als Lieferant markieren. Diese Kontakte werden, wenn der Button <strong>E-Mail Ticketdaten</strong> in der Ticketdetailansicht geklickt wird, in einer Liste zur Empfängerauswahl angezeigt.Dieses Recht blendet diese Option in den Ticketdetails ein.' WHERE RightID = 114
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 37, SegmentID = 24, RightDescr = 'Benutzer können die im Ticket ausgewählte Inventarnummer ändern' WHERE RightID = 115
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 35, SegmentID = 21, RightDescr = 'Benutzern mit diesem Recht ist es nicht möglich, Tickets zu schließen.' WHERE RightID = 116
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 1, SegmentID = 1, RightDescr = 'Ohne dieses Recht werden dem Benutzer in der Detailansicht die kommerziellen Daten zum jeweiligen Asset nicht angezeigt.' WHERE RightID = 200
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 2, SegmentID = 1, RightDescr = 'Benutzer mit diesem Recht dürfen die auf dem ausgewählten Asset installierten Softwareprodukte (aus der <strong>Asset.Desk</strong>-Datenbank) einsehen.' WHERE RightID = 201
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 3, SegmentID = 1, RightDescr = 'Ermöglicht den Einblick in die benutzerdefinierten Angaben zu dem entsprechenden Asset aus der Datenbank.' WHERE RightID = 202
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 34, SegmentID = 28, RightDescr = 'Benutzer mit diesem Recht erhalten die entsprechende Option in der Ticketdetailansicht. Damit werden die Eingaben des kopierten Tickets in ein neues Ticket-Formular übernommen.' WHERE RightID = 210
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 38, SegmentID = 19, RightDescr = 'Benutzer mit diesem Recht können Tickets miteinander verknüpfen. ' WHERE RightID = 211
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 10, SegmentID = 24, RightDescr = 'Benutzer mit diesem Recht dürfen Tickets einer Gruppe zuweisen.' WHERE RightID = 215
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 10, SegmentID = 24, RightDescr = 'Benutzer mit diesem Recht dürfen Tickets einem Supporter zuweisen.' WHERE RightID = 216
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 8, SegmentID = 17, RightDescr = 'Dieses Recht macht die Angabe einer Gruppe bei der Ticketerstellung erforderlich.' WHERE RightID = 217
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 8, SegmentID = 17, RightDescr = 'Dieses Recht macht die Angabe eines Supporters bei der Ticketerstellung erforderlich.' WHERE RightID = 218
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 39, SegmentID = 24, RightDescr = 'Benutzer mit diesem Recht können Tickets mit Schlagworten (Tags) versehn oder die Verschlagwortung ändern.' WHERE RightID = 219
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 39, SegmentID = 30, RightDescr = 'Ermöglicht das Anlegen neuer Schlagworte (Tags) für die Ticketverschlagwortung' WHERE RightID = 220
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 0, SegmentID = 30, RightDescr = 'Ermöglicht den Benutzer Tickets als Archiviert zu markieren. Archivierte Tickets werden in der normalen suche nicht mehr berücksichtigt.' WHERE RightID = 221
GO


UPDATE hm_Rights SET RightsSectionID = 3, RightsOrder = 1, SegmentID = 9, RightDescr = 'Mit diesem Recht kann ein Anwender neue Change Requests einstellen oder ein geschlossenes Ticket in einen Change Request umwandeln.' WHERE RightID = 300
GO
UPDATE hm_Rights SET RightsSectionID = 3, RightsOrder = 2, SegmentID = 9, RightDescr = 'Benutzer mit diesem Recht können den ganzen Change Request-Prozess nach ITIL bearbeiten und abschließen.' WHERE RightID = 301
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 5, SegmentID = 20, RightDescr = 'Mach für den Benutzer mit diesem Recht den Menüpunkt <strong>SLA Reporting</strong> im <strong>Reporting</strong>-Bereich sichtbar.  Hier lassen sich individuelle Service Level Agreements auflisten und jeweils detailliert betrachten, sowie gefilterte Listen für Reporting Zwecke überprüfen.  Zudem kann die angezeigte Liste als Excel-Datei exportiert werden.' WHERE RightID = 302
GO
UPDATE hm_Rights SET RightsSectionID = 3, RightsOrder = 5, SegmentID = 20, RightDescr = 'Gibt einem Benutzer das Recht, SLAs über den Button <strong>Neuer SLA</strong> in der SLA Reporting-Liste anzulegen. Außerdem darf dieser Anwender aufgelistete SLA editieren oder löschen.' WHERE RightID = 303
GO
UPDATE hm_Rights SET RightsSectionID = 3, RightsOrder = 5, SegmentID = 9, RightDescr = 'Nur Benutzer mit diesem Recht können Change Requests sehen.' WHERE RightID = 304
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 1, SegmentID = 22, RightDescr = 'Mit diesem Recht wird dem Benutzer auf der Startseite die Shoutbox angezeigt. Über die Shoutbox hat er die Möglichkeit, mit anderen an HEINZELMANN angemeldeten Anwendern, die dieses Recht aufweisen, schnell zu kommunizieren.' WHERE RightID = 400
GO
UPDATE hm_Rights SET RightsSectionID = 4, RightsOrder = 2, SegmentID = 29, RightDescr = 'Dieses Recht erlaubt das Erstellen von Ticketvorlagen.' WHERE RightID = 401
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 3, SegmentID = 28, RightDescr = 'Dieses Recht erlaubt die Erstellung von Tickets aus definierten Ticketvorlagen.' WHERE RightID = 402
GO
UPDATE hm_Rights SET RightsSectionID = 4, RightsOrder = 4, SegmentID = 26, RightDescr = 'Benutzer mit diesem Recht dürfen die standardmäßig verwendeten Spalten der Ticketliste für alle Benutzer anpassen.' WHERE RightID = 410
GO
UPDATE hm_Rights SET RightsSectionID = 4, RightsOrder = 5, SegmentID = 26, RightDescr = 'Benutzer mit diesem Recht dürfen die verwendeten Spalten benutzerspezifisch anpassen.' WHERE RightID = 411
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 6, SegmentID = 10, RightDescr = '<strong>Setzt das Zusatzmodul Kalender voraus </strong>Benutzer mit diesem Recht können den Menüpunkt <strong>Kalender</strong> einsehen.' WHERE RightID = 412
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 1, SegmentID = 18, RightDescr = 'Dieses Recht erteilt den Zugriff auf die Projektliste und die damit verbundenen Tickets. Eine Änderung der Projekte ist nicht möglich' WHERE RightID = 500
GO
UPDATE hm_Rights SET RightsSectionID = 3, RightsOrder = 2, SegmentID = 18, RightDescr = 'Das Recht zur Erstellung eigener Projekte.' WHERE RightID = 501
GO
UPDATE hm_Rights SET RightsSectionID = 3, RightsOrder = 3, SegmentID = 18, RightDescr = 'Das Recht zur Bearbeitung von Projekten.' WHERE RightID = 502
GO
UPDATE hm_Rights SET RightsSectionID = 3, RightsOrder = 4, SegmentID = 18, RightDescr = 'Mit diesem Recht können die notwendigen Projekttypen für die Projekte verwaltet werden.' WHERE RightID = 503
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 5, SegmentID = 18, RightDescr = 'Dieses Recht erteilt die Möglichkeit, Tickets einem Projekt zuzuordnen. Um mit dem Modul Projekte arbeiten zu können, müssen Tickets einem Projekt zugewiesen werden können.' WHERE RightID = 504
GO
UPDATE hm_Rights SET RightsSectionID = 3, RightsOrder = 6, SegmentID = 18, RightDescr = 'Das Recht zur Änderung der Zuordnung eines Projekts.' WHERE RightID = 505
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 17, SegmentID = 24, RightDescr = 'Blendet das Feld <strong>Fälligkeit<strong> in den Ticketdetails ein. Benutzer können die Ticketfälligkeit setzen.' WHERE RightID = 521
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 17, SegmentID = 24, RightDescr = 'Blendet das Feld <strong>Priorität</strong> in den Ticketdetails ein. Benutzer können die Ticketpriorität ändern.' WHERE RightID = 522
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 17, SegmentID = 24, RightDescr = 'Hiermit wird in den Ticketdetails und bei der Ticketbearbeitung das Feld <strong>Aufwand</strong> eingeblendet. Benutzer können Aufwände erfassen.' WHERE RightID = 524
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 1, SegmentID = 15, RightDescr = 'Benutzer mit diesem Recht dürfen auch nachträglich noch Beschreibungen von ihren Events abändern.' WHERE RightID = 600
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 2, SegmentID = 15, RightDescr = 'Benutzer mit diesem Recht dürfen das Datum ihrer Events bearbeiten.' WHERE RightID = 601
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 3, SegmentID = 15, RightDescr = 'Benutzer mit diesem Recht dürfen auch nachträglich noch Aufwände von ihren Events ändern.' WHERE RightID = 602
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 4, SegmentID = 15, RightDescr = 'Benutzer mit diesem Recht dürfen ihre Events löschen.' WHERE RightID = 603
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 1, SegmentID = 15, RightDescr = 'Benutzer mit diesem Recht dürfen auch nachträglich noch Beschreibungen von allen Events abändern.' WHERE RightID = 610
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 2, SegmentID = 15, RightDescr = 'Benutzer mit diesem Recht dürfen das Datum eines Events bearbeiten.' WHERE RightID = 611
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 3, SegmentID = 15, RightDescr = 'Benutzer mit diesem Recht dürfen auch nachträglich noch Aufwände von Events ändern.' WHERE RightID = 612
GO
UPDATE hm_Rights SET RightsSectionID = 2, RightsOrder = 4, SegmentID = 15, RightDescr = 'Benutzer mit diesem Recht dürfen Events löschen.' WHERE RightID = 613
GO
UPDATE hm_Rights SET RightsSectionID = 3, RightsOrder = 2, SegmentID = 31, RightDescr = 'Dieses Recht erlaubt es, neue Workflows zu definieren oder bestehende Definitionen zu bearbeiten.' WHERE RightID = 703
GO
UPDATE hm_Rights SET RightsSectionID = 3, RightsOrder = 4, SegmentID = 31, RightDescr = 'Dieses Recht blendet das Untermenü <strong>Definition</strong> bei <strong>Workflow</strong> ein bzw. aus.' WHERE RightID = 704
GO
UPDATE hm_Rights SET RightsSectionID = 3, RightsOrder = 6, SegmentID = 31, RightDescr = 'Dieses Recht ermöglicht es Benutzern definierte Workflows zu starten.' WHERE RightID = 705
GO
UPDATE hm_Rights SET RightsSectionID = 4, RightsOrder = 3, SegmentID = 6, RightDescr = '<strong>Setzt das Zusatzmodul Formular voraus </strong>Berechtigt zur Anzeige und Bearbeitung von Formularen (<strong>Verwaltung > Formulare</strong>).' WHERE RightID = 810
GO
UPDATE hm_Rights SET RightsSectionID = 1, RightsOrder = 6, SegmentID = 13, RightDescr = 'Benutzer mit diesem Recht dürfen die gesamte Kontaktliste einsehen.' WHERE RightID = 1005
GO
CREATE TABLE [dbo].[hm_DashboardLinks](
	[LinkID] [bigint] IDENTITY (1,1),
	[URL] [varchar] (200) NOT NULL,
        [Descr] [varchar] (500) NULL,
        [Imagepath] [varchar] (200) NULL,
        [Active] [tinyint] NULL,
        [Position] [int] NOT NULL,
		[SubDescr] VARCHAR(255) NULL,
        [OpenInSameWindow] tinyint DEFAULT 0 NULL
		 CONSTRAINT [PK_hm_DashboardLinks] PRIMARY KEY CLUSTERED
(
	[LinkID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_Messages]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_Messages](
	[ID] [bigint] IDENTITY(1,1) NOT NULL,
        [Message] [varchar](1000) NULL,
	[CreateDate] [datetime] DEFAULT Getdate() NOT NULL,
        [Active] [tinyint] DEFAULT 1 ,
        [MessageTypeID] [tinyint] NOT NULL ,
        [CreateUserID] [int] NULL ,
 CONSTRAINT [PK_hm_Messages] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_UserMessages]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_UserMessages](
	[UserID] [int] NOT NULL,
        [MessageID] [bigint] NOT NULL,
	[ReadDate] [datetime]  NULL,
        [Showed] [tinyint]  NULL,
        [Active] [tinyint] DEFAULT 1 ,
        [delivered] [tinyint] DEFAULT NULL ,

 CONSTRAINT [PK_hm_UserMessages] PRIMARY KEY CLUSTERED
(
	[UserID] ASC,
        [MessageID] ASC
)) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_Snippet] (
	[ID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[Title] [varchar] (255) NOT NULL ,
	[Snippet] [varchar] (MAX) NOT NULL ,
	[ispublic] [smallint] NULL ,
        [CreateUserID] [int] NOT NULL
 CONSTRAINT [PK_hm_Snippet] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 224)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
    VALUES (224, 'Textbausteine veröffentlichen', 2, 50, 30, 'Der Benutzer kann allgemein sichtbare Textbausteine anlegen. Diese können auch von anderen Benutzern im Heinzelmann verwendet werden.');
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 225)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
    VALUES (225, 'Textbausteine verwalten', 2, 55, 30, 'Der Benutzer kann auch Textbausteine von anderen Benutzern löschen.');
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 230)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
    VALUES (230, 'Dokumentenpfad anzeigen', 2, 15, 3, 'Mit diesem Recht wird dem Benutzer der UNC-Pfad der Dokumente in der Dokumentenliste angezeigt.');
GO
CREATE TABLE [dbo].[hm_TicketDeviceDate](
	[TicketID] [int] NOT NULL,
	[DeviceID] [int] NOT NULL,
	[addDate] [datetime]  DEFAULT GETDATE() NOT NULL,
	[removeDate] [datetime] NULL
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_TicketContactDate](
	[TicketID] [int] NOT NULL,
	[ContactID] [int] NOT NULL,
	[addDate] [datetime] DEFAULT GETDATE() NULL,
	[removeDate] [datetime] NULL
) ON [PRIMARY]
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 405)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
    VALUES (405, 'Supporter-Online anzeigen', 1, 2, 22, 'Mit diesem Recht bekommen Benutzer die derzeit angemeldeten Supporter auf der Startseite angezeigt.');
GO
CREATE TABLE [dbo].[hm_TicketSupporter](
	[TicketID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[addDate] [datetime]  DEFAULT GETDATE() NOT NULL,
        [CreateUserID] [int]  DEFAULT 0 NULL,
        [removeDate] [datetime]  DEFAULT 0 NOT NULL,
 CONSTRAINT [PK_hm_TicketSupporter] PRIMARY KEY CLUSTERED
(
	[TicketID] ASC,
	[UserID] ASC,
        [removeDate] ASC
)
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_TicketGroup](
	[TicketID] [int] NOT NULL,
	[GroupID] [int] NOT NULL,
	[addDate] [datetime] DEFAULT GETDATE() NULL,
        [CreateUserID] [int]  DEFAULT 0 NULL,
        [removeDate] [datetime]  DEFAULT 0 NOT NULL,
 CONSTRAINT [PK_hm_TicketGroup] PRIMARY KEY CLUSTERED
(
	[TicketID] ASC,
	[GroupID] ASC,
        [removeDate] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 405)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
    VALUES (405, 'Supporter-Online anzeigen', 1, 2, 22, 'Mit diesem Recht bekommen Benutzer die derzeit angemeldeten Supporter auf der Startseite angezeigt.');
GO
CREATE TABLE [dbo].[hm_TicketTemplateSupporter](
	[TicketTemplateID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
 CONSTRAINT [PK_hm_TicketTempSupporter] PRIMARY KEY CLUSTERED
(
	[TicketTemplateID] ASC,
	[UserID] ASC
)
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_TicketTemplateGroup](
	[TicketTemplateID] [int] NOT NULL,
	[GroupID] [int] NOT NULL,
 CONSTRAINT [PK_hm_TicketTempGroup] PRIMARY KEY CLUSTERED
(
	[TicketTemplateID] ASC,
	[GroupID] ASC
)
) ON [PRIMARY]
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (32, 'ITIL Service', 320)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 820)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
    VALUES (820, 'Servicetickets anlegen', 3, 10, 32, 'Benutzer mit diesem Recht dürfen Servicetickets anlegen.');
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 821)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
    VALUES (821, 'Services verwalten', 3, 15, 32, 'Benutzer mit diesem Recht dürfen Services anlegen und bearbeiten.');
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_GroupRights] WHERE right_id = 820 AND group_id = 1)
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 820)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_GroupRights] WHERE right_id = 821 AND group_id = 1)
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 821)
GO
CREATE TABLE [dbo].[hm_TicketEscalation](
	[TicketID] [bigint] NOT NULL,
	[Esc_Lvl_1] [datetime] NULL,
	[Esc_Lvl_2] [datetime] NULL,
	[Esc_Lvl_3] [datetime] NULL,
	[Esc_Lvl_4] [datetime] NULL,
	[Esc_Lvl_5] [datetime] NULL,
	[currentlvl] [int] DEFAULT 0 NOT NULL,
	[reached_lvl_1] [datetime] NULL,
	[reached_lvl_2] [datetime] NULL,
	[reached_lvl_3] [datetime] NULL,
	[reached_lvl_4] [datetime] NULL,
	[reached_lvl_5] [datetime] NULL,
	[DesireTime] [datetime] NULL
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[hm_TicketEscalation]  WITH CHECK ADD  CONSTRAINT [FK_hm_TicketEscalation_hm_Ticket] FOREIGN KEY([TicketID])
REFERENCES [dbo].[hm_Ticket] ([ID])
GO

ALTER TABLE [dbo].[hm_TicketEscalation] CHECK CONSTRAINT [FK_hm_TicketEscalation_hm_Ticket]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_Mandant]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_Mandant](
	[ID] [bigint] IDENTITY(1,1) NOT NULL,
	[Mandant] [varchar](100) NULL,
	[Deleted] [tinyint] DEFAULT 0 NOT NULL,
	published tinyint NOT NULL DEFAULT 1,
	CompanyCode bigint NULL,
	created datetime NULL,
	updated datetime NULL,
        SendFromAdress varchar(max) NULL
 CONSTRAINT [PK_hm_Mandant] PRIMARY KEY CLUSTERED
(
	[ID] ASC
) ) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_TicketMandant]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE dbo.hm_TicketMandant
	(
	MandantenID bigint NOT NULL,
	TicketID bigint NOT NULL,
	Createdate datetime DEFAULT GETDATE() NOT NULL,
Active int DEFAULT 1 NOT NULL
	)  ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Mandant] WHERE ID = 0)
BEGIN
    Set Identity_Insert hm_Mandant On

    Insert INTO hm_Mandant (ID, Mandant, CompanyCode) Values (0, ' Ohne Mandant ', 0)
END
GO
  Set IDENTITY_INSERT hm_Mandant Off
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ServiceLvlAgreement]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ServiceLvlAgreement](
	[ID] [bigint] IDENTITY (1, 1) NOT NULL ,
        [ServiceID] [bigint] NOT NULL ,
        [ServiceLvlID] [bigint] NOT NULL ,
        [CompanyID] [bigint] NOT NULL ,
        [MandantID] [bigint] NULL ,
	[Department] varchar(300) NULL,
        [Startdate] datetime DEFAULT GETDATE() NOT NULL,
        [Enddate] datetime DEFAULT GETDATE() NOT NULL,
 CONSTRAINT [PK_hm_ServiceLvlAgreement] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_Service]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_Service](
	[ID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[Title] varchar(300) NOT NULL,
        [Descr] varchar(5000)  NULL,
        [Risks] varchar(5000)  NULL,
	[ServiceTypeID] [int] NULL,
        [Status] [tinyint] DEFAULT 0 NOT NULL,
        [Problem] [tinyint] DEFAULT 0 NOT NULL,
        [MaturityLevel] [tinyint] DEFAULT 1 NOT NULL,
        [CategoryID1] [int] NULL,
        [CategoryID2] [int] NULL,
        [CreateUserID] [bigint] NULL,
        [CreateDate] [datetime] DEFAULT GETDATE() NOT NULL,
        [UpdateUserID] [bigint] NULL,
        [UpdateDate] [datetime] DEFAULT GETDATE() NOT NULL,
	[ticketshortdescr] varchar(300) NULL,
        [ticketdescr] varchar(5000)  NULL,
 CONSTRAINT [PK_hm_Service] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ConnectedService]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ConnectedService](
	[ServiceID] [bigint] NOT NULL ,
        [ConnectedServiceID] [bigint] NOT NULL
 CONSTRAINT [PK_hm_ConnectedService] PRIMARY KEY CLUSTERED
(
	[ServiceID] ASC,
        [ConnectedServiceID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ServiceType]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ServiceType](
	[ID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[Title] varchar(300) NOT NULL,
        [Descr] varchar(5000) NOT NULL,
        [Active] [tinyint] DEFAULT 1 NOT NULL
 CONSTRAINT [PK_hm_ServiceType] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ServiceManagerGroup]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ServiceManagerGroup](
	[ServiceID] [bigint] NOT NULL ,
	[GroupID] [bigint] NOT NULL
 CONSTRAINT [PK_hm_ServiceManagerGroup] PRIMARY KEY CLUSTERED
(
	[ServiceID] ASC,
        [GroupID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ServicePManagerGroup]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ServicePManagerGroup](
	[ServiceID] [bigint] NOT NULL ,
	[GroupID] [bigint] NOT NULL
 CONSTRAINT [PK_hm_ServicePManagerGroup] PRIMARY KEY CLUSTERED
(
	[ServiceID] ASC,
        [GroupID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ServiceIManagerGroup]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ServiceIManagerGroup](
	[ServiceID] [bigint] NOT NULL ,
	[GroupID] [bigint] NOT NULL
 CONSTRAINT [PK_hm_ServiceIManagerGroup] PRIMARY KEY CLUSTERED
(
	[ServiceID] ASC,
        [GroupID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ServiceEscalationGroup]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ServiceEscalationGroup](
	[ServiceID] [bigint] NOT NULL ,
	[EscalationLvl] [int] NOT NULL,
        [GroupID] [bigint] NOT NULL,
        [sendMail] [tinyint] DEFAULT 1 NOT NULL
 CONSTRAINT [PK_hm_ServiceEscalationGroup] PRIMARY KEY CLUSTERED
(
	[ServiceID] ASC,
        [EscalationLvl] ASC,
        [GroupID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ServiceLog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ServiceLog](
        [ID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[ServiceID] [bigint] NOT NULL ,
        [CreateUserID] [bigint] NULL,
        [CreateDate] [datetime] DEFAULT GETDATE() NOT NULL,
        [Message] varchar(5000) NULL
 CONSTRAINT [PK_hm_ServiceLog] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_TicketPrio' AND COLUMN_NAME = 'Color')
ALTER TABLE [dbo].[hm_TicketPrio] ADD
    [Color] varchar(50) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_TicketPrio' AND COLUMN_NAME = 'published')
ALTER TABLE [dbo].[hm_TicketPrio] ADD
    [published] tinyint DEFAULT 1 NOT NULL
GO
IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_WorkflowDefActivitys]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_WorkflowDefActivitys](
	[WFID] [int] NOT NULL,
	[ActivityID] [int] NOT NULL,
	[SessionID] [varchar](100) NULL,
 CONSTRAINT [PK_hm_WorkflowDefActivitys] PRIMARY KEY CLUSTERED
(
	[WFID] ASC
)) ON [PRIMARY]

GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_CategoryForms]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
    CREATE TABLE [dbo].[hm_CategoryForms] (
        [FormID] [bigint] IDENTITY (1, 1) NOT NULL ,
        [TableName] [varchar] (100) ,
        [FormName] [varchar] (100) NOT NULL ,
        [CategoryID] [bigint] NOT NULL ,
        [Published] [tinyint] NOT NULL ,
        [FormData] [text] ,
        [Deleted] [tinyint] NOT NULL ,
        [CreateDate] [datetime] NULL ,
        [CreateUserID] [bigint] NULL ,
        [UpdateDate] [datetime] NULL ,
        [UpdateUserID] [bigint] NULL ,
        [Required] [tinyint] NULL,
        [TicketTemplateID] [int] NULL,
        [SequenceName] [varchar] (100) ,
        [TriggerName] [varchar] (100)
    ) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_ServiceLevel](
	[ID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[Title] varchar(300) NOT NULL,
        [PrioID] int NULL,
        [Mon] [tinyint] DEFAULT 0 NOT NULL ,
        [Tue] [tinyint] DEFAULT 0 NOT NULL ,
        [Wed] [tinyint] DEFAULT 0 NOT NULL ,
        [Thu] [tinyint] DEFAULT 0 NOT NULL ,
        [Fri] [tinyint] DEFAULT 0 NOT NULL ,
        [Sat] [tinyint] DEFAULT 0 NOT NULL ,
        [Sun] [tinyint] DEFAULT 0 NOT NULL ,
        [MonFrom1] varchar(5) NULL,
        [MonUntil1] varchar(5) NULL,
        [MonFrom2] varchar(5) NULL,
        [MonUntil2] varchar(5) NULL,
        [TueFrom1] varchar(5) NULL,
        [TueUntil1] varchar(5) NULL,
        [TueFrom2] varchar(5) NULL,
        [TueUntil2] varchar(5) NULL,
        [WedFrom1] varchar(5) NULL,
        [WedUntil1] varchar(5) NULL,
        [WedFrom2] varchar(5) NULL,
        [WedUntil2] varchar(5) NULL,
        [ThuFrom1] varchar(5) NULL,
        [ThuUntil1] varchar(5) NULL,
        [ThuFrom2] varchar(5) NULL,
        [ThuUntil2] varchar(5) NULL,
        [FriFrom1] varchar(5) NULL,
        [FriUntil1] varchar(5) NULL,
        [FriFrom2] varchar(5) NULL,
        [FriUntil2] varchar(5) NULL,
        [SatFrom1] varchar(5) NULL,
        [SatUntil1] varchar(5) NULL,
        [SatFrom2] varchar(5) NULL,
        [SatUntil2] varchar(5) NULL,
        [SunFrom1] varchar(5) NULL,
        [SunUntil1] varchar(5) NULL,
        [SunFrom2] varchar(5) NULL,
        [SunUntil2] varchar(5) NULL,
	[DesireTime] [int] DEFAULT 0 NOT NULL,
	[esclvl_1] [int] DEFAULT 0 NOT NULL,
	[esclvl_2] [int] DEFAULT 0 NOT NULL,
	[esclvl_3] [int] DEFAULT 0 NOT NULL,
	[esclvl_4] [int] DEFAULT 0 NOT NULL,
	[esclvl_5] [int] DEFAULT 0 NOT NULL,
 CONSTRAINT [PK_hm_ServiceLevel] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_ServiceLevel] WHERE ID = 1)
INSERT INTO hm_ServiceLevel (Title, PrioID, DesireTime, esclvl_1, esclvl_2, esclvl_3, esclvl_4, esclvl_5, Mon , Tue , Wed , Thu , Fri , Sat , Sun,MonFrom1, MonUntil1, MonFrom2, MonUntil2, TueFrom1, TueUntil1, TueFrom2, TueUntil2, WedFrom1, WedUntil1, WedFrom2, WedUntil2, ThuFrom1, ThuUntil1, ThuFrom2, ThuUntil2, FriFrom1, FriUntil1, FriFrom2, FriUntil2, SatFrom1, SatUntil1, SatFrom2, SatUntil2, SunFrom1, SunUntil1, SunFrom2, SunUntil2) VALUES ( 'Bronze', 1, 16, 240, 480, 720, 960, 1200, 1, 1, 1, 1, 1, 0, 0, '09:00', '12:00', '13:00', '17:00', '09:00', '12:00', '13:00', '17:00', '09:00', '12:00', '13:00', '17:00', '09:00', '12:00', '13:00', '17:00', '09:00', '12:00', '13:00', '17:00', '', '', '', '', '', '', '', '')
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_ServiceLevel] WHERE ID = 2)
INSERT INTO hm_ServiceLevel (Title, PrioID, DesireTime, esclvl_1, esclvl_2, esclvl_3, esclvl_4, esclvl_5, Mon , Tue , Wed , Thu , Fri , Sat , Sun,MonFrom1, MonUntil1, MonFrom2, MonUntil2, TueFrom1, TueUntil1, TueFrom2, TueUntil2, WedFrom1, WedUntil1, WedFrom2, WedUntil2, ThuFrom1, ThuUntil1, ThuFrom2, ThuUntil2, FriFrom1, FriUntil1, FriFrom2, FriUntil2, SatFrom1, SatUntil1, SatFrom2, SatUntil2, SunFrom1, SunUntil1, SunFrom2, SunUntil2) VALUES ( 'Silber', 2, 10, 120, 300, 480, 600, 720, 1, 1, 1, 1, 1, 0, 0, '08:00', '', '', '17:00', '08:00', '', '', '17:00', '08:00', '', '', '17:00', '08:00', '', '', '17:00', '08:00', '', '', '17:00', '', '', '', '', '', '', '', '')
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_ServiceLevel] WHERE ID = 3)
INSERT INTO hm_ServiceLevel (Title, PrioID, DesireTime, esclvl_1, esclvl_2, esclvl_3, esclvl_4, esclvl_5, Mon , Tue , Wed , Thu , Fri , Sat , Sun,MonFrom1, MonUntil1, MonFrom2, MonUntil2, TueFrom1, TueUntil1, TueFrom2, TueUntil2, WedFrom1, WedUntil1, WedFrom2, WedUntil2, ThuFrom1, ThuUntil1, ThuFrom2, ThuUntil2, FriFrom1, FriUntil1, FriFrom2, FriUntil2, SatFrom1, SatUntil1, SatFrom2, SatUntil2, SunFrom1, SunUntil1, SunFrom2, SunUntil2) VALUES ( 'Gold', 3, 8, 60, 180, 360, 480, 600, 1, 1, 1, 1, 1, 0, 0, '08:00', '', '', '17:00', '08:00', '', '', '17:00', '08:00', '', '', '17:00', '08:00', '', '', '17:00', '08:00', '', '', '17:00', '', '', '', '', '', '', '', '')
GO
/*Backup der ADef-FormularDefinitionen */
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_WFActDefFormHistory]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_WFActDefFormHistory](
	[ActivityDefID] [int] NOT NULL,
	[Form] varchar(max) NULL,
	[UpdateDate] [datetime] DEFAULT GETDATE() NULL
) ON [PRIMARY]
GO
IF EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[tr_WFActDefFormHistory]') AND OBJECTPROPERTY(id, N'IsTrigger') = 1)
DROP TRIGGER tr_WFActDefFormHistory
GO
CREATE TRIGGER tr_WFActDefFormHistory on hm_WFDef_Activity
AFTER UPDATE
AS
insert into
   hm_WFActDefFormHistory (ActivityDefID, Form, UpdateDate)
select
   i.ID, t.Form, getDate()
from
   inserted as i,
   hm_WFDef_Activity as t
where
   i.id = t.id
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_WFGroups]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_WFGroups](
	[WFDID] [int] NOT NULL,
	[GroupID] [int] NOT NULL,
	[addDate] [datetime] DEFAULT GETDATE() NULL,
 CONSTRAINT [PK_hm_WFGroups] PRIMARY KEY CLUSTERED
(
	[WFDID] ASC,
	[GroupID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_WFReportTabSet]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_WFReportTabSet](
	[WFDID] [int] NOT NULL,
	[user_id] [bigint] NOT NULL,
	[data] varchar(max) NULL,
 CONSTRAINT [PK_hm_WFReportTabSet] PRIMARY KEY CLUSTERED
(
	[WFDID] ASC,
	[user_id] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_TicketLocation]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE dbo.hm_TicketLocation
	(
	TicketID bigint NOT NULL,
	Active tinyint NOT NULL,
	Createuserid bigint NOT NULL,
	Createdate datetime NOT NULL,
	RoomID bigint NOT NULL,
	FloorID bigint NOT NULL,
	BuildingID bigint NOT NULL,
	LocationID bigint NOT NULL,
        LocationLogGroupID bigint NULL
	)  ON [PRIMARY]
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 506)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID) VALUES (506, 'Kostenbeträge erfassen', 3, 8, 'Benutzer mit diesem Recht können bei einer Ticketbearbeitung direkt Beträge in das zugeordnete Projet buchen.', 18)
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_MandantGroups]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_MandantGroups](
	MandantenID int NOT NULL,
	GroupID int NOT NULL
 CONSTRAINT [PK_hm_MandantGroups] PRIMARY KEY CLUSTERED
(
	[MandantenID] ASC,
	[GroupID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 850)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID) VALUES (850, 'Mandanten verwalten', 3, 10, 'Benutzer mit diesem Recht können Mandanten anlegen, zuweisen und bearbeiten', 33)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_GroupRights] WHERE right_id = 850 AND group_id = 1)
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 850)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 851)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID) VALUES (851, 'Mandantenzuordnung ändern', 3, 10, 'Erlaubt es Benutzern, die Mandantenzuordnung in Tickets zu ändern', 33)
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_TicketDetailPositions]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE dbo.hm_TicketDetailPositions
(
    user_id bigint NOT NULL,
    positions text NULL
)  ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_TicketDetailPositionsGroups]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE dbo.hm_TicketDetailPositionsGroups
(
    group_id bigint NOT NULL,
    positions text NULL
)  ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_Decider]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_Decider](
	[user_id] [bigint] NOT NULL,
	[ticket_id] [bigint] NOT NULL
 CONSTRAINT [PK_hm_Decider] PRIMARY KEY CLUSTERED
(
	[user_id] ASC,
	[ticket_id] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_Interest]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_Interest](
	[user_id] [bigint] NOT NULL,
	[ticket_id] [bigint] NOT NULL
 CONSTRAINT [PK_hm_Interest] PRIMARY KEY CLUSTERED
(
	[user_id] ASC,
	[ticket_id] ASC
)
) ON [PRIMARY]
GO
CREATE TABLE [dbo].[hm_Decisor](
	[event_id] [bigint] NOT NULL,
	[user_id] [bigint] NOT NULL,
	[ticketid] [int] NOT NULL
 CONSTRAINT [PK_hm_Decisor] PRIMARY KEY CLUSTERED
(
	[user_id] ASC,
	[event_id] ASC,
	[ticketid] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_DecisionEvent]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_DecisionEvent](
	[decid] [bigint] IDENTITY (1, 1) NOT NULL,
	[decisor] [bigint] NOT NULL,
	[eventid] [bigint] NOT NULL,
        [decdescr] [text]  NULL,
        [agree] [bit] NULL,
        [decdate][datetime] DEFAULT GETDATE() NULL

 CONSTRAINT [PK_hm_DecisionEvent] PRIMARY KEY CLUSTERED
(
	[decid] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Contacts' AND COLUMN_NAME = 'Prename')
    ALTER TABLE [dbo].[hm_Contacts] ADD [Prename] [varchar] (255) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Contacts' AND COLUMN_NAME = 'Surname')
    ALTER TABLE [dbo].[hm_Contacts] ADD [Surname] [varchar] (255) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Contacts' AND COLUMN_NAME = 'Salutation')
    ALTER TABLE [dbo].[hm_Contacts] ADD [Salutation] [varchar] (50) NULL
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 825)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
    VALUES (825, 'Firmenstruktur im Ticket anzeigen', 2, 33, 24, 'Benutzer mit diesem Recht können einen Ort aus der Asset.Desk-Struktur im Ticket hinterlegen');
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_GroupRights] WHERE right_id = 825 AND group_id = 1)
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 825)
GO

/* 5.1.000 */
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (34, 'Tickettyp', 350)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 860)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID) VALUES (860, 'Tickettypen verwalten', 3, 10, 'Benutzer mit diesem Recht können Tickettypen anlegen, bearbeiten und löschen.', 34)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 862)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID) VALUES (862, 'Tickettyp-Felder verwalten', 3, 20, 'Benutzer mit diesem Recht können Felder für Tickettypen anlegen, bearbeiten und löschen.', 34)
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (35, 'Ticketbewertungen', 360)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 870)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID) VALUES (870, 'Bewertungskriterien verwalten', 3, 10, 'Benutzer mit diesem Recht können Bewertungskriterien anlegen, bearbeiten und löschen.', 35)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 872)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID) VALUES (872, 'Report über Bewertungen', 3, 20, 'Benutzer mit diesem Recht können den Report über die Ticketbewertungen sehen', 35)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 874)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID) VALUES (874, 'Bewertungen anzeigen', 3, 30, 'Benutzer mit diesem Recht bekommen die Ticketbewertungen angezeigt', 35)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 875)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID) VALUES (875, 'Tickets bewerten', 3, 30, 'Benutzer mit diesem Recht werden aufgefordert, abgeschlossene Tickets zu bewerten', 35)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_field]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_field](
	[field_id] [bigint] IDENTITY (1, 1) NOT NULL,
	[field_name] [varchar] (255) NOT NULL,
        [field_validation] [text] NOT NULL,
	[created_by] [bigint] NOT NULL,
        [created_date] [datetime] DEFAULT GETDATE() NOT NULL,
        [comment] [text]  NULL,
        [field_type] [varchar] (255)  NOT NULL,
        [field_active] [int] DEFAULT (1) NOT NULL,
        [sql_field_name] [varchar](255) NULL,
 CONSTRAINT [PK_hm_field] PRIMARY KEY CLUSTERED
(
	[field_id] ASC
)
) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_icon_lib]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_icon_lib](
	[icon_id] [int] IDENTITY (1, 1) NOT NULL,
	[icon_path] [varchar] (255)  NULL,
 [created_date] [datetime] DEFAULT GETDATE() NOT NULL,
	[created_by] [bigint] NOT NULL,
 [updated_date] [datetime] DEFAULT GETDATE() NOT NULL,
	[updated_by] [bigint] NOT NULL,
 CONSTRAINT [PK_hm_icon_lib] PRIMARY KEY CLUSTERED
(
	[icon_id] ASC
)) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_criteria]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_criteria](
	[criteria_id] [bigint] IDENTITY (1, 1) NOT NULL,
	[criteria_name] [varchar] (255) NOT NULL,
 [criteria_comment] [text],
	[created_by] [bigint] NOT NULL,
 [created_date] [datetime] DEFAULT GETDATE() NOT NULL,
 [updated_by] [bigint] NOT NULL,
 [updated_date] [datetime] DEFAULT GETDATE() NOT NULL,
 [criteria_order] [int] NOT NULL,
  [criteria_active] [bit]  NULL,
 CONSTRAINT [PK_hm_criteria] PRIMARY KEY CLUSTERED
(
	[criteria_id] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_rating]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_rating](
	[criteria_id] [bigint] NOT NULL,
	[ticket_id] [bigint] NOT NULL,
        [rating] [int] NOT NULL,

 CONSTRAINT [PK_hm_rating] PRIMARY KEY CLUSTERED
(
	[criteria_id] ASC,
        [ticket_id] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_tickettype]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_tickettype](
	[type_id] [bigint] IDENTITY (1, 1) NOT NULL,
	[type_name] [varchar] (255) NOT NULL,
        [standard_fields] [text] NOT NULL,
        [created_date] [datetime] DEFAULT GETDATE() NOT NULL,
	[created_user] [bigint] NOT NULL,
        [updated_date] [datetime] DEFAULT GETDATE() NOT NULL,
	[updated_user] [bigint] NOT NULL,
        [icon_path] [varchar] (255)  NULL,
        [icon_id] [int]  NULL,
        [active] [bit]  NULL,
        [field_order][varchar] (255) NULL,
        [type_description] [varchar] (500) NULL,
        [BSNotRequired] [int] DEFAULT(0),
 CONSTRAINT [PK_hm_tickettype] PRIMARY KEY CLUSTERED
(
	[type_id] ASC
)

) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_type_field]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_type_field](
	[type_id] [bigint] NOT NULL,
	[field_id] [bigint] NOT NULL,
	[required] [bit] NOT NULL,
        [RequiredOnClose] [bit] DEFAULT 0 NOT NULL,

 CONSTRAINT [FK_hm_type_field] FOREIGN KEY([type_id])
 REFERENCES [dbo].[hm_tickettype] ([type_id]),

 CONSTRAINT [FK_hm_field_type] FOREIGN KEY([field_id])
 REFERENCES [dbo].[hm_field] ([field_id]) ,

)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 855)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID) VALUES (855, 'Entscheider zufügen', 2, 50, 'Erlaubt es Benutzern, Entscheider in Tickets zuzufügen', 24)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_GroupRights] WHERE right_id = 855 AND group_id = 1)
    INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 855)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 863)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID) VALUES (863, 'Tickettyp ändern', 3, 25, 'Benutzer mit diesem Recht können bestehende Tickets in einen anderen Tickettyp umwandeln.', 34)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_GroupRights] WHERE right_id = 860 AND group_id = 1)
    INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 860)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_GroupRights] WHERE right_id = 862 AND group_id = 1)
    INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 862)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_GroupRights] WHERE right_id = 863 AND group_id = 1)
    INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 863)
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_TypeGroup_Create]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_TypeGroup_Create](
	[TypeID] [bigint] NOT NULL,
	[GroupID] [bigint] NOT NULL,
 CONSTRAINT [FK_hm_TypeGroup] FOREIGN KEY([TypeID])
 REFERENCES [dbo].[hm_tickettype] ([type_id]),

 CONSTRAINT [FK_hm_GroupType] FOREIGN KEY([GroupID])
 REFERENCES [dbo].[hm_Groups] ([group_id]))
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_TypeGroup_Update]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_TypeGroup_Update](
	[TypeID] [bigint] NOT NULL,
	[GroupID] [bigint] NOT NULL,
 CONSTRAINT [FK_hm_TypeGroupUpdate] FOREIGN KEY([TypeID])
 REFERENCES [dbo].[hm_tickettype] ([type_id]),

 CONSTRAINT [FK_hm_GroupTypeUpdate] FOREIGN KEY([GroupID])
 REFERENCES [dbo].[hm_Groups] ([group_id]))
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_GroupRights] WHERE right_id = 872 AND group_id = 1)
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 872)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_GroupRights] WHERE right_id = 870 AND group_id = 1)
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 870)


GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_edit_field]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_edit_field](
	[field_id] [bigint] NOT NULL,
	[group_id] [bigint] NOT NULL,
 CONSTRAINT [PK_hm_edit_field] PRIMARY KEY CLUSTERED
(
	[field_id] ASC,
	[group_id] ASC
)
) ON [PRIMARY]

GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_DSFiliale]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_DSFiliale](
	[FilialID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[Filiale] [varchar] (200) NOT NULL ,
        [Active] [int] DEFAULT (1) NOT NULL,
    CONSTRAINT [PK_hm_DSFiliale] PRIMARY KEY  CLUSTERED
    (
        [FilialID]
    ))  ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_DSMitarbeiter]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_DSMitarbeiter](
	[MitarbeiterID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[Mitarbeiter] [varchar] (200) NOT NULL ,
        [HMUserID] [bigint] NULL ,
        [Active] [int] DEFAULT (1) NOT NULL,
    CONSTRAINT [PK_hm_DSMitarbeiter] PRIMARY KEY  CLUSTERED
    (
        [MitarbeiterID]
    ))  ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_DSJob]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_DSJob](
	[JobID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[Job] [varchar] (200) NOT NULL ,
        [FilialID] [bigint] NULL ,
        [Active] [int] DEFAULT (1) NOT NULL,
    CONSTRAINT [PK_hm_DSJob] PRIMARY KEY  CLUSTERED
    (
        [JobID]
    ))  ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_DSMitarbeiterFiliale]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_DSMitarbeiterFiliale](
	[MitarbeiterID] [bigint] NOT NULL ,
        [FilialID] [bigint] NOT NULL,
        [JobID] [bigint] NULL ,
    CONSTRAINT [PK_hm_DSMF] PRIMARY KEY  CLUSTERED
    (
        [MitarbeiterID] ASC,
        [FilialID]
    ))  ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_TicketWorkflowConnection]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_TicketWorkflowConnection](
	[TicketID] [bigint] NOT NULL ,
        [WFIID] [bigint] NOT NULL,
        [StartDate] [datetime] DEFAULT GETDATE() NULL ,
        [Finished] [int] NULL,
    CONSTRAINT [PK_hm_TicketWFCon] PRIMARY KEY  CLUSTERED
    (
        [TicketID] ASC,
        [WFIID]
    ))  ON [PRIMARY]
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_UserDefField]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_UserDefField](
    [UserDefFieldID] [bigint] IDENTITY(1,1) NOT NULL,
    [FieldName] [varchar] (255)  NOT NULL,
    [FieldDescription] [varchar] (255)  NULL,
    [CreateDate] [datetime] NOT NULL,
    [CreateUser] [bigint] NOT NULL,
    [FieldActive] [bit] DEFAULT(1) NULL,
    [ShowAsRadio] [bit] DEFAULT(0) NULL
 CONSTRAINT [PK_hm_UserDefField] PRIMARY KEY CLUSTERED
(
	[UserDefFieldID] ASC
)
) ON [PRIMARY]

GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_UserDefFieldValue]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_UserDefFieldValue](
	[UserDefFieldValueID] [bigint] IDENTITY(1,1) NOT NULL,
 [UserDefFieldID] [bigint] NOT NULL,
	[Value] [varchar] (255) NOT NULL,
 [ValueDescription] [varchar] (255) NOT NULL,
 [ValueActive] [bit] NOT NULL,
 [ValueCreateDate] [datetime] NOT NULL,
 [ValueCreateUser] [bigint] NOT NULL,
 [ValueUpdateDate] [datetime] NOT NULL,
 [ValueUpdateUser] [bigint] NOT NULL,
 [ValueOrder] [int] NOT NULL,
 CONSTRAINT [PK_hm_UserDefFieldValue] PRIMARY KEY CLUSTERED
(
	[UserDefFieldValueID] ASC
)
) ON [PRIMARY]

GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_UserDefFieldValueTicket]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_UserDefFieldValueTicket](
	[UserDefFieldValueID] [bigint]  NOT NULL,
 [TicketID] [bigint] NOT NULL
 CONSTRAINT [PK_hm_UserDefFieldValueTicket] PRIMARY KEY CLUSTERED
(
	[UserDefFieldValueID] ASC,
 [TicketID] ASC
)
) ON [PRIMARY]

GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysindexes] WHERE name = 'idx_Value_FieldID')
CREATE NONCLUSTERED INDEX [idx_Value_FieldID] ON [dbo].[hm_UserDefFieldValue]
(
	[Value] ASC,
	[UserDefFieldID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_UserDefField_Type]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_UserDefField_Type](
	[UserDefFieldID] [bigint] NOT NULL,
        [TypeID] [bigint] NOT NULL,
        [Required] [bit] NOT NULL,
        [Multiple] [bit]  NULL,
        [RequiredOnClose] [bit] DEFAULT 0 NOT NULL
) ON [PRIMARY]

GO
IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_ProjectAttachment]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ProjectAttachment](
	[AttachmentID] [int] NOT NULL,
	[ProjectID] [int] NOT NULL,
        [SessionID] [varchar](64) NULL
 CONSTRAINT [PK_hm_ProjectAttachment] PRIMARY KEY CLUSTERED
(
	[AttachmentID] ASC,
	[ProjectID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Users] WHERE username = 'hm_SystemAccount')
INSERT INTO hm_Users ( name, username, password, RandomUserID2,registerDate,language_type,block, deleted, sendEmail ) VALUES('SystemAccount', 'hm_SystemAccount', CONVERT(VARCHAR(32), HashBytes('MD5',CONVERT(varchar(255), NEWID())), 2), CONVERT(VARCHAR(32), HashBytes('MD5',CONVERT(varchar(255), NEWID())), 2) , GETDATE(), 'de', 0, 0, 0)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[sysindexes] WHERE name = 'idx_TicketMandant')
CREATE NONCLUSTERED INDEX [idx_TicketMandant] ON [dbo].[hm_TicketMandant] ([Active],[TicketID]) INCLUDE ([MandantenID])
GO
IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_TicketFAQPairs]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_TicketFAQPairs](
	[TicketID] [bigint] NOT NULL,
	[FAQID] [int] NOT NULL,
        [Cosine] [float] NULL,
        [Confirmed] [tinyint] NULL,
        [ConfirmUserID] [int] NULL,
        [ConfirmDate] [datetime] NULL
 CONSTRAINT [PK_hm_TicketFAQPairs] PRIMARY KEY CLUSTERED
(
	[TicketID] ASC,
	[FAQID] ASC
)) ON [PRIMARY]
GO
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (40, 'Heinzelmann-Bot', 1400)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 880)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
    VALUES (880, 'Bot trainieren', 4, 1, 40, 'Mit diesem Recht können Benutzer das Matching von KB-Artikeln bestätigen');
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_GroupRights] WHERE right_id = 880 AND group_id = 1)
    INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 880)
GO

IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_HistoryEvent]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_HistoryEvent](
	[HistoryEventID] [bigint]  IDENTITY (1, 1) NOT NULL,
	[ArticleID] [bigint] NOT NULL,
        [Username] [varchar] (255) NOT NULL,
        [EditDate] [datetime] NOT NULL,
        [Comment] [varchar](255) NULL,
        [Event] INTEGER NOT NULL,
        [HistoryType] [int] NULL
 CONSTRAINT [PK_hm_HistoryEvent] PRIMARY KEY CLUSTERED
(
	[HistoryEventID] ASC
)) ON [PRIMARY]
GO

IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_KnowledgebaseArchive]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_KnowledgebaseArchive](
	[KnowledgebaseVersionID] [bigint]  IDENTITY(1, 1) NOT NULL,
	[KnowledgebaseEventID] [bigint] NOT NULL,
        [CreateUsername] [varchar] (255) NOT NULL,
        [CreateDate] [datetime] NOT NULL,
        [Content] [text] NULL,
        [Title] [varchar](255) NULL
 CONSTRAINT [PK_hm_KnowledgebaseArchive] PRIMARY KEY CLUSTERED
(
    [KnowledgebaseVersionID] ASC
)) ON [PRIMARY]
GO

IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_ConfigurationArchive]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ConfigurationArchive](
	[ConfigurationArchiveID] [bigint]  IDENTITY(1, 1) NOT NULL,
	[ConfigurationEventID] [bigint] NOT NULL,
        [ConfigurationName] [varchar] (255) NULL,
        [ObjectName] [varchar] (255) NULL,
        [OldValue] [varchar] (255) NULL,
        [NewValue] [varchar] (255) NULL
 CONSTRAINT [PK_hm_ConfigurationArchive] PRIMARY KEY CLUSTERED
(
    [ConfigurationArchiveID] ASC
)) ON [PRIMARY]
GO

IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_UserArchive]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_UserArchive](
	[UserArchiveID] [bigint]  IDENTITY(1, 1) NOT NULL,
	[UserEventID] [bigint] NOT NULL,
        [ObjectName] [varchar] (255) NULL,
        [OldValue] VARCHAR(MAX) NULL,
        [NewValue] VARCHAR(MAX) NULL,
        [UserID][bigint] NOT NULL
 CONSTRAINT [PK_hm_UserArchive] PRIMARY KEY CLUSTERED
(
    [UserArchiveID] ASC
)) ON [PRIMARY]
GO

IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_DocumentBlacklist]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_DocumentBlacklist](
	[DocumentHash] [varchar] (50) NOT NULL,
        [AttachmentID] [bigint]  NOT NULL,
        [DocumentName] [varchar] (255)  NULL,
        [DocumentFilename] [varchar] (255)  NULL,
        [CreateUserID] [bigint]  NULL,
        [CreateDate]   [datetime] DEFAULT GETDATE() NOT NULL
 CONSTRAINT [PK_hm_DocumentBL] PRIMARY KEY CLUSTERED
(
    [DocumentHash] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_WFMailTemplates]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_WFMailTemplates](
        [TemplateID] [int] Identity(1, 1),
	[MailType] [varchar](300) NOT NULL,
        [Subject] [varchar](300) NULL,
	[Content] [text] NULL,
	[CreateDate] [datetime] DEFAULT Getdate() NOT NULL,
        [Active] [tinyint] DEFAULT 1,
        [TemplateTitle] [varchar] (50) NULL
) ON [PRIMARY]
GO
IF EXISTS (SELECT *
  FROM sys.foreign_keys
   WHERE object_id = OBJECT_ID(N'dbo.DeviceType_ObjectTypeDetail_FK1')
   AND parent_object_id = OBJECT_ID(N'dbo.ObjectTypeDetail')
)
ALTER TABLE [dbo].[ObjectTypeDetail] DROP CONSTRAINT [DeviceType_ObjectTypeDetail_FK1]
GO

/*Geräteverwaltung*/
IF NOT EXISTS (SELECT * FROM dbo.sysobjects where id = object_id(N'[dbo].[Device]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN

	CREATE TABLE [dbo].[Device](
			[DeviceID] int identity NOT NULL,
		[DomainName] varchar(50) NULL,
		[HostName] varchar(50) NULL,
		[DeviceName] varchar(50) NULL,
		[DeviceTypeID] int NULL,
		[DeviceScannerID] int NULL,
		[IsVirtual] bit default 0 NULL,
		[PhysMem] int NULL,
		[OS] varchar(100) NULL,
		[OSVersion] varchar(100) NULL,
		[OSInstDate] datetime NULL,
		[SerialNo] varchar(50) NULL,
		[SerialNoChassis] varchar(50) NULL,
		[Descr] varchar(100) NULL,
		[DeviceDescr] varchar(150) NULL,
		[Model] varchar(50) NULL,
		[Manufacturer] varchar(50) NULL,
		[PROM] varchar(150) NULL,
		[PrimOwner] varchar(50) NULL,
		[IPAddress] varchar(30) NULL,
		[IPAddressForSearch] varchar(30) NULL,
		[MACAddress] varchar(30) NULL,
		[IPAddressV6] varchar(39) NULL,
		[IPv6PrefixLength] int NULL,
		[UpTime] bigint NULL,
		[DNS1] varchar(30) NULL,
		[DNS2] varchar(30) NULL,
		[WINS1] varchar(30) NULL,
		[WINS2] varchar(30) NULL,
		[DefGateway] varchar(30) NULL,
		[Monitor] varchar(150) NULL,
		[CPUName] varchar(50) NULL,
		[ScanTime] datetime NULL,
		[ScanStatus] varchar(10) NULL,
		[ScanError] varchar(255) NULL,
		[FirstAudit] datetime NULL,
		[LastMove] datetime NULL,
		[ManualInput] int NULL,
		[UserName] varchar(50) NULL,
		[VNCPasswd] varchar(15) NULL,
		[LogGroupDateTime] datetime NULL,
		[Configuration] varchar(2000) NULL,
		[Equipment] varchar(50) NULL,
		[Connection] varchar(50) NULL,
		[PowerMngmt] varchar(50) NULL,
		[Type] varchar(50) NULL,
		[Notice] varchar(4000) NULL,
		[Costs] money NULL,
		[DeviceUsageID1] int NULL,
		[DeviceUsageID2] int NULL,
		[LockModel] bit default ((0)) NULL,
		[LockManufacturer] bit default ((0)) NULL,
		[LockOS] bit default ((0)) NULL,
		[LockPhysMem] bit default ((0)) NULL,
		[LockDesc] bit default ((0)) NULL,
		[LockSerialNo] bit default ((0)) NULL,
		[LockSerialNoChassis] bit default ((0)) NULL,
		[LockPROM] bit default ((0)) NULL,
		[LockPrimOwner] bit default ((0)) NULL,
		[LockMonitor] bit default ((0)) NULL,
		[LockDeviceName] bit default ((0)) NULL,
		[LockCPUName] bit default ((0)) NULL,
		[LockIsVirtual] bit default ((0)) NULL,
		[LockObjectType] bit default ((0)) NULL,
		[ImportDate] datetime NULL,
		[SubnetMask] varchar(30) NULL,
		[Dimension] varchar(100) NULL,
		[Resolution] varchar(100) NULL,
		[InternalMemory] int NULL,
		[ExternalMemory] int NULL,
		[RAMThreshold] int NULL,
		[RAMAvailable] int NULL,
		[Kernel] varchar(50) NULL,
		[Hardware] varchar(100) NULL,
		[FreeInternalMemory] int NULL,
		[FreeExternalMemory] int NULL,
		[NumberOfNetworkcard] int NULL,
		[NumberOfHostBusAdapter] int NULL,
		[NumberOfPorts] int NULL,
		[ScannedBy] varchar(20) NULL,
		[ServiceCreateDate] datetime NULL,
		[InspectionMethodID] int NULL,
		[LastInventoryDate] datetime NULL,
		[IsPrivate] bit default ((0)) NULL,
		[HeightCM] float NULL,
		[WidthCM] float NULL,
		[LengthCM] float NULL,
		[CreateDate] datetime NULL,
		[CreateUser] varchar(100) NULL,
		[CreateLogOnUser] varchar(50) NULL,
		[LastUpdate] datetime default GetDate() NOT NULL,
		[LastUpdateUser] varchar(100) NULL,
		[LastUpdateLogOnUser] varchar(50) NULL,
		[ClientID] int NULL,
		[ADguid] varchar(36) NULL,
		[old_Height] varchar(50) NULL,
		[old_Width] varchar(50) NULL,
		[old_Depth] varchar(50) NULL
		)

	IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Device_PK]') and OBJECTPROPERTY(id, N'IsConstraint') = 1)
		ALTER TABLE [dbo].[Device]
		ADD CONSTRAINT [Device_PK] PRIMARY KEY NONCLUSTERED (DeviceID)
END
ELSE
BEGIN

	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'DeviceID')
		ALTER TABLE [dbo].[Device] ADD [DeviceID]  int identity NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'DomainName')
		ALTER TABLE [dbo].[Device] ADD [DomainName]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'HostName')
		ALTER TABLE [dbo].[Device] ADD [HostName]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'DeviceName')
		ALTER TABLE [dbo].[Device] ADD [DeviceName]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'DeviceTypeID')
		ALTER TABLE [dbo].[Device] ADD [DeviceTypeID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'DeviceScannerID')
		ALTER TABLE [dbo].[Device] ADD [DeviceScannerID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'IsVirtual')
		ALTER TABLE [dbo].[Device] ADD [IsVirtual]  bit default 0 NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'PhysMem')
		ALTER TABLE [dbo].[Device] ADD [PhysMem]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'OS')
		ALTER TABLE [dbo].[Device] ADD [OS]  varchar(100) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'OSVersion')
		ALTER TABLE [dbo].[Device] ADD [OSVersion]  varchar(100) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'OSInstDate')
		ALTER TABLE [dbo].[Device] ADD [OSInstDate]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'SerialNo')
		ALTER TABLE [dbo].[Device] ADD [SerialNo]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'SerialNoChassis')
		ALTER TABLE [dbo].[Device] ADD [SerialNoChassis]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'Descr')
		ALTER TABLE [dbo].[Device] ADD [Descr]  varchar(100) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'DeviceDescr')
		ALTER TABLE [dbo].[Device] ADD [DeviceDescr]  varchar(150) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'Model')
		ALTER TABLE [dbo].[Device] ADD [Model]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'Manufacturer')
		ALTER TABLE [dbo].[Device] ADD [Manufacturer]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'PROM')
		ALTER TABLE [dbo].[Device] ADD [PROM]  varchar(150) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'PrimOwner')
		ALTER TABLE [dbo].[Device] ADD [PrimOwner]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'IPAddress')
		ALTER TABLE [dbo].[Device] ADD [IPAddress]  varchar(30) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'IPAddressForSearch')
		ALTER TABLE [dbo].[Device] ADD [IPAddressForSearch]  varchar(30) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'MACAddress')
		ALTER TABLE [dbo].[Device] ADD [MACAddress]  varchar(30) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'IPAddressV6')
		ALTER TABLE [dbo].[Device] ADD [IPAddressV6]  varchar(39) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'IPv6PrefixLength')
		ALTER TABLE [dbo].[Device] ADD [IPv6PrefixLength]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'UpTime')
		ALTER TABLE [dbo].[Device] ADD [UpTime]  bigint NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'DNS1')
		ALTER TABLE [dbo].[Device] ADD [DNS1]  varchar(30) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'DNS2')
		ALTER TABLE [dbo].[Device] ADD [DNS2]  varchar(30) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'WINS1')
		ALTER TABLE [dbo].[Device] ADD [WINS1]  varchar(30) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'WINS2')
		ALTER TABLE [dbo].[Device] ADD [WINS2]  varchar(30) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'DefGateway')
		ALTER TABLE [dbo].[Device] ADD [DefGateway]  varchar(30) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'Monitor')
		ALTER TABLE [dbo].[Device] ADD [Monitor]  varchar(150) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'CPUName')
		ALTER TABLE [dbo].[Device] ADD [CPUName]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'ScanTime')
		ALTER TABLE [dbo].[Device] ADD [ScanTime]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'ScanStatus')
		ALTER TABLE [dbo].[Device] ADD [ScanStatus]  varchar(10) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'ScanError')
		ALTER TABLE [dbo].[Device] ADD [ScanError]  varchar(255) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'FirstAudit')
		ALTER TABLE [dbo].[Device] ADD [FirstAudit]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LastMove')
		ALTER TABLE [dbo].[Device] ADD [LastMove]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'ManualInput')
		ALTER TABLE [dbo].[Device] ADD [ManualInput]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'UserName')
		ALTER TABLE [dbo].[Device] ADD [UserName]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'VNCPasswd')
		ALTER TABLE [dbo].[Device] ADD [VNCPasswd]  varchar(15) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LogGroupDateTime')
		ALTER TABLE [dbo].[Device] ADD [LogGroupDateTime]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'Configuration')
		ALTER TABLE [dbo].[Device] ADD [Configuration]  varchar(2000) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'Equipment')
		ALTER TABLE [dbo].[Device] ADD [Equipment]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'Connection')
		ALTER TABLE [dbo].[Device] ADD [Connection]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'PowerMngmt')
		ALTER TABLE [dbo].[Device] ADD [PowerMngmt]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'Type')
		ALTER TABLE [dbo].[Device] ADD [Type]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'Notice')
		ALTER TABLE [dbo].[Device] ADD [Notice]  varchar(4000) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'Costs')
		ALTER TABLE [dbo].[Device] ADD [Costs]  money NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'DeviceUsageID1')
		ALTER TABLE [dbo].[Device] ADD [DeviceUsageID1]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'DeviceUsageID2')
		ALTER TABLE [dbo].[Device] ADD [DeviceUsageID2]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LockModel')
		ALTER TABLE [dbo].[Device] ADD [LockModel]  bit default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LockManufacturer')
		ALTER TABLE [dbo].[Device] ADD [LockManufacturer]  bit default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LockOS')
		ALTER TABLE [dbo].[Device] ADD [LockOS]  bit default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LockPhysMem')
		ALTER TABLE [dbo].[Device] ADD [LockPhysMem]  bit default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LockDesc')
		ALTER TABLE [dbo].[Device] ADD [LockDesc]  bit default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LockSerialNo')
		ALTER TABLE [dbo].[Device] ADD [LockSerialNo]  bit default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LockSerialNoChassis')
		ALTER TABLE [dbo].[Device] ADD [LockSerialNoChassis]  bit default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LockPROM')
		ALTER TABLE [dbo].[Device] ADD [LockPROM]  bit default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LockPrimOwner')
		ALTER TABLE [dbo].[Device] ADD [LockPrimOwner]  bit default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LockMonitor')
		ALTER TABLE [dbo].[Device] ADD [LockMonitor]  bit default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LockDeviceName')
		ALTER TABLE [dbo].[Device] ADD [LockDeviceName]  bit default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LockCPUName')
		ALTER TABLE [dbo].[Device] ADD [LockCPUName]  bit default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LockIsVirtual')
		ALTER TABLE [dbo].[Device] ADD [LockIsVirtual]  bit default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LockObjectType')
		ALTER TABLE [dbo].[Device] ADD [LockObjectType]  bit default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'ImportDate')
		ALTER TABLE [dbo].[Device] ADD [ImportDate]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'SubnetMask')
		ALTER TABLE [dbo].[Device] ADD [SubnetMask]  varchar(30) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'Dimension')
		ALTER TABLE [dbo].[Device] ADD [Dimension]  varchar(100) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'Resolution')
		ALTER TABLE [dbo].[Device] ADD [Resolution]  varchar(100) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'InternalMemory')
		ALTER TABLE [dbo].[Device] ADD [InternalMemory]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'ExternalMemory')
		ALTER TABLE [dbo].[Device] ADD [ExternalMemory]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'RAMThreshold')
		ALTER TABLE [dbo].[Device] ADD [RAMThreshold]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'RAMAvailable')
		ALTER TABLE [dbo].[Device] ADD [RAMAvailable]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'Kernel')
		ALTER TABLE [dbo].[Device] ADD [Kernel]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'Hardware')
		ALTER TABLE [dbo].[Device] ADD [Hardware]  varchar(100) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'FreeInternalMemory')
		ALTER TABLE [dbo].[Device] ADD [FreeInternalMemory]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'FreeExternalMemory')
		ALTER TABLE [dbo].[Device] ADD [FreeExternalMemory]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'NumberOfNetworkcard')
		ALTER TABLE [dbo].[Device] ADD [NumberOfNetworkcard]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'NumberOfHostBusAdapter')
		ALTER TABLE [dbo].[Device] ADD [NumberOfHostBusAdapter]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'NumberOfPorts')
		ALTER TABLE [dbo].[Device] ADD [NumberOfPorts]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'ScannedBy')
		ALTER TABLE [dbo].[Device] ADD [ScannedBy]  varchar(20) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'ServiceCreateDate')
		ALTER TABLE [dbo].[Device] ADD [ServiceCreateDate]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'InspectionMethodID')
		ALTER TABLE [dbo].[Device] ADD [InspectionMethodID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LastInventoryDate')
		ALTER TABLE [dbo].[Device] ADD [LastInventoryDate]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'IsPrivate')
		ALTER TABLE [dbo].[Device] ADD [IsPrivate]  bit default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'HeightCM')
		ALTER TABLE [dbo].[Device] ADD [HeightCM]  float NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'WidthCM')
		ALTER TABLE [dbo].[Device] ADD [WidthCM]  float NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LengthCM')
		ALTER TABLE [dbo].[Device] ADD [LengthCM]  float NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'CreateDate')
		ALTER TABLE [dbo].[Device] ADD [CreateDate]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'CreateUser')
		ALTER TABLE [dbo].[Device] ADD [CreateUser]  varchar(100) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'CreateLogOnUser')
		ALTER TABLE [dbo].[Device] ADD [CreateLogOnUser]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LastUpdate')
		ALTER TABLE [dbo].[Device] ADD [LastUpdate]  datetime default GetDate() NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LastUpdateUser')
		ALTER TABLE [dbo].[Device] ADD [LastUpdateUser]  varchar(100) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'LastUpdateLogOnUser')
		ALTER TABLE [dbo].[Device] ADD [LastUpdateLogOnUser]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'ClientID')
		ALTER TABLE [dbo].[Device] ADD [ClientID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'ADguid')
		ALTER TABLE [dbo].[Device] ADD [ADguid]  varchar(36) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'old_Height')
		ALTER TABLE [dbo].[Device] ADD [old_Height]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'old_Width')
		ALTER TABLE [dbo].[Device] ADD [old_Width]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Device]') and name = 'old_Depth')
		ALTER TABLE [dbo].[Device] ADD [old_Depth]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Device_PK]') and OBJECTPROPERTY(id, N'IsConstraint') = 1)
		ALTER TABLE [dbo].[Device]
		ADD CONSTRAINT [Device_PK] PRIMARY KEY NONCLUSTERED (DeviceID)
END
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_DeviceContact]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_DeviceContact](
	[DeviceID] [int] NOT NULL,
	[ContactID] [int] NOT NULL,
	[addDate] [datetime]  DEFAULT GETDATE() NOT NULL,
 CONSTRAINT [PK_hm_DeviceContact] PRIMARY KEY CLUSTERED
(
	[DeviceID] ASC,
	[ContactID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_DefFieldValue]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_DefFieldValue](
    [TicketID] [bigint] NOT NULL
)
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects where id = object_id(N'[dbo].[SWProduct]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN

	CREATE TABLE [dbo].[SWProduct](
			[SWProductID] bigint identity NOT NULL,
		[DeviceID] int NOT NULL,
		[SWProductCatalogID] int NOT NULL,
		[ProductKey] varchar(50) NULL,
		[BuildNo] varchar(50) NULL,
		[SerialNo] varchar(50) NULL,
		[IDNumber] varchar(50) NULL,
		[InstDir] varchar(100) NULL,
		[UninstallString] varchar(300) NULL,
		[InstDate] datetime NULL,
		[ProductID] varchar(50) NULL,
		[OSArchitecture] varchar(10) NULL,
		[OSReleaseID] varchar(50) NULL,
		[OSDataExecutionProtection] bit default 0 NULL,
		[TimeZone] varchar(20) NULL,
		[CountryName] varchar(150) NULL,
		[CodeSet] varchar(150) NULL,
		[Linux_Firmware] varchar(50) NULL,
		[Linux_FirmwareVersion] varchar(50) NULL,
		[Linux_FirmwareDescription] varchar(200) NULL,
		[Linux_Kernel] varchar(50) NULL,
		[Linux_KernelVersion] varchar(100) NULL,
		[LastUpdate] datetime default GetDate() NOT NULL,
		[LastUpdateUser] varchar(50) NULL,
		[LastUpdateLogOnUser] varchar(50) NULL
		)

	IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[SWProduct_PK]') and OBJECTPROPERTY(id, N'IsConstraint') = 1)
		ALTER TABLE [dbo].[SWProduct]
		ADD CONSTRAINT [SWProduct_PK] PRIMARY KEY NONCLUSTERED (SWProductID)


END
ELSE
BEGIN

	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'SWProductID')
		ALTER TABLE [dbo].[SWProduct] ADD [SWProductID]  bigint identity NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'DeviceID')
		ALTER TABLE [dbo].[SWProduct] ADD [DeviceID]  int NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'SWProductCatalogID')
		ALTER TABLE [dbo].[SWProduct] ADD [SWProductCatalogID]  int NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'ProductKey')
		ALTER TABLE [dbo].[SWProduct] ADD [ProductKey]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'BuildNo')
		ALTER TABLE [dbo].[SWProduct] ADD [BuildNo]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'SerialNo')
		ALTER TABLE [dbo].[SWProduct] ADD [SerialNo]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'IDNumber')
		ALTER TABLE [dbo].[SWProduct] ADD [IDNumber]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'InstDir')
		ALTER TABLE [dbo].[SWProduct] ADD [InstDir]  varchar(100) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'UninstallString')
		ALTER TABLE [dbo].[SWProduct] ADD [UninstallString]  varchar(300) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'InstDate')
		ALTER TABLE [dbo].[SWProduct] ADD [InstDate]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'ProductID')
		ALTER TABLE [dbo].[SWProduct] ADD [ProductID]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'OSArchitecture')
		ALTER TABLE [dbo].[SWProduct] ADD [OSArchitecture]  varchar(10) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'OSReleaseID')
		ALTER TABLE [dbo].[SWProduct] ADD [OSReleaseID]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'OSDataExecutionProtection')
		ALTER TABLE [dbo].[SWProduct] ADD [OSDataExecutionProtection]  bit default 0 NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'TimeZone')
		ALTER TABLE [dbo].[SWProduct] ADD [TimeZone]  varchar(20) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'CountryName')
		ALTER TABLE [dbo].[SWProduct] ADD [CountryName]  varchar(150) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'CodeSet')
		ALTER TABLE [dbo].[SWProduct] ADD [CodeSet]  varchar(150) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'Linux_Firmware')
		ALTER TABLE [dbo].[SWProduct] ADD [Linux_Firmware]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'Linux_FirmwareVersion')
		ALTER TABLE [dbo].[SWProduct] ADD [Linux_FirmwareVersion]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'Linux_FirmwareDescription')
		ALTER TABLE [dbo].[SWProduct] ADD [Linux_FirmwareDescription]  varchar(200) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'Linux_Kernel')
		ALTER TABLE [dbo].[SWProduct] ADD [Linux_Kernel]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'Linux_KernelVersion')
		ALTER TABLE [dbo].[SWProduct] ADD [Linux_KernelVersion]  varchar(100) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'LastUpdate')
		ALTER TABLE [dbo].[SWProduct] ADD [LastUpdate]  datetime default GetDate() NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'LastUpdateUser')
		ALTER TABLE [dbo].[SWProduct] ADD [LastUpdateUser]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProduct]') and name = 'LastUpdateLogOnUser')
		ALTER TABLE [dbo].[SWProduct] ADD [LastUpdateLogOnUser]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[SWProduct_PK]') and OBJECTPROPERTY(id, N'IsConstraint') = 1)
		ALTER TABLE [dbo].[SWProduct]
		ADD CONSTRAINT [SWProduct_PK] PRIMARY KEY NONCLUSTERED (SWProductID)


END
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[DeviceGroup](
	[DeviceGroupID] [int] NOT NULL,
	[DeviceGroupName] [varchar](30) NOT NULL,
	[Description] [varchar](100) NULL,
 CONSTRAINT [DeviceGroup_PK] PRIMARY KEY CLUSTERED
(
	[DeviceGroupID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeviceType]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[DeviceType](
	[DeviceTypeID] [int] IDENTITY(1,1) NOT NULL,
	[DeviceGroupID] [int] NOT NULL,
	[TypeName] [varchar](100) NULL,
	[IconOK] [image] NULL,
	[IconErr] [image] NULL,
	[LastUpdate] [datetime] DEFAULT GETDATE() NOT NULL,
	[LastUpdateUser] [varchar](50) NULL,
	[LastUpdateLogOnUser] [varchar](50) NULL,
	[IsDefaultOfObjectGroup] [bit]  DEFAULT ((0))  NULL,
	[IsSystemEntry] [bit] DEFAULT ((0)) NULL,
	[IsNWElementByDefault] [bit] DEFAULT ((0)) NULL,
	[RefType] [int] NULL,
	[RoomObjectType] [int] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
ELSE
BEGIN

	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[DeviceType]') and name = 'DeviceTypeID')
		ALTER TABLE [dbo].[DeviceType] ADD [DeviceTypeID]  int identity NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[DeviceType]') and name = 'DeviceGroupID')
		ALTER TABLE [dbo].[DeviceType] ADD [DeviceGroupID]  int NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[DeviceType]') and name = 'TypeName')
		ALTER TABLE [dbo].[DeviceType] ADD [TypeName]  varchar(100) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[DeviceType]') and name = 'IconOK')
		ALTER TABLE [dbo].[DeviceType] ADD [IconOK]  image NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[DeviceType]') and name = 'IconErr')
		ALTER TABLE [dbo].[DeviceType] ADD [IconErr]  image NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[DeviceType]') and name = 'IsDefaultOfObjectGroup')
		ALTER TABLE [dbo].[DeviceType] ADD [IsDefaultOfObjectGroup]  bit default 0 NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[DeviceType]') and name = 'IsNWElementByDefault')
		ALTER TABLE [dbo].[DeviceType] ADD [IsNWElementByDefault]  bit default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[DeviceType]') and name = 'IsSystemEntry')
		ALTER TABLE [dbo].[DeviceType] ADD [IsSystemEntry]  bit default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[DeviceType]') and name = 'RefType')
		ALTER TABLE [dbo].[DeviceType] ADD [RefType]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[DeviceType]') and name = 'RoomObjectType')
		ALTER TABLE [dbo].[DeviceType] ADD [RoomObjectType]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[DeviceType]') and name = 'LastUpdate')
		ALTER TABLE [dbo].[DeviceType] ADD [LastUpdate]  datetime default GetDate() NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[DeviceType]') and name = 'LastUpdateUser')
		ALTER TABLE [dbo].[DeviceType] ADD [LastUpdateUser]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[DeviceType]') and name = 'LastUpdateLogOnUser')
		ALTER TABLE [dbo].[DeviceType] ADD [LastUpdateLogOnUser]  varchar(50) NULL

END
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceGroup] WHERE DeviceGroupID = 1)
INSERT [dbo].[DeviceGroup] ([DeviceGroupID], [DeviceGroupName], [Description]) VALUES (1, N'PC und Server', N'voll scanbare Geräte')
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceGroup] WHERE DeviceGroupID = 2)
INSERT [dbo].[DeviceGroup] ([DeviceGroupID], [DeviceGroupName], [Description]) VALUES (2, N'SNMP Devices', N'über SNMP scanbare Geräte')
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceGroup] WHERE DeviceGroupID = 3)
INSERT [dbo].[DeviceGroup] ([DeviceGroupID], [DeviceGroupName], [Description]) VALUES (3, N'Unmanaged Devices', N'nicht scanbare sonstige Geräte')
GO
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceGroup] WHERE DeviceGroupID = 4)
INSERT [dbo].[DeviceGroup] ([DeviceGroupID], [DeviceGroupName], [Description]) VALUES (4, N'Managed Devices', N'nicht scanbare verwaltbare sonstige Geräte')
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceGroup] WHERE DeviceGroupID = 5)
INSERT [dbo].[DeviceGroup] ([DeviceGroupID], [DeviceGroupName], [Description]) VALUES (5, N'Mobile Devices', N'mobile Geräte (Smartphones, Tablet-PCs)')
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceGroup] WHERE DeviceGroupID = 10)
INSERT [dbo].[DeviceGroup] ([DeviceGroupID], [DeviceGroupName], [Description]) VALUES (10, N'Mobiliar', N'Einrichtungsgegenstände')
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceGroup] WHERE DeviceGroupID = 20)
INSERT [dbo].[DeviceGroup] ([DeviceGroupID], [DeviceGroupName], [Description]) VALUES (20, N'Abstrakt', N'Sonstiges abstraktes Objekt')
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceGroup] WHERE DeviceGroupID = 30)
INSERT [dbo].[DeviceGroup] ([DeviceGroupID], [DeviceGroupName], [Description]) VALUES (30, N'Software', N'Objekt für SW-Lizenz')
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
GO
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 1)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (1, 1, N'PC', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 1, 1, 0, NULL, NULL)
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 2)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (2, 1, N'Notebook', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 0, NULL, NULL)
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 3)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (3, 1, N'Server', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 1, NULL, NULL)
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 4)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (4, 3, N'Printer', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 0, NULL, NULL)
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 5)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (5, 3, N'Router', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 1, NULL, NULL)
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 6)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (6, 3, N'Switch', NULL, NULL, CAST(N'2014-01-24T09:35:33.830' AS DateTime), N'Administrator', N'FCS\malbert', 0, NULL, 1, NULL, NULL)
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 7)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (7, 5, N'Mobile', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 1, 1, 0, NULL, NULL)
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 8)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (8, 3, N'Hub', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 1, NULL, NULL)

IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 9)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (9, 3, N'Monitor', 0x89504E470D0A1A0A0000000D49484452000000100000001008060000001FF3FF61000000017352474200AECE1CE90000000467414D410000B18F0BFC6105000000097048597300000EC300000EC301C76FA864000002AE49444154384FAD92FB4B935118C7FD23FA038A08CA2648FE10D1856E6A1685041511DD884ABC74A1A8CCA2B412EC36AC9CB7DC52739A539BA31556F3272BA12D32E6AC655BEABBF26DEE624EA5823E9DF36E4124F4530F7C39E779CEF7FBE1BC2F27C9D2F58292CA368A0D16A1D699AAF84BC227FD329724EBBC187E999E606C2A4A783AA1A90821A1B1C9B88252B108AAD0E7581465E22B32A701CEDE3013180F31EBB093B945AF49B9E821EDEA3B96960FB2C6E027ABDA4776DD47B6997CEC32F9D963F431F84545E634C0997233BEE028730AFB48BBEC61F90D11ACF1B3DE384C76A3C23673809D2D01F6B52AE4DC1BE1A079987E25405179531C50A4BFCBC088C2BC92019688F0AADA21D635286C6AFECC168BCA8E0E95BDF75572ACA314747E22B7ED13AE0F4314E91BE380D362E31AF4B3A0CCCBB2AA8FACAD0FB0A1556573C718DB6D61763F08B3DF1E22EF519023769502017AE6F940E1F504E0D4B57A7ADC5E52F43E56D429AC6B51C9B686D96A1F67E79318071C310ABAC739EE8872EA6998A3F620DD7D6F91B938E0EA1D1E3BFB49BD39CCEA865136B687C8B47E65956D92A5B66952DB63E8CC5174A620F32B03CCBE3644D74B3732A7014E5C31D2F9EC0D8BC4E16293CAC2FA30C9CD13E8EE7F4767FF498AED07BAD649740D11926B55E6E815AC3D7DC89C06385E769B46C72BB2AADCACAEEC27DDE825BDC94786451137192553FCB40CB39F8CFAF7A4D7785879D3CD5D870B99D300C7CAEAA87AE824FA2D46647A3C2EF1A834890714994CECA7E267D1EF31CD2F731A406FB470A4B486820B55E49718C82F369077BE82BC7315E49EBBA5ADB29773797E48F8A45FE634802CA7D3C96F35753CA2D46463F349030D8F7BB555F672FEA72F119D598705DDE11AA0D73BC2F377C3DA2A7B394F58FE5D35E64E0E5DAA26575C39B7587C8658652FE709CBFFACA4A45F1CA966828AF6944C0000000049454E44AE426082, 0x89504E470D0A1A0A0000000D49484452000000100000001008060000001FF3FF61000000017352474200AECE1CE90000000467414D410000B18F0BFC6105000000097048597300000EC300000EC301C76FA864000002E149444154384F9D92FF4FCC711CC7FB23FC03667EF0A5CDB059C2162211311746BE4C48E76893AFC7542A224EACEB4A5DA5EEA453EA12C3CA2FC2EC32A1E2D4F5ED73751FD5553A6E180FEFCF7D4AC66F9EDB63EFF73E9FF7F3B1D77B7B07D91E3C2335F73629469BA0E25F72FE429C53CE2BBD2025C9E2E347FF18835F46F0FAC7F932CC9060F0B3CA80826F1859D0EF1B411AFB84D20B084E5FB5E21E1D62CA2107D3F4AF084E6B655ED67B42B3DB5966EC64559E8BE8C22E3615B9D85ED4C94EB38BF68F324A2F2038956DC535E061EA8966E65D6865F15551CCEF24D2DC4374A9C426AB9BD87237BB2B24E26FF5B2CFDA438BE4469F6D51057A43196DBD12D353DB0811E5B0EBDD44DC90587BB31F8D4D666B95CCAE3B32F1D51E74357D24DCEEA3A9A31BBDA154159C149BA6F64E66643A5964EA6279899BD515321BAA06D962F7B2E3AE973D754368EF0F905827A313A2C6D60E4E5C1E171CBF54C293B74E820D2E96144A4494CB44577B89A91B25F6918FBDF53E740DA3E49597D36D89C252709186E677283D559055CC43470B73AEF5B0F48687A8CA2156567F22CCFE9950BB9F39953EE697F5516BDA0F64D35510CEA3C6A728BD80E0E84533358DAF999BEB664191CCAC122F336F8E31FBCE3766D7FD24D8FE9DB8825A3C2FB4844569C1738427854928BD802029B380D2FA97AC32BD65696E0BE16627E116172B6C9298C443F42D27F78A757C736B59B6464CE13B8CAB3A96CCF369AAE0706621A67B0E46BEFA18F68FAA884715403C20E97919DEFAF5D01747D6B93DD0BF1B7FF336EC865DAAC060B69198918FEEAC8903A9460EA418D126E7A03D93833E399DD6DCE5FC78A7810E0DE733E2C1A5E1A73306A93252152871381C4C60A9BA4F46919D0DC78C38AEACE5AB63257C582D88A4EDF1BAC08A3392EFCD117498359392891C12D3D437B5F1DCD94BCB8550DE9C5BC8EBF490006F32D455DD2F0CFC1FAF4D26DF5AC3C1F43C12C45536EE3B2638CEE68493E8D32EFD9EF24FC66BFF9BA0A05FC2E3852751EC5E800000000049454E44AE426082, CAST(N'2014-02-07T10:22:23.040' AS DateTime), N'Administrator', N'FCS\lstockum', 0, NULL, 0, NULL, NULL)

IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 10)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (10, 3, N'Scanner', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 0, NULL, NULL)
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 11)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (11, 2, N'IP-Device', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 1, 1, 1, NULL, NULL)
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 12)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (12, 2, N'SNMP-Drucker', NULL, NULL, CAST(N'2015-03-09T11:24:20.677' AS DateTime), N'', N'', 0, NULL, 0, NULL, NULL)
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 13)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (13, 2, N'SNMP-Router', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 1, NULL, NULL)
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 14)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (14, 2, N'SNMP-Switch', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 1, NULL, NULL)
GO
SET IDENTITY_INSERT [dbo].[DeviceType] ON
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 15)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (15, 2, N'SNMP-Hub', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 1, NULL, NULL)

IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 16)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (16, 2, N'SNMP-PC', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 0, NULL, NULL)

IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 17)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (17, 2, N'SNMP-Server', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 1, NULL, NULL)

IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 18)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (18, 2, N'SNMP-Workstation', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 0, NULL, NULL)

IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 19)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (19, 2, N'SNMP-Telephon', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 0, NULL, NULL)

IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 20)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (20, 1, N'MAC', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 0, NULL, NULL)

IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 21)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (21, 2, N'Linux', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 1, NULL, NULL)

IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 22)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (22, 2, N'Solaris', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 1, NULL, NULL)

IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 23)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (23, 2, N'SunOS', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 1, NULL, NULL)

IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 24)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (24, 2, N'MacOS', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 0, NULL, NULL)

IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 25)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (25, 10, N'Schrank', NULL, NULL, CAST(N'2015-03-09T11:24:20.677' AS DateTime), N'', N'', 0, NULL, 0, NULL, NULL)

IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 26)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (26, 10, N'Tisch', NULL, NULL, CAST(N'2015-03-09T11:24:20.677' AS DateTime), N'Administrator', N'FCS-HAUSMESSE\Administrator', 0, NULL, 0, NULL, NULL)

IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 27)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (27, 10, N'Stuhl', NULL, NULL, CAST(N'2015-03-09T11:24:20.677' AS DateTime), N'Administrator', N'FCS-HAUSMESSE\Administrator', 0, NULL, 0, NULL, NULL)

IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 28)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (28, 10, N'Couch', NULL, NULL, CAST(N'2007-11-15T13:48:44.310' AS DateTime), N'', N'', 0, NULL, 0, NULL, NULL)

IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 29)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (29, 10, N'Lampe', NULL, NULL, CAST(N'2015-03-09T11:24:20.677' AS DateTime), N'', N'', 0, NULL, 0, NULL, NULL)

IF NOT EXISTS (SELECT * FROM [dbo].[DeviceType] WHERE DeviceTypeID = 30)
INSERT [dbo].[DeviceType] ([DeviceTypeID], [DeviceGroupID], [TypeName], [IconOK], [IconErr], [LastUpdate], [LastUpdateUser], [LastUpdateLogOnUser], [IsDefaultOfObjectGroup], [IsSystemEntry], [IsNWElementByDefault], [RefType], [RoomObjectType]) VALUES (30, 10, N'Bild', 0x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ateTime), N'Administrator', N'FCS\lstockum', 0, NULL, 0, NULL, NULL)
GO
SET IDENTITY_INSERT [dbo].[DeviceType] OFF
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[DeviceType]') AND name = N'DeviceType_PK')
ALTER TABLE [dbo].[DeviceType] ADD  CONSTRAINT [DeviceType_PK] PRIMARY KEY NONCLUSTERED
(
	[DeviceTypeID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[DeviceGroup] WHERE DeviceGroupID = 0)
    INSERT INTO [dbo].[DeviceGroup] (DeviceGroupID, DeviceGroupName, Description) VALUES (0, 'Heinzelmann', 'Geräte aus Heinzelmann')
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects where id = object_id(N'[dbo].[CommercialDevData]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN

	CREATE TABLE [dbo].[CommercialDevData](
			[CommercialDevDataID] int identity NOT NULL,
		[DeviceID] int NULL,
		[VendorID] int NULL,
		[ArticleID] int NULL,
		[PriceListID] int NULL,
		[FinanceTypeID] int NULL,
		[ServiceTypeID] int NULL,
		[InventoryNo] varchar(50) NULL,
		[AssetNo] varchar(50) NULL,
		[PurchaseDate] datetime NULL,
		[DeliveryDate] datetime NULL,
		[PurchasePrice] money default ((0)) NULL,
		[Description] varchar(250) NULL,
		[OutDate] datetime NULL,
		[ArticleNo] varchar(30) NULL,
		[ManuPartNumber] varchar(50) NULL,
		[WarrantyEnd] datetime NULL,
		[IsWarrantyEndReminding] bit default 0 NULL,
		[WarrantyEndRemindDate] datetime NULL,
		[AFAActiv] bit default ((0)) NOT NULL,
		[AFABasicprice] money NULL,
		[AFAUsingPeriod] int NULL,
		[AFAStartDate] datetime NULL,
		[AFAEndDate] datetime NULL,
		[AFAAccount] varchar(10) NULL,
		[AFAIsBookDiffering] bit default 0 NULL,
		[AFADifferingCostCenterID] int NULL,
		[AFADifferingRefID] int NULL,
		[AFADifferingRefType] int NULL,
		[LeasingActiv] bit default ((0)) NOT NULL,
		[LeasingVendorID] int NULL,
		[LeasingPeriod] int default ((0)) NULL,
		[LeasingDownPayment] money default ((0)) NULL,
		[LeasingRate] money default ((0)) NULL,
		[LeasingStartDate] datetime NULL,
		[LeasingEndDate] datetime NULL,
		[Leasingfactor] float NULL,
		[LeasingBasicprice] money NULL,
		[LeasingRemainValue] money NULL,
		[LeasingAccount] varchar(10) NULL,
		[LeasingCalculatedTo] datetime NULL,
		[DailyValue] money default ((0)) NULL,
		[MonthlyValue] money default ((0)) NULL,
		[ChargedValue] money default ((0)) NULL,
		[CreditValue] money default ((0)) NULL,
		[ContactPersonID] int NULL,
		[ContactPersonName] varchar(100) NULL,
		[ContactPersonTitle] varchar(50) NULL,
		[ContactPersonPhone] varchar(62) NULL,
		[OrderNumber] varchar(50) NULL,
		[ExtOrderNumber] varchar(50) NULL,
		[PurchaseOrderID] int NULL,
		[PurchaseOrderItemID] int NULL,
		[SaleOrderID] int NULL,
		[SaleOrderNumber] varchar(50) NULL,
		[DeliveryNote] varchar(50) NULL,
		[InvoiceNo] varchar(50) NULL,
		[InvoiceDate] datetime NULL,
		[MonthlyCosts] money NULL,
		[ExternalNo] varchar(50) NULL,
		[LastUpdate] datetime default GetDate() NOT NULL,
		[LastUpdateUser] varchar(50) NULL,
		[LastUpdateLogOnUser] varchar(50) NULL
		)

	IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[CommercialDevData_PK]') and OBJECTPROPERTY(id, N'IsConstraint') = 1)
		ALTER TABLE [dbo].[CommercialDevData]
		ADD CONSTRAINT [CommercialDevData_PK] PRIMARY KEY NONCLUSTERED (CommercialDevDataID)


END
ELSE
BEGIN

	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'CommercialDevDataID')
		ALTER TABLE [dbo].[CommercialDevData] ADD [CommercialDevDataID]  int identity NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'DeviceID')
		ALTER TABLE [dbo].[CommercialDevData] ADD [DeviceID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'VendorID')
		ALTER TABLE [dbo].[CommercialDevData] ADD [VendorID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'ArticleID')
		ALTER TABLE [dbo].[CommercialDevData] ADD [ArticleID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'PriceListID')
		ALTER TABLE [dbo].[CommercialDevData] ADD [PriceListID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'FinanceTypeID')
		ALTER TABLE [dbo].[CommercialDevData] ADD [FinanceTypeID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'ServiceTypeID')
		ALTER TABLE [dbo].[CommercialDevData] ADD [ServiceTypeID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'InventoryNo')
		ALTER TABLE [dbo].[CommercialDevData] ADD [InventoryNo]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'AssetNo')
		ALTER TABLE [dbo].[CommercialDevData] ADD [AssetNo]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'PurchaseDate')
		ALTER TABLE [dbo].[CommercialDevData] ADD [PurchaseDate]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'DeliveryDate')
		ALTER TABLE [dbo].[CommercialDevData] ADD [DeliveryDate]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'PurchasePrice')
		ALTER TABLE [dbo].[CommercialDevData] ADD [PurchasePrice]  money default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'Description')
		ALTER TABLE [dbo].[CommercialDevData] ADD [Description]  varchar(250) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'OutDate')
		ALTER TABLE [dbo].[CommercialDevData] ADD [OutDate]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'ArticleNo')
		ALTER TABLE [dbo].[CommercialDevData] ADD [ArticleNo]  varchar(30) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'ManuPartNumber')
		ALTER TABLE [dbo].[CommercialDevData] ADD [ManuPartNumber]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'WarrantyEnd')
		ALTER TABLE [dbo].[CommercialDevData] ADD [WarrantyEnd]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'IsWarrantyEndReminding')
		ALTER TABLE [dbo].[CommercialDevData] ADD [IsWarrantyEndReminding]  bit default 0 NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'WarrantyEndRemindDate')
		ALTER TABLE [dbo].[CommercialDevData] ADD [WarrantyEndRemindDate]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'AFAActiv')
		ALTER TABLE [dbo].[CommercialDevData] ADD [AFAActiv]  bit default ((0)) NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'AFABasicprice')
		ALTER TABLE [dbo].[CommercialDevData] ADD [AFABasicprice]  money NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'AFAUsingPeriod')
		ALTER TABLE [dbo].[CommercialDevData] ADD [AFAUsingPeriod]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'AFAStartDate')
		ALTER TABLE [dbo].[CommercialDevData] ADD [AFAStartDate]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'AFAEndDate')
		ALTER TABLE [dbo].[CommercialDevData] ADD [AFAEndDate]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'AFAAccount')
		ALTER TABLE [dbo].[CommercialDevData] ADD [AFAAccount]  varchar(10) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'AFAIsBookDiffering')
		ALTER TABLE [dbo].[CommercialDevData] ADD [AFAIsBookDiffering]  bit default 0 NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'AFADifferingCostCenterID')
		ALTER TABLE [dbo].[CommercialDevData] ADD [AFADifferingCostCenterID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'AFADifferingRefID')
		ALTER TABLE [dbo].[CommercialDevData] ADD [AFADifferingRefID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'AFADifferingRefType')
		ALTER TABLE [dbo].[CommercialDevData] ADD [AFADifferingRefType]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'LeasingActiv')
		ALTER TABLE [dbo].[CommercialDevData] ADD [LeasingActiv]  bit default ((0)) NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'LeasingVendorID')
		ALTER TABLE [dbo].[CommercialDevData] ADD [LeasingVendorID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'LeasingPeriod')
		ALTER TABLE [dbo].[CommercialDevData] ADD [LeasingPeriod]  int default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'LeasingDownPayment')
		ALTER TABLE [dbo].[CommercialDevData] ADD [LeasingDownPayment]  money default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'LeasingRate')
		ALTER TABLE [dbo].[CommercialDevData] ADD [LeasingRate]  money default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'LeasingStartDate')
		ALTER TABLE [dbo].[CommercialDevData] ADD [LeasingStartDate]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'LeasingEndDate')
		ALTER TABLE [dbo].[CommercialDevData] ADD [LeasingEndDate]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'Leasingfactor')
		ALTER TABLE [dbo].[CommercialDevData] ADD [Leasingfactor]  float NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'LeasingBasicprice')
		ALTER TABLE [dbo].[CommercialDevData] ADD [LeasingBasicprice]  money NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'LeasingRemainValue')
		ALTER TABLE [dbo].[CommercialDevData] ADD [LeasingRemainValue]  money NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'LeasingAccount')
		ALTER TABLE [dbo].[CommercialDevData] ADD [LeasingAccount]  varchar(10) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'LeasingCalculatedTo')
		ALTER TABLE [dbo].[CommercialDevData] ADD [LeasingCalculatedTo]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'DailyValue')
		ALTER TABLE [dbo].[CommercialDevData] ADD [DailyValue]  money default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'MonthlyValue')
		ALTER TABLE [dbo].[CommercialDevData] ADD [MonthlyValue]  money default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'ChargedValue')
		ALTER TABLE [dbo].[CommercialDevData] ADD [ChargedValue]  money default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'CreditValue')
		ALTER TABLE [dbo].[CommercialDevData] ADD [CreditValue]  money default ((0)) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'ContactPersonID')
		ALTER TABLE [dbo].[CommercialDevData] ADD [ContactPersonID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'ContactPersonName')
		ALTER TABLE [dbo].[CommercialDevData] ADD [ContactPersonName]  varchar(100) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'ContactPersonTitle')
		ALTER TABLE [dbo].[CommercialDevData] ADD [ContactPersonTitle]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'ContactPersonPhone')
		ALTER TABLE [dbo].[CommercialDevData] ADD [ContactPersonPhone]  varchar(62) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'OrderNumber')
		ALTER TABLE [dbo].[CommercialDevData] ADD [OrderNumber]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'ExtOrderNumber')
		ALTER TABLE [dbo].[CommercialDevData] ADD [ExtOrderNumber]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'PurchaseOrderID')
		ALTER TABLE [dbo].[CommercialDevData] ADD [PurchaseOrderID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'PurchaseOrderItemID')
		ALTER TABLE [dbo].[CommercialDevData] ADD [PurchaseOrderItemID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'SaleOrderID')
		ALTER TABLE [dbo].[CommercialDevData] ADD [SaleOrderID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'SaleOrderNumber')
		ALTER TABLE [dbo].[CommercialDevData] ADD [SaleOrderNumber]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'DeliveryNote')
		ALTER TABLE [dbo].[CommercialDevData] ADD [DeliveryNote]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'InvoiceNo')
		ALTER TABLE [dbo].[CommercialDevData] ADD [InvoiceNo]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'InvoiceDate')
		ALTER TABLE [dbo].[CommercialDevData] ADD [InvoiceDate]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'MonthlyCosts')
		ALTER TABLE [dbo].[CommercialDevData] ADD [MonthlyCosts]  money NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'ExternalNo')
		ALTER TABLE [dbo].[CommercialDevData] ADD [ExternalNo]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'LastUpdate')
		ALTER TABLE [dbo].[CommercialDevData] ADD [LastUpdate]  datetime default GetDate() NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'LastUpdateUser')
		ALTER TABLE [dbo].[CommercialDevData] ADD [LastUpdateUser]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[CommercialDevData]') and name = 'LastUpdateLogOnUser')
		ALTER TABLE [dbo].[CommercialDevData] ADD [LastUpdateLogOnUser]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[CommercialDevData_PK]') and OBJECTPROPERTY(id, N'IsConstraint') = 1)
		ALTER TABLE [dbo].[CommercialDevData]
		ADD CONSTRAINT [CommercialDevData_PK] PRIMARY KEY NONCLUSTERED (CommercialDevDataID)


END
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_AssetParamVisibilities]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_AssetParamVisibilities](
	[field] varchar(200) NOT NULL,
        [type] varchar(200) NOT NULL,
        [label] varchar(200) NULL,
        [description] varchar(500) NULL,
        [visibleintable] int NULL ,
        [visibleinform]int NULL ,
 CONSTRAINT [PK_AssetParamVisibilities] PRIMARY KEY CLUSTERED
(
	[field] ASC,
	[type] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_WFDef_StartWF]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_WFDef_StartWF](
    [FromActivityID] [int] NOT NULL,
    [FromWFIID] [int] NOT NULL,
    [WFDID] [int] NOT NULL,
    [InstanceDescr] [varchar](500) NULL,
    [InitiatorID] [int] NULL,
    [SubstitudeID] [int] NULL,
    [ContactID] [int] NULL,
    [ProjectID] [int] NULL,
    [RefLvl2ID] [int] NULL,
    [projectsource] [int] NULL,
    [contactsource] [int] NULL,
    [substitudesource] [int] NULL,
    [titlesource] [int] NULL,
    [initiatorSource] [int] NULL,
    [InitiatorSourceField]  [varchar](500) NULL,
    [SubstitudeSourceField]  [varchar](500) NULL,
)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_WFInstanz' AND COLUMN_NAME = 'StartedByActivityID')
ALTER TABLE [dbo].[hm_WFInstanz] ADD [StartedByActivityID] [int] NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_WF_Activity' AND COLUMN_NAME = 'StartedWFIID')
ALTER TABLE [dbo].[hm_WF_Activity] ADD [StartedWFIID] [int] NULL
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects where id = object_id(N'[dbo].[SWProductCatalog]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN

	CREATE TABLE [dbo].[SWProductCatalog](
			[SWProductCatalogID] int identity NOT NULL,
		[SWCatalogID] int NULL,
		[ProdName] varchar(100) NOT NULL,
		[ProdVersion] varchar(100) NULL,
		[ProdLanguage] varchar(100) NULL,
		[ProdVendor] varchar(100) NULL,
		[CategoryNo] int NULL,
		[Descr] varchar(100) NULL,
		[CreateDate] datetime NOT NULL,
		[IsExcluded] bit default ((0)) NOT NULL,
		[LastUpdate] datetime default GetDate() NOT NULL,
		[LastUpdateUser] varchar(50) NULL,
		[LastUpdateLogOnUser] varchar(50) NULL,
		[FOCUploaded] bit default ((0)) NOT NULL
		)

	IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[SWProductCatalog_PK]') and OBJECTPROPERTY(id, N'IsConstraint') = 1)
		ALTER TABLE [dbo].[SWProductCatalog]
		ADD CONSTRAINT [SWProductCatalog_PK] PRIMARY KEY NONCLUSTERED (SWProductCatalogID)


END
ELSE
BEGIN

	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProductCatalog]') and name = 'SWProductCatalogID')
		ALTER TABLE [dbo].[SWProductCatalog] ADD [SWProductCatalogID]  int identity NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProductCatalog]') and name = 'SWCatalogID')
		ALTER TABLE [dbo].[SWProductCatalog] ADD [SWCatalogID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProductCatalog]') and name = 'ProdName')
		ALTER TABLE [dbo].[SWProductCatalog] ADD [ProdName]  varchar(100) NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProductCatalog]') and name = 'ProdVersion')
		ALTER TABLE [dbo].[SWProductCatalog] ADD [ProdVersion]  varchar(100) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProductCatalog]') and name = 'ProdLanguage')
		ALTER TABLE [dbo].[SWProductCatalog] ADD [ProdLanguage]  varchar(100) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProductCatalog]') and name = 'ProdVendor')
		ALTER TABLE [dbo].[SWProductCatalog] ADD [ProdVendor]  varchar(100) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProductCatalog]') and name = 'CategoryNo')
		ALTER TABLE [dbo].[SWProductCatalog] ADD [CategoryNo]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProductCatalog]') and name = 'Descr')
		ALTER TABLE [dbo].[SWProductCatalog] ADD [Descr]  varchar(100) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProductCatalog]') and name = 'CreateDate')
		ALTER TABLE [dbo].[SWProductCatalog] ADD [CreateDate]  datetime NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProductCatalog]') and name = 'IsExcluded')
		ALTER TABLE [dbo].[SWProductCatalog] ADD [IsExcluded]  bit default ((0)) NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProductCatalog]') and name = 'LastUpdate')
		ALTER TABLE [dbo].[SWProductCatalog] ADD [LastUpdate]  datetime default GetDate() NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProductCatalog]') and name = 'LastUpdateUser')
		ALTER TABLE [dbo].[SWProductCatalog] ADD [LastUpdateUser]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProductCatalog]') and name = 'LastUpdateLogOnUser')
		ALTER TABLE [dbo].[SWProductCatalog] ADD [LastUpdateLogOnUser]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[SWProductCatalog]') and name = 'FOCUploaded')
		ALTER TABLE [dbo].[SWProductCatalog] ADD [FOCUploaded]  bit default ((0)) NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[SWProductCatalog_PK]') and OBJECTPROPERTY(id, N'IsConstraint') = 1)
		ALTER TABLE [dbo].[SWProductCatalog]
		ADD CONSTRAINT [SWProductCatalog_PK] PRIMARY KEY NONCLUSTERED (SWProductCatalogID)


END
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects where id = object_id(N'[dbo].[Vendor]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN

	CREATE TABLE [dbo].[Vendor](
			[VendorID] int identity NOT NULL,
		[VendorNumber] varchar(30) NOT NULL,
		[VendorNameShort] varchar(50) NOT NULL,
		[VendorName1] varchar(50) NOT NULL,
		[VendorName2] varchar(50) NULL,
		[VendorName3] varchar(50) NULL,
		[CountryID] int NULL,
		[TermsOfPaymentID] int NULL,
		[ZipCode] varchar(10) NULL,
		[City] varchar(50) NULL,
		[Street] varchar(50) NULL,
		[Postbox] varchar(30) NULL,
		[Phone] varchar(50) NULL,
		[Fax] varchar(30) NULL,
		[Internet] varchar(255) NULL,
		[Remark] varchar(400) NULL,
		[VendorCustomerNo] varchar(30) NULL,
		[LockInfo] bit default 0 NULL,
		[LockDate] datetime NULL,
		[LockUser] varchar(50) NULL,
		[LastUpdate] datetime default GetDate() NOT NULL,
		[LastUpdateUser] varchar(50) NULL,
		[LastUpdateLogOnUser] varchar(50) NULL,
		[ClientID] int NULL
		)

	IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Vendor_PK]') and OBJECTPROPERTY(id, N'IsConstraint') = 1)
		ALTER TABLE [dbo].[Vendor]
		ADD CONSTRAINT [Vendor_PK] PRIMARY KEY NONCLUSTERED (VendorID)
END
ELSE
BEGIN

	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'VendorID')
		ALTER TABLE [dbo].[Vendor] ADD [VendorID]  int identity NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'VendorNumber')
		ALTER TABLE [dbo].[Vendor] ADD [VendorNumber]  varchar(30) NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'VendorNameShort')
		ALTER TABLE [dbo].[Vendor] ADD [VendorNameShort]  varchar(50) NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'VendorName1')
		ALTER TABLE [dbo].[Vendor] ADD [VendorName1]  varchar(50) NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'VendorName2')
		ALTER TABLE [dbo].[Vendor] ADD [VendorName2]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'VendorName3')
		ALTER TABLE [dbo].[Vendor] ADD [VendorName3]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'CountryID')
		ALTER TABLE [dbo].[Vendor] ADD [CountryID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'TermsOfPaymentID')
		ALTER TABLE [dbo].[Vendor] ADD [TermsOfPaymentID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'ZipCode')
		ALTER TABLE [dbo].[Vendor] ADD [ZipCode]  varchar(10) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'City')
		ALTER TABLE [dbo].[Vendor] ADD [City]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'Street')
		ALTER TABLE [dbo].[Vendor] ADD [Street]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'Postbox')
		ALTER TABLE [dbo].[Vendor] ADD [Postbox]  varchar(30) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'Phone')
		ALTER TABLE [dbo].[Vendor] ADD [Phone]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'Fax')
		ALTER TABLE [dbo].[Vendor] ADD [Fax]  varchar(30) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'Internet')
		ALTER TABLE [dbo].[Vendor] ADD [Internet]  varchar(255) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'Remark')
		ALTER TABLE [dbo].[Vendor] ADD [Remark]  varchar(400) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'VendorCustomerNo')
		ALTER TABLE [dbo].[Vendor] ADD [VendorCustomerNo]  varchar(30) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'LockInfo')
		ALTER TABLE [dbo].[Vendor] ADD [LockInfo]  bit default 0 NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'LockDate')
		ALTER TABLE [dbo].[Vendor] ADD [LockDate]  datetime NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'LockUser')
		ALTER TABLE [dbo].[Vendor] ADD [LockUser]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'LastUpdate')
		ALTER TABLE [dbo].[Vendor] ADD [LastUpdate]  datetime default GetDate() NOT NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'LastUpdateUser')
		ALTER TABLE [dbo].[Vendor] ADD [LastUpdateUser]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'LastUpdateLogOnUser')
		ALTER TABLE [dbo].[Vendor] ADD [LastUpdateLogOnUser]  varchar(50) NULL
	IF NOT EXISTS (SELECT * FROM dbo.syscolumns where id = object_id(N'[dbo].[Vendor]') and name = 'ClientID')
		ALTER TABLE [dbo].[Vendor] ADD [ClientID]  int NULL
	IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Vendor_PK]') and OBJECTPROPERTY(id, N'IsConstraint') = 1)
		ALTER TABLE [dbo].[Vendor]
		ADD CONSTRAINT [Vendor_PK] PRIMARY KEY NONCLUSTERED (VendorID)
END
GO
/* Rechte Panelanordnung */
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1007)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID)
VALUES (1007, 'Ticketdetailansicht laden', 1, 46, 'Ohne dieses Recht können Benutzer nicht zwischen eigene Ansicht, Gruppenansicht und Default-Ansicht wechseln', 24)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_GroupRights] WHERE right_id = 219 AND group_id = 1)
    INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 219)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_GroupRights] WHERE right_id = 220 AND group_id = 1)
    INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 220)
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_Backlog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_Backlog](
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
        [Name] [varchar](255) NULL,
	[CreateUserID] [int] DEFAULT 0 NOT NULL,
	[CreateDate] [datetime]  DEFAULT GETDATE() NOT NULL
 CONSTRAINT [PK_hm_Backlog] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_BacklogGroups]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_BacklogGroups](
	[BacklogID] [int] NOT NULL ,
        [GroupID] [int] NOT NULL
 CONSTRAINT [PK_hm_BacklogGroups] PRIMARY KEY CLUSTERED
(
	[BacklogID] ASC,
        [GroupID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_BacklogTicket]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_BacklogTicket](
	[BacklogID] [int] NOT NULL ,
        [TicketID] [int] NOT NULL,
	[AddDate] [datetime]  DEFAULT GETDATE() NOT NULL,
        [AddUserID] [int] DEFAULT 0 NOT NULL,
        [OrderNo] [int] NULL
 CONSTRAINT [PK_hm_BacklogTicket] PRIMARY KEY CLUSTERED
(
	[BacklogID] ASC,
        [TicketID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_BacklogSprint]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_BacklogSprint](
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[BacklogID] [int] NOT NULL ,
    [Name] [varchar](255) NULL,
	[StartDate] [datetime]  NULL,
    [EndDate] [datetime]  NULL,
    [AvailableHours] [int] NULL,
    [CreateDate] [datetime]  DEFAULT GETDATE() NOT NULL,
    [CreateUserID] [int] NULL,
    [Active] [int] DEFAULT 1 NOT NULL,
    [Info] [text] NULL,
    [NewSprintID] [bigint] NULL
 CONSTRAINT [PK_hm_BlSprint] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_BacklogSprintUser]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_BacklogSprintUser](
	[SprintID] [int] NOT NULL ,
        [UserID] [int] NOT NULL ,
        [AvailableQuote] [int] NOT NULL ,
        [AddDate] [datetime]  DEFAULT GETDATE() NOT NULL
 CONSTRAINT [PK_hm_BlSprintUser] PRIMARY KEY CLUSTERED
(
	[SprintID] ASC,
        [UserID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_BacklogSprintTicket]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_BacklogSprintTicket](
	[SprintID] [int] NOT NULL ,
    [TicketID] [int] NOT NULL ,
    [StatusInSprint] [int] DEFAULT 1 NOT NULL ,
    [AddDate] [datetime]  DEFAULT GETDATE() NOT NULL,
    [OrderNo] [bigint] DEFAULT(0) NULL
 CONSTRAINT [PK_hm_BlSprintTicket] PRIMARY KEY CLUSTERED
(
	[SprintID] ASC,
        [TicketID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_BacklogSprintTicket' AND COLUMN_NAME = 'StatusInSprint')
ALTER TABLE [dbo].[hm_BacklogSprintTicket] ADD
    [StatusInSprint] [int] DEFAULT 1 NOT NULL
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_BacklogSprintLog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_BacklogSprintLog](
	[SprintID] [int] NOT NULL ,
        [DaysSinceStart] [int] NOT NULL ,
        [ExpenseOverALL] [int] NOT NULL ,
        [ExpenseLeft] [int] NOT NULL,
        [ExpensePlaned] [int]  NULL,
        [TicketsTotal] [int]  NULL,
        [TicketsOpen] [int]  NULL
 CONSTRAINT [PK_hm_BLSprintLog] PRIMARY KEY CLUSTERED
(
	[SprintID] ASC,
        [DaysSinceStart] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 900)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
    VALUES (900, 'Backlogs verwalten', 3, 100, 45, 'Benutzer mit diesem Recht dürfen Backlogs und Sprints anlegen und bearbeiten.');
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_GroupRights] WHERE right_id = 900 AND group_id = 1)
    INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 900)
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_DeviceTypeGroup]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_DeviceTypeGroup](
	[DeviceTypeID] [int] NOT NULL ,
        [GroupID] [int] NOT NULL
 CONSTRAINT [PK_hm_DeviceTypeGroup] PRIMARY KEY CLUSTERED
(
	[DeviceTypeID] ASC,
        [GroupID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_RightsSegment] WHERE SegmentID = 50)
    INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (50, 'Fehlerbilder & Klassifikation', 10)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1100)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID) VALUES (1100, 'Klassifikationen und Fehlerbilder bearbeiten', 3, 10, 'Benutzer mit diesem Recht können Klassifikationen und Fehlerbilder anlegen und bearbeiten.', 50)
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_EPClassification]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_EPClassification](
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
        [Level] [int]  DEFAULT(1) NOT NULL,
        [Descr_de] varchar(100) NULL,
        [Descr_en] varchar(100) NULL,
        [CodeKey] [int] NULL
 CONSTRAINT [PK_hm_EPClass] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_EPClassPairs]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_EPClassPairs](
	[MainGroupID] [int] NOT NULL ,
        [SubGroupID] [int] NOT NULL,
        [CreateDate] datetime DEFAULT GETDATE() NOT NULL
 CONSTRAINT [PK_hm_EPClassPairs] PRIMARY KEY CLUSTERED
(
	[MainGroupID] ASC,
        [SubGroupID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_EPErrorDescr]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_EPErrorDescr](
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
        [Descr_de] varchar(100) NULL,
        [Descr_en] varchar(100) NULL
 CONSTRAINT [PK_hm_EPErrorDescr] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_EPErrorObject]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_EPErrorObject](
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
        [Descr_de] varchar(100) NULL,
        [Descr_en] varchar(100) NULL
 CONSTRAINT [PK_hm_EPErrorObject] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_EPErrorPreposition]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_EPErrorPreposition](
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
        [Descr_de] varchar(100) NULL,
        [Descr_en] varchar(100) NULL
 CONSTRAINT [PK_hm_EPErrorPreposition] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_EPErrorPattern]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_EPErrorPattern](
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
        [ErrorDescrID] [int] NOT NULL,
        [ErrorObjectID] [int] NOT NULL,
        [ErrorPrepositionID] [int] NOT NULL,
        CreateUserID [int] NOT NULL,
        CreateDate [datetime] DEFAULT GETDATE() NOT NULL
 CONSTRAINT [PK_hm_EPErrorPattern] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_TicketErrorPattern]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_TicketErrorPattern](
	[TicketID] [int] NOT NULL ,
        [MainGroupClassID] [int]  NULL,
        [SubGroupClassID] [int]  NULL,
        [ErrorPatternID] [int]  NULL,
        CreateUserID [int] NOT NULL,
        CreateDate [datetime] DEFAULT GETDATE() NOT NULL
 CONSTRAINT [PK_hm_TicketEP] PRIMARY KEY CLUSTERED
(
	[TicketID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_EPErrorCode]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_EPErrorCode](
	[ErrorCode] [int] NOT NULL ,
        [ArticleNo] varchar(100) NULL,
        [Descr_de] varchar(4000) NULL,
        [Descr_en] varchar(4000) NULL,
        [Active] [bit] DEFAULT (1) NOT NULL,
        [CreateUserID] [int] NOT NULL,
        [CreateDate] [datetime] DEFAULT GETDATE() NOT NULL
 CONSTRAINT [PK_hm_EPErrorCode] PRIMARY KEY CLUSTERED
(
	[ErrorCode] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_TicketErrorCode]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_TicketErrorCode](
	[TicketID] [int] NOT NULL ,
        [ErrorCode] [int] NOT NULL ,
        [SessionID] [varchar](64) DEFAULT NULL NULL,
        [CreateUserID] [int] NOT NULL,
        [CreateDate] [datetime] DEFAULT GETDATE() NOT NULL
 CONSTRAINT [PK_hm_TicketErrorCode] PRIMARY KEY CLUSTERED
(
	[TicketID] ASC,
        [ErrorCode] ASC
)
) ON [PRIMARY]  
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_EPErrorPatternAssetType]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_EPErrorPatternAssetType](
		[PatternID] [int] NOT NULL,
        [DeviceTypeID] [int] NOT NULL,
        [CreateUser] [varchar] (50)  NOT NULL,
        [CreateDate] [datetime] DEFAULT GETDATE() NOT NULL
 CONSTRAINT [PK_hm_EPErrorPatternAssetType] PRIMARY KEY CLUSTERED
(
	[PatternID] ASC,
	[DeviceTypeID] ASC
)
) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_MultiLogin]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
    CREATE TABLE [dbo].[hm_MultiLogin] (
        [user_id] [bigint] NOT NULL ,
        [AccessToken] [varchar](255) NOT NULL,
        [CreateDate] [datetime] NOT NULL,
        [APIKey] [varchar] (255) NULL
    ) ON [PRIMARY];
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_EPClassiAssettype]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_EPClassiAssettype](
	[AssettypeID] [int] NOT NULL ,
        [MainGroupID] [int] NOT NULL,
        [SubGroupID] [int]  NULL,
        [CreateDate] [datetime] NOT NULL DEFAULT (GETDATE()),
        [CreateUserID] [int] NULL
)
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_EPClassiErrorCodes]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].hm_EPClassiErrorCodes(
        [AssettypeID] [int] NOT NULL ,
        [MainGroupID] [int] NOT NULL,
        [SubGroupID] [int]  NULL,
	[ErrorCodeID] [int]  NOT NULL,
        [CreateDate] [datetime] NOT NULL DEFAULT (GETDATE()),
        [CreateUserID] [int] NULL
)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_RightsSegment] WHERE SegmentID = 60)
    INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (60, 'Historie', 1500)
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1200)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID) VALUES (1200, 'Historie anzeigen', 3, 40, 'Benutzer mit diesem Recht können die Systemhistorie sehen', 60)
GO


IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_BKSegment]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].hm_BKSegment(
        [ID] [int] IDENTITY (1, 1) NOT NULL ,
        [SegmentName] [varchar](255) NOT NULL,
        [Active] [bit] DEFAULT (1) NOT NULL
 CONSTRAINT [PK_hm_BKSegment] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_BKGruppe]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].hm_BKGruppe(
        [ID] [int] IDENTITY (1, 1) NOT NULL ,
        [SegmentID] [int] NOT NULL,
        [GruppenName] [varchar](255) NOT NULL,
        [Active] [bit] DEFAULT (1) NOT NULL
 CONSTRAINT [PK_hm_BKGruppe] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_BKArtikel]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].hm_BKArtikel(
        [ArtikelNr] [varchar](255) NOT NULL,
        [Version] [varchar](255) NOT NULL,
        [ArtikelName] [varchar](255) NOT NULL,
        [GruppenID] [int] NOT NULL,
        [jsonData] nvarchar(max) NULL,
        [Active] [bit] DEFAULT (1) NOT NULL,
        [RequestTypeID] [int]  NULL
 CONSTRAINT [PK_hm_BKArtikel] PRIMARY KEY CLUSTERED
(
	[ArtikelNr] ASC,
        [Version] ASC
)
) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_RightsSegment] WHERE SegmentID = 60)
    INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (60, 'Historie', 1500)
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1200)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID) VALUES (1200, 'Historie anzeigen', 3, 40, 'Benutzer mit diesem Recht können die Systemhistorie sehen', 60)
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 203)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
VALUES (203, 'Assetdaten anzeigen', 1, 4, 1, 'Ohne dieses Recht können Benutzer die Assetdaten nicht sehen.')
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_GroupRights] WHERE right_id = 203 AND group_id = 1)
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 203)
GO

ALTER TABLE hm_TicketPrio ALTER COLUMN Descr VARCHAR(30)
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Users' AND COLUMN_NAME = 'NewTicketPosition')
ALTER TABLE [dbo].[hm_Users] ADD
    [NewTicketPosition] [varchar](max) NULL
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Groups' AND COLUMN_NAME = 'NewTicketPosition')
ALTER TABLE [dbo].[hm_Groups] ADD
    [NewTicketPosition] [varchar](max) NULL
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Users' AND COLUMN_NAME = 'NewTicketPositionGroup')
ALTER TABLE [dbo].[hm_Users] ADD
    [NewTicketPositionGroup] [int] DEFAULT 0 NOT NULL
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1008)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
VALUES (1008, 'Ticketansichten verwalten', 1, 47, 24, 'Benutzer mit diesem Recht können dem Interessierten Kreis keine Gruppen zuweisen.')
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_GroupRights] WHERE right_id = 1008 AND group_id = 1)
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 1008)
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_WebFormular]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_WebFormular](
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
        [APIKey] [varchar](255) NOT NULL,
        [TemplateFile] [varchar](255) NULL,
        [Description] [varchar](255) NULL,
        [UserID] [bigint] NOT NULL, 
        [CreateDate] [datetime] NOT NULL,
        [CreateUser][bigint] NOT NULL,
        [UpdateDate][datetime] NOT NULL,
        [UpdateUser][bigint] NOT NULL,
        [LongDescription][varchar](max) NULL
 CONSTRAINT [PK_hm_WebFormular] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)
) ON [PRIMARY]
GO
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ServiceScheck]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
	CREATE TABLE [dbo].[hm_ServiceScheck](
		[ServiceScheckID] [int] IDENTITY(1,1) NOT NULL,
		[ServiceScheckName] [varchar](255) NOT NULL
	 CONSTRAINT [PK_hm_ServiceScheck] PRIMARY KEY CLUSTERED
	(
		[ServiceScheckID] ASC
	)
	) ON [PRIMARY]
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('Händlereingangskontrolle')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('Inbetriebnahme')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('250 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('500 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('1000 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('1500 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('2000 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('2500 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('3000 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('3500 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('4000 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('4500 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('5000 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('5500 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('6000 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('6500 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('7000 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('7500 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('8000 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('8500 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('9000 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('9500 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('10000 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('10500 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('11000 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('11500 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('12000 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('12500 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('13000 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('13500 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('14000 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('14500 Stunden Service')
	INSERT INTO hm_ServiceScheck (ServiceScheckName) VALUES ('15000 Stunden Service')
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ServiceScheckExecutionType]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
	CREATE TABLE [dbo].[hm_ServiceScheckExecutionType](
		[ServiceScheckExecutionTypeID] [int] IDENTITY(1,1)  NOT NULL,
		[ServiceScheckExecutionTypeName] [varchar](255) NOT NULL
	 CONSTRAINT [PK_hm_ServiceScheckExecutionType] PRIMARY KEY CLUSTERED
	(
		[ServiceScheckExecutionTypeID] ASC
	)
	) ON [PRIMARY]
	INSERT INTO [dbo].[hm_ServiceScheckExecutionType] (ServiceScheckExecutionTypeName) VALUES ('Durchführung durch Händler')
	INSERT INTO [dbo].[hm_ServiceScheckExecutionType] (ServiceScheckExecutionTypeName) VALUES ('Durchführung durch Kunde mit Original Teilen')
	INSERT INTO [dbo].[hm_ServiceScheckExecutionType] (ServiceScheckExecutionTypeName) VALUES ('Durchführung durch Kunden')
	INSERT INTO [dbo].[hm_ServiceScheckExecutionType] (ServiceScheckExecutionTypeName) VALUES ('Durchführung durch Fremdwerkstatt')
	INSERT INTO [dbo].[hm_ServiceScheckExecutionType] (ServiceScheckExecutionTypeName) VALUES ('Sonstiges')
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ServiceScheckToTicket]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ServiceScheckToTicket](
	[ServiceScheckID] [int] NOT NULL,
	[TicketID] [int] NOT NULL,
	[DeviceID] [int] NOT NULL,
	[ServiceScheckExecutionTypeID] [int] NOT NULL
)
GO
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 826)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
VALUES (826, 'Alle Firmen im Suchfilter anzeigen', 1, 12, 27, 'Mit diesem Recht kann der User alle Firmen in der Ticketliste sehen.')
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 80)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID)
VALUES (80, 'Benötigt Aktion ausblenden', 2, 10, 'Mit diesem Recht wird die Checkbox Benötigt Aktion im Ticketevent ausgeblendet', 25)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 81)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID)
VALUES (81, 'Bearbeitungsdatum ausblenden', 2, 10, 'Mit diesem Recht wird das Bearbeitungsdatum im Ticketevent ausgeblendet', 25)
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_BKRequestType]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].hm_BKRequestType(
        [RequestTypeID] [int]  IDENTITY (1, 1) NOT NULL ,
        [RequestType] [varchar](255) NOT NULL
 CONSTRAINT [PK_hm_BKRequestType] PRIMARY KEY CLUSTERED
(
	[RequestTypeID] ASC,
        [RequestType] ASC
)
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[hm_OrderCatalogArticleAttachment] (
	[ArticleID] [varchar](255) NOT NULL,
	[AttachmentID] [bigint] NOT NULL
) ON [PRIMARY]
GO


IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 853)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
VALUES (853, '+ Tickets des eigenen Mandanten', 1, 27, 11, 'Über dieses Recht könnte man alle Tickets des jeweiligen Mandanten über alle Gruppen hinweg sehen, ohne tatsächlich Gruppenmitglied zu sein.')
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_WF_TargetGroup]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_WF_TargetGroup](
	[ActivityDefID] [int] NOT NULL,
	[GroupID] [int] NOT NULL,
 CONSTRAINT [PK_hm_WF_TargetGroup] PRIMARY KEY CLUSTERED
(
	[ActivityDefID] ASC,
	[GroupID] ASC
)
) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_WF_TargetUser]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_WF_TargetUser](
	[ActivityDefID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
 CONSTRAINT [PK_hm_WF_TargetUser] PRIMARY KEY CLUSTERED
(
	[ActivityDefID] ASC,
	[UserID] ASC
)
) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_Activity_TargetGroup]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_Activity_TargetGroup](
	[ActivityID] [int] NOT NULL,
	[GroupID] [int] NOT NULL,
 CONSTRAINT [PK_hm_Activity_TargetGroup] PRIMARY KEY CLUSTERED
(
	[ActivityID] ASC,
	[GroupID] ASC
)
) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_Activity_TargetUser]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_Activity_TargetUser](
	[ActivityID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
 CONSTRAINT [PK_hm_Activity_TargetUser] PRIMARY KEY CLUSTERED
(
	[ActivityID] ASC,
	[UserID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 827)
                        INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
                        VALUES (827, 'Ticketstatus NEU halten', 1, 27, 13, 'Keine Änderung des Status von NEU zu OFFEN, wenn der Benutzer ein neues Ticket öffnet.')
GO

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Rights' AND COLUMN_NAME = 'RightName')
ALTER TABLE hm_Rights ALTER COLUMN RightName VARCHAR (5000);
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1300)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, SegmentID, RightsSectionID, RightsOrder, RightDescr)
VALUES (1300, 'Benutzer / Kontakte aus Azure Active Directory importieren', 13, 4, 5, 'Benutzer mit diesem Recht können Benutzer / Kontakte aus Azure Active Directory importieren.')
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_GroupRights] WHERE right_id = 1300 AND group_id = 1)
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 1300)

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Ticket' AND COLUMN_NAME = 'TicketStoryID')
ALTER TABLE [dbo].[hm_Ticket] ADD
    [TicketStoryID] [bigint] NULL
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Ticket' AND COLUMN_NAME = 'isStory')
ALTER TABLE [dbo].[hm_Ticket] ADD
    [isStory] [bit] DEFAULT(0) NULL
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_tickettype' AND COLUMN_NAME = 'OrderNo')
ALTER TABLE [dbo].[hm_tickettype] ADD
    [OrderNo] [bigint] DEFAULT(0) NULL
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_tickettemplate' AND COLUMN_NAME = 'OrderNo')
ALTER TABLE [dbo].[hm_tickettemplate] ADD
    [OrderNo] [bigint] DEFAULT(0) NULL
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_WFDefinitions' AND COLUMN_NAME = 'OrderNo')
ALTER TABLE [dbo].[hm_WFDefinitions] ADD
    [OrderNo] [bigint] DEFAULT(0) NULL
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1009)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
VALUES (1009, 'Ansicht der Vorschaltseite verwalten', 1, 48, 24, 'Mit diesem Recht kann der Benutzer die Ansicht der Vorschaltseite anpassen.')
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Configuration] WHERE [ConfigurationName] = 'VSOrder')
INSERT INTO [dbo].[hm_Configuration] (ConfigurationName, Configuration)
VALUES ('VSOrder', '[{"index":1,"id":"TT","collapse":false},{"index":2,"id":"Tpl","collapse":false},{"index":3,"id":"WF","collapse":false}]')
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 204)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
VALUES (204, 'Auswahl des Enddatums beim Start einer Workflow-Instanz nicht anzeigen', 3, 7, 31, 'Mit diesem Recht kann der Benutzer das Enddatum einer Workflow-Instanz nicht manuell eintragen.')
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 205)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
VALUES (205, 'Vertreterauswahl beim Start einer Workflow-Instanz anzeigen', 3, 8, 31, 'Mit diesem Recht kann der Benutzer den Vertreter beim Start einer Workflow-Instanz wählen.')
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 206)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
VALUES (206, 'Kontaktauswahl beim Start einer Workflow-Instanz nicht anzeigen', 3, 9, 31, 'Mit diesem Recht wird die Kontaktauswahl beim Start einer Workflow-Instanz ausgeblendet.')
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_users' AND COLUMN_NAME = 'LinkListOrder')
ALTER TABLE [dbo].[hm_users] ADD
    [LinkListOrder] [varchar](max) NULL
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_MailBlacklist]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_MailBlacklist](
        [MailaddressID] [bigint] IDENTITY(1, 1) NOT NULL,
	[Mailaddress] [int] NOT NULL,
	[CreateUser] [bigint] NOT NULL,
        [CreateDate] [datetime] NOT NULL,
 CONSTRAINT [PK_hm_MailBlacklist] PRIMARY KEY CLUSTERED
(
	[MailaddressID] ASC
)
) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_MailAccounts' AND COLUMN_NAME = 'ReplyTpl4TicketEditOnly')
ALTER TABLE [dbo].[hm_MailAccounts] ADD
    [ReplyTpl4TicketEditOnly] [int] NULL
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_TicketChangedHistory]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE hm_TicketChangedHistory
(
   TicketChangedHistoryID INT identity,
   TicketID INT,
   REFID INT,
   OldValue sql_variant,
   NewValue sql_variant,
   UpdateUserID INT,
   UpdateDate DateTime DEFAULT getdate()
)
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[TicketChangedHistory_PK]') and OBJECTPROPERTY(id, N'IsConstraint') = 1)
	ALTER TABLE [dbo].[hm_TicketChangedHistory]
	ADD CONSTRAINT [TicketChangedHistory_PK] PRIMARY KEY NONCLUSTERED (TicketChangedHistoryID)
GO


IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TicketChanged_Trigger]'))
DROP TRIGGER [dbo].[TicketChanged_Trigger]
GO    

IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TicketCreated_Trigger]'))
DROP TRIGGER [dbo].[TicketCreated_Trigger]
GO


-- REFID 1 = Priorität, REFID 2 = Status, REFID 3 = Ticketbeschreibung

CREATE TRIGGER TicketCreated_Trigger
ON hm_Ticket
AFTER INSERT   
AS
DECLARE @TicketID INT, @UpdateUserID INT
SELECT @TicketID = ID FROM deleted
SELECT @UpdateUserID = UpdateUserID FROM inserted
IF UPDATE (TicketPrioID)
BEGIN
	DECLARE @NewPrioID INT
	SELECT @NewPrioID = TicketPrioID FROM inserted

	INSERT INTO hm_TicketChangedHistory (REFID, TicketID, OldValue, NewValue, UpdateUserID) VALUES (1, @TicketID, 0, @NewPrioID, @UpdateUserID)
END
IF UPDATE (TicketStatusID)
BEGIN
	DECLARE @NewStatusID INT
	SELECT @NewStatusID = TicketStatusID FROM inserted

	INSERT INTO hm_TicketChangedHistory (REFID, TicketID, OldValue, NewValue, UpdateUserID) VALUES (2, @TicketID, 0, @NewStatusID, @UpdateUserID)
END
--IF UPDATE (TicketDescr)
--BEGIN
--	DECLARE @NewTicketDescr sql_variant
--	SELECT @NewTicketDescr = TicketDescr FROM inserted
--
--	INSERT INTO hm_TicketChangedHistory (REFID, TicketID, OldValue, NewValue, UpdateUserID) VALUES (3, @TicketID, '', @NewTicketDescr, @UpdateUserID)
--END
GO  

CREATE TRIGGER TicketChanged_Trigger
ON hm_Ticket
AFTER UPDATE   
AS
DECLARE @TicketID INT, @UpdateUserID INT
SELECT @TicketID = ID FROM deleted
SELECT @UpdateUserID = UpdateUserID FROM inserted
IF UPDATE (TicketPrioID)
BEGIN
	DECLARE @OldPrioID INT, @NewPrioID INT
	SELECT @OldPrioID = TicketPrioID FROM deleted
	SELECT @NewPrioID = TicketPrioID FROM inserted

	IF (@OldPrioID != @NewPrioID)
		INSERT INTO hm_TicketChangedHistory (REFID, TicketID, OldValue, NewValue, UpdateUserID) VALUES (1, @TicketID, @OldPrioID, @NewPrioID, @UpdateUserID)
END
IF UPDATE (TicketStatusID)
BEGIN
	DECLARE @OldStatusID INT, @NewStatusID INT
	SELECT @OldStatusID = TicketStatusID FROM deleted
	SELECT @NewStatusID = TicketStatusID FROM inserted

	IF (@OldStatusID != @NewStatusID)
		INSERT INTO hm_TicketChangedHistory (REFID, TicketID, OldValue, NewValue, UpdateUserID) VALUES (2, @TicketID, @OldStatusID, @NewStatusID, @UpdateUserID)
END



--IF UPDATE (TicketDescr)
--BEGIN
--	DECLARE @OldTicketDescr sql_variant, @NewTicketDescr sql_variant
--	SELECT @OldTicketDescr = TicketDescr FROM deleted
--	SELECT @NewTicketDescr = TicketDescr FROM inserted
--
--	IF (@OldTicketDescr != @NewTicketDescr)
--		INSERT INTO hm_TicketChangedHistory (REFID, TicketID, OldValue, NewValue, UpdateUserID) VALUES (3, @TicketID, @OldTicketDescr, @NewTicketDescr, @UpdateUserID)
--END
GO  

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ActivityDef_TargetSource]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ActivityDef_TargetSource](
        [ID] [bigint] IDENTITY(1, 1) NOT NULL,
	[ActivityDefID] [int] NOT NULL,
	[TargetHash] [varchar](max) NOT NULL,
 CONSTRAINT [PK_hm_ActivityDef_TargetSource] PRIMARY KEY CLUSTERED
(
	[ID] ASC
)
) ON [PRIMARY]
GO  

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_FAQData' AND COLUMN_NAME = 'ValidTill')
ALTER TABLE [dbo].[hm_FAQData] ADD [ValidTill] [datetime]
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_News' AND COLUMN_NAME = 'ValidTill')
ALTER TABLE [dbo].[hm_News] ADD [ValidTill] [datetime]
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_SubStatus]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE hm_SubStatus
(
	[SubStatusID] INT,
	[Description] varchar(255),
	[IconPath] varchar(MAX)
)

INSERT INTO hm_SubStatus (SubStatusID, Description) VALUES (1, 'Ungelesen')
INSERT INTO hm_SubStatus (SubStatusID, Description) VALUES (2, 'Gelesen')
END
GO

INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr) VALUES (20, 'DRAFT')
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_FilterColumnsWidth]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_FilterColumnsWidth](
	[ID] [bigint] IDENTITY(1, 1) NOT NULL,
	[FilterID] [bigint] NOT NULL,
        [ColumnsWidth] [varchar](max) NOT NULL,
 CONSTRAINT [PK_hm_FilterColumnsWidth] PRIMARY KEY CLUSTERED
(
	[ID] ASC
	
)
) ON [PRIMARY]

GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_TicketTemplateAssets]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_TicketTemplateAssets](
	[ID] [bigint] IDENTITY(1, 1) NOT NULL,
	[TicketTemplateID] [bigint] NULL,
        [DeviceID] [bigint]  NULL,
        [SessionID][varchar](max) NULL,
 CONSTRAINT [PK_hm_TicketTemplateAssets] PRIMARY KEY CLUSTERED
(
	[ID] ASC
	
)
) ON [PRIMARY]

GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_Rating_TicketEvent]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE hm_Rating_TicketEvent
(
	[EventRatingID] BIGINT IDENTITY (1, 1) NOT NULL ,
	[TicketEventID] BIGINT NOT NULL,
	[Rating] INT NOT NULL,
	[Comment] VARCHAR(MAX),
    CreateUserID  [bigint] NULL,
    CreateDate  [datetime] DEFAULT GETDATE(),
    UpdateDate  [datetime] DEFAULT NULL,
	CONSTRAINT [PK_hm_Rating_TicketEvent] PRIMARY KEY CLUSTERED
	(
		[EventRatingID] ASC
	)
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_RatingDocument]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE hm_RatingDocument
(
	[AttachmentID] BIGINT NOT NULL,
	[EventRatingID] BIGINT NULL,
	[TicketEventID] BIGINT NULL,
	[CreateDate] [datetime] NULL ,
	[CreateUserID] [bigint] NULL
)
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_SprintTicketLog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE hm_SprintTicketLog
(
	
        [ID] BIGINT IDENTITY (1, 1) NOT NULL ,
        [SprintID] BIGINT NOT NULL,
	[TicketID] BIGINT NOT NULL,
	[AddedOn] [datetime] NULL ,
	[RemovedOn] [datetime] NULL
)
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Ticket' AND COLUMN_NAME = 'WarrantyProcessingRequestTypeID ')
    ALTER TABLE [dbo].[hm_Ticket] ADD [WarrantyProcessingRequestTypeID ] [bigint] NULL;
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Ticket' AND COLUMN_NAME = 'RepairEndDate')
    ALTER TABLE [dbo].[hm_Ticket] ADD [RepairEndDate] [datetime] NULL;
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Ticket' AND COLUMN_NAME = 'DamageDate')
    ALTER TABLE [dbo].[hm_Ticket] ADD [DamageDate] [datetime] NULL;
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Ticket' AND COLUMN_NAME = 'paCallID')
    ALTER TABLE [dbo].[hm_Ticket] ADD [paCallID] [varchar](255) NULL;
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_WarrantyProcessingRequestType]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_WarrantyProcessingRequestType] 
(
	[WarrantyProcessingRequestTypeID] [bigint] IDENTITY (1, 1) NOT NULL,
	[Name] [varchar] (255) NOT NULL ,
	[IsActive] [tinyint] default 1,
	[CreateDate] [datetime] default GETDATE(),
	[CreateUserID] [bigint] NOT NULL
 CONSTRAINT [PK_WarrantyProcessingRequestType] PRIMARY KEY CLUSTERED
(
	[WarrantyProcessingRequestTypeID] ASC
)) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_WarrantyProcessingRequestPosition]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_WarrantyProcessingRequestPosition]
(
	[WarrantyProcessingRequestPositionID] BIGINT IDENTITY (1, 1) NOT NULL,
	[ETNumber] VARCHAR(200) NULL,
	[TicketID] BIGINT NULL,
	[SessionID] VARCHAR(64) NULL,
	[InvoiceNumber] VARCHAR(300) NOT NULL,
	[Description] VARCHAR(MAX) NULL,
	[Amount] INT DEFAULT 1 NOT NULL,
	[UnitPrice] MONEY NULL,
	[FreightPrice] MONEY NULL,
	[CurrencySymbol] VARCHAR(50) NULL,
	[CreateDate] DATETIME DEFAULT GETDATE() NOT NULL,
	[CreateUserID] BIGINT NOT NULL,
	[RemoveDate] DATETIME NULL,
	[RemoveUserID] BIGINT NULL,
	[MainGroupClassID] INT  NULL,
    [SubGroupClassID] INT  NULL,
    [ErrorPatternID] INT  NULL
	CONSTRAINT [PK_WarrantyProcessingRequestPosition] PRIMARY KEY CLUSTERED
(
	[WarrantyProcessingRequestPositionID] ASC
)) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_WarrantyProcessingRequestWagePosition]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_WarrantyProcessingRequestWagePosition]
(
	[WarrantyProcessingRequestWagePositionID] BIGINT IDENTITY (1, 1) NOT NULL,
	[Type] VARCHAR(200) NULL,
	[TicketID] BIGINT NULL,
	[SessionID] VARCHAR(64) NULL,
	[Description] VARCHAR(MAX) NULL,
	[Amount] FLOAT DEFAULT 1 NOT NULL,
	[AdditionalInformation] VARCHAR(MAX) NULL,
	[UnitPrice] MONEY NULL,
	[CurrencySymbol] VARCHAR(50) NULL,
	[CreateDate] DATETIME DEFAULT GETDATE() NOT NULL,
	[CreateUserID] BIGINT NOT NULL,
	[RemoveDate] DATETIME NULL,
	[RemoveUserID] BIGINT NULL,
	CONSTRAINT [PK_WarrantyProcessingRequestWagePosition] PRIMARY KEY CLUSTERED
(
	[WarrantyProcessingRequestWagePositionID] ASC
)) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_TicketAttachment' AND COLUMN_NAME = 'WarrantyProcessingRequestInvoicePositionID')
ALTER TABLE [dbo].[hm_TicketAttachment] ADD [WarrantyProcessingRequestInvoicePositionID] [BIGINT] NULL;
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_TicketAttachment' AND COLUMN_NAME = 'WarrantyProcessingRequestWagePositionID')
ALTER TABLE [dbo].[hm_TicketAttachment] ADD [WarrantyProcessingRequestWagePositionID] [BIGINT] NULL;
GO

INSERT INTO hm_ActivityDef_TargetSource (ActivityDefID, TargetHash)
SELECT ID, AdressSourceActivity
FROM hm_WFDef_Activity
 WHERE (hm_WFDef_Activity.AdressSourceActivity IS NOT NULL AND hm_WFDef_Activity.AdressSourceActivity <> '' AND hm_WFDef_Activity.AdressSourceActivity <> 'Array')
 AND NOT EXISTS (SELECT ActivityDefID FROM hm_ActivityDef_TargetSource WHERE ActivityDefID = hm_WFDef_Activity.ID AND TargetHash = hm_WFDef_Activity.AdressSourceActivity )  
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_BacklogSprint' AND COLUMN_NAME = 'HoursPerDay')
    ALTER TABLE [dbo].[hm_BacklogSprint] ADD
        [HoursPerDay] [int] NOT NULL DEFAULT(8)
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Users' AND COLUMN_NAME = 'AzureID')
ALTER TABLE [dbo].[hm_Users] ADD
    [AzureID] [varchar](max) NULL
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Contacts' AND COLUMN_NAME = 'AzureID')
ALTER TABLE [dbo].[hm_Contacts] ADD
    [AzureID] [varchar](max) NULL
GO

IF EXISTS (SELECT 1 FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[View_TicketList]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP View [dbo].[View_TicketList]
GO
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[View_TicketList]
AS
SELECT 
	hm_Ticket.SolutionDate SolutionDate, hm_Ticket.EscalationLevel, hm_ProjectTicket.ProjectID, hm_Ticket.FinancialCommitmentValue,
	hm_Ticket.EscalationType, hm_Ticket.TicketDescr, ISNULL(hm_BacklogTicket.BacklogID, 0) BacklogID,
	hm_Ticket.ContactID, hm_Contacts.name Contact, hm_Contacts.important, hm_Contacts.street AS ContactStreet, hm_Contacts.email AS ContactEmail, hm_Contacts.city AS ContactLocation, hm_Contacts.plz AS ContactPostalCode,
	hm_Contacts.building ContactBuilding, hm_Contacts.room ContactRoom, hm_Contacts.floor ContactFloor,
	hm_Contacts.CostCenter ContactCostCenter, hm_Contacts.Department ContactDepartment,
	hm_Contacts.phone ContactPhone, hm_Contacts.mobil ContactMobile,
	hm_Ticket.SupporterID, hm_Users.name Supporter,
	hm_Ticket.IsProblem, hm_Company.company, hm_Ticket.TicketStatusID,
	hm_TicketStatus.Descr TStatus, hm_Ticket.TicketPrioID,
	hm_Backlog.Name AS Backlog, hm_BacklogSprint.Name AS Sprint,
	hm_TicketPrio.Descr Priority, hm_Ticket.Published, hm_Ticket.OnHold OnHold,
	hm_Ticket.TicketDesireDate TicketDesireDate, hm_Ticket.CategoryID1, Cat1.name
	Category1, hm_Ticket.CategoryID2, Cat2.name Category2, hm_Ticket.CreateDate
	CreateDate, hm_Ticket.EditDate EditDate, hm_Ticket.Expense, hm_Ticket.GroupID, hm_Groups.name
	GroupDescr, hm_Ticket.ID, hm_tickettype.type_id, hm_tickettype.type_name, hm_tickettype.active AS type_active, hm_icon_lib.icon_path, DATEDIFF(minute, GETDATE(), hm_Ticket.OnHold) DiffOnHold,
	hm_Ticket.UpdateDate UpdateDate, Cat1.cost_rate Category1Costs, hm_Ticket.TicketReferenzID,
	hm_Ticket.InventoryNumber, CreateUser.Name CreateUserName, UpdateUser.Name UpdateUserName,
	hm_Ticket.Archived, MasterTable.Masternumber, ReferenzTable.ReferenceNumber, AttachmentTable.AttachmentNumber, TicketTagsTable.TagsNumber,
	CASE WHEN (hm_Ticket.OnHold IS NOT NULL AND hm_Ticket.OnHold > GETDATE() AND hm_Ticket.OnHold > hm_Ticket.TicketDesireDate) THEN hm_Ticket.OnHold ELSE hm_Ticket.TicketDesireDate END WorkOnDate,
	CASE  WHEN hm_Ticket.expExpense > 0 THEN (hm_Ticket.Expense * 100 / hm_Ticket.expExpense) ELSE 0  END UsedExpense, hm_Ticket.ExpExpense,
	hm_TicketBasket.TicketID basket, hm_Mandant.ID Mandantenid, hm_Mandant.Mandant,
	hm_Ticket.Draft, hm_DefFieldValue.*, MasterTicket.ID as MasterID, MasterTicket.TicketDescr as MasterDescr, hm_Ticket.isStory, tmpSubStatusID.SubStatusID, hm_Project.ProjectName, 
	WFD.Description WFDescr, WFA.ActivityID,
	TicketCosts.Costs TicketCosts
FROM hm_Ticket
            LEFT JOIN hm_Ticket AS MasterTicket ON hm_Ticket.TicketReferenzID = MasterTicket.ID
            LEFT JOIN hm_DefFieldValue ON hm_DefFieldValue.TicketID = hm_Ticket.ID
            LEFT JOIN hm_Contacts ON hm_Ticket.ContactID = hm_Contacts.contact_id
            LEFT JOIN hm_Company ON hm_Contacts.CompanyID = hm_Company.CompanyID
            LEFT JOIN hm_Users CreateUser ON CreateUser.USER_ID = hm_Ticket.CreateUserID
            LEFT JOIN hm_Users UpdateUser ON UpdateUser.USER_ID = hm_Ticket.UpdateUserID
            LEFT JOIN hm_TicketStatus ON hm_Ticket.TicketStatusID = hm_TicketStatus.ID
            LEFT JOIN hm_TicketPrio ON hm_Ticket.TicketPrioID = hm_TicketPrio.TicketPrioID
            LEFT JOIN hm_Categories Cat1 ON hm_Ticket.CategoryID1 = Cat1.ID
            LEFT JOIN hm_Categories Cat2 ON hm_Ticket.CategoryID2 = Cat2.ID
            LEFT JOIN hm_WF_Activity WFA ON WFA.TicketID = hm_Ticket.ID
            LEFT JOIN hm_Activity_TargetUser ON WFA.ActivityID = hm_Activity_TargetUser.ActivityID
            LEFT JOIN hm_Activity_TargetGroup ON WFA.ActivityID = hm_Activity_TargetGroup.ActivityID
            LEFT JOIN hm_ProjectTicket ON hm_ProjectTicket.TicketID = hm_Ticket.ID
            LEFT JOIN hm_TicketGroup ON hm_Ticket.ID = hm_TicketGroup.TicketID AND hm_TicketGroup.removeDate = 0
            LEFT JOIN hm_TicketSupporter ON hm_Ticket.ID = hm_TicketSupporter.TicketID AND hm_TicketSupporter.removeDate = 0
            LEFT JOIN hm_Users ON hm_TicketSupporter.UserID = hm_Users.user_id
            LEFT JOIN hm_Groups ON hm_TicketGroup.GroupID = hm_Groups.group_id AND hm_TicketGroup.removeDate = 0
            LEFT JOIN hm_tickettype ON hm_Ticket.TypeID = hm_tickettype.type_id
            LEFT JOIN hm_icon_lib ON hm_icon_lib.icon_id = hm_tickettype.icon_id
            LEFT JOIN hm_TicketBasket ON hm_Ticket.ID = hm_TicketBasket.TicketID 
            LEFT JOIN hm_TicketMandant ON hm_TicketMandant.TicketID = hm_Ticket.ID AND hm_TicketMandant.Active = 1
            LEFT JOIN hm_Interest ON hm_Ticket.ID = hm_Interest.ticket_id
            LEFT JOIN hm_Decisor ON hm_Ticket.ID = hm_Decisor.ticketid
            LEFT JOIN hm_UserDefFieldValueTicket ON hm_UserDefFieldValueTicket.TicketID = hm_Ticket.ID
            LEFT JOIN hm_UserDefFieldValue ON hm_UserDefFieldValueTicket.UserDefFieldValueID = hm_UserDefFieldValue.UserDefFieldValueID
            LEFT JOIN hm_UserDefField ON hm_UserDefFieldValue.UserDefFieldID = hm_UserDefField.UserDefFieldID
            LEFT JOIN hm_Mandant ON hm_Mandant.ID = hm_TicketMandant.MandantenID
            LEFT JOIN hm_BacklogTicket ON hm_BacklogTicket.TicketID = hm_Ticket.ID
			LEFT JOIN hm_Backlog ON hm_Backlog.ID = hm_BacklogTicket.BacklogID
            LEFT JOIN hm_BacklogSprintTicket ON hm_BacklogSprintTicket.TicketID = hm_Ticket.ID
			LEFT JOIN hm_BacklogSprint ON hm_BacklogSprint.ID = hm_BacklogSprintTicket.SprintID
            LEFT JOIN hm_TicketDevice ON hm_TicketDevice.TicketID = hm_Ticket.ID
            LEFT JOIN Device ON Device.DeviceID = hm_TicketDevice.DeviceID
            LEFT JOIN (SELECT  TicketID as TicketIDInTags, COUNT(hm_TicketTags.TagID) as TagsNumber FROM hm_TicketTags GROUP BY TicketID) AS TicketTagsTable ON TicketTagsTable.TicketIDInTags = hm_Ticket.ID
            LEFT JOIN (select hm_Ticket.ID,COUNT(t2.TicketReferenzID) as MasterNumber from hm_Ticket LEFT
JOIN (SELECT hm_Ticket.TicketReferenzID FROM hm_Ticket WHERE hm_Ticket.TicketReferenzID IS NOT NULL) t2
ON hm_Ticket.ID = t2.TicketReferenzID GROUP BY ID) AS MasterTable ON MasterTable.ID = hm_Ticket.ID LEFT JOIN
(SELECT COUNT(hm_TicketReferences.TicketID) ReferenceNumber, hm_Ticket.ID from hm_Ticket LEFT JOIN hm_TicketReferences ON hm_Ticket.ID = hm_TicketReferences.TicketID OR hm_Ticket.ID = hm_TicketReferences.ConnectedTicketID GROUP BY hm_Ticket.ID) ReferenzTable ON hm_Ticket.ID = ReferenzTable.ID
LEFT JOIN (SELECT COUNT(hm_TicketAttachment.TicketID) AttachmentNumber,  hm_Ticket.ID FROM hm_Ticket LEFT JOIN hm_TicketAttachment ON hm_Ticket.ID = hm_TicketAttachment.TicketID GROUP BY hm_Ticket.ID) AttachmentTable ON AttachmentTable.ID = hm_Ticket.ID
LEFT JOIN (SELECT CASE WHEN SubStatusID = 1  then 1 ELSE 2 END SubStatusID, TicketID from hm_TicketEvent where SubStatusID IS NOT NULL GROUP BY SubStatusID, TicketID) tmpSubStatusID ON tmpSubStatusID.TicketID = hm_Ticket.ID
LEFT JOIN hm_TicketTags TT ON TT.TicketID = hm_Ticket.ID
LEFT JOIN hm_ServiceLvlAgreement SLA ON hm_Ticket.SLAID = SLA.ID
LEFT JOIN hm_Project ON hm_Project.ProjectID = hm_ProjectTicket.ProjectID
LEFT JOIN hm_WFInstanz WFI ON WFI.ID = WFA.WFIID
LEFT JOIN hm_WFDefinitions WFD ON WFD.ID = WFI.WFDID
LEFT JOIN (
SELECT SUM(EventCosts) Costs, TicketID FROM (
                                SELECT (CostRatePerMinute * hm_TicketEvent.Expense) EventCosts, CC.Symbol, hm_TicketEvent.ID, hm_TicketEvent.TicketID, CostRatePerMinute, Expense
                                FROM hm_TicketEvent
                                    INNER JOIN hm_CostGroupRate CGR ON CGR.CostGroupID = hm_TicketEvent.CostGroupID
                                    AND CGR.StartDate = (
                                            SELECT MAX(StartDate) As StartDate
                                            FROM hm_CostGroupRate
                                            WHERE hm_CostGroupRate.CostGroupID = hm_TicketEvent.CostGroupID
                                            AND hm_CostGroupRate.StartDate <= hm_TicketEvent.EventDate
                                    )
                            LEFT JOIN hm_CostRate CR ON CR.CostRateID = CGR.CostRateID
                            LEFT JOIN hm_CostCurrency CC ON CC.CostCurrencyID = CR.CostCurrencyID
                            WHERE hm_TicketEvent.Expense > 0
                            )  tmpTable
                            GROUP BY TicketID) TicketCosts ON TicketCosts.TicketID = hm_Ticket.ID
LEFT JOIN hm_TicketEvent ON hm_Ticket.ID = hm_TicketEvent.TicketID
'
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ADShoppingCart]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_ADShoppingCart]
(
	[ADShoppingCartID] BIGINT IDENTITY (1, 1) NOT NULL,
        [ActivityID] BIGINT NOT NULL,
	[CreateUserID] BIGINT NOT NULL,
	[CreateDate] DATETIME DEFAULT GETDATE() NOT NULL,
        [UpdateDate] DATETIME DEFAULT GETDATE() NOT NULL,
	[ExportDate] DATETIME NULL,
    [CartOrderNotice] [varchar](250) NULL,
    [CartOrderText] [varchar](300) NULL
	CONSTRAINT [PK_hm_ADShoppingCart] PRIMARY KEY CLUSTERED
(
	[ADShoppingCartID] ASC
)) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ADShoppingCartArticle]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_ADShoppingCartArticle]
(
	[ADShoppingCartArticleID] BIGINT IDENTITY (1, 1) NOT NULL,
	[ADShoppingCartID] BIGINT NOT NULL,
	[ArticleID] BIGINT NOT NULL,
	[EmployeeID] BIGINT NOT NULL,
	[VendorID] BIGINT NOT NULL,
	[Amount] INT NOT NULL,
	[CreateUserID] BIGINT NOT NULL,
	[CreateDate] DATETIME DEFAULT GETDATE() NOT NULL,
    [UpdateDate] DATETIME DEFAULT GETDATE() NOT NULL,
	[PurchaseOrderID] BIGINT NULL,
    [ArticleName] VARCHAR(MAX) NULL,
    [PurchaseOrderItemID] BIGINT NULL,
    [OrderText] [varchar](300) NULL,
	CONSTRAINT [PK_hm_ADShoppingCartArticle] PRIMARY KEY CLUSTERED
(
	[ADShoppingCartArticleID] ASC
)) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_InterestGroup]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
    CREATE TABLE [dbo].[hm_InterestGroup] (
        [TicketID] [bigint] NULL,
        [GroupID] [bigint] NULL
    ) ON [PRIMARY];
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Users' AND COLUMN_NAME = 'UseOldKBEditor')
ALTER TABLE [dbo].[hm_Users] ADD
    [UseOldKBEditor] INT NOT NULL DEFAULT(0)
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Contacts' AND COLUMN_NAME = 'InBlackList')
ALTER TABLE [dbo].[hm_Contacts] ADD
    [InBlackList] INT NOT NULL DEFAULT(0)
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1400)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
VALUES (1400, 'Händlerauswahl im Bestellkalalog', 3, 10, 31, 'Mit diesem Recht kann der Benutzer Händler bei Bestellung über Bestellkalalog auswöhlen.')
GO

IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_InterestGroup]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
    CREATE TABLE [dbo].[hm_InterestGroup] (
        [TicketID] [bigint] NULL,
        [GroupID] [bigint] NULL
    ) ON [PRIMARY];
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1000)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
VALUES (1000, 'Status Zurückstellung aufheben', 2, 24, 60, 'Mit diesem Recht kann der Benutzer bei  Ticketbearbeitung den Zurückstellung-Status aufheben.')
GO  

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1500)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightDescr, RightsSectionID, RightsOrder, SegmentID)
VALUES (1500, 'Knowledgebaseeinträge bearbeiten', 'Berechtigt zur Bearbeitung von Knowledgebase-Artikel.', 3, 4, 12)
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_tickettemplate' AND COLUMN_NAME = 'IconID')
ALTER TABLE [dbo].[hm_tickettemplate] ADD
    [IconID] BIGINT NULL
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_WFDefinitions' AND COLUMN_NAME = 'IconID')
ALTER TABLE [dbo].[hm_WFDefinitions] ADD
    [IconID] BIGINT NULL
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_FAQData' AND COLUMN_NAME = 'Thumbnail')
ALTER TABLE [dbo].[hm_FAQData] ADD
    [Thumbnail] varchar(max) NULL
GO

IF EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 230)
    DELETE FROM [dbo].[hm_GroupRights] WHERE right_id = 230
    DELETE FROM [dbo].[hm_Rights] WHERE RightID = 230
GO

ALTER TABLE [dbo].[hm_FAQData]
  ALTER COLUMN Keywords [varchar] (max) NULL
GO
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 706)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
    VALUES (706, 'Workflow-Reports', 3, 7, 31, 'Benutzer mit diesem Recht können in der Workflowliste alle Workflows sehen')
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_groups' AND COLUMN_NAME = 'StandardFilterID')
ALTER TABLE [dbo].[hm_groups] ADD
    [StandardFilterID] bigint NULL
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_WFDef_Activity' AND COLUMN_NAME = 'sendAdditionalReport')
ALTER TABLE [dbo].[hm_WFDef_Activity] ADD
    [sendAdditionalReport] INT NOT NULL DEFAULT(0)
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_WF_Activity' AND COLUMN_NAME = 'sendAdditionalReport')
ALTER TABLE [dbo].[hm_WF_Activity] ADD
    [sendAdditionalReport] INT NOT NULL DEFAULT(0)
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Ticket' AND COLUMN_NAME = 'ForeignAPIID')
ALTER TABLE [dbo].[hm_Ticket] ADD
    [ForeignAPIID] varchar(max) NULL
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Ticket' AND COLUMN_NAME = 'APISource')
ALTER TABLE [dbo].[hm_Ticket] ADD
    [APISource] varchar(max) NULL
GO
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID , RightDescr)
    VALUES (310, 'Benutzerrechte-Report anzeigen', 1, 7, 20, 'Benutzer mit diesem Recht können den Benutzerrechte-Report sehen und exportieren')
GO
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_WarrantyRequest]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_WarrantyRequest]
(
    [WarrantyRequestID] BIGINT IDENTITY (1, 1) NOT NULL,
    [TicketID] BIGINT NULL,
    [CallID] BIGINT NULL,
    [Company] VARCHAR(MAX) NULL,
    [EntryDate] DATETIME NULL,
    [Type] INT NULL,
    [TransactionNumberCustomer] VARCHAR(MAX) NULL,
    [DealerID] BIGINT NULL,
    [ContactPerson] VARCHAR(MAX) NULL,
    [ContactEMail] VARCHAR(MAX) NULL,
    [MachineNumber] VARCHAR(MAX) NULL,
    [DamageOccurrenceDate] DATETIME NULL,
    [OperatingHoursDamageOccurrence] FLOAT NULL,
    [RepairEndDate] DATETIME NULL,
    [DamageDescription] VARCHAR(MAX) NULL,
    [DamageRepair] VARCHAR(MAX) NULL,
    [Supporter] VARCHAR(MAX) NULL,
    [WarrantyRequestStatus] INT NULL,
    [Classification] VARCHAR(MAX) NULL,
    [ErrorPattern] VARCHAR(MAX) NULL,
    [CustomerID] BIGINT NULL,
    [CreateUserID] BIGINT  NULL,
	[CreateDate] DATETIME DEFAULT GETDATE() NOT NULL,
    [UpdateUserID] BIGINT  NULL,
    [UpdateDate] DATETIME DEFAULT GETDATE() NOT NULL,
    [ServiceBulletin] VARCHAR(20) NULL,
    [PositionsEditable]  [bit] DEFAULT 0 NOT NULL

	CONSTRAINT [PK_hm_WarrantyRequest] PRIMARY KEY CLUSTERED
(
	[WarrantyRequestID] ASC
)) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_WarrantyRequestPosition]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_WarrantyRequestPosition]
(
    [WarrantyRequestPositionID] BIGINT IDENTITY (1, 1) NOT NULL,
    [WarrantyRequestID] BIGINT NOT NULL,
    [Article] VARCHAR(MAX) NOT NULL,
    [UnitPrice] FLOAT NOT NULL,
    [TotalPrice] FLOAT NULL,
    [Amount] INT NOT NULL,
    [PositionNumber] FLOAT NOT NULL,
    [Description] VARCHAR(MAX) NULL,
    [Freight] FLOAT NULL,
    [CurrencyCode] INT NULL,
    [CurrencyName] VARCHAR(MAX) NULL,
    [InvoiceNumber] VARCHAR(MAX) NOT NULL,
    [InvoiceDate] DATETIME NOT NULL,
    [Vendor] VARCHAR(MAX) NULL,
    [PositionURL] VARCHAR(MAX) NULL,
    [Comment] VARCHAR(MAX) NULL,
    [Classification] VARCHAR(MAX) NULL,
    [ErrorPattern] VARCHAR(MAX) NULL,
    [GK_Decision] int DEFAULT 0 NOT NULL,
    [GK_GK] [varchar] (50) NULL,
    [GK_Percent]  [float] NULL,
    [GK_Amount]  [float] NULL,
    [GK_Shipping]  [float] NULL,
    [GK_Initiator]  [varchar] (100) NULL,
    [CreateUserID] BIGINT NULL,
	[CreateDate] DATETIME DEFAULT GETDATE() NOT NULL,
    [UpdateUserID] BIGINT NULL,
    [UpdateDate] DATETIME DEFAULT GETDATE() NOT NULL,
    [Kundenbezeichnung1]  [varchar] (20) NULL,
    [Kundenbezeichnung2]  [varchar] (20) NULL

	CONSTRAINT [PK_hm_WarrantyRequestPosition] PRIMARY KEY CLUSTERED
(
	[WarrantyRequestPositionID] ASC
)) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_WarrantyRequestPositionAttachment]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_WarrantyRequestPositionAttachment]
(
    [WarrantyRequestPositionAttachmentID] BIGINT IDENTITY (1, 1) NOT NULL,
    [WarrantyRequestPositionID] BIGINT NOT NULL,
    [AttachmentID] BIGINT NOT NULL,
    [CreateUserID] BIGINT NOT NULL,
	[CreateDate] DATETIME DEFAULT GETDATE() NOT NULL,
    [UpdateUserID] BIGINT NOT NULL,
    [UpdateDate] DATETIME DEFAULT GETDATE() NOT NULL

	CONSTRAINT [PK_hm_WarrantyRequestPositionAttachment] PRIMARY KEY CLUSTERED
(
	[WarrantyRequestPositionAttachmentID] ASC
)) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_WarrantyRequestPositionSerials]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_WarrantyRequestPositionSerials]
(
    [WarrantyRequestPositionSerialsID] BIGINT IDENTITY (1, 1) NOT NULL,
    [WarrantyRequestPositionID] BIGINT NOT NULL,
    [OldSerialNumber] VARCHAR(MAX) NULL,
    [NewSerialNumber] VARCHAR(MAX) NULL

	CONSTRAINT [PK_hm_WarrantyRequestPositionSerials] PRIMARY KEY CLUSTERED
(
	[WarrantyRequestPositionSerialsID] ASC
)) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_BacklogSprintLog' AND COLUMN_NAME = 'RealExpenseOverALL')
ALTER TABLE [dbo].[hm_BacklogSprintLog] ADD
    [RealExpenseOverALL] int NULL
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_AssetKeyAccount]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_AssetKeyAccount]
(
    [KeyAccountID] BIGINT IDENTITY (1, 1) NOT NULL,
    [Name] VARCHAR(MAX) NOT NULL,
    [CreateDate] DATETIME DEFAULT GETDATE() NOT NULL,
    [UpdateDate] DATETIME DEFAULT GETDATE() NOT NULL,
    [isActive] BIT DEFAULT 0 NOT NULL,
    [GroupID] BIGINT NULL
    
    CONSTRAINT [PK_hm_AssetKeyAccount] PRIMARY KEY CLUSTERED
    (
            [KeyAccountID] ASC
    )
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='Device' AND COLUMN_NAME = 'KeyAccountID')
ALTER TABLE [dbo].[Device] ADD
    [KeyAccountID] BIGINT NULL
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 236)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
    VALUES (236, 'Interessierten Kreis nicht bearbeiten', 1, 24, 46, 'Benutzern mit diesem Recht können den interessierten Kreis im Ticket nicht bearbeiten');
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_InterestTemplate]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_InterestTemplate]
(
    [TicketTemplateID] BIGINT NOT NULL,
    [UserID] BIGINT NOT NULL,
    [CreateDate] DATETIME DEFAULT GETDATE() NOT NULL,
    [UpdateDate] DATETIME DEFAULT GETDATE() NOT NULL
    
    CONSTRAINT [PK_hm_InterestTemplate] PRIMARY KEY CLUSTERED
    (
            [TicketTemplateID] ASC,
            [UserID] ASC
    )
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_InterestTemplateGroup]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_InterestTemplateGroup]
(
    [TicketTemplateID] BIGINT NOT NULL,
    [GroupID] BIGINT NOT NULL,
    [CreateDate] DATETIME DEFAULT GETDATE() NOT NULL,
    [UpdateDate] DATETIME DEFAULT GETDATE() NOT NULL
    
    CONSTRAINT [PK_hm_InterestTemplateGroup] PRIMARY KEY CLUSTERED
    (
            [TicketTemplateID] ASC,
            [GroupID] ASC
    )
) ON [PRIMARY]
END
GO
GO

CREATE TABLE [dbo].[hm_TicketTemplateAttachment] (
	[TicketTemplateID] [bigint] NULL ,
	[AttachmentID] [bigint] NOT NULL ,
    [SessionID] [varchar](64) NULL
) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Users' AND COLUMN_NAME = 'KeyCloakAccessToken')
ALTER TABLE [dbo].[hm_Users] ADD
    [KeyCloakAccessToken] VARCHAR(MAX) NULL
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Users' AND COLUMN_NAME = 'KeyCloakRefreshToken')
ALTER TABLE [dbo].[hm_Users] ADD
    [KeyCloakRefreshToken] VARCHAR(MAX) NULL
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_OwnApplication]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_OwnApplication]
(
    [OwnApplicationID] BIGINT IDENTITY (1, 1) NOT NULL,
    [TicketTemplateID] BIGINT NOT NULL,
    [Description] VARCHAR(MAX) NOT NULL,
    [ApplicationURL] VARCHAR(MAX) NOT NULL
    
    CONSTRAINT [PK_hm_OwnApplication] PRIMARY KEY CLUSTERED
    (
            [OwnApplicationID] ASC
    )
) ON [PRIMARY]
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_WF_Activity' AND COLUMN_NAME = 'UpdateDate')
ALTER TABLE [dbo].[hm_WF_Activity] ADD
    [UpdateDate] datetime NULL
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_FilterDefinitions]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_FilterDefinitions]
(
    [FilterDefinitionID] BIGINT IDENTITY (1, 1) NOT NULL,
    [FilterDefinitionName] VARCHAR(MAX) NOT NULL,
    [FilterID] BIGINT NOT NULL,
    [Action] INT DEFAULT(1) NOT NULL, 
    [CreateDate] DATETIME DEFAULT GETDATE() NOT NULL,
    [UpdateDate] DATETIME DEFAULT GETDATE() NOT NULL,
    [IsActive] BIT DEFAULT 1 NOT NULL
    
    CONSTRAINT [PK_hm_FilterDefinitions] PRIMARY KEY CLUSTERED
    (
            [FilterDefinitionID] ASC
    )
) ON [PRIMARY]
END
GO


IF (SELECT COUNT(*) FROM hm_Rights WHERE RightID = 245) = 0
BEGIN
    UPDATE hm_Rights SET RightDescr = 'Benutzer mit diesem Recht dürfen bei bestehenden Tickets die Gruppe ändern.' WHERE RightID = 215
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID) 
    VALUES (245, 'Gruppe wählen', 2, 10, 'Benutzer mit diesem Recht dürfen bei der Ticketerstellung die Gruppe wählen.', 24)

    SELECT group_id
	INTO   #TempGroups
	FROM   hm_GroupRights
	WHERE right_id = 215

	DECLARE @Id int

	WHILE (SELECT Count(*) FROM #TempGroups) > 0
	BEGIN
		SELECT TOP 1 @Id = group_id FROM #TempGroups
		INSERT INTO hm_GroupRights (group_id, right_id) VALUES (@Id, 245)
		DELETE #TempGroups WHERE group_id = @Id
	END

	DROP TABLE #TempGroups
END
GO

IF (SELECT COUNT(*) FROM hm_Rights WHERE RightID = 246) = 0
BEGIN
    UPDATE hm_Rights SET RightDescr = 'Benutzer mit diesem Recht dürfen bei bestehenden Tickets die Supporter ändern.' WHERE RightID = 216
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID) 
    VALUES (246, 'Supporter wählen', 2, 10, 'Benutzer mit diesem Recht dürfen bei der Ticketerstellung die Supporter wählen.', 24)

	SELECT group_id
	INTO   #TempGroups
	FROM   hm_GroupRights
	WHERE right_id = 216

	DECLARE @Id int

	WHILE (SELECT Count(*) FROM #TempGroups) > 0
	BEGIN
		SELECT TOP 1 @Id = group_id FROM #TempGroups
		INSERT INTO hm_GroupRights (group_id, right_id) VALUES (@Id, 246)
		DELETE #TempGroups WHERE group_id = @Id
	END

	DROP TABLE #TempGroups
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_SnippetRubric]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_SnippetRubric]
(
    [SnippetRubricID] BIGINT IDENTITY (1, 1) NOT NULL,
    [Name] VARCHAR(MAX) NOT NULL,
    [Description] VARCHAR(MAX) NULL
    
    CONSTRAINT [PK_hm_SnippetRubric] PRIMARY KEY CLUSTERED
    (
            [SnippetRubricID] ASC
    )
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Snippet' AND COLUMN_NAME = 'SnippetRubricID')
ALTER TABLE [dbo].[hm_Snippet] ADD
    [SnippetRubricID] BIGINT NULL
GO

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_SnippetRubric')
BEGIN
    IF NOT EXISTS (SELECT * FROM [dbo].[hm_SnippetRubric] WHERE SnippetRubricID = 1)
    BEGIN
        SET IDENTITY_INSERT hm_SnippetRubric ON

        INSERT INTO hm_SnippetRubric (SnippetRubricID, Name, Description) VALUES (1, 'Default', 'Standardrubrik')
    END

  SET IDENTITY_INSERT hm_SnippetRubric OFF

END
GO


IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_TapiCalls]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
    DROP TABLE hm_TapiCalls
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_TapiCall]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_TapiCall]
(
    [TapiCallID] BIGINT IDENTITY (1, 1) NOT NULL,
    [UserID] integer NOT NULL,
    [PhoneNumber] VARCHAR(MAX) NOT NULL,
	[CallState] integer NOT NULL,
	[Notice] VARCHAR(MAX) NULL,
	[CallDate] datetime NOT NULL,
	[Duration] bigint NULL
    
    CONSTRAINT [PK_hm_TapiCall] PRIMARY KEY CLUSTERED
    (
            [TapiCallID] ASC
    )
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Users' AND COLUMN_NAME = 'OAuth2AccessToken')
ALTER TABLE [dbo].[hm_Users] ADD
    [OAuth2AccessToken] [varchar](max)  NULL
GO 

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 250)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
    VALUES (250, 'GA-Anträge erstellen', 1, 24, 60, 'Benutzer mit diesem Recht können GA-Anträge erstellen.');
GO
INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 250)
GO

UPDATE hm_Rights SET RightsOrder = 49 WHERE RightID = 1009
UPDATE hm_Rights SET RightsOrder = 48 WHERE RightID = 1008
UPDATE hm_Rights SET RightsOrder = 47 WHERE RightID = 1007

IF (SELECT COUNT(*) FROM hm_Rights WHERE RightID = 237) = 0
BEGIN
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
    VALUES (237, 'Keine Supporter dem Interessierten Kreis zufügen', 1, 24, 46, 'Benutzer mit diesem Recht können dem Interessierten Kreis keine Supporter zuweisen');
  
    SELECT group_id
	INTO   #TempGroups
	FROM   hm_GroupRights
	WHERE right_id = 236

	DECLARE @Id int

	WHILE (SELECT Count(*) FROM #TempGroups) > 0
	BEGIN
		SELECT TOP 1 @Id = group_id FROM #TempGroups
		INSERT INTO hm_GroupRights (group_id, right_id) VALUES (@Id, 237)
		DELETE #TempGroups WHERE group_id = @Id
	END

	DROP TABLE #TempGroups
END
GO

IF (SELECT COUNT(*) FROM hm_Rights WHERE RightID = 238) = 0
BEGIN
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
    VALUES (238, 'Keine Gruppen dem Interessierten Kreis zufügen', 1, 24, 47, 'Benutzern mit diesem Recht können den interessierten Kreis keine Gruppen zuweisen');
  
    SELECT group_id
	INTO   #TempGroups
	FROM   hm_GroupRights
	WHERE right_id = 236

	DECLARE @Id int

	WHILE (SELECT Count(*) FROM #TempGroups) > 0
	BEGIN
		SELECT TOP 1 @Id = group_id FROM #TempGroups
		INSERT INTO hm_GroupRights (group_id, right_id) VALUES (@Id, 238)      
		DELETE #TempGroups WHERE group_id = @Id
	END

	DROP TABLE #TempGroups
END
GO

IF (SELECT COUNT(*) FROM hm_GroupRights WHERE right_id = 236) > 0
BEGIN
    DELETE hm_GroupRights WHERE right_id = 236
END
GO

IF (SELECT COUNT(*) FROM hm_GroupRights WHERE right_id = 236) = 0
BEGIN
    DELETE hm_Rights WHERE RightID = 236
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_WFDefContainer]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_WFDefContainer] (
    [WFDefContainerID] BIGINT IDENTITY (1, 1) NOT NULL,
	[Title] VARCHAR(MAX) NOT NULL,
 CONSTRAINT [PK_WorkflowContainer] PRIMARY KEY CLUSTERED
(
	[WFDefContainerID] ASC
)) ON [PRIMARY]
END
GO

ALTER TABLE hm_WF_Activity ALTER COLUMN Form VARCHAR(MAX)
GO
ALTER TABLE hm_WF_Activity ALTER COLUMN FormData VARCHAR(MAX)
GO

IF (OBJECT_ID(N'[dbo].[TapiCallInserted_Trigger]') IS NOT NULL)
 DROP TRIGGER TapiCallInserted_Trigger
GO
CREATE TRIGGER TapiCallInserted_Trigger
ON hm_TapiCall
AFTER INSERT   
AS
BEGIN
	DELETE FROM hm_TapiCall WHERE CallDate <= DATEADD(day,-7,GETDATE())
END
GO

IF NOT EXISTS (SELECT 1 FROM hm_GroupRights WHERE group_id = 1 AND right_id = 224) INSERT INTO hm_GroupRights (group_id, right_id) VALUES (1, 224)
GO
IF NOT EXISTS (SELECT 1 FROM hm_GroupRights WHERE group_id = 1 AND right_id = 225) INSERT INTO hm_GroupRights (group_id, right_id) VALUES (1, 225)
GO
IF NOT EXISTS (SELECT 1 FROM hm_GroupRights WHERE group_id = 1 AND right_id = 226) INSERT INTO hm_GroupRights (group_id, right_id) VALUES (1, 226)
GO

IF OBJECT_ID('dbo.RemoveNullChars') IS NOT NULL
  DROP FUNCTION RemoveNullChars
GO

CREATE FUNCTION dbo.RemoveNullChars 
(
    @string NVARCHAR(MAX)
)
RETURNS NVARCHAR(MAX) WITH RETURNS NULL ON NULL INPUT
AS
BEGIN
DECLARE @Result NVARCHAR(MAX)
SET @Result = ''

DECLARE @counter INT

SET @counter = 0

WHILE (@counter <= LEN(@string))
    BEGIN
     IF UNICODE(SUBSTRING(@string,@counter,1)) <>  0 
        SET @Result = @Result + SUBSTRING(@string,@counter,1)
    SET @counter = @counter + 1    
    END
RETURN @Result
END

GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 226)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
    VALUES (226, 'Textbausteine anzeigen', 2, 49, 30, 'Der Benutzer kann Textbausteine sehen und benutzen.');
GO

IF NOT EXISTS (SELECT * FROM [dbo].[sysobjects] WHERE id = object_id(N'[dbo].[hm_MergedTicket]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
    CREATE TABLE [dbo].[hm_MergedTicket] (
    	[NewTicketID] [bigint] NOT NULL,
    	[OldTicketID] [bigint] NOT NULL
    )
GO

ALTER TABLE hm_TicketTemplate ALTER COLUMN LongDescr VARCHAR(MAX)
GO
ALTER TABLE hm_TicketTemplate ALTER COLUMN templatedescr VARCHAR(MAX)
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_SnippetToTicketTemplate]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_SnippetToTicketTemplate]
(
    [SnippetID] BIGINT NOT NULL,
    [TicketTemplateID] BIGINT NOT NULL
)
DECLARE @SnippetID int = 0
WHILE(1 = 1)
    BEGIN
      SELECT @SnippetID = MIN(ID)
      FROM hm_Snippet WHERE ID > @SnippetID
      IF @SnippetID IS NULL BREAK
      INSERT INTO hm_SnippetToTicketTemplate (SnippetID, TicketTemplateID) VALUES (@SnippetID, -1)
    END
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_TempEmailAddress]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_TempEmailAddress] (
    [TempEmailAddressID] BIGINT IDENTITY (1, 1) NOT NULL,
    [EMailAddress] VARCHAR(MAX) NOT NULL,
    [TicketEventID] BIGINT NOT NULL,
    [CreateDate] datetime NULL,
    [UpdateDate] datetime NULL,
 CONSTRAINT [PK_TempEmailAddress] PRIMARY KEY CLUSTERED
(
	[TempEmailAddressID] ASC
)) ON [PRIMARY]
END
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_SprintTicketLog' AND COLUMN_NAME = 'IsActive')
ALTER TABLE [dbo].[hm_SprintTicketLog] ADD
    [IsActive] INT DEFAULT(1) NOT NULL
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_SprintTicketLog' AND COLUMN_NAME = 'Expense')
ALTER TABLE [dbo].[hm_SprintTicketLog] ADD
    [Expense] BIGINT NULL,
    [ExpExpense] BIGINT NULL
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Users' AND COLUMN_NAME = 'RemarkText')
ALTER TABLE [dbo].[hm_Users] ADD
    [RemarkText] [varchar] (max) NULL 
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 207)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
VALUES (207, 'Initiator beim Start einer Workflow-Instanz nicht anzeigen', 3, 10, 31, 'Mit diesem Recht kann der Benutzer den Initiator einer Workflow-Instanz nicht auswählen.')
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 208)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
VALUES (208, 'Projektauswahl beim Start einer Workflow-Instanz nicht anzeigen', 3, 11, 31, 'Mit diesem Recht kann der Benutzer das Projekt einer Workflow-Instanz nicht auswählen.')
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 241)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
VALUES (241, 'Benutzerdefinierte Felder bei Ticketanlage anzeigen', 1, 52, 24, 'Mit diesem Recht werden die benutzerdefinierten Felder bei der Ticketanalge angezeigt.')
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ScheduledWorkflowDefinition]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_ScheduledWorkflowDefinition] (
    [ScheduledWorkflowDefinitionID] BIGINT IDENTITY (1, 1) NOT NULL,
    [Active] BIT NOT NULL,
    [WorkflowDefinitionID] BIGINT NOT NULL,
    [Name] VARCHAR(MAX) NOT NULL,
    [InitiatorID] BIGINT NULL,
    [SubstituderID] BIGINT NULL,
    [ContactID] BIGINT NULL,
    [ProjectID] BIGINT NULL,
    [EndDate] DATETIME NULL,
    [CreateDate] DATETIME NULL,
    [UpdateDate] DATETIME NULL,
 CONSTRAINT [PK_ScheduledWorkflowDefinition] PRIMARY KEY CLUSTERED
(
	[ScheduledWorkflowDefinitionID] ASC
)) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ScheduledWorkflowRepeatMode]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_ScheduledWorkflowRepeatMode] (
    [ScheduledWorkflowRepeatModeID] BIGINT IDENTITY (1, 1) NOT NULL,
    [ScheduledWorkflowDefinitionID] BIGINT NOT NULL,
    [RepeatType] INTEGER NOT NULL,
    [StartTime] TIME NOT NULL,
    [Weekday] INT NULL,
    [MonthlyDay] INT NULL,
    [YearlyDate] DATETIME NULL,
    [DelayDays] INT NULL,
    [CreateDate] DATETIME NULL,
    [UpdateDate] DATETIME NULL,
 CONSTRAINT [PK_ScheduledWorkflowRepeatMode] PRIMARY KEY CLUSTERED
(
	[ScheduledWorkflowRepeatModeID] ASC
)) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ScheduledWorkflowInstance]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_ScheduledWorkflowInstance] (
    [ScheduledWorkflowInstanceID] BIGINT IDENTITY (1, 1) NOT NULL,
    [ScheduledWorkflowDefinitionID] BIGINT NOT NULL,
    [LastExecution] DATETIME NULL,
    [NexExecution] DATETIME NULL,
 CONSTRAINT [PK_ScheduledWorkflowInstance] PRIMARY KEY CLUSTERED
(
	[ScheduledWorkflowInstanceID] ASC
)) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_TicketEventComment]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_TicketEventComment] (
    [TicketEventCommentID] BIGINT IDENTITY (1, 1) NOT NULL,
    [TicketEventID] BIGINT NOT NULL,
    [Comment] VARCHAR(MAX) NOT NULL,
    [CommentBY] VARCHAR(MAX) NOT NULL,
    [CreateDate] DATETIME NULL,
    [UpdateDate] DATETIME NULL,
 CONSTRAINT [PK_TicketEventComment] PRIMARY KEY CLUSTERED
(
	[TicketEventCommentID] ASC
)) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ProfessionalSupporterToTicket]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_ProfessionalSupporterToTicket]
(
    [ProfessionalSupporterID] BIGINT NOT NULL,
    [TicketID] BIGINT NOT NULL,
    [CreateDate] DATETIME NULL,
    [UpdateDate] DATETIME NULL,
)
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ProfessionalSupporterToTicketEvent]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
CREATE TABLE [dbo].[hm_ProfessionalSupporterToTicketEvent]
(
    [ProfessionalSupporterID] BIGINT NOT NULL,
    [TicketEventID] BIGINT NOT NULL,
    [CreateDate] DATETIME NULL,
    [UpdateDate] DATETIME NULL,
)
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_TicketStatus] WHERE ID = 21)
BEGIN
    IF EXISTS (SELECT * from syscolumns where id = Object_ID('hm_TicketStatus') and colstat & 1 = 1)
    SET IDENTITY_INSERT [dbo].[hm_TicketStatus] ON
    INSERT INTO hm_TicketStatus (ID, Descr) VALUES (21,'REQUEST TO PROFESSIONAL SUPPORTER')
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Project' AND COLUMN_NAME = 'DocumentTree')
ALTER TABLE [dbo].[hm_Project] ADD
    [DocumentTree] [varchar] (max) NULL 
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Project' AND COLUMN_NAME = 'HasTree')
ALTER TABLE [dbo].[hm_Project] ADD
    [HasTree] [bit] DEFAULT 0 NOT NULL 
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_Users' AND COLUMN_NAME = 'remember_token')
ALTER TABLE [dbo].[hm_Users] ADD
	[remember_token] [varchar] (100) NULL
GO
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TicketStatusChanged_Trigger]'))
DROP TRIGGER [dbo].[TicketStatusChanged_Trigger]
GO

CREATE TRIGGER TicketStatusChanged_Trigger
ON hm_Ticket
AFTER INSERT, UPDATE 
AS
DECLARE @TicketID INT
SELECT @TicketID = ID FROM inserted
IF UPDATE (TicketStatusID)
BEGIN
	DECLARE @NewStatusID INT
	SELECT @NewStatusID = TicketStatusID FROM inserted
	IF (@NewStatusID = 18 OR @NewStatusID = 19)
	BEGIN
		DELETE FROM hm_TicketEscalation WHERE TicketID = @TicketID
		INSERT INTO hm_TicketEscalation (TicketID, DesireTime) VALUES (@TicketID, GETDATE())
	END
END
GO

IF NOT EXISTS (SELECT ConfigurationID FROM hm_Configuration WHERE Configuration LIKE '%"id":"OA"%')
BEGIN
    DECLARE @Configuration VARCHAR(MAX)
    SELECT @Configuration = Configuration FROM hm_Configuration WHERE ConfigurationName = 'VSOrder'
    UPDATE hm_Configuration SET Configuration = STUFF(@Configuration, LEN(@Configuration), 1, ', {"index":4,"id":"OA","collapse":false}]') WHERE ConfigurationName = 'VSOrder'
END
GO  

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1600)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightDescr, RightsSectionID, SegmentID, RightsOrder)
VALUES (1600, 'Dokumentenbaum bearbeiten', 'Mit diesem Recht kann der Benutzer Dokumente innerhalb des Dokumentenbaumes zufügen oder entfernen.', 2, 3, 16)
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ProjectGroup]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ProjectGroup](
	[ProjectID] [bigint] NOT NULL,
	[GroupID] [bigint] NOT NULL,
	
 CONSTRAINT [PK_hm_ProjectGroup] PRIMARY KEY CLUSTERED
(
	[ProjectID] ASC,
	[GroupID] ASC
)
) ON [PRIMARY]

GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_RightsSegment] WHERE SegmentID = 70)
INSERT INTO hm_RightsSegment (SegmentID, Descr, SegmentOrder) VALUES (70, 'Vorschaltseite', 360)
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1010)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr) VALUES (1010, 'Tickettypen anzeigen', 1, 101, 70, 'Mit diesem Recht wird der Container für die Tickettypen in der Vorschaltseite angezeigt')
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1011)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr) VALUES (1011, 'Ticketvorlagen anzeigen', 1, 102, 70, 'Mit diesem Recht wird der Container für die Ticketvorlagen in der Vorschaltseite angezeigt')
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1012)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr) VALUES (1012, 'Workflows anzeigen', 1, 103, 70, 'Mit diesem Recht wird der Container für die Workflows in der Vorschaltseite angezeigt')
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1013)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr) VALUES (1013, 'Eigene Anwendungen anzeigen', 1, 104, 70, 'Mit diesem Recht wird der Container für die Eigenen Anwendungen in der Vorschaltseite angezeigt')
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1009)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr) VALUES (1009, 'Ansicht der Vorschaltseite verwalten', 1, 100, 70, 'Mit diesem Recht kann der Benutzer die Ansicht der Vorschaltseite anpassen.')
GO

IF EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1009 AND SegmentID = 24)
BEGIN
	DELETE FROM [dbo].[hm_Rights] WHERE RightID = 1009
	INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr) VALUES (1009, 'Ansicht der Vorschaltseite verwalten', 1, 100, 70, 'Mit diesem Recht kann der Benutzer die Ansicht der Vorschaltseite anpassen.')
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 506 AND SegmentID = 18)
BEGIN
	INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr) VALUES (506, 'Kostenbetrachtung anzeigen', 3, 100, 18, 'Ohne dieses Recht können Benutzer Kostendaten im Projekt nicht sehen und bearbeiten.')
END
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_UserDefField_Type_ForGroup]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_UserDefField_Type_ForGroup](
	[DefFieldID] [bigint] NOT NULL,
        [TypeID] [bigint] NOT NULL,
	[GroupID] [bigint] NOT NULL
	
 CONSTRAINT [PK_hm_UserDefField_Type_ForGroup] PRIMARY KEY CLUSTERED
(
	[DefFieldID] ASC,
        [TypeID] ASC,
	[GroupID] ASC
)
) ON [PRIMARY]

GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_Field_Type_ForGroup ]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_Field_Type_ForGroup](
	[FieldID] [bigint] NOT NULL,
        [TypeID] [bigint] NOT NULL,
	[GroupID] [bigint] NOT NULL
	
 CONSTRAINT [PK_hm_Field_Type_ForGroup] PRIMARY KEY CLUSTERED
(
	[FieldID] ASC,
        [TypeID] ASC,
	[GroupID] ASC
)
) ON [PRIMARY]

GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 242 AND SegmentID = 24)
BEGIN
	INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr) VALUES (242, 'Panel "Nicht angezeigte Objekte" in Ticketansicht anzeigen', 1, 60, 24, 'Ohne dieses Recht wird das Panel "Nicht angezeigte Objekte" im Ticket ausgeblendet.')
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 507 AND SegmentID = 18)
BEGIN
	INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr) VALUES (507, 'Projektlaufzeit ändern', 3, 101, 18, 'Ohne dieses Recht können Benutzer die Projektlaufzeit nicht ändern.')
END
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 255 AND SegmentID = 24)
BEGIN
	INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr) VALUES (255, 'Garantieabwicklung', 1, 65, 24, 'Benutzer mit diesem Recht könne die Garantieabwicklung-Daten GK sehen und bearbeiten.')
END

GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_WarrantyRequestWage]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_WarrantyRequestWage](
    [WarrantyRequestWageID] BIGINT IDENTITY (1, 1) NOT NULL,
    [DealerID] INT NOT NULL,
    [Description] VARCHAR(200) NULL,
    [HintText] VARCHAR(200) NULL,
    [WorkPrice] FLOAT DEFAULT 0.00 NOT NULL,
    [TravelPrice] FLOAT DEFAULT 0.00 NOT NULL,
    [KmPrice] FLOAT DEFAULT 0.00 NOT NULL,
    [maxKm] INT NOT NULL,
    [ValidFrom] DATE DEFAULT GETDATE() NOT NULL,
    [ValidUntil] DATE NULL,
    [CreateUserID] BIGINT  NULL,
	[CreateDate] DATETIME DEFAULT GETDATE() NOT NULL,
    [UpdateUserID] BIGINT  NULL,
    [UpdateDate] DATETIME DEFAULT GETDATE() NOT NULL
	CONSTRAINT [PK_hm_WarrantyRequestWage] PRIMARY KEY CLUSTERED
(
	[WarrantyRequestWageID] ASC
)) ON [PRIMARY]

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 227)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
    VALUES (227, 'Nur eigene Textbausteine verwalten', 2, 55, 30, 'Der Benutzer kann nur seinen eigenen Textbausteine verwalten.');
GO

UPDATE hm_Rights SET RightName = 'Alle Textbausteine verwalten' WHERE RightName = 'Textbausteine verwalten';
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 243 AND SegmentID = 24)
BEGIN
	INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr) VALUES (243, 'Tickets ohne Supporter anzeigen (Datenschutz)', 1, 65, 24, 'Benutzer mit diesem Recht sehen in der Ticketliste und in der Detailansicht nicht, welcher Supporter dem Ticket zugewiesen ist und wer ein Ticketevent angelegt hat.')
END

IF (SELECT COUNT(*) FROM hm_Rights WHERE RightID = 239) = 0
BEGIN
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
    VALUES (239, 'Gruppe im interessierten Kreis anzeigen', 1, 24, 47, 'Nur Benutzergruppen mit diesem Recht werden als zuweisbar für den Interessierten Kreis angezeigt.');
END
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_RMAPosition]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].hm_RMAPosition(
    RMAPositionID BIGINT IDENTITY (1, 1) NOT NULL,
    [paCallID] INT NOT NULL,
    [HaendlerID] INT NULL,
    [EndKundeID] INT NULL,
    
    PositionsNr FLOAT DEFAULT 0.00 NOT NULL,
    ETNummer VARCHAR(200) NULL,
    ETNummerAlt VARCHAR(200) NULL,
    ETBezeichnungDE  VARCHAR(max) NULL,
    ETBezeichnungEN  VARCHAR(max) NULL,    
    [Amount] FLOAT DEFAULT 0.00 NOT NULL,
    RechnungsNr VARCHAR(200) NULL,
    RechnungsPositionNr VARCHAR(20) NULL,
    Einzelpreis VARCHAR(200) NULL,
    Gesamtpreis VARCHAR(200) NULL,
    Rueckliefercode  INT NULL,
    Ruecklieferstatus  INT NULL,
    RMABelegNr  INT NULL,
	RMABelegPos FLOAT DEFAULT 0.00 NULL,
    RMABelegMenge FLOAT DEFAULT 0.00 NULL,

    WABelegNr  INT NULL,
	WABelegPos FLOAT DEFAULT 0.00 NULL,
    WABelegMenge FLOAT DEFAULT 0.00 NULL,


    zurueckgelMenge FLOAT DEFAULT 0.00 NOT NULL,
    Kommentar  VARCHAR(max) NULL,
    EingangBestaetigtDatum  DATETIME NULL,
    EingangBestaetigtPa DATETIME NULL,
    RuecklieferstatusFCS INT NULL,
    RMAListID INT NULL,

    [CreateUserID] BIGINT  NULL,
	[CreateDate] DATETIME DEFAULT GETDATE() NOT NULL,
    [UpdateUserID] BIGINT  NULL,
    [UpdateDate] DATETIME DEFAULT GETDATE() NOT NULL
	CONSTRAINT [PK_hm_RMAPosition] PRIMARY KEY CLUSTERED
(
	[RMAPositionID] ASC
)) ON [PRIMARY]


IF EXISTS (SELECT 1 FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[View_EventCosts]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP View [dbo].View_EventCosts
GO
EXEC dbo.sp_executesql @statement = N'Create View [dbo].[View_EventCosts] AS
SELECT DISTINCT (CostRatePerMinute * hm_TicketEvent.Expense) EventCosts, CC.Symbol, hm_TicketEvent.ID
FROM hm_TicketEvent
    INNER JOIN hm_CostGroupRate CGR ON CGR.CostGroupID = hm_TicketEvent.CostGroupID
    AND CGR.StartDate = (
            SELECT MAX(StartDate) As StartDate
            FROM hm_CostGroupRate
            WHERE hm_CostGroupRate.CostGroupID = hm_TicketEvent.CostGroupID
            AND hm_CostGroupRate.StartDate <= hm_TicketEvent.EventDate
    )
LEFT JOIN hm_CostRate CR ON CR.CostRateID = CGR.CostRateID
LEFT JOIN hm_CostCurrency CC ON CC.CostCurrencyID = CR.CostCurrencyID
'
GO

IF EXISTS (SELECT 1 FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[View_ProjectEventCosts]') AND OBJECTPROPERTY(id, N'IsView') = 1)
DROP View [dbo].View_ProjectEventCosts
GO
EXEC dbo.sp_executesql @statement = N'Create View [dbo].[View_ProjectEventCosts] as 
SELECT DISTINCT (ProjectCostRatePerMinute * hm_TicketEvent.ProjectFactor * hm_TicketEvent.Expense) ProjectEventCosts, hm_TicketEvent.ID
                                FROM hm_TicketEvent
                                    INNER JOIN hm_CostGroupRate CGR ON CGR.CostGroupID = hm_TicketEvent.ProjectCostGroupID
                                    AND CGR.StartDate = (
                                            SELECT MAX(StartDate) As StartDate
                                            FROM hm_CostGroupRate
                                            WHERE hm_CostGroupRate.CostGroupID = hm_TicketEvent.ProjectCostGroupID
                                            AND hm_CostGroupRate.StartDate <= hm_TicketEvent.EventDate
                                    )
                            LEFT JOIN hm_CostRate CR ON CR.CostRateID = CGR.CostRateID
                            LEFT JOIN hm_CostCurrency CC ON CC.CostCurrencyID = CR.CostCurrencyID
'
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 229)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
        VALUES (229, 'Gruppe / Supporter nur per Dialogfenster (Stift) bearbeiten', 2, 65, 24, 'Benutzer mit diesem Recht können in bestehenden Tickets die Supportergruppe und Supporter nur mittels dem PopUp-Dialogs "Gruppe/Supporter ändern" bearbeiten')
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_ProjectUser]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ProjectUser](
	[ProjectID] [bigint] NOT NULL,
	[UserID] [bigint] NOT NULL,
	
 CONSTRAINT [PK_hm_ProjectUser] PRIMARY KEY CLUSTERED
(
	[ProjectID] ASC,
	[UserID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_News' AND COLUMN_NAME = 'IsImportant')
ALTER TABLE [dbo].[hm_News] ADD
    [IsImportant] BIT NOT NULL DEFAULT(0), 
    [NewsOrder] INT NULL
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_TicketFilterUserColor]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_TicketFilterUserColor](
	[FilterID] [int] NOT NULL,
    [UserID] [int] NOT NULL,
    [Color] VARCHAR(7) NULL
 CONSTRAINT [PK_hm_TFUserColor] PRIMARY KEY CLUSTERED
(
	[FilterID] ASC,
    [UserID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 248)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
    VALUES (248, 'Interne Notizen aus der selben Firma anzeigen', 1, 24, 51, 'Benutzer mit diesem Recht sehen Interne Notizen die von Benutzern angelegt wurden, welche der selben Firma wie sie zugewiesen sind.');
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 249)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
    VALUES (249, 'Interne Notizen der eigenen Gruppe(n) anzeigen', 1, 24, 51, 'Benutzer mit diesem Recht sehen Interne Notizen, welche von Benutzern erstellt wurden, die mind. eine gleichen Gruppe wie der Benutzer zugewiesen sind.');
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 231)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
    VALUES (231, 'Benutzernamen in der Dokumentenliste anzeigen', 2, 24, 66, 'Benutzer mit diesem Recht können den Benutzernamen des Benutzers, der das Dokument hochgeladen hat, in der Dokumentenliste in der Ticketansicht sehen.');
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 270)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
    VALUES (270, 'Assets verwalten', 1, 1, 5, 'Benutzer mit diesem Recht können Assets unter Verwaltung>Assetverwaltung verwalten.');
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_WFDefinitions' AND COLUMN_NAME = 'WFDefDescr')
ALTER TABLE [dbo].[hm_WFDefinitions] ADD [WFDefDescr] [varchar](max) NULL
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 315)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr)
    VALUES (315, 'Anzahl aktiver Tickets im Menu anzeigen', 1, 10, 20, 'Anzahl aktiver Tickets im Menü anzeigen.')
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_tickettype' AND COLUMN_NAME = 'TemplateOrderNo')
ALTER TABLE [dbo].[hm_tickettype] ADD [TemplateOrderNo] [int] NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_tickettype' AND COLUMN_NAME = 'TemplateCollapse')
ALTER TABLE [dbo].[hm_tickettype] ADD [TemplateCollapse] [bit] DEFAULT(0)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_TicketEvent' AND COLUMN_NAME = 'EventFromProalpha')
ALTER TABLE [dbo].hm_TicketEvent ADD [EventFromProalpha]  [bit] DEFAULT 0 NOT NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_OwnApplication' AND COLUMN_NAME = 'IconPath')
    ALTER TABLE [dbo].[hm_OwnApplication] ADD [IconPath] INT NULL
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1700)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
    VALUES (1700, 'Kategorie 1 / Kategorie 2 nur per Dialogfenster (Stift) bearbeiten', 2, 24, 66, 'Benutzer mit diesem Recht können in bestehenden Tickets Kategorie 1 und Kategorie 2 nur mittels dem PopUp-Dialogs bearbeiten.');
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1020)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr) VALUES (1020, 'Ansicht der Workflow-Aktivitäten verwalten', 1, 48, 25, 'Mit diesem Recht kann der Benutzer die Ansicht der Workflow-Aktivitäten anpassen.')
GO
IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_TickettypNotificationGroup]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_TickettypNotificationGroup](
	[TickettypeID] [int] NOT NULL,
	[GroupID] [int] NOT NULL,
 CONSTRAINT [PK_hm_TypeNotiGroup] PRIMARY KEY CLUSTERED
(
	[TickettypeID] ASC,
	[GroupID] ASC
)) ON [PRIMARY]
GO


IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 1800)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
    VALUES (1800, 'Alle Filter in der Ticketliste verwalten', 2, 24, 67, 'Benutzer mit diesem Recht können alle Filter in der Ticketliste verwalten, auch wenn solche Filter seiner Gruppe nicht zugeordnet werden.');
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_FAQCategories] WHERE name = '(ohne Rubrik)')
                        INSERT INTO hm_FAQCategories (name)
                        VALUES ('(ohne Rubrik)')
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 69)
INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID)
VALUES (69, '+ Tickets ohne Gruppe anzeigen', 1, 9, 'Benutzer mit diesem zusätzlichen Recht sehen Tickets, denen keine Gruppe zugewiesen ist.', 27)
GO


IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 222)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
    VALUES (222, 'Allgemeine Gruppenbenachrichtigung deaktivieren', 2, 14, 10, 'Benutzer dieser Gruppe werden nicht benachrichtigt wenn die Empfänger nur anhand der Gruppe ermittelt werden.')
GO



IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 223)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
    VALUES (223, 'Bearbeitungsart ist Pflichtfeld', 2, 17, 10, 'Erforder das Recht <strong>Bearbeitungsart anzeigen</strong>. Benutzer mit diesem Recht müssen bei der Ticketerstellung oder -bearbeitung eine Bearbeitungsart wählen.')
GO



BEGIN
	INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, SegmentID, RightDescr) VALUES (260, 'GA - Positionensbearbeitung freigeben', 1, 66, 24, 'Benutzer mit diesem Recht könne die Positionsbearbeitung in GA-Anträgen zur Bearbeitung freigeben oder sperren.')
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 852)
    INSERT INTO [dbo].[hm_Rights] (RightID, RightName, RightsSectionID, RightsOrder, RightDescr, SegmentID) VALUES (852, 'Mandant anzeigen', 3, 5, 'Zeigt den zugewiesenen Mandanten oder die Mandantenauswahl in Tickets an', 33)
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_TicketStatus] WHERE ID = 22)
BEGIN
    IF EXISTS (SELECT * from syscolumns where id = Object_ID('hm_TicketStatus') and colstat & 1 = 1)
    SET IDENTITY_INSERT [dbo].[hm_TicketStatus] ON
    INSERT INTO [dbo].[hm_TicketStatus] (ID, Descr, Descr_en, Descr_de, is_custom)
    VALUES (22, 'WAITING FOR ORDER', 'WAITING FOR ORDER', 'AUF BESTELLUNG WARTEN', 1);
END
IF NOT EXISTS (SELECT * FROM [dbo].[hm_TicketStatus] WHERE ID = 23)
BEGIN
    IF EXISTS (SELECT * from syscolumns where id = Object_ID('hm_TicketStatus') and colstat & 1 = 1)
    SET IDENTITY_INSERT [dbo].[hm_TicketStatus] ON
    INSERT INTO hm_TicketStatus (ID, Descr, Descr_en, Descr_de, is_custom) VALUES (23,'WAITING FOR SERVICE PROVIDER', 'WAITING FOR SERVICE PROVIDER', 'WARTEN AUF DIENSTLEISTER', 1)
END
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_show_field]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_show_field](
	[field_id] [bigint] NOT NULL,
	[group_id] [bigint] NOT NULL,
 CONSTRAINT [PK_hm_show_field] PRIMARY KEY CLUSTERED
(
	[field_id] ASC,
	[group_id] ASC
)
) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_UserDefFieldValueTemplate]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_UserDefFieldValueTemplate](
	[UserDefFieldValueID] [bigint]  NOT NULL,
 [TemplateID] [bigint] NOT NULL
 CONSTRAINT [PK_hm_UserDefFieldValueTemplate] PRIMARY KEY CLUSTERED
(
	[UserDefFieldValueID] ASC,
 [TemplateID] ASC
)
) ON [PRIMARY]
GO
IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_GroupArchive]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_GroupArchive](
	[GroupArchiveID] [bigint]  IDENTITY(1, 1) NOT NULL,
	[GroupEventID] [bigint] NOT NULL,
        [ObjectName] [varchar] (255) NULL,
        [OldValue] [text] NULL,
        [NewValue] [text] NULL,
        [GroupID][bigint] NOT NULL
 CONSTRAINT [PK_hm_GroupArchive] PRIMARY KEY CLUSTERED
(
    [GroupArchiveID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_BKActivityOrders]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].hm_BKActivityOrders(
        [ActivityID] [int] NOT NULL,
        [ArtikelNr] [varchar](255) NOT NULL,
        [ArtikelVersion] [varchar](255) NOT NULL,
        [OrderText] [varchar](300) NULL,
        [Anzahl] [int] NOT NULL,
        [Preis] [float] NULL,
		[ActionID] [int] DEFAULT (0) NOT NULL,
        [CreateUserID] [int] NOT NULL,
        [CreateDate] [datetime] DEFAULT GETDATE() NOT NULL,
 CONSTRAINT [PK_hm_BKActivityOrders] PRIMARY KEY CLUSTERED
(
	[ActivityID] ASC,
        [ArtikelNr] ASC
)
) ON [PRIMARY]
GO

IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_ContactArchive]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ContactArchive](
	[ContactArchiveID] [bigint]  IDENTITY(1, 1) NOT NULL,
	[ContactEventID] [bigint] NOT NULL,
        [ObjectName] [varchar] (255) NULL,
        [OldValue] [text] NULL,
        [NewValue] [text] NULL,
        [ContactID][bigint] NOT NULL
 CONSTRAINT [PK_hm_ContactArchive] PRIMARY KEY CLUSTERED
(
    [ContactArchiveID] ASC
)) ON [PRIMARY]
GO

IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_ProjectArchive]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_ProjectArchive](
	[ProjectArchiveID] [bigint]  IDENTITY(1, 1) NOT NULL,
	[ProjectEventID] [bigint] NOT NULL,
        [ObjectName] [varchar] (255) NULL,
        [OldValue] [text] NULL,
        [NewValue] [text] NULL,
        [ProjectID][bigint] NOT NULL
 CONSTRAINT [PK_hm_ProjectArchive] PRIMARY KEY CLUSTERED
(
    [ProjectArchiveID] ASC
)) ON [PRIMARY]
GO


IF NOT EXISTS (select * from dbo.sysobjects where id = object_id(N'[dbo].[hm_CatArchive]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_CatArchive](
	[CatArchiveID] [bigint]  IDENTITY(1, 1) NOT NULL,
	[CatEventID] [bigint] NOT NULL,
        [ObjectName] [varchar] (255) NULL,
        [OldValue] [text] NULL,
        [NewValue] [text] NULL,
        [CatID][bigint] NOT NULL
 CONSTRAINT [PK_hm_CatArchive] PRIMARY KEY CLUSTERED
(
    [CatArchiveID] ASC
)) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_EPClassiEP]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].hm_EPClassiEP(
        [AssettypeID] [int] NOT NULL ,
        [MainGroupID] [int] NOT NULL,
        [SubGroupID] [int]  NULL,
		[ErrorPatternID] [int]  NOT NULL,
        [CreateDate] [datetime] NOT NULL DEFAULT (GETDATE()),
        [CreateUserID] [int] NULL,
        [CodeID] AS CONCAT( RIGHT(REPLICATE('0',4) + CAST(hm_EPClassiEP.AssettypeID AS VARCHAR(4)),4), '_',RIGHT(REPLICATE('0',4) + CAST(hm_EPClassiEP.MainGroupID AS VARCHAR(4)),4), '_', RIGHT(REPLICATE('0',4) + CAST(hm_EPClassiEP.SubGroupID AS VARCHAR(4)),4))
)
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_PARequests]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
BEGIN
    CREATE TABLE [dbo].[hm_PARequests](
        [ID] [int] IDENTITY(1,1) NOT NULL,
        [Function] [nvarchar](max) NULL,
        [Request] [nvarchar](max) NULL,
        [Response] [nvarchar](max) NULL,
        [UserID] [int] NOT NULL,
        [CallID] [int] NOT NULL,
        [TicketID] [int] NOT NULL,
        [ErrorMessage] [nvarchar](max) NULL,
        [CreateDate] [datetime] NOT NULL DEFAULT GETDATE(),
        CONSTRAINT [PK_hm_PARequests] PRIMARY KEY CLUSTERED 
        (
            [ID] ASC
        )
    );
END
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_Rights] WHERE RightID = 857)
    INSERT INTO hm_Rights (RightID, RightName, RightsSectionID, SegmentID, RightsOrder, RightDescr)
    VALUES (857, 'Interne Tickets anzeigen', 2, 24, 70, 'Benutzer mit diesem Recht können Tickets als Intern markieren und bekommen Interne Tickets angezeigt, sofern dieses für sie generell sichtbar sind.');
GO
IF NOT EXISTS (SELECT * FROM [dbo].[hm_GroupRights] WHERE right_id = 857 AND group_id = 1)
    INSERT INTO [dbo].[hm_GroupRights] (group_id, right_id) VALUES (1, 857)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'dbo' AND TABLE_NAME ='hm_MailAccounts' AND COLUMN_NAME = 'MaildomainKeepInbox')
    ALTER TABLE [dbo].[hm_MailAccounts] ADD [MaildomainKeepInbox] [bit] NULL DEFAULT 0
GO
IF NOT EXISTS (
    SELECT * FROM dbo.sysobjects 
    WHERE id = object_id(N'[dbo].[hm_IncidentImpact]') 
      AND OBJECTPROPERTY(id, N'IsUserTable') = 1
)
CREATE TABLE [dbo].[hm_IncidentImpact] (
    [ID] INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
    [Name_de] VARCHAR(50) NOT NULL,
    [Name_en] VARCHAR(50) NOT NULL,
    [Description_de] VARCHAR(255) NULL,
    [Description_en] VARCHAR(255) NULL,
    [Score] TINYINT NOT NULL 
) ON [PRIMARY]
GO
IF NOT EXISTS (
    SELECT * FROM dbo.sysobjects 
    WHERE id = object_id(N'[dbo].[hm_IncidentUrgency]') 
      AND OBJECTPROPERTY(id, N'IsUserTable') = 1
)
CREATE TABLE [dbo].[hm_IncidentUrgency] (
    [ID] INT IDENTITY(1,1) NOT NULL PRIMARY KEY,
    [Name_de] VARCHAR(50) NOT NULL,
    [Name_en] VARCHAR(50) NOT NULL,
    [Description_de] VARCHAR(255) NULL,
    [Description_en] VARCHAR(255) NULL,
    [Score] TINYINT NOT NULL 
) ON [PRIMARY]
GO
IF OBJECT_ID('dbo.trg_UpdateIncidentPrio', 'TR') IS NOT NULL
    DROP TRIGGER dbo.trg_UpdateIncidentPrio;
GO

CREATE TRIGGER dbo.trg_UpdateIncidentPrio
ON dbo.hm_Ticket
AFTER INSERT, UPDATE
AS
BEGIN
    SET NOCOUNT ON;

    IF (UPDATE(IncidentImpactID) OR UPDATE(IncidentUrgencyID))
    BEGIN
        UPDATE t
        SET IncidentPrio = FLOOR((ISNULL(i.Score, 0) + ISNULL(u.Score, 0)) / 2)
        FROM dbo.hm_Ticket t
        INNER JOIN inserted ins ON t.ID = ins.ID
        LEFT JOIN dbo.hm_IncidentImpact i ON ins.IncidentImpactID = i.ID
        LEFT JOIN dbo.hm_IncidentUrgency u ON ins.IncidentUrgencyID = u.ID
        WHERE ins.IncidentImpactID IS NOT NULL OR ins.IncidentUrgencyID IS NOT NULL;
    END
END
GO
CREATE TABLE hm_DashboardLinkGroup (
    DashboardLinkId BIGINT NOT NULL,
    GroupId BIGINT NOT NULL,
    created_at DATETIME2 DEFAULT GETDATE(),
    updated_at DATETIME2 DEFAULT GETDATE(),
    CONSTRAINT PK_hm_DashboardLinkGroup PRIMARY KEY (DashboardLinkId, GroupId),
    CONSTRAINT FK_DashboardLink FOREIGN KEY (DashboardLinkId) 
        REFERENCES hm_DashboardLinks(LinkID) ON DELETE CASCADE,
    CONSTRAINT FK_Group FOREIGN KEY (GroupId) 
        REFERENCES hm_Groups(group_id) ON DELETE CASCADE
);
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[hm_DefFieldValueTemplate]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
CREATE TABLE [dbo].[hm_DefFieldValueTemplate](
    [TicketTemplateID] [bigint] NOT NULL
)
GO
